/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.CrpConstants;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.crp.es.EsSendEnginePollThread;
import com.yqbsoft.laser.service.crp.es.EsSendEnginePutThread;
import com.yqbsoft.laser.service.crp.es.EsSendEngineService;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendBaseService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeBaseService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.crp.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class CrpRechargeBaseServiceImpl
extends BaseServiceImpl
implements CrpRechargeBaseService {
    private static final String SYS_CODE = "service.crp.CrpRechargeBaseServiceImpl";
    private CrpChannelsendBaseService crpChannelsendBaseService;
    CrpRechargeService crpRechargeService;
    private static EsSendEngineService esSendEngineService;
    private static Object lock;

    public void setCrpRechargeService(CrpRechargeService crpRechargeService) {
        this.crpRechargeService = crpRechargeService;
    }

    public void setCrpChannelsendBaseService(CrpChannelsendBaseService crpChannelsendBaseService) {
        this.crpChannelsendBaseService = crpChannelsendBaseService;
    }

    @Override
    public String saveRechargeBase(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain || StringUtil.isBlank((String)crpRechargeDomain.getRechargeOpcode()) || StringUtil.isBlank((String)crpRechargeDomain.getUserinfoCode())) {
            this.logger.error("service.crp.CrpRechargeBaseServiceImpl.saveRechargeBase", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        this.crpChannelsendBaseService.sendChangeApply(crpRechargeDomain);
        return "success";
    }

    @Override
    public String updateSendUrechargeBase(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("cpRechargeDomain"))) {
            throw new ApiException("service.crp.CrpRechargeBaseServiceImplupdateSendUrechargeBase.", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.crpChannelsendBaseService.updateSendAutoUrechargeStr(map);
        return "success";
    }

    @Override
    public String loadSendUrechargeBase(String tenantCode) throws ApiException {
        QueryResult<CrpRecharge> qlist;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_OPEN);
        map.put("rechargeType", "0");
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        map.put("rechargeStartQend", da);
        map.put("rechargeEndQstart", da);
        String getddflag = FlagSettingUtils.getUrl(tenantCode, "CrpBalance", "CrpBalance");
        if (StringUtils.isBlank((String)getddflag)) {
            map.put("rechargeName10", "0");
        }
        if (null != (qlist = this.crpRechargeService.queryCrpPage(map)) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeStar(crpRecharge);
            }
        }
        map.remove("rechargeStartQend");
        map.remove("rechargeEndQstart");
        map.put("rechargeEndStr", da);
        if (StringUtils.isNotBlank((String)getddflag)) {
            map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        }
        qlist = this.crpRechargeService.queryCrpPage(map);
        this.logger.info("service.crp.CrpRechargeBaseServiceImplmap: " + JsonUtil.buildNonDefaultBinder().toJson(map) + " qlist: " + JsonUtil.buildNonDefaultBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeEnd(crpRecharge);
            }
        }
        return null;
    }

    @Override
    public String loadSendUrechargeBaseToTime(String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        map.put("rechargeStateStr", "0,1");
        map.put("rechargeType", "0");
        map.put("rechargeName10", "0,-1");
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        map.put("rechargeEndStr", da);
        this.logger.error("map====4", (Object)JsonUtil.buildNormalBinder().toJson(map));
        QueryResult<CrpRecharge> qlist = this.crpRechargeService.queryCrpPage(map);
        this.logger.error("qlist====4", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeEndToTime(crpRecharge);
            }
        }
        map.remove("rechargeEndStr");
        map.put("rechargeStartQend", da);
        map.put("rechargeEndQstart", da);
        map.put("order", true);
        map.put("orderStr", "RECHARGE_END ASC");
        map.put("rechargeSortStr", "3");
        map.put("rechargeName10", "0,-1");
        this.logger.error("map====1", (Object)JsonUtil.buildNormalBinder().toJson(map));
        qlist = this.crpRechargeService.queryCrpPage(map);
        this.logger.error("qlist====1", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeStarToTime(crpRecharge);
            }
        }
        map = new HashMap();
        map.put("tenantCode", tenantCode);
        map.put("rechargeType", "0");
        map.put("rechargeName10", "3");
        map.put("rechargeState", 3);
        map.put("rechargeSort", "3");
        map.put("order", true);
        map.put("orderStr", "RECHARGE_END  asc, RECHARGE_ID asc");
        map.put("refundType", "automatic");
        return this.crpRechargeService.updateBmoneyCrpTobeReturn(map);
    }

    @Override
    public void loadrechargeBaseToReturn(String tenantCode) throws ApiException {
        this.loadDb(tenantCode);
    }

    private void loadDb(String tenantCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("rechargeType", "0");
            map.put("rechargeName10", "3");
            map.put("rechargeState", 3);
            map.put("rechargeSort", "3");
            map.put("dataState", 2);
            map.put("order", true);
            map.put("orderStr", "RECHARGE_END  asc, RECHARGE_ID asc");
            this.logger.info("service.crp.CrpRechargeBaseServiceImpl.updateBmoneyCrpToReturn.map", (Object)JsonUtil.buildNonNullBinder().toJson(map));
            Date rechargeEndQstart = DateUtil.getDateToString((String)"2023-03-01", (String)"yyyy-MM-dd");
            map.put("rechargeEndQstart", rechargeEndQstart);
            List<CrpRecharge> crpList = this.crpRechargeService.queryBmoneyCrp(map);
            if (ListUtil.isNotEmpty(crpList)) {
                CrpRechargeBaseServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(CrpRechargeBaseServiceImpl.getEsSendEngineService(), crpList));
            }
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeBaseServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsSendEngineService getEsSendEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esSendEngineService) {
                esSendEngineService = new EsSendEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 100; ++i) {
                    esSendEngineService.addPollPool(new EsSendEnginePollThread(esSendEngineService));
                }
            }
            return esSendEngineService;
        }
    }

    static {
        lock = new Object();
    }
}

