/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.CrpConstants;
import com.yqbsoft.laser.service.crp.domain.CrpRechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargelistDomain;
import com.yqbsoft.laser.service.crp.es.EsSendEnginePollThread;
import com.yqbsoft.laser.service.crp.es.EsSendEnginePutThread;
import com.yqbsoft.laser.service.crp.es.EsSendEngineService;
import com.yqbsoft.laser.service.crp.model.CrpChannelsend;
import com.yqbsoft.laser.service.crp.model.CrpRecharge;
import com.yqbsoft.laser.service.crp.model.CrpUrecharge;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendBaseService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeBaseService;
import com.yqbsoft.laser.service.crp.service.CrpRechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargelistService;
import com.yqbsoft.laser.service.crp.utils.FlagSettingUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class CrpRechargeBaseServiceImpl
extends BaseServiceImpl
implements CrpRechargeBaseService {
    private static final String SYS_CODE = "service.crp.CrpRechargeBaseServiceImpl";
    private CrpChannelsendBaseService crpChannelsendBaseService;
    CrpRechargeService crpRechargeService;
    private CrpUrechargelistService crpUrechargelistService;
    private CrpUrechargeService crpUrechargeService;
    private CrpRechargeBaseService crpRechargeBaseService;
    private static EsSendEngineService esSendEngineService;
    private static Object lock;

    public CrpUrechargelistService getCrpUrechargelistService() {
        return this.crpUrechargelistService;
    }

    public void setCrpUrechargelistService(CrpUrechargelistService crpUrechargelistService) {
        this.crpUrechargelistService = crpUrechargelistService;
    }

    public CrpUrechargeService getCrpUrechargeService() {
        return this.crpUrechargeService;
    }

    public void setCrpUrechargeService(CrpUrechargeService crpUrechargeService) {
        this.crpUrechargeService = crpUrechargeService;
    }

    public void setCrpRechargeService(CrpRechargeService crpRechargeService) {
        this.crpRechargeService = crpRechargeService;
    }

    public void setCrpChannelsendBaseService(CrpChannelsendBaseService crpChannelsendBaseService) {
        this.crpChannelsendBaseService = crpChannelsendBaseService;
    }

    @Override
    public String saveRechargeBase(CrpRechargeDomain crpRechargeDomain) throws ApiException {
        if (null == crpRechargeDomain || StringUtil.isBlank((String)crpRechargeDomain.getRechargeOpcode()) || StringUtil.isBlank((String)crpRechargeDomain.getUserinfoCode())) {
            this.logger.error("service.crp.CrpRechargeBaseServiceImpl.saveRechargeBase", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)crpRechargeDomain));
            return "error";
        }
        this.crpChannelsendBaseService.sendChangeApply(crpRechargeDomain);
        return "success";
    }

    @Override
    public String updateSendUrechargeBase(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map) || EmptyUtil.isEmpty((Object)map.get("cpRechargeDomain"))) {
            throw new ApiException("service.crp.CrpRechargeBaseServiceImplupdateSendUrechargeBase.", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.crpChannelsendBaseService.updateSendAutoUrechargeStr(map);
        return "success";
    }

    @Override
    public String loadSendUrechargeBase(String tenantCode) throws ApiException {
        QueryResult<CrpRecharge> qlist;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        map.put("rechargeState", CrpConstants.RECHARGE_STATE_OPEN);
        map.put("rechargeType", "0");
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        map.put("rechargeStartQend", da);
        map.put("rechargeEndQstart", da);
        String getddflag = FlagSettingUtils.getUrl(tenantCode, "CrpBalance", "CrpBalance");
        if (StringUtils.isBlank((String)getddflag)) {
            map.put("rechargeName10", "0");
        }
        if (null != (qlist = this.crpRechargeService.queryCrpPage(map)) && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeStar(crpRecharge);
            }
        }
        map.remove("rechargeStartQend");
        map.remove("rechargeEndQstart");
        map.put("rechargeEndStr", da);
        if (StringUtils.isNotBlank((String)getddflag)) {
            map.put("rechargeState", CrpConstants.RECHARGE_STATE_0);
        }
        qlist = this.crpRechargeService.queryCrpPage(map);
        this.logger.info("service.crp.CrpRechargeBaseServiceImplmap: " + JsonUtil.buildNonDefaultBinder().toJson(map) + " qlist: " + JsonUtil.buildNonDefaultBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeEnd(crpRecharge);
            }
        }
        return null;
    }

    @Override
    public String loadSendUrechargeBaseToTime(String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        map.put("rechargeStateStr", "0,1");
        map.put("rechargeType", "0");
        map.put("rechargeName10", "0,-1");
        Date vf = new Date();
        String nowStr = DateUtil.getDateString((Date)vf, (String)"yyyy-MM-dd");
        Date da = DateUtil.getDateToString((String)nowStr, (String)"yyyy-MM-dd");
        map.put("rechargeEndStr", da);
        this.logger.error("map====4", (Object)JsonUtil.buildNormalBinder().toJson(map));
        QueryResult<CrpRecharge> qlist = this.crpRechargeService.queryCrpPage(map);
        this.logger.error("qlist====4", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeEndToTime(crpRecharge);
            }
        }
        map.remove("rechargeEndStr");
        map.put("rechargeStartQend", da);
        map.put("rechargeEndQstart", da);
        map.put("order", true);
        map.put("orderStr", "RECHARGE_END ASC");
        map.put("rechargeSortStr", "3");
        map.put("rechargeName10", "0,-1");
        this.logger.error("map====1", (Object)JsonUtil.buildNormalBinder().toJson(map));
        qlist = this.crpRechargeService.queryCrpPage(map);
        this.logger.error("qlist====1", (Object)JsonUtil.buildNormalBinder().toJson(qlist));
        if (null != qlist && ListUtil.isNotEmpty((Collection)qlist.getList())) {
            for (CrpRecharge crpRecharge : qlist.getList()) {
                this.crpRechargeService.updateCrpRechargeStarToTime(crpRecharge);
            }
        }
        map = new HashMap();
        map.put("tenantCode", tenantCode);
        map.put("rechargeType", "0");
        map.put("rechargeName10", "3");
        map.put("rechargeState", 3);
        map.put("rechargeSort", "3");
        map.put("order", true);
        map.put("orderStr", "RECHARGE_END  asc, RECHARGE_ID asc");
        map.put("refundType", "automatic");
        return this.crpRechargeService.sendUpdateBmoneyCrpTobeReturn(map);
    }

    @Override
    public void loadrechargeBaseToReturn(String tenantCode) throws ApiException {
        this.loadDb(tenantCode);
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeByAutomaticStr(CrpRecharge crpRecharge, Map<String, Object> map) throws ApiException {
        if (null == crpRecharge) {
            this.logger.error("service.crp.CrpRechargeBaseServiceImpl.updateCrpUrechargeByAutomatic.crpRecharge");
            return null;
        }
        if (!"1".equals(crpRecharge.getRechargeType())) {
            throw new ApiException("service.crp.CrpRechargeBaseServiceImpl.updateCrpUrechargeByAutomatic.", "\u7c7b\u578b\u9519\u8bef");
        }
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("tenantCode", crpRecharge.getTenantCode());
        objectMap.put("rechargeMoney", crpRecharge.getRechargeMoney());
        objectMap.put("rechargeCode", crpRecharge.getRechargeCode());
        objectMap.put("type", "2");
        this.crpRechargeService.updateCrpRecharges(objectMap);
        CrpRecharge recharge = this.crpRechargeService.getCrpRecharge(crpRecharge.getRechargeId());
        if (null == recharge) {
            throw new ApiException("service.crp.CrpRechargeBaseServiceImpl.updateCrpUrechargeByAutomatic.recharge", "recharge:" + JsonUtil.getNotDefJsonUtil().toJson((Object)crpRecharge));
        }
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpRecharge);
            crpUrechargelistDomain.setRechargeType("1");
            crpUrechargelistDomain.setUrechargelistDir("0");
            crpUrechargelistDomain.setRechargeEnd(null);
            crpUrechargelistDomain.setRechargeStart(null);
            crpUrechargelistDomain.setRechargeName9(null);
            crpUrechargelistDomain.setRechargeName10("0");
            String field = crpRecharge.getTenantCode().concat("-").concat("1-fund_type_one");
            String cds = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
            crpUrechargelistDomain.setBankcodeName(cds);
            crpUrechargelistDomain.setRechargeSmoney(crpRecharge.getRechargeMoney());
            if (EmptyUtil.isEmpty((Object)recharge.getRechargeUmoney())) {
                recharge.setRechargeUmoney(BigDecimal.ZERO);
            }
            if (EmptyUtil.isEmpty((Object)recharge.getRechargeBmoney())) {
                recharge.setRechargeBmoney(BigDecimal.ZERO);
            }
            crpUrechargelistDomain.setRechargeAllmoney(recharge.getRechargeUmoney().subtract(recharge.getRechargeBmoney()));
            crpUrechargelistDomain.setRechargeName8(crpRecharge.getRechargeId().toString());
            if (StringUtils.isBlank((String)crpUrechargelistDomain.getUrechargelistCode())) {
                crpUrechargelistDomain.setUrechargelistCode(this.getNo(null, "CrpUrechargelist", "crpUrechargelist", crpUrechargelistDomain.getTenantCode()));
            }
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("tenantCode", crpRecharge.getTenantCode());
            map1.put("userinfoCode", crpRecharge.getUserinfoCode());
            QueryResult<CrpUrecharge> queryResult = this.crpUrechargeService.queryCrpUrechargePage(map1);
            if (null == queryResult || ListUtil.isEmpty((Collection)queryResult.getList())) {
                this.logger.error("service.crp.CrpRechargeBaseServiceImpl.updateCrpRechargeEndToTime.queryResult", (Object)JsonUtil.buildNonNullBinder().toJson(map1));
                throw new ApiException("service.crp.CrpRechargeBaseServiceImpl.updateCrpUrechargeByAutomatic.queryResult", "\u6570\u636e\u9519\u8bef");
            }
            BigDecimal amountArrears = BigDecimal.ZERO;
            for (CrpUrecharge crp : queryResult.getList()) {
                if (EmptyUtil.isEmpty((Object)crp.getRechargeUmoney())) {
                    crp.setRechargeUmoney(BigDecimal.ZERO);
                }
                if (EmptyUtil.isEmpty((Object)crp.getRechargeBmoney())) {
                    crp.setRechargeBmoney(BigDecimal.ZERO);
                }
                amountArrears = amountArrears.add(crp.getRechargeUmoney().subtract(crp.getRechargeBmoney()));
            }
            if (amountArrears.compareTo(crpUrechargelistDomain.getRechargeSmoney()) < 0) {
                throw new ApiException("service.crp.CrpRechargeBaseServiceImpl.updateCrpUrechargeByAutomatic.amountArrears", "amountArrears:" + amountArrears + "rechargeSmoney:" + crpUrechargelistDomain.getRechargeSmoney());
            }
            crpUrechargelistDomain.setRechargeAllmoney(amountArrears.subtract(crpUrechargelistDomain.getRechargeSmoney()));
            crpUrechargelistDomain.setRechargeUrl3(crpUrechargelistDomain.getUrechargelistCode());
            if (MapUtil.isNotEmpty(map) && !EmptyUtil.isEmpty((Object)map.get("rechargeOpcodeStr"))) {
                crpUrechargelistDomain.setRechargeOpcode(map.get("rechargeOpcodeStr").toString());
            }
            if (MapUtil.isNotEmpty(map) && !EmptyUtil.isEmpty((Object)map.get("refundCode"))) {
                crpUrechargelistDomain.setRechargeUrl3(map.get("refundCode").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<CrpChannelsend> channelsends = this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        this.crpUrechargeService.saveOrUpdateCrpUrecharge(crpUrechargelistDomain);
        return channelsends;
    }

    private void loadDb(String tenantCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put("rechargeType", "0");
            map.put("rechargeName10", "3");
            map.put("rechargeState", 3);
            map.put("rechargeSort", "3");
            map.put("dataState", 2);
            map.put("order", true);
            map.put("orderStr", "RECHARGE_END  asc, RECHARGE_ID asc");
            this.logger.info("service.crp.CrpRechargeBaseServiceImpl.updateBmoneyCrpToReturn.map", (Object)JsonUtil.buildNonNullBinder().toJson(map));
            Date rechargeEndQstart = DateUtil.getDateToString((String)"2023-03-01", (String)"yyyy-MM-dd");
            map.put("rechargeEndQstart", rechargeEndQstart);
            int startRow = 0;
            boolean flag = true;
            QueryResult<CrpRecharge> result = null;
            map.put("startRow", startRow);
            map.put("rows", CrpRechargeBaseServiceImpl.getEsSendEngineService().getPage());
            result = this.crpRechargeService.queryCrpRechargePages(map);
            if (result == null || result.getPageTools() == null || ListUtil.isEmpty((Collection)result.getRows())) {
                return;
            }
            this.logger.info("service.crp.CrpRechargeBaseServiceImpl.addPutPool", (Object)JsonUtil.buildNormalBinder().toJson(result));
            CrpRechargeBaseServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(CrpRechargeBaseServiceImpl.getEsSendEngineService(), result.getRows()));
        }
        catch (Exception e) {
            throw new ApiException("service.crp.CrpRechargeBaseServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EsSendEngineService getEsSendEngineService() {
        Object object = lock;
        synchronized (object) {
            if (null == esSendEngineService) {
                esSendEngineService = new EsSendEngineService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 100; ++i) {
                    esSendEngineService.addPollPool(new EsSendEnginePollThread(esSendEngineService));
                }
            }
            return esSendEngineService;
        }
    }

    static {
        lock = new Object();
    }
}

