/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.common.FchannelTypeFactory;
import com.yqbsoft.laser.service.data.dao.DaCashSumListMapper;
import com.yqbsoft.laser.service.data.dao.DaSalesRateSumListMapper;
import com.yqbsoft.laser.service.data.dao.DaSalesSumListMapper;
import com.yqbsoft.laser.service.data.dao.DaSalesSumMapper;
import com.yqbsoft.laser.service.data.domain.DaCashSumListDomain;
import com.yqbsoft.laser.service.data.domain.DaCashSumListReDomain;
import com.yqbsoft.laser.service.data.domain.DaSalesRateSumListReDomain;
import com.yqbsoft.laser.service.data.domain.DaSalesSumDomain;
import com.yqbsoft.laser.service.data.domain.DaSalesSumListReDomain;
import com.yqbsoft.laser.service.data.domain.DaSalesSumReDomain;
import com.yqbsoft.laser.service.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractReDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.data.model.DaCashSumList;
import com.yqbsoft.laser.service.data.model.DaSalesRateSumList;
import com.yqbsoft.laser.service.data.model.DaSalesSum;
import com.yqbsoft.laser.service.data.model.DaSalesSumList;
import com.yqbsoft.laser.service.data.service.DaCashSumListService;
import com.yqbsoft.laser.service.data.service.DaSalesRateSumListService;
import com.yqbsoft.laser.service.data.service.DaSalesSumListService;
import com.yqbsoft.laser.service.data.service.DaSalesSumService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaSalesSumServiceImpl
extends BaseServiceImpl
implements DaSalesSumService {
    private static final String SYS_CODE = "da.DaSalesSumServiceImpl";
    private DaSalesSumMapper daSalesSumMapper;
    private DaCashSumListMapper daCashSumListMapper;
    private DaSalesSumListMapper daSalesSumListMapper;
    private DaSalesRateSumListMapper daSalesRateSumListMapper;
    private DaCashSumListService daCashSumListService;
    private DaSalesSumListService daSalesSumListService;
    private DaSalesRateSumListService daSalesRateSumListService;

    public void setDaCashSumListMapper(DaCashSumListMapper daCashSumListMapper) {
        this.daCashSumListMapper = daCashSumListMapper;
    }

    public void setDaSalesSumListMapper(DaSalesSumListMapper daSalesSumListMapper) {
        this.daSalesSumListMapper = daSalesSumListMapper;
    }

    public void setDaSalesRateSumListMapper(DaSalesRateSumListMapper daSalesRateSumListMapper) {
        this.daSalesRateSumListMapper = daSalesRateSumListMapper;
    }

    public void setDaSalesSumListService(DaSalesSumListService daSalesSumListService) {
        this.daSalesSumListService = daSalesSumListService;
    }

    public void setDaSalesRateSumListService(DaSalesRateSumListService daSalesRateSumListService) {
        this.daSalesRateSumListService = daSalesRateSumListService;
    }

    public void setDaCashSumListService(DaCashSumListService daCashSumListService) {
        this.daCashSumListService = daCashSumListService;
    }

    public void setDaSalesSumMapper(DaSalesSumMapper daSalesSumMapper) {
        this.daSalesSumMapper = daSalesSumMapper;
    }

    private Date getSysDate() {
        try {
            return this.daSalesSumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaSalesSumServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checksalesSum(DaSalesSumDomain daSalesSumDomain) {
        if (null == daSalesSumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daSalesSumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setsalesSumDefault(DaSalesSum daSalesSum) {
        if (null == daSalesSum) {
            return;
        }
        if (null == daSalesSum.getDataState()) {
            daSalesSum.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daSalesSum.getGmtCreate()) {
            daSalesSum.setGmtCreate(date);
        }
        daSalesSum.setGmtModified(date);
        if (StringUtils.isBlank((String)daSalesSum.getSalesSumCode())) {
            daSalesSum.setSalesSumCode(this.getNo(null, "DaSalesSum", "daSalesSum", daSalesSum.getTenantCode()));
        }
    }

    private int getsalesSumMaxCode() {
        int code = 0;
        try {
            return this.daSalesSumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaSalesSumServiceImpl.getsalesSumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setsalesSumUpdataDefault(DaSalesSum daSalesSum) {
        if (null == daSalesSum) {
            return;
        }
        daSalesSum.setGmtModified(this.getSysDate());
    }

    private void savesalesSumModel(DaSalesSum daSalesSum) throws ApiException {
        if (null == daSalesSum) {
            return;
        }
        try {
            this.daSalesSumMapper.insert(daSalesSum);
        }
        catch (Exception e) {
            throw new ApiException("da.DaSalesSumServiceImpl.savesalesSumModel.ex", (Throwable)e);
        }
    }

    private void savesalesSumBatchModel(List<DaSalesSum> daSalesSumList) throws ApiException {
        if (null == daSalesSumList || daSalesSumList.isEmpty()) {
            return;
        }
        try {
            this.daSalesSumMapper.insertBatch(daSalesSumList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaSalesSumServiceImpl.savesalesSumBatchModel.ex", (Throwable)e);
        }
    }

    private DaSalesSum getsalesSumModelById(Integer salesSumId) {
        if (null == salesSumId) {
            return null;
        }
        try {
            return this.daSalesSumMapper.selectByPrimaryKey(salesSumId);
        }
        catch (Exception e) {
            this.logger.error("da.DaSalesSumServiceImpl.getsalesSumModelById", (Throwable)e);
            return null;
        }
    }

    private DaSalesSum getsalesSumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daSalesSumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaSalesSumServiceImpl.getsalesSumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delsalesSumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daSalesSumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaSalesSumServiceImpl.delsalesSumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaSalesSumServiceImpl.delsalesSumModelByCode.num");
        }
    }

    private void deletesalesSumModel(Integer salesSumId) throws ApiException {
        if (null == salesSumId) {
            return;
        }
        int i = 0;
        try {
            i = this.daSalesSumMapper.deleteByPrimaryKey(salesSumId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaSalesSumServiceImpl.deletesalesSumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaSalesSumServiceImpl.deletesalesSumModel.num");
        }
    }

    private void updatesalesSumModel(DaSalesSum daSalesSum) throws ApiException {
        if (null == daSalesSum) {
            return;
        }
        int i = 0;
        try {
            i = this.daSalesSumMapper.updateByPrimaryKey(daSalesSum);
        }
        catch (Exception e) {
            throw new ApiException("da.DaSalesSumServiceImpl.updatesalesSumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaSalesSumServiceImpl.updatesalesSumModel.num");
        }
    }

    private void updateStatesalesSumModel(Integer salesSumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == salesSumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("salesSumId", salesSumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daSalesSumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaSalesSumServiceImpl.updateStatesalesSumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaSalesSumServiceImpl.updateStatesalesSumModel.null");
        }
    }

    private void updateStatesalesSumModelByCode(String tenantCode, String salesSumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)salesSumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salesSumCode", salesSumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daSalesSumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaSalesSumServiceImpl.updateStatesalesSumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaSalesSumServiceImpl.updateStatesalesSumModelByCode.null");
        }
    }

    private DaSalesSum makesalesSum(DaSalesSumDomain daSalesSumDomain, DaSalesSum daSalesSum) {
        if (null == daSalesSumDomain) {
            return null;
        }
        if (null == daSalesSum) {
            daSalesSum = new DaSalesSum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daSalesSum, (Object)daSalesSumDomain);
            daSalesSum.setTransactionDate(DateUtil.isDate((String)daSalesSumDomain.getTransactionDate(), (String)"yyyy-MM-dd"));
            return daSalesSum;
        }
        catch (Exception e) {
            this.logger.error("da.DaSalesSumServiceImpl.makesalesSum", (Throwable)e);
            return null;
        }
    }

    private DaSalesSumReDomain makeDaSalesSumReDomain(DaSalesSum daSalesSum) {
        if (null == daSalesSum) {
            return null;
        }
        DaSalesSumReDomain daSalesSumReDomain = new DaSalesSumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daSalesSumReDomain, (Object)daSalesSum);
            daSalesSumReDomain.setTransactionDate(DateUtil.parseDate((Date)daSalesSum.getTransactionDate()));
            return daSalesSumReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaSalesSumServiceImpl.makeDaSalesSumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaSalesSum> querysalesSumModelPage(Map<String, Object> parammap) {
        try {
            return this.daSalesSumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaSalesSumServiceImpl.querysalesSumModel", (Throwable)e);
            return null;
        }
    }

    private int countsalesSum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daSalesSumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaSalesSumServiceImpl.countsalesSum", (Throwable)e);
        }
        return i;
    }

    private DaSalesSum createDaSalesSum(DaSalesSumDomain daSalesSumDomain) {
        String msg = this.checksalesSum(daSalesSumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaSalesSumServiceImpl.savesalesSum.checksalesSum", msg);
        }
        DaSalesSum daSalesSum = this.makesalesSum(daSalesSumDomain, null);
        this.setsalesSumDefault(daSalesSum);
        return daSalesSum;
    }

    @Override
    public String savesalesSum(DaSalesSumDomain daSalesSumDomain) throws ApiException {
        DaSalesSum daSalesSum = this.createDaSalesSum(daSalesSumDomain);
        this.savesalesSumModel(daSalesSum);
        return daSalesSum.getSalesSumCode();
    }

    @Override
    public String savesalesSumBatch(List<DaSalesSumDomain> daSalesSumDomainList) throws ApiException {
        if (null == daSalesSumDomainList || daSalesSumDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaSalesSum> daSalesSumList = new ArrayList<DaSalesSum>();
        String code = "";
        for (DaSalesSumDomain daSalesSumDomain : daSalesSumDomainList) {
            DaSalesSum daSalesSum = this.createDaSalesSum(daSalesSumDomain);
            code = daSalesSum.getSalesSumCode();
            daSalesSumList.add(daSalesSum);
        }
        this.savesalesSumBatchModel(daSalesSumList);
        return code;
    }

    @Override
    public void updatesalesSumState(Integer salesSumId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == salesSumId) {
            return;
        }
        this.updateStatesalesSumModel(salesSumId, dataState, oldDataState, map);
    }

    @Override
    public void updatesalesSumStateByCode(String tenantCode, String salesSumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)salesSumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatesalesSumModelByCode(tenantCode, salesSumCode, dataState, oldDataState, map);
    }

    @Override
    public void updatesalesSum(DaSalesSumDomain daSalesSumDomain) throws ApiException {
        String msg = this.checksalesSum(daSalesSumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaSalesSumServiceImpl.updatesalesSum.checksalesSum", msg);
        }
        DaSalesSum oldDaSalesSum = this.getsalesSumModelById(daSalesSumDomain.getSalesSumId());
        if (null == oldDaSalesSum) {
            throw new ApiException("da.DaSalesSumServiceImpl.updatesalesSum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaSalesSum daSalesSum = this.makesalesSum(daSalesSumDomain, oldDaSalesSum);
        this.setsalesSumUpdataDefault(daSalesSum);
        this.updatesalesSumModel(daSalesSum);
    }

    @Override
    public DaSalesSum getsalesSum(Integer salesSumId) {
        if (null == salesSumId) {
            return null;
        }
        return this.getsalesSumModelById(salesSumId);
    }

    @Override
    public void deletesalesSum(Integer salesSumId) throws ApiException {
        if (null == salesSumId) {
            return;
        }
        this.deletesalesSumModel(salesSumId);
    }

    @Override
    public QueryResult<DaSalesSum> querysalesSumPage(Map<String, Object> map) {
        this.logger.error("----querysalesSumPage-----", (Object)JsonUtil.buildNormalBinder().toJson(map));
        List<DaSalesSum> daSalesSumList = this.querysalesSumModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countsalesSum(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daSalesSumList);
        return queryResult;
    }

    @Override
    public DaSalesSum getsalesSumByCode(String tenantCode, String salesSumCode) throws ApiException {
        if (StringUtils.isBlank((String)salesSumCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salesSumCode", salesSumCode);
        return this.getsalesSumModelByCode(map);
    }

    @Override
    public void deletesalesSumByCode(String tenantCode, String salesSumCode) throws ApiException {
        if (StringUtils.isBlank((String)salesSumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("salesSumCode", salesSumCode);
        this.delsalesSumModelByCode(map);
    }

    @Override
    public void createSalesOrderSumReport(String tenantCode) throws ApiException {
        ArrayList<OcContractReDomain> ocContractReDomainList;
        String date = DateUtil.getAfterDate((Date)new Date(), (int)-1, (String)"yyyy-MM-dd");
        String startDate = date + " 00:00:00";
        String endDate = date + " 23:59:59";
        ArrayList daSalesSumList = new ArrayList();
        List<OcContractReDomain> ocContractReDomains = this.queryOcContracts(tenantCode, startDate, endDate, 1);
        HashMap ocContractReDomainMap = new HashMap();
        if (ListUtil.isNotEmpty(ocContractReDomains)) {
            for (OcContractReDomain domain : ocContractReDomains) {
                ocContractReDomainList = ocContractReDomainMap.get(domain.getMemberCcode()) == null ? new ArrayList<OcContractReDomain>() : (List)ocContractReDomainMap.get(domain.getMemberCcode());
                ocContractReDomainList.add(domain);
            }
        }
        if (MapUtil.isNotEmpty(ocContractReDomainMap)) {
            for (String key : ocContractReDomainMap.keySet()) {
                ocContractReDomainList = (ArrayList<OcContractReDomain>)ocContractReDomainMap.get(key);
                DaSalesSumDomain salesSum = new DaSalesSumDomain();
                salesSum.setTenantCode(tenantCode);
                salesSum.setDataType(1);
                salesSum.setMemberCode(key);
                salesSum.setMemberName(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberCname());
                salesSum.setTransactionDate(date);
                salesSum.setBelegwaers("CNY");
                salesSum.setTransactionType("SA");
                salesSum.setTransactionStartDate(startDate);
                salesSum.setTransactionEndDate(endDate);
                String code = this.savesalesSum(salesSum);
                if (!ListUtil.isNotEmpty(ocContractReDomainList)) continue;
                for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
                    HashMap ocContractGoodsDomainMap = new HashMap();
                    List<OcContractGoodsDomain> ocContractGoodsDomains = ocContractReDomain.getGoodsList();
                    if (!ListUtil.isNotEmpty(ocContractGoodsDomains)) continue;
                }
            }
        }
    }

    @Override
    public void createRefundOrderSumReport(String tenantCode) throws ApiException {
        ArrayList<OcRefundReDomain> ocRefundReDomainList;
        String date = DateUtil.getAfterDate((Date)new Date(), (int)-1, (String)"yyyy-MM-dd");
        String startDate = date + " 00:00:00";
        String endDate = date + " 23:59:59";
        ArrayList daSalesSumList = new ArrayList();
        List<OcRefundReDomain> ocRefundReDomains = this.queryOcRefunds(tenantCode, startDate, endDate, 1);
        HashMap ocRefundReDomainMap = new HashMap();
        if (ListUtil.isNotEmpty(ocRefundReDomains)) {
            for (OcRefundReDomain domain : ocRefundReDomains) {
                ocRefundReDomainList = ocRefundReDomainMap.get(domain.getMemberCcode()) == null ? new ArrayList<OcRefundReDomain>() : (List)ocRefundReDomainMap.get(domain.getMemberCcode());
                ocRefundReDomainList.add(domain);
            }
        }
        if (MapUtil.isNotEmpty(ocRefundReDomainMap)) {
            for (String key : ocRefundReDomainMap.keySet()) {
                ocRefundReDomainList = (ArrayList<OcRefundReDomain>)ocRefundReDomainMap.get(key);
                DaSalesSumDomain salesSum = new DaSalesSumDomain();
                salesSum.setTenantCode(tenantCode);
                salesSum.setDataType(1);
                salesSum.setMemberCode(key);
                salesSum.setMemberName(((OcRefundReDomain)ocRefundReDomainList.get(0)).getMemberCname());
                salesSum.setTransactionDate(date);
                salesSum.setBelegwaers("CNY");
                salesSum.setTransactionType("SA");
                salesSum.setTransactionStartDate(startDate);
                salesSum.setTransactionEndDate(endDate);
                String code = this.savesalesSum(salesSum);
                if (!ListUtil.isNotEmpty(ocRefundReDomainList)) continue;
                for (OcRefundReDomain ocRefundReDomain : ocRefundReDomainList) {
                    HashMap ocRefundGoodsDomainMap = new HashMap();
                    List<OcRefundGoodsDomain> ocRefundGoodsDomains = ocRefundReDomain.getRefundGoodsList();
                    if (!ListUtil.isNotEmpty(ocRefundGoodsDomains)) continue;
                }
            }
        }
    }

    @Override
    public void createSalesCashSumReport(String tenantCode) throws ApiException {
        ArrayList<OcContractReDomain> ocContractReDomainList;
        String date = DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd");
        String startDate = date + " 00:00:00";
        String endDate = date + " 23:59:59";
        List<OcContractReDomain> ocContractReDomains = this.queryOcContracts(tenantCode, startDate, endDate, 3);
        HashMap ocContractReDomainMap = new HashMap();
        if (ListUtil.isNotEmpty(ocContractReDomains)) {
            for (OcContractReDomain domain : ocContractReDomains) {
                ocContractReDomainList = ocContractReDomainMap.get(domain.getMemberCcode()) == null ? new ArrayList<OcContractReDomain>() : (List)ocContractReDomainMap.get(domain.getMemberCcode());
                ocContractReDomainList.add(domain);
                ocContractReDomainMap.put(domain.getMemberCcode(), ocContractReDomainList);
            }
        }
        if (MapUtil.isNotEmpty(ocContractReDomainMap)) {
            for (String key : ocContractReDomainMap.keySet()) {
                ocContractReDomainList = (ArrayList<OcContractReDomain>)ocContractReDomainMap.get(key);
                DaSalesSumDomain salesSum = new DaSalesSumDomain();
                salesSum.setTenantCode(tenantCode);
                salesSum.setDataType(3);
                salesSum.setMemberCode(key);
                salesSum.setMemberName(((OcContractReDomain)ocContractReDomainList.get(0)).getMemberCname());
                salesSum.setTransactionDate(date);
                salesSum.setBelegwaers("CNY");
                salesSum.setTransactionType("SA");
                salesSum.setTransactionStartDate(startDate);
                salesSum.setTransactionEndDate(endDate);
                String code = this.savesalesSum(salesSum);
                ArrayList<DaCashSumListDomain> daCashSumListDomains = new ArrayList<DaCashSumListDomain>();
                HashMap payMap = new HashMap();
                if (ListUtil.isNotEmpty(ocContractReDomainList)) {
                    for (OcContractReDomain ocContractReDomain : ocContractReDomainList) {
                        ArrayList<OcContractReDomain> contractReDomains = payMap.get(ocContractReDomain.getFchannelCode()) == null ? new ArrayList<OcContractReDomain>() : (List)payMap.get(ocContractReDomain.getFchannelCode());
                        contractReDomains.add(ocContractReDomain);
                        ocContractReDomainMap.put(ocContractReDomain.getFchannelCode(), contractReDomains);
                    }
                    if (MapUtil.isNotEmpty(ocContractReDomainMap)) {
                        for (String orderKey : ocContractReDomainMap.keySet()) {
                            DaCashSumListDomain cashSumListDomain = new DaCashSumListDomain();
                            cashSumListDomain.setTenantCode(tenantCode);
                            cashSumListDomain.setSalesSumCode(code);
                            cashSumListDomain.setAmountSign("+");
                            cashSumListDomain.setTransactionCurrency("CNY");
                            cashSumListDomain.setTransactionCode(FchannelTypeFactory.getChannelType(orderKey));
                            List moneyList = (List)ocContractReDomainMap.get(orderKey);
                            BigDecimal amount = new BigDecimal(0);
                            if (ListUtil.isNotEmpty((Collection)moneyList)) {
                                for (OcContractReDomain oc : moneyList) {
                                    amount = amount.add(oc.getContractPaygmoney());
                                }
                            }
                            cashSumListDomain.setTransactionAmount(amount);
                            daCashSumListDomains.add(cashSumListDomain);
                        }
                    }
                }
                this.daCashSumListService.savecashSumListBatch(daCashSumListDomains);
            }
        }
    }

    @Override
    public void createRefundCashSumReport(String tenantCode) throws ApiException {
        ArrayList<OcRefundReDomain> ocRefundReDomainList;
        String date = DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd");
        String startDate = date + " 00:00:00";
        String endDate = date + " 23:59:59";
        List<OcRefundReDomain> ocRefundReDomains = this.queryOcRefunds(tenantCode, startDate, endDate, 3);
        HashMap ocRefundReDomainMap = new HashMap();
        if (ListUtil.isNotEmpty(ocRefundReDomains)) {
            for (OcRefundReDomain domain : ocRefundReDomains) {
                ocRefundReDomainList = ocRefundReDomainMap.get(domain.getMemberCcode()) == null ? new ArrayList<OcRefundReDomain>() : (List)ocRefundReDomainMap.get(domain.getMemberCcode());
                ocRefundReDomainList.add(domain);
                ocRefundReDomainMap.put(domain.getMemberCcode(), ocRefundReDomainList);
            }
        }
        if (MapUtil.isNotEmpty(ocRefundReDomainMap)) {
            for (String key : ocRefundReDomainMap.keySet()) {
                ocRefundReDomainList = (ArrayList<OcRefundReDomain>)ocRefundReDomainMap.get(key);
                DaSalesSumDomain salesSum = new DaSalesSumDomain();
                salesSum.setTenantCode(tenantCode);
                salesSum.setDataType(3);
                salesSum.setMemberCode(key);
                salesSum.setMemberName(((OcRefundReDomain)ocRefundReDomainList.get(0)).getMemberCname());
                salesSum.setTransactionDate(date);
                salesSum.setBelegwaers("CNY");
                salesSum.setTransactionType("SA");
                salesSum.setTransactionStartDate(startDate);
                salesSum.setTransactionEndDate(endDate);
                String code = this.savesalesSum(salesSum);
                ArrayList<DaCashSumListDomain> daCashSumListDomains = new ArrayList<DaCashSumListDomain>();
                HashMap payMap = new HashMap();
                if (ListUtil.isNotEmpty(ocRefundReDomainList)) {
                    for (OcRefundReDomain ocRefundReDomain : ocRefundReDomainList) {
                        ArrayList<OcRefundReDomain> RefundReDomains = payMap.get(ocRefundReDomain.getFchannelCode()) == null ? new ArrayList<OcRefundReDomain>() : (List)payMap.get(ocRefundReDomain.getFchannelCode());
                        RefundReDomains.add(ocRefundReDomain);
                        ocRefundReDomainMap.put(ocRefundReDomain.getFchannelCode(), RefundReDomains);
                    }
                    if (MapUtil.isNotEmpty(ocRefundReDomainMap)) {
                        for (String orderKey : ocRefundReDomainMap.keySet()) {
                            DaCashSumListDomain cashSumListDomain = new DaCashSumListDomain();
                            cashSumListDomain.setTenantCode(tenantCode);
                            cashSumListDomain.setSalesSumCode(code);
                            cashSumListDomain.setAmountSign("+");
                            cashSumListDomain.setTransactionCurrency("CNY");
                            cashSumListDomain.setTransactionCode(FchannelTypeFactory.getChannelType(orderKey));
                            List moneyList = (List)ocRefundReDomainMap.get(orderKey);
                            BigDecimal amount = new BigDecimal(0);
                            if (ListUtil.isNotEmpty((Collection)moneyList)) {
                                for (OcRefundReDomain oc : moneyList) {
                                    amount = amount.add(oc.getContractPaymoney());
                                }
                            }
                            cashSumListDomain.setTransactionAmount(amount);
                            daCashSumListDomains.add(cashSumListDomain);
                        }
                    }
                }
                this.daCashSumListService.savecashSumListBatch(daCashSumListDomains);
            }
        }
    }

    @Override
    public void sendSalesOrderSum(String tenantCode) throws ApiException {
        List<DaSalesSum> daSalesSumList;
        String date = DateUtil.getAfterDate((Date)new Date(), (int)-1, (String)"yyyy-MM-dd");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("transactionDate", DateUtil.isDate((String)date, (String)"yyyyMMdd"));
        int count = this.countsalesSum(map);
        if (count < 100) {
            // empty if block
        }
        if (ListUtil.isNotEmpty(daSalesSumList = this.querysalesSumModelPage(map))) {
            for (DaSalesSum salesSum : daSalesSumList) {
                HashMap<String, Object> listMap = new HashMap<String, Object>();
                listMap.put("tenantCode", tenantCode);
                listMap.put("salesSumCode", salesSum.getSalesSumCode());
                if (salesSum.getDataType() == 3 || salesSum.getDataType() == 4) {
                    QueryResult<DaSalesRateSumList> daSalesRateSumListQueryResult = this.daSalesRateSumListService.querysalesRateSumListPage(listMap);
                    if (daSalesRateSumListQueryResult == null || !ListUtil.isNotEmpty((Collection)daSalesRateSumListQueryResult.getList())) continue;
                    for (DaSalesRateSumList rate : daSalesRateSumListQueryResult.getList()) {
                        DaSalesRateSumListReDomain rateReDomain = new DaSalesRateSumListReDomain();
                        try {
                            BeanUtils.copyAllPropertys((Object)rateReDomain, (Object)rate);
                        }
                        catch (Exception e) {
                            this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                        }
                    }
                    continue;
                }
                QueryResult<DaSalesSumList> salesSumListQueryResult = this.daSalesSumListService.querysalesSumListPage(listMap);
                if (salesSumListQueryResult == null || !ListUtil.isNotEmpty((Collection)salesSumListQueryResult.getList())) continue;
                for (DaSalesSumList sum : salesSumListQueryResult.getList()) {
                    HashMap<String, Object> rateMap = new HashMap<String, Object>();
                    rateMap.put("tenantCode", tenantCode);
                    rateMap.put("salesSumCode", salesSum.getSalesSumCode());
                    rateMap.put("salesSumListCode", sum.getSalesSumListCode());
                    QueryResult<DaSalesRateSumList> salesRateSumListQueryResult = this.daSalesRateSumListService.querysalesRateSumListPage(rateMap);
                    if (salesRateSumListQueryResult == null || !ListUtil.isNotEmpty((Collection)salesRateSumListQueryResult.getList())) continue;
                    for (DaSalesRateSumList rateSumListReDomain : salesRateSumListQueryResult.getList()) {
                        DaSalesRateSumListReDomain rateDomain = new DaSalesRateSumListReDomain();
                        try {
                            BeanUtils.copyAllPropertys((Object)rateDomain, (Object)rateSumListReDomain);
                        }
                        catch (Exception e) {
                            this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void sendRefundOrderSum(String tenantCode) throws ApiException {
    }

    @Override
    public void sendSalesCashSum(String tenantCode) throws ApiException {
    }

    @Override
    public void sendRefundCashSum(String tenantCode) throws ApiException {
    }

    @Override
    public List<DaSalesSumReDomain> sendSumData(Map<String, Object> map) throws ApiException {
        this.logger.error("----------------sendSumData\u5f00\u59cb-----------------------", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (null == map) {
            return null;
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (map.get("flag") != null && (Integer)map.get("flag") == 0) {
            queryMap.put("salesSumCode", map.get("salesSumCode"));
            queryMap.put("dataStateStr", "0,2");
            queryMap.put("order", true);
            queryMap.put("fuzzy", true);
        } else {
            queryMap.put("tenantCode", (String)map.get("tenantCode"));
            queryMap.put("dataType", (Integer)map.get("dataType"));
            queryMap.put("dataStateStr", "0");
            queryMap.put("transactionStartDate", (String)map.get("startDate"));
            queryMap.put("transactionEndDate", (String)map.get("endDate"));
        }
        queryMap.put("rows", 1);
        queryMap.put("page", 1);
        queryMap.put("startRow", 0);
        queryMap.put("endRow", 1);
        this.logger.error("----------------sendSumData\u67e5\u8be2\u53c2\u6570-----------------------", (Object)JsonUtil.buildNormalBinder().toJson(queryMap));
        ArrayList<DaSalesSumReDomain> daSalesSumReDomains = new ArrayList<DaSalesSumReDomain>();
        QueryResult<DaSalesSum> daSalesSumList = this.querysalesSumPage(queryMap);
        if (daSalesSumReDomains != null && ListUtil.isNotEmpty((Collection)daSalesSumList.getList())) {
            this.logger.error("----------------DaSalesSum\u6570\u91cf-----------------------", (Object)daSalesSumList.getList().size());
            for (DaSalesSum salesSum : daSalesSumList.getList()) {
                DaSalesSumReDomain salesSumReDomain = new DaSalesSumReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)salesSumReDomain, (Object)salesSum);
                    salesSumReDomain.setTransactionEndDate(salesSum.getTransactionEndDate().replace("-", "").replace(":", "").replace(" ", ""));
                    salesSumReDomain.setTransactionStartDate(salesSum.getTransactionStartDate().replace("-", "").replace(":", "").replace(" ", ""));
                    salesSumReDomain.setTransactionDate(DateUtil.parseDate((Date)salesSum.getTransactionDate()).replace("-", ""));
                }
                catch (Exception e) {
                    this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                }
                HashMap<String, Object> listMap = new HashMap<String, Object>();
                listMap.put("salesSumCode", salesSum.getSalesSumCode());
                if (salesSum.getDataType() == 3 || salesSum.getDataType() == 4) {
                    QueryResult<DaCashSumList> daCashSumListQueryResult = this.daCashSumListService.querycashSumListPage(listMap);
                    ArrayList<DaCashSumListReDomain> daCashSumListReDomainList = new ArrayList<DaCashSumListReDomain>();
                    if (daCashSumListQueryResult != null && ListUtil.isNotEmpty((Collection)daCashSumListQueryResult.getList())) {
                        this.logger.error("----------------DaCashSumList\u6570\u91cf-----------------------", (Object)daCashSumListQueryResult.getList().size());
                        for (DaCashSumList cash : daCashSumListQueryResult.getList()) {
                            DaCashSumListReDomain daCashSumListReDomain = new DaCashSumListReDomain();
                            try {
                                BeanUtils.copyAllPropertys((Object)daCashSumListReDomain, (Object)cash);
                            }
                            catch (Exception e) {
                                this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                            }
                            daCashSumListReDomainList.add(daCashSumListReDomain);
                        }
                        salesSumReDomain.setDaCashSumListReDomainList(daCashSumListReDomainList);
                    }
                } else {
                    ArrayList<DaSalesSumListReDomain> daSalesSumListReDomainList = new ArrayList<DaSalesSumListReDomain>();
                    QueryResult<DaSalesSumList> salesSumListQueryResult = this.daSalesSumListService.querysalesSumListPage(listMap);
                    if (salesSumListQueryResult != null && ListUtil.isNotEmpty((Collection)salesSumListQueryResult.getList())) {
                        this.logger.error("----------------salesSumListQueryResult\u6570\u91cf-----------------------", (Object)salesSumListQueryResult.getList().size());
                        for (DaSalesSumList sum : salesSumListQueryResult.getList()) {
                            DaSalesSumListReDomain daSalesSumListReDomain = new DaSalesSumListReDomain();
                            try {
                                BeanUtils.copyAllPropertys((Object)daSalesSumListReDomain, (Object)sum);
                            }
                            catch (Exception e) {
                                this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                            }
                            HashMap<String, Object> rateMap = new HashMap<String, Object>();
                            rateMap.put("salesSumCode", salesSum.getSalesSumCode());
                            rateMap.put("salesSumListCode", sum.getSalesSumListCode());
                            QueryResult<DaSalesRateSumList> salesRateSumListQueryResult = this.daSalesRateSumListService.querysalesRateSumListPage(rateMap);
                            ArrayList<DaSalesRateSumListReDomain> daSalesRateSumListReDomains = new ArrayList<DaSalesRateSumListReDomain>();
                            if (salesRateSumListQueryResult != null && ListUtil.isNotEmpty((Collection)salesRateSumListQueryResult.getList())) {
                                for (DaSalesRateSumList rateSumListReDomain : salesRateSumListQueryResult.getList()) {
                                    DaSalesRateSumListReDomain rateDomain = new DaSalesRateSumListReDomain();
                                    try {
                                        BeanUtils.copyAllPropertys((Object)rateDomain, (Object)rateSumListReDomain);
                                    }
                                    catch (Exception e) {
                                        this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                                    }
                                    daSalesRateSumListReDomains.add(rateDomain);
                                }
                                daSalesSumListReDomain.setDaSalesRateSumListReDomainList(daSalesRateSumListReDomains);
                            }
                            daSalesSumListReDomainList.add(daSalesSumListReDomain);
                        }
                    }
                    salesSumReDomain.setDaSalesSumListReDomainList(daSalesSumListReDomainList);
                }
                daSalesSumReDomains.add(salesSumReDomain);
            }
        }
        this.logger.error("----------------sendSumData\u7ed3\u675f-----------------------", (Object)daSalesSumReDomains.size());
        return daSalesSumReDomains;
    }

    @Override
    public void sendAllSumData(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (map.get("flag") != null && (Integer)map.get("flag") == 0) {
            queryMap.put("salesSumCode", map.get("salesSumCode"));
            queryMap.put("dataStateStr", "0,2");
            queryMap.put("order", true);
            queryMap.put("fuzzy", true);
        } else {
            queryMap.put("dataType", (Integer)map.get("dataType"));
            queryMap.put("dataStateStr", "0");
            if (map.get("startDate") == null && map.get("endDate") != null) {
                queryMap.put("transactionStartDate", (String)map.get("startDate"));
                queryMap.put("transactionEndDate", (String)map.get("endDate"));
            }
        }
        this.logger.error("----------------sendSumData\u5f00\u59cb\u67e5\u8be2\u53c2\u6570-----------------------", (Object)JsonUtil.buildNormalBinder().toJson(queryMap));
        QueryResult<DaSalesSum> daSalesSumList = this.querysalesSumPage(queryMap);
        if (ListUtil.isNotEmpty((Collection)daSalesSumList.getList())) {
            this.logger.error("----------------DaSalesSum\u6570\u91cf-----------------------", (Object)daSalesSumList.getList().size());
            for (DaSalesSum salesSum : daSalesSumList.getList()) {
                DaSalesSumReDomain salesSumReDomain = new DaSalesSumReDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)salesSumReDomain, (Object)salesSum);
                    salesSumReDomain.setTransactionEndDate(salesSum.getTransactionEndDate().replace("-", "").replace(":", "").replace(" ", ""));
                    salesSumReDomain.setTransactionStartDate(salesSum.getTransactionStartDate().replace("-", "").replace(":", "").replace(" ", ""));
                    salesSumReDomain.setTransactionDate(DateUtil.parseDate((Date)salesSum.getTransactionDate()).replace("-", ""));
                }
                catch (Exception e) {
                    this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                }
                HashMap<String, Object> listMap = new HashMap<String, Object>();
                listMap.put("salesSumCode", salesSum.getSalesSumCode());
                listMap.put("tenantCode", (String)map.get("tenantCode"));
                if (salesSum.getDataType() == 3 || salesSum.getDataType() == 4) {
                    List<DaCashSumList> daCashSumListList = this.daCashSumListMapper.query(listMap);
                    ArrayList<DaCashSumListReDomain> daCashSumListReDomainList = new ArrayList<DaCashSumListReDomain>();
                    if (ListUtil.isNotEmpty(daCashSumListList)) {
                        this.logger.error("----------------DaCashSumList\u6570\u91cf-----------------------", (Object)daCashSumListList.size());
                        for (DaCashSumList cash : daCashSumListList) {
                            DaCashSumListReDomain daCashSumListReDomain = new DaCashSumListReDomain();
                            try {
                                BeanUtils.copyAllPropertys((Object)daCashSumListReDomain, (Object)cash);
                            }
                            catch (Exception e) {
                                this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                            }
                            daCashSumListReDomainList.add(daCashSumListReDomain);
                        }
                        salesSumReDomain.setDaCashSumListReDomainList(daCashSumListReDomainList);
                    }
                } else {
                    ArrayList<DaSalesSumListReDomain> daSalesSumListReDomainList = new ArrayList<DaSalesSumListReDomain>();
                    List<DaSalesSumList> salesSumLists = this.daSalesSumListMapper.query(listMap);
                    if (ListUtil.isNotEmpty(salesSumLists)) {
                        this.logger.error("----------------salesSumListQueryResult\u6570\u91cf-----------------------", (Object)salesSumLists.size());
                        for (DaSalesSumList sum : salesSumLists) {
                            DaSalesSumListReDomain daSalesSumListReDomain = new DaSalesSumListReDomain();
                            try {
                                BeanUtils.copyAllPropertys((Object)daSalesSumListReDomain, (Object)sum);
                            }
                            catch (Exception e) {
                                this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                            }
                            HashMap<String, Object> rateMap = new HashMap<String, Object>();
                            rateMap.put("salesSumCode", salesSum.getSalesSumCode());
                            rateMap.put("salesSumListCode", sum.getSalesSumListCode());
                            List<DaSalesRateSumList> salesRateSumLists = this.daSalesRateSumListMapper.query(rateMap);
                            ArrayList<DaSalesRateSumListReDomain> daSalesRateSumListReDomains = new ArrayList<DaSalesRateSumListReDomain>();
                            if (ListUtil.isNotEmpty(salesRateSumLists)) {
                                for (DaSalesRateSumList rateSumListReDomain : salesRateSumLists) {
                                    DaSalesRateSumListReDomain rateDomain = new DaSalesRateSumListReDomain();
                                    try {
                                        BeanUtils.copyAllPropertys((Object)rateDomain, (Object)rateSumListReDomain);
                                    }
                                    catch (Exception e) {
                                        this.logger.error("da.DaSalesSumServiceImpl.sendSalesOrderSum", (Throwable)e);
                                    }
                                    daSalesRateSumListReDomains.add(rateDomain);
                                }
                                daSalesSumListReDomain.setDaSalesRateSumListReDomainList(daSalesRateSumListReDomains);
                            }
                            daSalesSumListReDomainList.add(daSalesSumListReDomain);
                        }
                    }
                    salesSumReDomain.setDaSalesSumListReDomainList(daSalesSumListReDomainList);
                }
                HashMap<String, DaSalesSumReDomain> data = new HashMap<String, DaSalesSumReDomain>();
                data.put("salesSumReDomain", salesSumReDomain);
                HashMap<String, String> invokeMap = new HashMap<String, String>();
                invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(data));
                String result = "";
                if (salesSumReDomain.getDataType() == 1 || salesSumReDomain.getDataType() == 2) {
                    result = (String)this.readObj("jbsSap.contract.sendContract", invokeMap, "object", new Object[]{String.class});
                } else if (salesSumReDomain.getDataType() == 3 || salesSumReDomain.getDataType() == 4) {
                    result = (String)this.readObj("jbsSap.contract.sendContractPayment", invokeMap, "object", new Object[]{String.class});
                }
                this.logger.error("----------------jbsSap\u8fd4\u56de\u7ed3\u679c-----------------------", (Object)result);
                if (!StringUtils.isNotBlank((String)result)) continue;
                Map resultMap = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(result, String.class, Object.class);
                HashMap<String, Object> updMap = new HashMap<String, Object>();
                updMap.put("salesSumCode", salesSumReDomain.getSalesSumCode());
                if (resultMap != null && ((Boolean)resultMap.get("success")).booleanValue()) {
                    updMap.put("dataState", 1);
                } else {
                    updMap.put("dataState", 2);
                }
                updMap.put("memo", resultMap.get("msg") != null ? (String)resultMap.get("msg") : "");
                try {
                    this.daSalesSumMapper.updateStateByCode(updMap);
                }
                catch (Exception e) {
                    throw new ApiException("da.DaSalesSumServiceImpl.updateStatesalesSumModelByCode.ex", (Throwable)e);
                }
            }
        }
        this.logger.error("----------------sendSumData\u7ed3\u675f-----------------------", (Object)daSalesSumList.getList().size());
    }

    @Override
    public Map<String, Object> updateDataState(Map<String, Object> map) throws ApiException {
        this.logger.error("----------------updateDataState\u5f00\u59cb-----------------------", (Object)JsonUtil.buildNormalBinder().toJson(map));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("flag", false);
        if (null == map) {
            return result;
        }
        if (map.get("salesSumCode") == null || map.get("dataState") == null) {
            return result;
        }
        try {
            this.daSalesSumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaSalesSumServiceImpl.updateStatesalesSumModelByCode.ex", (Throwable)e);
        }
        result.put("flag", true);
        return result;
    }

    private List<OcRefundReDomain> queryOcRefunds(String tenantCode, String startDate, String endDate, int type) {
        List<OcRefundReDomain> ocRefundReDomains = new ArrayList<OcRefundReDomain>();
        HashMap<String, Object> queryOcMap = new HashMap<String, Object>();
        queryOcMap.put("tenantCode", tenantCode);
        queryOcMap.put("gmtModifiedQstart", startDate);
        queryOcMap.put("gmtModifiedQend", endDate);
        queryOcMap.put("dataState", 3);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryOcMap));
        QueryResult queryResutl = this.getQueryResutl("oc.refund.ocDataTotal", invokeMap, OcRefundReDomain.class);
        if (queryResutl != null && ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
            if (type == 3 || type == 4) {
                for (OcRefundReDomain domain : queryResutl.getList()) {
                    if (!"70".equals(domain.getContractType()) || !"00".equals(domain.getContractType()) || !"60".equals(domain.getContractType())) continue;
                    ocRefundReDomains.add(domain);
                }
            } else {
                ocRefundReDomains = queryResutl.getList();
            }
        }
        return ocRefundReDomains;
    }

    private List<OcContractReDomain> queryOcContracts(String tenantCode, String startDate, String endDate, int type) {
        List<OcContractReDomain> ocContractReDomains = new ArrayList<OcContractReDomain>();
        HashMap<String, Object> queryOcMap = new HashMap<String, Object>();
        queryOcMap.put("tenantCode", tenantCode);
        queryOcMap.put("gmtModifiedQstart", startDate);
        queryOcMap.put("gmtModifiedQend", endDate);
        queryOcMap.put("dataState", 3);
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryOcMap));
        QueryResult queryResutl = this.getQueryResutl("oc.contract.ocDataTotal", invokeMap, OcContractReDomain.class);
        if (queryResutl != null && ListUtil.isNotEmpty((Collection)queryResutl.getList())) {
            if (type == 3 || type == 4) {
                for (OcContractReDomain domain : queryResutl.getList()) {
                    if (!"70".equals(domain.getContractType()) || !"00".equals(domain.getContractType()) || !"60".equals(domain.getContractType())) continue;
                    ocContractReDomains.add(domain);
                }
            } else {
                ocContractReDomains = queryResutl.getList();
            }
        }
        return ocContractReDomains;
    }

    private List<OcContractGoodsDomain> queryOcContractGoods() {
        return null;
    }

    public static void main(String[] args) {
        int count = 97;
        System.out.println(count % 100);
    }
}

