/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOrderSumGoodsMapper;
import com.yqbsoft.laser.service.data.domain.DaOrderSumGoodsDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderSumGoodsReDomain;
import com.yqbsoft.laser.service.data.model.DaOrderSumGoods;
import com.yqbsoft.laser.service.data.service.DaOrderSumGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaOrderSumGoodsServiceImpl
extends BaseServiceImpl
implements DaOrderSumGoodsService {
    private static final String SYS_CODE = SYS_CODE + ".DaOrderSumGoodsServiceImpl";
    private DaOrderSumGoodsMapper daOrderSumGoodsMapper;

    public void setDaOrderSumGoodsMapper(DaOrderSumGoodsMapper daOrderSumGoodsMapper) {
        this.daOrderSumGoodsMapper = daOrderSumGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.daOrderSumGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkOrderSumGoods(DaOrderSumGoodsDomain daOrderSumGoodsDomain) {
        if (null == daOrderSumGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOrderSumGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setOrderSumGoodsDefault(DaOrderSumGoods daOrderSumGoods) {
        if (null == daOrderSumGoods) {
            return;
        }
        if (null == daOrderSumGoods.getDataState()) {
            daOrderSumGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOrderSumGoods.getGmtCreate()) {
            daOrderSumGoods.setGmtCreate(date);
        }
        daOrderSumGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)daOrderSumGoods.getOrderSumGoodsCode())) {
            daOrderSumGoods.setOrderSumGoodsCode(this.getNo(null, "DaOrderSumGoods", "daOrderSumGoods", daOrderSumGoods.getTenantCode()));
        }
    }

    private int getOrderSumGoodsMaxCode() {
        int code = 0;
        try {
            return this.daOrderSumGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderSumGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setOrderSumGoodsUpdataDefault(DaOrderSumGoods daOrderSumGoods) {
        if (null == daOrderSumGoods) {
            return;
        }
        daOrderSumGoods.setGmtModified(this.getSysDate());
    }

    private void saveOrderSumGoodsModel(DaOrderSumGoods daOrderSumGoods) throws ApiException {
        if (null == daOrderSumGoods) {
            return;
        }
        try {
            this.daOrderSumGoodsMapper.insert(daOrderSumGoods);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderSumGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveOrderSumGoodsBatchModel(List<DaOrderSumGoods> daOrderSumGoodsList) throws ApiException {
        if (null == daOrderSumGoodsList || daOrderSumGoodsList.isEmpty()) {
            return;
        }
        try {
            this.daOrderSumGoodsMapper.insertBatch(daOrderSumGoodsList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderSumGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private DaOrderSumGoods getOrderSumGoodsModelById(Integer orderSumGoodsId) {
        if (null == orderSumGoodsId) {
            return null;
        }
        try {
            return this.daOrderSumGoodsMapper.selectByPrimaryKey(orderSumGoodsId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderSumGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private DaOrderSumGoods getOrderSumGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daOrderSumGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderSumGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delOrderSumGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderSumGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delOrderSumGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delOrderSumGoodsModelByCode.num");
        }
    }

    private void deleteOrderSumGoodsModel(Integer orderSumGoodsId) throws ApiException {
        if (null == orderSumGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderSumGoodsMapper.deleteByPrimaryKey(orderSumGoodsId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteOrderSumGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteOrderSumGoodsModel.num");
        }
    }

    private void updateOrderSumGoodsModel(DaOrderSumGoods daOrderSumGoods) throws ApiException {
        if (null == daOrderSumGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderSumGoodsMapper.updateByPrimaryKey(daOrderSumGoods);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderSumGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateOrderSumGoodsModel.num");
        }
    }

    private void updateStateOrderSumGoodsModel(Integer orderSumGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == orderSumGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orderSumGoodsId", orderSumGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderSumGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateOrderSumGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateOrderSumGoodsModel.null");
        }
    }

    private void updateStateOrderSumGoodsModelByCode(String tenantCode, String orderSumGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)orderSumGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderSumGoodsCode", orderSumGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderSumGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateOrderSumGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateOrderSumGoodsModelByCode.null");
        }
    }

    private DaOrderSumGoods makeOrderSumGoods(DaOrderSumGoodsDomain daOrderSumGoodsDomain, DaOrderSumGoods daOrderSumGoods) {
        if (null == daOrderSumGoodsDomain) {
            return null;
        }
        if (null == daOrderSumGoods) {
            daOrderSumGoods = new DaOrderSumGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOrderSumGoods, (Object)daOrderSumGoodsDomain);
            return daOrderSumGoods;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeOrderSumGoods", (Throwable)e);
            return null;
        }
    }

    private DaOrderSumGoodsReDomain makeDaOrderSumGoodsReDomain(DaOrderSumGoods daOrderSumGoods) {
        if (null == daOrderSumGoods) {
            return null;
        }
        DaOrderSumGoodsReDomain daOrderSumGoodsReDomain = new DaOrderSumGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOrderSumGoodsReDomain, (Object)daOrderSumGoods);
            return daOrderSumGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaOrderSumGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaOrderSumGoods> queryOrderSumGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.daOrderSumGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryOrderSumGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderSumGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOrderSumGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countOrderSumGoods", (Throwable)e);
        }
        return i;
    }

    private DaOrderSumGoods createDaOrderSumGoods(DaOrderSumGoodsDomain daOrderSumGoodsDomain) {
        String msg = this.checkOrderSumGoods(daOrderSumGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveOrderSumGoods.checkOrderSumGoods", msg);
        }
        DaOrderSumGoods daOrderSumGoods = this.makeOrderSumGoods(daOrderSumGoodsDomain, null);
        this.setOrderSumGoodsDefault(daOrderSumGoods);
        return daOrderSumGoods;
    }

    @Override
    public String saveOrderSumGoods(DaOrderSumGoodsDomain daOrderSumGoodsDomain) throws ApiException {
        DaOrderSumGoods daOrderSumGoods = this.createDaOrderSumGoods(daOrderSumGoodsDomain);
        this.saveOrderSumGoodsModel(daOrderSumGoods);
        return daOrderSumGoods.getOrderSumGoodsCode();
    }

    @Override
    public String saveOrderSumGoodsBatch(List<DaOrderSumGoodsDomain> daOrderSumGoodsDomainList) throws ApiException {
        if (null == daOrderSumGoodsDomainList || daOrderSumGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderSumGoods> daOrderSumGoodsList = new ArrayList<DaOrderSumGoods>();
        String code = "";
        for (DaOrderSumGoodsDomain daOrderSumGoodsDomain : daOrderSumGoodsDomainList) {
            DaOrderSumGoods daOrderSumGoods = this.createDaOrderSumGoods(daOrderSumGoodsDomain);
            code = daOrderSumGoods.getOrderSumGoodsCode();
            daOrderSumGoodsList.add(daOrderSumGoods);
        }
        this.saveOrderSumGoodsBatchModel(daOrderSumGoodsList);
        return code;
    }

    @Override
    public void updateOrderSumGoodsState(Integer orderSumGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == orderSumGoodsId) {
            return;
        }
        this.updateStateOrderSumGoodsModel(orderSumGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderSumGoodsStateByCode(String tenantCode, String orderSumGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)orderSumGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrderSumGoodsModelByCode(tenantCode, orderSumGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderSumGoods(DaOrderSumGoodsDomain daOrderSumGoodsDomain) throws ApiException {
        String msg = this.checkOrderSumGoods(daOrderSumGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateOrderSumGoods.checkOrderSumGoods", msg);
        }
        DaOrderSumGoods oldDaOrderSumGoods = this.getOrderSumGoodsModelById(daOrderSumGoodsDomain.getOrderSumGoodsId());
        if (null == oldDaOrderSumGoods) {
            throw new ApiException(SYS_CODE + ".updateOrderSumGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOrderSumGoods daOrderSumGoods = this.makeOrderSumGoods(daOrderSumGoodsDomain, oldDaOrderSumGoods);
        this.setOrderSumGoodsUpdataDefault(daOrderSumGoods);
        this.updateOrderSumGoodsModel(daOrderSumGoods);
    }

    @Override
    public DaOrderSumGoods getOrderSumGoods(Integer orderSumGoodsId) {
        if (null == orderSumGoodsId) {
            return null;
        }
        return this.getOrderSumGoodsModelById(orderSumGoodsId);
    }

    @Override
    public void deleteOrderSumGoods(Integer orderSumGoodsId) throws ApiException {
        if (null == orderSumGoodsId) {
            return;
        }
        this.deleteOrderSumGoodsModel(orderSumGoodsId);
    }

    @Override
    public QueryResult<DaOrderSumGoods> queryOrderSumGoodsPage(Map<String, Object> map) {
        List<DaOrderSumGoods> daOrderSumGoodsList = this.queryOrderSumGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderSumGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOrderSumGoodsList);
        return queryResult;
    }

    @Override
    public DaOrderSumGoods getOrderSumGoodsByCode(String tenantCode, String orderSumGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)orderSumGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderSumGoodsCode", orderSumGoodsCode);
        return this.getOrderSumGoodsModelByCode(map);
    }

    @Override
    public void deleteOrderSumGoodsByCode(String tenantCode, String orderSumGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)orderSumGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderSumGoodsCode", orderSumGoodsCode);
        this.delOrderSumGoodsModelByCode(map);
    }
}

