/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaPayableListMapper;
import com.yqbsoft.laser.service.data.domain.DaPayableListDomain;
import com.yqbsoft.laser.service.data.domain.DaPayableListReDomain;
import com.yqbsoft.laser.service.data.model.DaPayableList;
import com.yqbsoft.laser.service.data.service.DaPayableListService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaPayableListServiceImpl
extends BaseServiceImpl
implements DaPayableListService {
    private static final String SYS_CODE = "da.DaPayableListServiceImpl";
    private DaPayableListMapper daPayableListMapper;

    public void setDaPayableListMapper(DaPayableListMapper daPayableListMapper) {
        this.daPayableListMapper = daPayableListMapper;
    }

    private Date getSysDate() {
        try {
            return this.daPayableListMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableListServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPayableList(DaPayableListDomain daPayableListDomain) {
        if (null == daPayableListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daPayableListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPayableListDefault(DaPayableList daPayableList) {
        if (null == daPayableList) {
            return;
        }
        if (null == daPayableList.getDataState()) {
            daPayableList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daPayableList.getGmtCreate()) {
            daPayableList.setGmtCreate(date);
        }
        daPayableList.setGmtModified(date);
        if (StringUtils.isBlank((String)daPayableList.getPayableListCode())) {
            daPayableList.setPayableListCode(this.getNo(null, "DaPayableList", "daPayableList", daPayableList.getTenantCode()));
        }
    }

    private int getPayableListMaxCode() {
        int code = 0;
        try {
            return this.daPayableListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableListServiceImpl.getPayableListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPayableListUpdataDefault(DaPayableList daPayableList) {
        if (null == daPayableList) {
            return;
        }
        daPayableList.setGmtModified(this.getSysDate());
    }

    private void savePayableListModel(DaPayableList daPayableList) throws ApiException {
        if (null == daPayableList) {
            return;
        }
        try {
            this.daPayableListMapper.insert(daPayableList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableListServiceImpl.savePayableListModel.ex", (Throwable)e);
        }
    }

    private void savePayableListBatchModel(List<DaPayableList> daPayableListList) throws ApiException {
        if (null == daPayableListList || daPayableListList.isEmpty()) {
            return;
        }
        try {
            this.daPayableListMapper.insertBatch(daPayableListList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableListServiceImpl.savePayableListBatchModel.ex", (Throwable)e);
        }
    }

    private DaPayableList getPayableListModelById(Integer PayableListId) {
        if (null == PayableListId) {
            return null;
        }
        try {
            return this.daPayableListMapper.selectByPrimaryKey(PayableListId);
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableListServiceImpl.getPayableListModelById", (Throwable)e);
            return null;
        }
    }

    private DaPayableList getPayableListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daPayableListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableListServiceImpl.getPayableListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPayableListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daPayableListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableListServiceImpl.delPayableListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaPayableListServiceImpl.delPayableListModelByCode.num");
        }
    }

    private void deletePayableListModel(Integer PayableListId) throws ApiException {
        if (null == PayableListId) {
            return;
        }
        int i = 0;
        try {
            i = this.daPayableListMapper.deleteByPrimaryKey(PayableListId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableListServiceImpl.deletePayableListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaPayableListServiceImpl.deletePayableListModel.num");
        }
    }

    private void updatePayableListModel(DaPayableList daPayableList) throws ApiException {
        if (null == daPayableList) {
            return;
        }
        int i = 0;
        try {
            i = this.daPayableListMapper.updateByPrimaryKey(daPayableList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableListServiceImpl.updatePayableListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaPayableListServiceImpl.updatePayableListModel.num");
        }
    }

    private void updateStatePayableListModel(Integer PayableListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == PayableListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PayableListId", PayableListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daPayableListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableListServiceImpl.updateStatePayableListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaPayableListServiceImpl.updateStatePayableListModel.null");
        }
    }

    private void updateStatePayableListModelByCode(String tenantCode, String PayableListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)PayableListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PayableListCode", PayableListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daPayableListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaPayableListServiceImpl.updateStatePayableListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaPayableListServiceImpl.updateStatePayableListModelByCode.null");
        }
    }

    private DaPayableList makePayableList(DaPayableListDomain daPayableListDomain, DaPayableList daPayableList) {
        if (null == daPayableListDomain) {
            return null;
        }
        if (null == daPayableList) {
            daPayableList = new DaPayableList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daPayableList, (Object)daPayableListDomain);
            return daPayableList;
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableListServiceImpl.makePayableList", (Throwable)e);
            return null;
        }
    }

    private DaPayableListReDomain makeDaPayableListReDomain(DaPayableList daPayableList) {
        if (null == daPayableList) {
            return null;
        }
        DaPayableListReDomain daPayableListReDomain = new DaPayableListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daPayableListReDomain, (Object)daPayableList);
            return daPayableListReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableListServiceImpl.makeDaPayableListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaPayableList> queryPayableListModelPage(Map<String, Object> parammap) {
        try {
            return this.daPayableListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableListServiceImpl.queryPayableListModel", (Throwable)e);
            return null;
        }
    }

    private int countPayableList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daPayableListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaPayableListServiceImpl.countPayableList", (Throwable)e);
        }
        return i;
    }

    private DaPayableList createDaPayableList(DaPayableListDomain daPayableListDomain) {
        String msg = this.checkPayableList(daPayableListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaPayableListServiceImpl.savePayableList.checkPayableList", msg);
        }
        DaPayableList daPayableList = this.makePayableList(daPayableListDomain, null);
        this.setPayableListDefault(daPayableList);
        return daPayableList;
    }

    @Override
    public String savePayableList(DaPayableListDomain daPayableListDomain) throws ApiException {
        DaPayableList daPayableList = this.createDaPayableList(daPayableListDomain);
        this.savePayableListModel(daPayableList);
        return daPayableList.getPayableListCode();
    }

    @Override
    public String savePayableListBatch(List<DaPayableListDomain> daPayableListDomainList) throws ApiException {
        if (null == daPayableListDomainList || daPayableListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaPayableList> daPayableListList = new ArrayList<DaPayableList>();
        String code = "";
        for (DaPayableListDomain daPayableListDomain : daPayableListDomainList) {
            DaPayableList daPayableList = this.createDaPayableList(daPayableListDomain);
            code = daPayableList.getPayableListCode();
            daPayableListList.add(daPayableList);
        }
        this.savePayableListBatchModel(daPayableListList);
        return code;
    }

    @Override
    public void updatePayableListState(Integer PayableListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == PayableListId) {
            return;
        }
        this.updateStatePayableListModel(PayableListId, dataState, oldDataState, map);
    }

    @Override
    public void updatePayableListStateByCode(String tenantCode, String PayableListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)PayableListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePayableListModelByCode(tenantCode, PayableListCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePayableList(DaPayableListDomain daPayableListDomain) throws ApiException {
        String msg = this.checkPayableList(daPayableListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaPayableListServiceImpl.updatePayableList.checkPayableList", msg);
        }
        DaPayableList oldDaPayableList = this.getPayableListModelById(daPayableListDomain.getPayableListId());
        if (null == oldDaPayableList) {
            throw new ApiException("da.DaPayableListServiceImpl.updatePayableList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaPayableList daPayableList = this.makePayableList(daPayableListDomain, oldDaPayableList);
        this.setPayableListUpdataDefault(daPayableList);
        this.updatePayableListModel(daPayableList);
    }

    @Override
    public DaPayableList getPayableList(Integer PayableListId) {
        if (null == PayableListId) {
            return null;
        }
        return this.getPayableListModelById(PayableListId);
    }

    @Override
    public void deletePayableList(Integer PayableListId) throws ApiException {
        if (null == PayableListId) {
            return;
        }
        this.deletePayableListModel(PayableListId);
    }

    @Override
    public QueryResult<DaPayableList> queryPayableListPage(Map<String, Object> map) {
        List<DaPayableList> daPayableListList = this.queryPayableListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPayableList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daPayableListList);
        return queryResult;
    }

    @Override
    public DaPayableList getPayableListByCode(String tenantCode, String PayableListCode) throws ApiException {
        if (StringUtils.isBlank((String)PayableListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PayableListCode", PayableListCode);
        return this.getPayableListModelByCode(map);
    }

    @Override
    public void deletePayableListByCode(String tenantCode, String PayableListCode) throws ApiException {
        if (StringUtils.isBlank((String)PayableListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("PayableListCode", PayableListCode);
        this.delPayableListModelByCode(map);
    }
}

