/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaUserpathMapper;
import com.yqbsoft.laser.service.data.domain.DaUserpathDomain;
import com.yqbsoft.laser.service.data.domain.DaUserpathReDomain;
import com.yqbsoft.laser.service.data.model.DaUserpath;
import com.yqbsoft.laser.service.data.service.DaUserpathService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaUserpathServiceImpl
extends BaseServiceImpl
implements DaUserpathService {
    private static final String SYS_CODE = "da.DaUserpathServiceImpl";
    private DaUserpathMapper daUserpathMapper;

    public void setDaUserpathMapper(DaUserpathMapper daUserpathMapper) {
        this.daUserpathMapper = daUserpathMapper;
    }

    private Date getSysDate() {
        try {
            return this.daUserpathMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("da.DaUserpathServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUserpath(DaUserpathDomain daUserpathDomain) {
        if (null == daUserpathDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daUserpathDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUserpathDefault(DaUserpath daUserpath) {
        if (null == daUserpath) {
            return;
        }
        if (null == daUserpath.getDataState()) {
            daUserpath.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daUserpath.getGmtCreate()) {
            daUserpath.setGmtCreate(date);
        }
        daUserpath.setGmtModified(date);
        if (StringUtils.isBlank((String)daUserpath.getUserpathCode())) {
            daUserpath.setUserpathCode(this.getNo(null, "DaUserpath", "daUserpath", daUserpath.getTenantCode()));
        }
    }

    private int getUserpathMaxCode() {
        int code = 0;
        try {
            return this.daUserpathMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("da.DaUserpathServiceImpl.getUserpathMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserpathUpdataDefault(DaUserpath daUserpath) {
        if (null == daUserpath) {
            return;
        }
        daUserpath.setGmtModified(this.getSysDate());
    }

    private void saveUserpathModel(DaUserpath daUserpath) throws ApiException {
        if (null == daUserpath) {
            return;
        }
        try {
            this.daUserpathMapper.insert(daUserpath);
        }
        catch (Exception e) {
            throw new ApiException("da.DaUserpathServiceImpl.saveUserpathModel.ex", (Throwable)e);
        }
    }

    private void saveUserpathBatchModel(List<DaUserpath> daUserpathList) throws ApiException {
        if (null == daUserpathList || daUserpathList.isEmpty()) {
            return;
        }
        try {
            this.daUserpathMapper.insertBatch(daUserpathList);
        }
        catch (Exception e) {
            throw new ApiException("da.DaUserpathServiceImpl.saveUserpathBatchModel.ex", (Throwable)e);
        }
    }

    private DaUserpath getUserpathModelById(Integer userpathId) {
        if (null == userpathId) {
            return null;
        }
        try {
            return this.daUserpathMapper.selectByPrimaryKey(userpathId);
        }
        catch (Exception e) {
            this.logger.error("da.DaUserpathServiceImpl.getUserpathModelById", (Throwable)e);
            return null;
        }
    }

    private DaUserpath getUserpathModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daUserpathMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaUserpathServiceImpl.getUserpathModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUserpathModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daUserpathMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaUserpathServiceImpl.delUserpathModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaUserpathServiceImpl.delUserpathModelByCode.num");
        }
    }

    private void deleteUserpathModel(Integer userpathId) throws ApiException {
        if (null == userpathId) {
            return;
        }
        int i = 0;
        try {
            i = this.daUserpathMapper.deleteByPrimaryKey(userpathId);
        }
        catch (Exception e) {
            throw new ApiException("da.DaUserpathServiceImpl.deleteUserpathModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaUserpathServiceImpl.deleteUserpathModel.num");
        }
    }

    private void updateUserpathModel(DaUserpath daUserpath) throws ApiException {
        if (null == daUserpath) {
            return;
        }
        int i = 0;
        try {
            i = this.daUserpathMapper.updateByPrimaryKey(daUserpath);
        }
        catch (Exception e) {
            throw new ApiException("da.DaUserpathServiceImpl.updateUserpathModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("da.DaUserpathServiceImpl.updateUserpathModel.num");
        }
    }

    private void updateStateUserpathModel(Integer userpathId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userpathId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userpathId", userpathId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daUserpathMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaUserpathServiceImpl.updateStateUserpathModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaUserpathServiceImpl.updateStateUserpathModel.null");
        }
    }

    private void updateStateUserpathModelByCode(String tenantCode, String userpathCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)userpathCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userpathCode", userpathCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daUserpathMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("da.DaUserpathServiceImpl.updateStateUserpathModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("da.DaUserpathServiceImpl.updateStateUserpathModelByCode.null");
        }
    }

    private DaUserpath makeUserpath(DaUserpathDomain daUserpathDomain, DaUserpath daUserpath) {
        if (null == daUserpathDomain) {
            return null;
        }
        if (null == daUserpath) {
            daUserpath = new DaUserpath();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daUserpath, (Object)daUserpathDomain);
            return daUserpath;
        }
        catch (Exception e) {
            this.logger.error("da.DaUserpathServiceImpl.makeUserpath", (Throwable)e);
            return null;
        }
    }

    private DaUserpathReDomain makeDaUserpathReDomain(DaUserpath daUserpath) {
        if (null == daUserpath) {
            return null;
        }
        DaUserpathReDomain daUserpathReDomain = new DaUserpathReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daUserpathReDomain, (Object)daUserpath);
            return daUserpathReDomain;
        }
        catch (Exception e) {
            this.logger.error("da.DaUserpathServiceImpl.makeDaUserpathReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaUserpath> queryUserpathModelPage(Map<String, Object> parammap) {
        try {
            return this.daUserpathMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("da.DaUserpathServiceImpl.queryUserpathModel", (Throwable)e);
            return null;
        }
    }

    private int countUserpath(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daUserpathMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("da.DaUserpathServiceImpl.countUserpath", (Throwable)e);
        }
        return i;
    }

    private DaUserpath createDaUserpath(DaUserpathDomain daUserpathDomain) {
        String msg = this.checkUserpath(daUserpathDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaUserpathServiceImpl.saveUserpath.checkUserpath", msg);
        }
        DaUserpath daUserpath = this.makeUserpath(daUserpathDomain, null);
        this.setUserpathDefault(daUserpath);
        return daUserpath;
    }

    @Override
    public String saveUserpath(DaUserpathDomain daUserpathDomain) throws ApiException {
        DaUserpath daUserpath = this.createDaUserpath(daUserpathDomain);
        this.saveUserpathModel(daUserpath);
        return daUserpath.getUserpathCode();
    }

    @Override
    public String saveUserpathBatch(List<DaUserpathDomain> daUserpathDomainList) throws ApiException {
        if (null == daUserpathDomainList || daUserpathDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaUserpath> daUserpathList = new ArrayList<DaUserpath>();
        String code = "";
        for (DaUserpathDomain daUserpathDomain : daUserpathDomainList) {
            DaUserpath daUserpath = this.createDaUserpath(daUserpathDomain);
            code = daUserpath.getUserpathCode();
            daUserpathList.add(daUserpath);
        }
        this.saveUserpathBatchModel(daUserpathList);
        return code;
    }

    @Override
    public void updateUserpathState(Integer userpathId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == userpathId) {
            return;
        }
        this.updateStateUserpathModel(userpathId, dataState, oldDataState, map);
    }

    @Override
    public void updateUserpathStateByCode(String tenantCode, String userpathCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userpathCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUserpathModelByCode(tenantCode, userpathCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUserpath(DaUserpathDomain daUserpathDomain) throws ApiException {
        String msg = this.checkUserpath(daUserpathDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("da.DaUserpathServiceImpl.updateUserpath.checkUserpath", msg);
        }
        DaUserpath oldDaUserpath = this.getUserpathModelById(daUserpathDomain.getUserpathId());
        if (null == oldDaUserpath) {
            throw new ApiException("da.DaUserpathServiceImpl.updateUserpath.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaUserpath daUserpath = this.makeUserpath(daUserpathDomain, oldDaUserpath);
        this.setUserpathUpdataDefault(daUserpath);
        this.updateUserpathModel(daUserpath);
    }

    @Override
    public DaUserpath getUserpath(Integer userpathId) {
        if (null == userpathId) {
            return null;
        }
        return this.getUserpathModelById(userpathId);
    }

    @Override
    public void deleteUserpath(Integer userpathId) throws ApiException {
        if (null == userpathId) {
            return;
        }
        this.deleteUserpathModel(userpathId);
    }

    @Override
    public QueryResult<DaUserpath> queryUserpathPage(Map<String, Object> map) {
        List<DaUserpath> daUserpathList = this.queryUserpathModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserpath(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daUserpathList);
        return queryResult;
    }

    @Override
    public DaUserpath getUserpathByCode(String tenantCode, String userpathCode) throws ApiException {
        if (StringUtils.isBlank((String)userpathCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userpathCode", userpathCode);
        return this.getUserpathModelByCode(map);
    }

    @Override
    public void deleteUserpathByCode(String tenantCode, String userpathCode) throws ApiException {
        if (StringUtils.isBlank((String)userpathCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userpathCode", userpathCode);
        this.delUserpathModelByCode(map);
    }
}

