/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaStoreSkuMapper;
import com.yqbsoft.laser.service.data.domain.DaStoreSkuDomain;
import com.yqbsoft.laser.service.data.domain.DaStoreSkuReDomain;
import com.yqbsoft.laser.service.data.model.DaStoreSku;
import com.yqbsoft.laser.service.data.service.DaStoreSkuService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaStoreSkuServiceImpl
extends BaseServiceImpl
implements DaStoreSkuService {
    private static final String SYS_CODE = SYS_CODE + ".DaStoreSkuServiceImpl";
    private DaStoreSkuMapper daStoreSkuMapper;

    public void setDaStoreSkuMapper(DaStoreSkuMapper daStoreSkuMapper) {
        this.daStoreSkuMapper = daStoreSkuMapper;
    }

    private Date getSysDate() {
        try {
            return this.daStoreSkuMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStoreSku(DaStoreSkuDomain daStoreSkuDomain) {
        if (null == daStoreSkuDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daStoreSkuDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStoreSkuDefault(DaStoreSku daStoreSku) {
        if (null == daStoreSku) {
            return;
        }
        if (null == daStoreSku.getDataState()) {
            daStoreSku.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daStoreSku.getGmtCreate()) {
            daStoreSku.setGmtCreate(date);
        }
        daStoreSku.setGmtModified(date);
        if (StringUtils.isBlank((String)daStoreSku.getStoreSkuCode())) {
            daStoreSku.setStoreSkuCode(this.getNo(null, "DaStoreSku", "daStoreSku", daStoreSku.getTenantCode()));
        }
    }

    private int getStoreSkuMaxCode() {
        int code = 0;
        try {
            return this.daStoreSkuMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreSkuMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStoreSkuUpdataDefault(DaStoreSku daStoreSku) {
        if (null == daStoreSku) {
            return;
        }
        daStoreSku.setGmtModified(this.getSysDate());
    }

    private void saveStoreSkuModel(DaStoreSku daStoreSku) throws ApiException {
        if (null == daStoreSku) {
            return;
        }
        try {
            this.daStoreSkuMapper.insert(daStoreSku);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveStoreSkuModel.ex", (Throwable)e);
        }
    }

    private void saveStoreSkuBatchModel(List<DaStoreSku> daStoreSkuList) throws ApiException {
        if (null == daStoreSkuList || daStoreSkuList.isEmpty()) {
            return;
        }
        try {
            this.daStoreSkuMapper.insertBatch(daStoreSkuList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveStoreSkuBatchModel.ex", (Throwable)e);
        }
    }

    private DaStoreSku getStoreSkuModelById(Integer storeSkuId) {
        if (null == storeSkuId) {
            return null;
        }
        try {
            return this.daStoreSkuMapper.selectByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreSkuModelById", (Throwable)e);
            return null;
        }
    }

    private DaStoreSku getStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daStoreSkuMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getStoreSkuModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delStoreSkuModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreSkuMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delStoreSkuModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delStoreSkuModelByCode.num");
        }
    }

    private void delStoreSkuModelByTime(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.daStoreSkuMapper.delByTime(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delStoreSkuModelByTime.ex", map.toString(), (Throwable)e);
        }
    }

    private void deleteStoreSkuModel(Integer storeSkuId) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreSkuMapper.deleteByPrimaryKey(storeSkuId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteStoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteStoreSkuModel.num");
        }
    }

    private void updateStoreSkuModel(DaStoreSku daStoreSku) throws ApiException {
        if (null == daStoreSku) {
            return;
        }
        int i = 0;
        try {
            i = this.daStoreSkuMapper.updateByPrimaryKey(daStoreSku);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStoreSkuModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateStoreSkuModel.num");
        }
    }

    private void updateStateStoreSkuModel(Integer storeSkuId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == storeSkuId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storeSkuId", storeSkuId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStoreSkuMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateStoreSkuModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateStoreSkuModel.null");
        }
    }

    private void updateStateStoreSkuModelByCode(String tenantCode, String storeSkuCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuCode", storeSkuCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daStoreSkuMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateStoreSkuModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateStoreSkuModelByCode.null");
        }
    }

    private DaStoreSku makeStoreSku(DaStoreSkuDomain daStoreSkuDomain, DaStoreSku daStoreSku) {
        if (null == daStoreSkuDomain) {
            return null;
        }
        if (null == daStoreSku) {
            daStoreSku = new DaStoreSku();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daStoreSku, (Object)daStoreSkuDomain);
            return daStoreSku;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeStoreSku", (Throwable)e);
            return null;
        }
    }

    private DaStoreSkuReDomain makeDaStoreSkuReDomain(DaStoreSku daStoreSku) {
        if (null == daStoreSku) {
            return null;
        }
        DaStoreSkuReDomain daStoreSkuReDomain = new DaStoreSkuReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daStoreSkuReDomain, (Object)daStoreSku);
            return daStoreSkuReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaStoreSkuReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaStoreSku> queryStoreSkuModelPage(Map<String, Object> parammap) {
        try {
            return this.daStoreSkuMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryStoreSkuModel", (Throwable)e);
            return null;
        }
    }

    private int countStoreSku(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daStoreSkuMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countStoreSku", (Throwable)e);
        }
        return i;
    }

    private DaStoreSku createDaStoreSku(DaStoreSkuDomain daStoreSkuDomain) {
        String msg = this.checkStoreSku(daStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveStoreSku.checkStoreSku", msg);
        }
        DaStoreSku daStoreSku = this.makeStoreSku(daStoreSkuDomain, null);
        this.setStoreSkuDefault(daStoreSku);
        return daStoreSku;
    }

    @Override
    public String saveStoreSku(DaStoreSkuDomain daStoreSkuDomain) throws ApiException {
        DaStoreSku daStoreSku = this.createDaStoreSku(daStoreSkuDomain);
        this.saveStoreSkuModel(daStoreSku);
        return daStoreSku.getStoreSkuCode();
    }

    @Override
    public String saveStoreSkuBatch(List<DaStoreSkuDomain> daStoreSkuDomainList) throws ApiException {
        if (null == daStoreSkuDomainList || daStoreSkuDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaStoreSku> daStoreSkuList = new ArrayList<DaStoreSku>();
        String code = "";
        for (DaStoreSkuDomain daStoreSkuDomain : daStoreSkuDomainList) {
            DaStoreSku daStoreSku = this.createDaStoreSku(daStoreSkuDomain);
            code = daStoreSku.getStoreSkuCode();
            daStoreSkuList.add(daStoreSku);
        }
        this.saveStoreSkuBatchModel(daStoreSkuList);
        return code;
    }

    @Override
    public void updateStoreSkuState(Integer storeSkuId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        this.updateStateStoreSkuModel(storeSkuId, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreSkuStateByCode(String tenantCode, String storeSkuCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateStoreSkuModelByCode(tenantCode, storeSkuCode, dataState, oldDataState, map);
    }

    @Override
    public void updateStoreSku(DaStoreSkuDomain daStoreSkuDomain) throws ApiException {
        String msg = this.checkStoreSku(daStoreSkuDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateStoreSku.checkStoreSku", msg);
        }
        DaStoreSku oldDaStoreSku = this.getStoreSkuModelById(daStoreSkuDomain.getStoreSkuId());
        if (null == oldDaStoreSku) {
            throw new ApiException(SYS_CODE + ".updateStoreSku.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaStoreSku daStoreSku = this.makeStoreSku(daStoreSkuDomain, oldDaStoreSku);
        this.setStoreSkuUpdataDefault(daStoreSku);
        this.updateStoreSkuModel(daStoreSku);
    }

    @Override
    public DaStoreSku getStoreSku(Integer storeSkuId) {
        if (null == storeSkuId) {
            return null;
        }
        return this.getStoreSkuModelById(storeSkuId);
    }

    @Override
    public void deleteStoreSku(Integer storeSkuId) throws ApiException {
        if (null == storeSkuId) {
            return;
        }
        this.deleteStoreSkuModel(storeSkuId);
    }

    @Override
    public QueryResult<DaStoreSku> queryStoreSkuPage(Map<String, Object> map) {
        List<DaStoreSku> daStoreSkuList = this.queryStoreSkuModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStoreSku(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daStoreSkuList);
        return queryResult;
    }

    @Override
    public DaStoreSku getStoreSkuByCode(String tenantCode, String storeSkuCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuCode", storeSkuCode);
        return this.getStoreSkuModelByCode(map);
    }

    @Override
    public void deleteStoreSkuByCode(String tenantCode, String storeSkuCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuCode", storeSkuCode);
        this.delStoreSkuModelByCode(map);
    }

    @Override
    public void deleteStoreBatch(String tenantCode, String storeSkuTime, String warehouseCode) throws ApiException {
        if (StringUtils.isBlank((String)storeSkuTime) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("storeSkuTime", storeSkuTime);
        map.put("warehouseCode", warehouseCode);
        this.logger.error(SYS_CODE + ".deleteStoreBatch.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        this.delStoreSkuModelByTime(map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveLoadStore(String tenantCode, String warehouseCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String storeSkuTime = DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd");
        this.deleteStoreBatch(tenantCode, storeSkuTime, warehouseCode);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        int startRow = 0;
        paramsMap.put("rows", 200);
        paramsMap.put("tenantCode", tenantCode);
        paramsMap.put("warehouseCode", warehouseCode);
        String apiCode = "wh.whStoreGoods.queryStoreSkuPage";
        HashMap<String, String> sendMap = new HashMap<String, String>();
        try {
            boolean flag = true;
            do {
                Date starDate = new Date();
                paramsMap.put("startRow", startRow);
                sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramsMap));
                this.logger.error("saveLoadStore==============>", (Object)((Object)sendMap).toString());
                QueryResult qlist = this.getQueryResutl(apiCode, sendMap, DaStoreSkuDomain.class);
                if (null == qlist) return;
                if (ListUtil.isEmpty((Collection)qlist.getList())) {
                    return;
                }
                if (qlist.getList().size() < 200) {
                    flag = false;
                }
                if (!"success".equals(this.saveSku(qlist.getList(), storeSkuTime, starDate, tenantCode))) return;
                startRow = startRow++;
            } while (flag);
            return;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".saveLoadStore", (Throwable)e);
        }
    }

    private String saveSku(List<DaStoreSkuDomain> skuList, String batch, Date starDate, String tenantCode) {
        if (ListUtil.isEmpty(skuList) || StringUtils.isBlank((String)batch)) {
            return "success";
        }
        for (DaStoreSkuDomain daStoreSkuDomain : skuList) {
            daStoreSkuDomain.setStoreSkuId(null);
            daStoreSkuDomain.setStoreSkuCode(null);
            daStoreSkuDomain.setStoreSkuEtime(new Date());
            daStoreSkuDomain.setStoreSkuStime(starDate);
            daStoreSkuDomain.setStoreSkuType("sku");
            daStoreSkuDomain.setStoreSkuTime(batch);
            daStoreSkuDomain.setTenantCode(tenantCode);
        }
        this.saveStoreSkuBatch(skuList);
        return "success";
    }
}

