/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaPickStatisticsMapper;
import com.yqbsoft.laser.service.data.domain.ContentStatistics;
import com.yqbsoft.laser.service.data.domain.DaPickStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.DaPickStatisticsReDomain;
import com.yqbsoft.laser.service.data.model.DaPickStatistics;
import com.yqbsoft.laser.service.data.service.DaPickStatisticsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaPickStatisticsServiceImpl
extends BaseServiceImpl
implements DaPickStatisticsService {
    private static final String SYS_CODE = SYS_CODE + ".DaPickStatisticsServiceImpl";
    private DaPickStatisticsMapper daPickStatisticsMapper;

    public void setDaPickStatisticsMapper(DaPickStatisticsMapper daPickStatisticsMapper) {
        this.daPickStatisticsMapper = daPickStatisticsMapper;
    }

    private Date getSysDate() {
        try {
            return this.daPickStatisticsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPickStatistics(DaPickStatisticsDomain daPickStatisticsDomain) {
        if (null == daPickStatisticsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daPickStatisticsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPickStatisticsDefault(DaPickStatistics daPickStatistics) {
        if (null == daPickStatistics) {
            return;
        }
        if (null == daPickStatistics.getDataState()) {
            daPickStatistics.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daPickStatistics.getGmtCreate()) {
            daPickStatistics.setGmtCreate(date);
        }
        daPickStatistics.setGmtModified(date);
        if (StringUtils.isBlank((String)daPickStatistics.getPistCode())) {
            daPickStatistics.setPistCode(this.getNo(null, "DaPickStatistics", "daPickStatistics", daPickStatistics.getTenantCode()));
        }
    }

    private int getPickStatisticsMaxCode() {
        int code = 0;
        try {
            return this.daPickStatisticsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getPickStatisticsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPickStatisticsUpdataDefault(DaPickStatistics daPickStatistics) {
        if (null == daPickStatistics) {
            return;
        }
        daPickStatistics.setGmtModified(this.getSysDate());
    }

    private void savePickStatisticsModel(DaPickStatistics daPickStatistics) throws ApiException {
        if (null == daPickStatistics) {
            return;
        }
        try {
            this.daPickStatisticsMapper.insert(daPickStatistics);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".savePickStatisticsModel.ex", (Throwable)e);
        }
    }

    private void savePickStatisticsBatchModel(List<DaPickStatistics> daPickStatisticsList) throws ApiException {
        if (null == daPickStatisticsList || daPickStatisticsList.isEmpty()) {
            return;
        }
        try {
            this.daPickStatisticsMapper.insertBatch(daPickStatisticsList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".savePickStatisticsBatchModel.ex", (Throwable)e);
        }
    }

    private DaPickStatistics getPickStatisticsModelById(Integer pistId) {
        if (null == pistId) {
            return null;
        }
        try {
            return this.daPickStatisticsMapper.selectByPrimaryKey(pistId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getPickStatisticsModelById", (Throwable)e);
            return null;
        }
    }

    private DaPickStatistics getPickStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daPickStatisticsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getPickStatisticsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPickStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daPickStatisticsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delPickStatisticsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delPickStatisticsModelByCode.num");
        }
    }

    private void deletePickStatisticsModel(Integer pistId) throws ApiException {
        if (null == pistId) {
            return;
        }
        int i = 0;
        try {
            i = this.daPickStatisticsMapper.deleteByPrimaryKey(pistId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deletePickStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deletePickStatisticsModel.num");
        }
    }

    private void updatePickStatisticsModel(DaPickStatistics daPickStatistics) throws ApiException {
        if (null == daPickStatistics) {
            return;
        }
        int i = 0;
        try {
            i = this.daPickStatisticsMapper.updateByPrimaryKey(daPickStatistics);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updatePickStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updatePickStatisticsModel.num");
        }
    }

    private void updateStatePickStatisticsModel(Integer pistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pistId", pistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daPickStatisticsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStatePickStatisticsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStatePickStatisticsModel.null");
        }
    }

    private void updateStatePickStatisticsModelByCode(String tenantCode, String pistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pistCode", pistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daPickStatisticsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStatePickStatisticsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStatePickStatisticsModelByCode.null");
        }
    }

    private DaPickStatistics makePickStatistics(DaPickStatisticsDomain daPickStatisticsDomain, DaPickStatistics daPickStatistics) {
        if (null == daPickStatisticsDomain) {
            return null;
        }
        if (null == daPickStatistics) {
            daPickStatistics = new DaPickStatistics();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daPickStatistics, (Object)daPickStatisticsDomain);
            return daPickStatistics;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makePickStatistics", (Throwable)e);
            return null;
        }
    }

    private DaPickStatisticsReDomain makeDaPickStatisticsReDomain(DaPickStatistics daPickStatistics) {
        if (null == daPickStatistics) {
            return null;
        }
        DaPickStatisticsReDomain daPickStatisticsReDomain = new DaPickStatisticsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daPickStatisticsReDomain, (Object)daPickStatistics);
            return daPickStatisticsReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaPickStatisticsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaPickStatistics> queryPickStatisticsModelPage(Map<String, Object> parammap) {
        try {
            return this.daPickStatisticsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryPickStatisticsModel", (Throwable)e);
            return null;
        }
    }

    private int countPickStatistics(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daPickStatisticsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countPickStatistics", (Throwable)e);
        }
        return i;
    }

    private DaPickStatistics createDaPickStatistics(DaPickStatisticsDomain daPickStatisticsDomain) {
        String msg = this.checkPickStatistics(daPickStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".savePickStatistics.checkPickStatistics", msg);
        }
        DaPickStatistics daPickStatistics = this.makePickStatistics(daPickStatisticsDomain, null);
        this.setPickStatisticsDefault(daPickStatistics);
        return daPickStatistics;
    }

    @Override
    public String savePickStatistics(DaPickStatisticsDomain daPickStatisticsDomain) throws ApiException {
        DaPickStatistics daPickStatistics = this.createDaPickStatistics(daPickStatisticsDomain);
        this.savePickStatisticsModel(daPickStatistics);
        return daPickStatistics.getPistCode();
    }

    @Override
    public String savePickStatisticsBatch(List<DaPickStatisticsDomain> daPickStatisticsDomainList) throws ApiException {
        if (null == daPickStatisticsDomainList || daPickStatisticsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaPickStatistics> daPickStatisticsList = new ArrayList<DaPickStatistics>();
        String code = "";
        for (DaPickStatisticsDomain daPickStatisticsDomain : daPickStatisticsDomainList) {
            DaPickStatistics daPickStatistics = this.createDaPickStatistics(daPickStatisticsDomain);
            code = daPickStatistics.getPistCode();
            daPickStatisticsList.add(daPickStatistics);
        }
        this.savePickStatisticsBatchModel(daPickStatisticsList);
        return code;
    }

    @Override
    public void updatePickStatisticsState(Integer pistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pistId) {
            return;
        }
        this.updateStatePickStatisticsModel(pistId, dataState, oldDataState, map);
    }

    @Override
    public void updatePickStatisticsStateByCode(String tenantCode, String pistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePickStatisticsModelByCode(tenantCode, pistCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePickStatistics(DaPickStatisticsDomain daPickStatisticsDomain) throws ApiException {
        String msg = this.checkPickStatistics(daPickStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updatePickStatistics.checkPickStatistics", msg);
        }
        DaPickStatistics oldDaPickStatistics = this.getPickStatisticsModelById(daPickStatisticsDomain.getPistId());
        if (null == oldDaPickStatistics) {
            throw new ApiException(SYS_CODE + ".updatePickStatistics.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaPickStatistics daPickStatistics = this.makePickStatistics(daPickStatisticsDomain, oldDaPickStatistics);
        this.setPickStatisticsUpdataDefault(daPickStatistics);
        this.updatePickStatisticsModel(daPickStatistics);
    }

    @Override
    public DaPickStatistics getPickStatistics(Integer pistId) {
        if (null == pistId) {
            return null;
        }
        return this.getPickStatisticsModelById(pistId);
    }

    @Override
    public void deletePickStatistics(Integer pistId) throws ApiException {
        if (null == pistId) {
            return;
        }
        this.deletePickStatisticsModel(pistId);
    }

    @Override
    public QueryResult<DaPickStatistics> queryPickStatisticsPage(Map<String, Object> map) {
        List<DaPickStatistics> daPickStatisticsList = this.queryPickStatisticsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPickStatistics(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daPickStatisticsList);
        return queryResult;
    }

    @Override
    public DaPickStatistics getPickStatisticsByCode(String tenantCode, String pistCode) throws ApiException {
        if (StringUtils.isBlank((String)pistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pistCode", pistCode);
        return this.getPickStatisticsModelByCode(map);
    }

    @Override
    public void deletePickStatisticsByCode(String tenantCode, String pistCode) throws ApiException {
        if (StringUtils.isBlank((String)pistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pistCode", pistCode);
        this.delPickStatisticsModelByCode(map);
    }

    @Override
    public ContentStatistics getContentStatistics(Map<String, Object> map) {
        return this.getContentStatisticsModel(map);
    }

    private ContentStatistics getContentStatisticsModel(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daPickStatisticsMapper.getContentStatisticsModel(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getContentStatisticsModel", (Throwable)e);
            return null;
        }
    }
}

