/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaPgStatisticsMapper;
import com.yqbsoft.laser.service.data.domain.DaPgStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.DaPgStatisticsReDomain;
import com.yqbsoft.laser.service.data.model.DaPgStatistics;
import com.yqbsoft.laser.service.data.service.DaPgStatisticsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaPgStatisticsServiceImpl
extends BaseServiceImpl
implements DaPgStatisticsService {
    private static final String SYS_CODE = SYS_CODE + ".DaPgStatisticsServiceImpl";
    private DaPgStatisticsMapper daPgStatisticsMapper;

    public void setDaPgStatisticsMapper(DaPgStatisticsMapper daPgStatisticsMapper) {
        this.daPgStatisticsMapper = daPgStatisticsMapper;
    }

    private Date getSysDate() {
        try {
            return this.daPgStatisticsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPgStatistics(DaPgStatisticsDomain daPgStatisticsDomain) {
        if (null == daPgStatisticsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daPgStatisticsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPgStatisticsDefault(DaPgStatistics daPgStatistics) {
        if (null == daPgStatistics) {
            return;
        }
        if (null == daPgStatistics.getDataState()) {
            daPgStatistics.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daPgStatistics.getGmtCreate()) {
            daPgStatistics.setGmtCreate(date);
        }
        daPgStatistics.setGmtModified(date);
        if (StringUtils.isBlank((String)daPgStatistics.getPgstCode())) {
            daPgStatistics.setPgstCode(this.getNo(null, "DaPgStatistics", "daPgStatistics", daPgStatistics.getTenantCode()));
        }
    }

    private int getPgStatisticsMaxCode() {
        int code = 0;
        try {
            return this.daPgStatisticsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getPgStatisticsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPgStatisticsUpdataDefault(DaPgStatistics daPgStatistics) {
        if (null == daPgStatistics) {
            return;
        }
        daPgStatistics.setGmtModified(this.getSysDate());
    }

    private void savePgStatisticsModel(DaPgStatistics daPgStatistics) throws ApiException {
        if (null == daPgStatistics) {
            return;
        }
        try {
            this.daPgStatisticsMapper.insert(daPgStatistics);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".savePgStatisticsModel.ex", (Throwable)e);
        }
    }

    private void savePgStatisticsBatchModel(List<DaPgStatistics> daPgStatisticsList) throws ApiException {
        if (null == daPgStatisticsList || daPgStatisticsList.isEmpty()) {
            return;
        }
        try {
            this.daPgStatisticsMapper.insertBatch(daPgStatisticsList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".savePgStatisticsBatchModel.ex", (Throwable)e);
        }
    }

    private DaPgStatistics getPgStatisticsModelById(Integer pgstId) {
        if (null == pgstId) {
            return null;
        }
        try {
            return this.daPgStatisticsMapper.selectByPrimaryKey(pgstId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getPgStatisticsModelById", (Throwable)e);
            return null;
        }
    }

    private DaPgStatistics getPgStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daPgStatisticsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getPgStatisticsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPgStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daPgStatisticsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delPgStatisticsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delPgStatisticsModelByCode.num");
        }
    }

    private void deletePgStatisticsModel(Integer pgstId) throws ApiException {
        if (null == pgstId) {
            return;
        }
        int i = 0;
        try {
            i = this.daPgStatisticsMapper.deleteByPrimaryKey(pgstId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deletePgStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deletePgStatisticsModel.num");
        }
    }

    private void updatePgStatisticsModel(DaPgStatistics daPgStatistics) throws ApiException {
        if (null == daPgStatistics) {
            return;
        }
        int i = 0;
        try {
            i = this.daPgStatisticsMapper.updateByPrimaryKey(daPgStatistics);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updatePgStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updatePgStatisticsModel.num");
        }
    }

    private void updateStatePgStatisticsModel(Integer pgstId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == pgstId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pgstId", pgstId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daPgStatisticsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStatePgStatisticsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStatePgStatisticsModel.null");
        }
    }

    private void updateStatePgStatisticsModelByCode(String tenantCode, String pgstCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)pgstCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pgstCode", pgstCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daPgStatisticsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStatePgStatisticsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStatePgStatisticsModelByCode.null");
        }
    }

    private DaPgStatistics makePgStatistics(DaPgStatisticsDomain daPgStatisticsDomain, DaPgStatistics daPgStatistics) {
        if (null == daPgStatisticsDomain) {
            return null;
        }
        if (null == daPgStatistics) {
            daPgStatistics = new DaPgStatistics();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daPgStatistics, (Object)daPgStatisticsDomain);
            return daPgStatistics;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makePgStatistics", (Throwable)e);
            return null;
        }
    }

    private DaPgStatisticsReDomain makeDaPgStatisticsReDomain(DaPgStatistics daPgStatistics) {
        if (null == daPgStatistics) {
            return null;
        }
        DaPgStatisticsReDomain daPgStatisticsReDomain = new DaPgStatisticsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daPgStatisticsReDomain, (Object)daPgStatistics);
            return daPgStatisticsReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaPgStatisticsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaPgStatistics> queryPgStatisticsModelPage(Map<String, Object> parammap) {
        try {
            return this.daPgStatisticsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryPgStatisticsModel", (Throwable)e);
            return null;
        }
    }

    private int countPgStatistics(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daPgStatisticsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countPgStatistics", (Throwable)e);
        }
        return i;
    }

    private DaPgStatistics createDaPgStatistics(DaPgStatisticsDomain daPgStatisticsDomain) {
        String msg = this.checkPgStatistics(daPgStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".savePgStatistics.checkPgStatistics", msg);
        }
        DaPgStatistics daPgStatistics = this.makePgStatistics(daPgStatisticsDomain, null);
        this.setPgStatisticsDefault(daPgStatistics);
        return daPgStatistics;
    }

    @Override
    public String savePgStatistics(DaPgStatisticsDomain daPgStatisticsDomain) throws ApiException {
        DaPgStatistics daPgStatistics = this.createDaPgStatistics(daPgStatisticsDomain);
        this.savePgStatisticsModel(daPgStatistics);
        return daPgStatistics.getPgstCode();
    }

    @Override
    public String savePgStatisticsBatch(List<DaPgStatisticsDomain> daPgStatisticsDomainList) throws ApiException {
        if (null == daPgStatisticsDomainList || daPgStatisticsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaPgStatistics> daPgStatisticsList = new ArrayList<DaPgStatistics>();
        String code = "";
        for (DaPgStatisticsDomain daPgStatisticsDomain : daPgStatisticsDomainList) {
            DaPgStatistics daPgStatistics = this.createDaPgStatistics(daPgStatisticsDomain);
            code = daPgStatistics.getPgstCode();
            daPgStatisticsList.add(daPgStatistics);
        }
        this.savePgStatisticsBatchModel(daPgStatisticsList);
        return code;
    }

    @Override
    public void updatePgStatisticsState(Integer pgstId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == pgstId) {
            return;
        }
        this.updateStatePgStatisticsModel(pgstId, dataState, oldDataState, map);
    }

    @Override
    public void updatePgStatisticsStateByCode(String tenantCode, String pgstCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)pgstCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatePgStatisticsModelByCode(tenantCode, pgstCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePgStatistics(DaPgStatisticsDomain daPgStatisticsDomain) throws ApiException {
        String msg = this.checkPgStatistics(daPgStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updatePgStatistics.checkPgStatistics", msg);
        }
        DaPgStatistics oldDaPgStatistics = this.getPgStatisticsModelById(daPgStatisticsDomain.getPgstId());
        if (null == oldDaPgStatistics) {
            throw new ApiException(SYS_CODE + ".updatePgStatistics.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaPgStatistics daPgStatistics = this.makePgStatistics(daPgStatisticsDomain, oldDaPgStatistics);
        this.setPgStatisticsUpdataDefault(daPgStatistics);
        this.updatePgStatisticsModel(daPgStatistics);
    }

    @Override
    public DaPgStatistics getPgStatistics(Integer pgstId) {
        if (null == pgstId) {
            return null;
        }
        return this.getPgStatisticsModelById(pgstId);
    }

    @Override
    public void deletePgStatistics(Integer pgstId) throws ApiException {
        if (null == pgstId) {
            return;
        }
        this.deletePgStatisticsModel(pgstId);
    }

    @Override
    public QueryResult<DaPgStatistics> queryPgStatisticsPage(Map<String, Object> map) {
        List<DaPgStatistics> daPgStatisticsList = this.queryPgStatisticsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPgStatistics(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daPgStatisticsList);
        return queryResult;
    }

    @Override
    public DaPgStatistics getPgStatisticsByCode(String tenantCode, String pgstCode) throws ApiException {
        if (StringUtils.isBlank((String)pgstCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pgstCode", pgstCode);
        return this.getPgStatisticsModelByCode(map);
    }

    @Override
    public void deletePgStatisticsByCode(String tenantCode, String pgstCode) throws ApiException {
        if (StringUtils.isBlank((String)pgstCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("pgstCode", pgstCode);
        this.delPgStatisticsModelByCode(map);
    }
}

