/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.thread;

import com.yqbsoft.laser.service.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Date;
import java.util.HashMap;

public class CyySendRefundTotalThread
implements Runnable {
    private final DaOrderTotalService orderTotalService;
    private final OcRefundDomain ocRefundDomain;
    private final SupperLogUtil logger = new SupperLogUtil(this.getClass());

    public CyySendRefundTotalThread(DaOrderTotalService orderTotalService, OcRefundDomain ocRefundDomain) {
        this.orderTotalService = orderTotalService;
        this.ocRefundDomain = ocRefundDomain;
    }

    @Override
    public void run() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelClearSeqno", this.ocRefundDomain.getContractBillcode());
        param.put("tenantCode", this.ocRefundDomain.getTenantCode());
        for (OcRefundGoodsDomain ocRefundGoodsDomain : this.ocRefundDomain.getOcRefundGoodsDomainList()) {
            param.put("skuShowno", ocRefundGoodsDomain.getSkuNo());
            param.put("refundState", this.ocRefundDomain.getDataState().toString());
            if (8 == this.ocRefundDomain.getDataState()) {
                param.put("dataOcstate", -1);
                param.put("orderTotalDate1", new Date());
            } else if (0 == this.ocRefundDomain.getDataState()) {
                param.put("refundFlag", "1");
                param.put("refundCode", this.ocRefundDomain.getRefundCode());
            } else if (-1 == this.ocRefundDomain.getDataState()) {
                param.put("refundFlag", "0");
                param.put("refundCode", "");
            } else if (-2 == this.ocRefundDomain.getDataState()) {
                param.put("refundState", "-1");
                param.put("refundFlag", "0");
                param.put("refundCode", "");
            }
            this.logger.error("----\u9000\u6b3e--\u62a5\u8868\u4fee\u6539\u6570\u636e-----", (Object)JsonUtil.buildNormalBinder().toJson(param));
            this.orderTotalService.updateOrderTotalCyy(param);
        }
    }

    public void start() {
        new Thread(this).start();
    }
}

