/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaCmsStatisticsMapper;
import com.yqbsoft.laser.service.data.domain.DaCmsStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.DaCmsStatisticsReDomain;
import com.yqbsoft.laser.service.data.model.DaCmsStatistics;
import com.yqbsoft.laser.service.data.service.DaCmsStatisticsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaCmsStatisticsServiceImpl
extends BaseServiceImpl
implements DaCmsStatisticsService {
    private static final String SYS_CODE = SYS_CODE + ".DaCmsStatisticsServiceImpl";
    private DaCmsStatisticsMapper daCmsStatisticsMapper;

    public void setDaCmsStatisticsMapper(DaCmsStatisticsMapper daCmsStatisticsMapper) {
        this.daCmsStatisticsMapper = daCmsStatisticsMapper;
    }

    private Date getSysDate() {
        try {
            return this.daCmsStatisticsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCmsStatistics(DaCmsStatisticsDomain daCmsStatisticsDomain) {
        if (null == daCmsStatisticsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daCmsStatisticsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCmsStatisticsDefault(DaCmsStatistics daCmsStatistics) {
        if (null == daCmsStatistics) {
            return;
        }
        if (null == daCmsStatistics.getDataState()) {
            daCmsStatistics.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daCmsStatistics.getGmtCreate()) {
            daCmsStatistics.setGmtCreate(date);
        }
        daCmsStatistics.setGmtModified(date);
        if (StringUtils.isBlank((String)daCmsStatistics.getCmstCode())) {
            daCmsStatistics.setCmstCode(this.getNo(null, "DaCmsStatistics", "daCmsStatistics", daCmsStatistics.getTenantCode()));
        }
    }

    private int getCmsStatisticsMaxCode() {
        int code = 0;
        try {
            return this.daCmsStatisticsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getCmsStatisticsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCmsStatisticsUpdataDefault(DaCmsStatistics daCmsStatistics) {
        if (null == daCmsStatistics) {
            return;
        }
        daCmsStatistics.setGmtModified(this.getSysDate());
    }

    private void saveCmsStatisticsModel(DaCmsStatistics daCmsStatistics) throws ApiException {
        if (null == daCmsStatistics) {
            return;
        }
        try {
            this.daCmsStatisticsMapper.insert(daCmsStatistics);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveCmsStatisticsModel.ex", (Throwable)e);
        }
    }

    private void saveCmsStatisticsBatchModel(List<DaCmsStatistics> daCmsStatisticsList) throws ApiException {
        if (null == daCmsStatisticsList || daCmsStatisticsList.isEmpty()) {
            return;
        }
        try {
            this.daCmsStatisticsMapper.insertBatch(daCmsStatisticsList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveCmsStatisticsBatchModel.ex", (Throwable)e);
        }
    }

    private DaCmsStatistics getCmsStatisticsModelById(Integer cmstId) {
        if (null == cmstId) {
            return null;
        }
        try {
            return this.daCmsStatisticsMapper.selectByPrimaryKey(cmstId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getCmsStatisticsModelById", (Throwable)e);
            return null;
        }
    }

    private DaCmsStatistics getCmsStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daCmsStatisticsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getCmsStatisticsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCmsStatisticsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daCmsStatisticsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delCmsStatisticsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delCmsStatisticsModelByCode.num");
        }
    }

    private void deleteCmsStatisticsModel(Integer cmstId) throws ApiException {
        if (null == cmstId) {
            return;
        }
        int i = 0;
        try {
            i = this.daCmsStatisticsMapper.deleteByPrimaryKey(cmstId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteCmsStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteCmsStatisticsModel.num");
        }
    }

    private void updateCmsStatisticsModel(DaCmsStatistics daCmsStatistics) throws ApiException {
        if (null == daCmsStatistics) {
            return;
        }
        int i = 0;
        try {
            i = this.daCmsStatisticsMapper.updateByPrimaryKey(daCmsStatistics);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateCmsStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateCmsStatisticsModel.num");
        }
    }

    private void updateStateCmsStatisticsModel(Integer cmstId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == cmstId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cmstId", cmstId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daCmsStatisticsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateCmsStatisticsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateCmsStatisticsModel.null");
        }
    }

    private void updateStateCmsStatisticsModelByCode(String tenantCode, String cmstCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)cmstCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cmstCode", cmstCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daCmsStatisticsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateCmsStatisticsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateCmsStatisticsModelByCode.null");
        }
    }

    private DaCmsStatistics makeCmsStatistics(DaCmsStatisticsDomain daCmsStatisticsDomain, DaCmsStatistics daCmsStatistics) {
        if (null == daCmsStatisticsDomain) {
            return null;
        }
        if (null == daCmsStatistics) {
            daCmsStatistics = new DaCmsStatistics();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daCmsStatistics, (Object)daCmsStatisticsDomain);
            return daCmsStatistics;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeCmsStatistics", (Throwable)e);
            return null;
        }
    }

    private DaCmsStatisticsReDomain makeDaCmsStatisticsReDomain(DaCmsStatistics daCmsStatistics) {
        if (null == daCmsStatistics) {
            return null;
        }
        DaCmsStatisticsReDomain daCmsStatisticsReDomain = new DaCmsStatisticsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daCmsStatisticsReDomain, (Object)daCmsStatistics);
            return daCmsStatisticsReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaCmsStatisticsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaCmsStatistics> queryCmsStatisticsModelPage(Map<String, Object> parammap) {
        try {
            return this.daCmsStatisticsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryCmsStatisticsModel", (Throwable)e);
            return null;
        }
    }

    private int countCmsStatistics(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daCmsStatisticsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countCmsStatistics", (Throwable)e);
        }
        return i;
    }

    private DaCmsStatistics createDaCmsStatistics(DaCmsStatisticsDomain daCmsStatisticsDomain) {
        String msg = this.checkCmsStatistics(daCmsStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveCmsStatistics.checkCmsStatistics", msg);
        }
        DaCmsStatistics daCmsStatistics = this.makeCmsStatistics(daCmsStatisticsDomain, null);
        this.setCmsStatisticsDefault(daCmsStatistics);
        return daCmsStatistics;
    }

    @Override
    public String saveCmsStatistics(DaCmsStatisticsDomain daCmsStatisticsDomain) throws ApiException {
        DaCmsStatistics daCmsStatistics = this.createDaCmsStatistics(daCmsStatisticsDomain);
        this.saveCmsStatisticsModel(daCmsStatistics);
        return daCmsStatistics.getCmstCode();
    }

    @Override
    public String saveCmsStatisticsBatch(List<DaCmsStatisticsDomain> daCmsStatisticsDomainList) throws ApiException {
        if (null == daCmsStatisticsDomainList || daCmsStatisticsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaCmsStatistics> daCmsStatisticsList = new ArrayList<DaCmsStatistics>();
        String code = "";
        for (DaCmsStatisticsDomain daCmsStatisticsDomain : daCmsStatisticsDomainList) {
            DaCmsStatistics daCmsStatistics = this.createDaCmsStatistics(daCmsStatisticsDomain);
            code = daCmsStatistics.getCmstCode();
            daCmsStatisticsList.add(daCmsStatistics);
        }
        this.saveCmsStatisticsBatchModel(daCmsStatisticsList);
        return code;
    }

    @Override
    public void updateCmsStatisticsState(Integer cmstId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == cmstId) {
            return;
        }
        this.updateStateCmsStatisticsModel(cmstId, dataState, oldDataState, map);
    }

    @Override
    public void updateCmsStatisticsStateByCode(String tenantCode, String cmstCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)cmstCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateCmsStatisticsModelByCode(tenantCode, cmstCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCmsStatistics(DaCmsStatisticsDomain daCmsStatisticsDomain) throws ApiException {
        String msg = this.checkCmsStatistics(daCmsStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateCmsStatistics.checkCmsStatistics", msg);
        }
        DaCmsStatistics oldDaCmsStatistics = this.getCmsStatisticsModelById(daCmsStatisticsDomain.getCmstId());
        if (null == oldDaCmsStatistics) {
            throw new ApiException(SYS_CODE + ".updateCmsStatistics.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaCmsStatistics daCmsStatistics = this.makeCmsStatistics(daCmsStatisticsDomain, oldDaCmsStatistics);
        this.setCmsStatisticsUpdataDefault(daCmsStatistics);
        this.updateCmsStatisticsModel(daCmsStatistics);
    }

    @Override
    public DaCmsStatistics getCmsStatistics(Integer cmstId) {
        if (null == cmstId) {
            return null;
        }
        return this.getCmsStatisticsModelById(cmstId);
    }

    @Override
    public void deleteCmsStatistics(Integer cmstId) throws ApiException {
        if (null == cmstId) {
            return;
        }
        this.deleteCmsStatisticsModel(cmstId);
    }

    @Override
    public QueryResult<DaCmsStatistics> queryCmsStatisticsPage(Map<String, Object> map) {
        List<DaCmsStatistics> daCmsStatisticsList = this.queryCmsStatisticsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCmsStatistics(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daCmsStatisticsList);
        return queryResult;
    }

    @Override
    public DaCmsStatistics getCmsStatisticsByCode(String tenantCode, String cmstCode) throws ApiException {
        if (StringUtils.isBlank((String)cmstCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cmstCode", cmstCode);
        return this.getCmsStatisticsModelByCode(map);
    }

    @Override
    public void deleteCmsStatisticsByCode(String tenantCode, String cmstCode) throws ApiException {
        if (StringUtils.isBlank((String)cmstCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("cmstCode", cmstCode);
        this.delCmsStatisticsModelByCode(map);
    }
}

