/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisContractlogMapper;
import com.yqbsoft.laser.service.distribution.domain.DisContractDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractlogDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractlogReDomain;
import com.yqbsoft.laser.service.distribution.loges.SendPollThread;
import com.yqbsoft.laser.service.distribution.loges.SendPutThread;
import com.yqbsoft.laser.service.distribution.loges.SendService;
import com.yqbsoft.laser.service.distribution.model.DisChannelsend;
import com.yqbsoft.laser.service.distribution.model.DisContractlog;
import com.yqbsoft.laser.service.distribution.service.DisChannelsendBaseService;
import com.yqbsoft.laser.service.distribution.service.DisContractService;
import com.yqbsoft.laser.service.distribution.service.DisContractlogService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisContractlogServiceImpl
extends BaseServiceImpl
implements DisContractlogService {
    private static final String SYS_CODE = "dis.DisContractlogServiceImpl";
    private DisContractlogMapper disContractlogMapper;
    private static SendService sendService;
    private static Object lock;
    DisContractService disContractService;

    public void setDisContractlogMapper(DisContractlogMapper disContractlogMapper) {
        this.disContractlogMapper = disContractlogMapper;
    }

    private Date getSysDate() {
        try {
            return this.disContractlogMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractlogServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractlog(DisContractlogDomain disContractlogDomain) {
        if (null == disContractlogDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disContractlogDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractlogDefault(DisContractlog disContractlog) {
        if (null == disContractlog) {
            return;
        }
        if (null == disContractlog.getDataState()) {
            disContractlog.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disContractlog.getGmtCreate()) {
            disContractlog.setGmtCreate(date);
        }
        disContractlog.setGmtModified(date);
        if (StringUtils.isBlank((String)disContractlog.getContractlogCode())) {
            disContractlog.setContractlogCode(this.getNo(null, "DisContractlog", "disContractlog", disContractlog.getTenantCode()));
        }
    }

    private int getContractlogMaxCode() {
        int code = 0;
        try {
            return this.disContractlogMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractlogServiceImpl.getContractlogMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractlogUpdataDefault(DisContractlog disContractlog) {
        if (null == disContractlog) {
            return;
        }
        disContractlog.setGmtModified(this.getSysDate());
    }

    private void saveContractlogModel(DisContractlog disContractlog) throws ApiException {
        if (null == disContractlog) {
            return;
        }
        try {
            this.disContractlogMapper.insert(disContractlog);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.saveContractlogModel.ex", (Throwable)e);
        }
    }

    private void saveContractlogBatchModel(List<DisContractlog> disContractlogList) throws ApiException {
        if (null == disContractlogList || disContractlogList.isEmpty()) {
            return;
        }
        try {
            this.disContractlogMapper.insertBatch(disContractlogList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.saveContractlogBatchModel.ex", (Throwable)e);
        }
    }

    private DisContractlog getContractlogModelById(Integer contractlogId) {
        if (null == contractlogId) {
            return null;
        }
        try {
            return this.disContractlogMapper.selectByPrimaryKey(contractlogId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractlogServiceImpl.getContractlogModelById", (Throwable)e);
            return null;
        }
    }

    private DisContractlog getContractlogModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disContractlogMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractlogServiceImpl.getContractlogModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractlogModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractlogMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.delContractlogModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractlogServiceImpl.delContractlogModelByCode.num");
        }
    }

    private void deleteContractlogModel(Integer contractlogId) throws ApiException {
        if (null == contractlogId) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractlogMapper.deleteByPrimaryKey(contractlogId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.deleteContractlogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractlogServiceImpl.deleteContractlogModel.num");
        }
    }

    private void updateContractlogModel(DisContractlog disContractlog) throws ApiException {
        if (null == disContractlog) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractlogMapper.updateByPrimaryKey(disContractlog);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateContractlogModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateContractlogModel.num");
        }
    }

    private void updateStateContractlogModel(Integer contractlogId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractlogId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractlogId", contractlogId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractlogMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateStateContractlogModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateStateContractlogModel.null");
        }
    }

    private void updateStateContractlogModelByCode(String tenantCode, String contractlogCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractlogCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractlogCode", contractlogCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractlogMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateStateContractlogModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateStateContractlogModelByCode.null");
        }
    }

    private void updateCallContractlogModelByCode(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractlogMapper.updateCallByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateCallContractlogModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateCallContractlogModelByCode.null", map.toString());
        }
    }

    private DisContractlog makeContractlog(DisContractlogDomain disContractlogDomain, DisContractlog disContractlog) {
        if (null == disContractlogDomain) {
            return null;
        }
        if (null == disContractlog) {
            disContractlog = new DisContractlog();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disContractlog, (Object)disContractlogDomain);
            return disContractlog;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractlogServiceImpl.makeContractlog", (Throwable)e);
            return null;
        }
    }

    private DisContractlogReDomain makeDisContractlogReDomain(DisContractlog disContractlog) {
        if (null == disContractlog) {
            return null;
        }
        DisContractlogReDomain disContractlogReDomain = new DisContractlogReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractlogReDomain, (Object)disContractlog);
            return disContractlogReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractlogServiceImpl.makeDisContractlogReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisContractlog> queryContractlogModelPage(Map<String, Object> parammap) {
        try {
            return this.disContractlogMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractlogServiceImpl.queryContractlogModel", (Throwable)e);
            return null;
        }
    }

    private int countContractlog(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disContractlogMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractlogServiceImpl.countContractlog", (Throwable)e);
        }
        return i;
    }

    private DisContractlog createDisContractlog(DisContractlogDomain disContractlogDomain) {
        String msg = this.checkContractlog(disContractlogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractlogServiceImpl.saveContractlog.checkContractlog", msg);
        }
        DisContractlog disContractlog = this.makeContractlog(disContractlogDomain, null);
        this.setContractlogDefault(disContractlog);
        return disContractlog;
    }

    @Override
    public String saveContractlog(DisContractlogDomain disContractlogDomain) throws ApiException {
        DisContractlog disContractlog = this.createDisContractlog(disContractlogDomain);
        this.saveContractlogModel(disContractlog);
        return disContractlog.getContractlogCode();
    }

    @Override
    public List<DisContractlog> saveContractlogBatch(List<DisContractlogDomain> disContractlogDomainList) throws ApiException {
        if (null == disContractlogDomainList || disContractlogDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisContractlog> disContractlogList = new ArrayList<DisContractlog>();
        for (DisContractlogDomain disContractlogDomain : disContractlogDomainList) {
            DisContractlog disContractlog = this.createDisContractlog(disContractlogDomain);
            disContractlogList.add(disContractlog);
        }
        this.saveContractlogBatchModel(disContractlogList);
        return disContractlogList;
    }

    @Override
    public void updateContractlogState(Integer contractlogId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractlogModel(contractlogId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractlogStateByCode(String tenantCode, String contractlogCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractlogModelByCode(tenantCode, contractlogCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractlog(DisContractlogDomain disContractlogDomain) throws ApiException {
        String msg = this.checkContractlog(disContractlogDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateContractlog.checkContractlog", msg);
        }
        DisContractlog oldDisContractlog = this.getContractlogModelById(disContractlogDomain.getContractlogId());
        if (null == oldDisContractlog) {
            throw new ApiException("dis.DisContractlogServiceImpl.updateContractlog.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisContractlog disContractlog = this.makeContractlog(disContractlogDomain, oldDisContractlog);
        this.setContractlogUpdataDefault(disContractlog);
        this.updateContractlogModel(disContractlog);
    }

    @Override
    public DisContractlog getContractlog(Integer contractlogId) {
        return this.getContractlogModelById(contractlogId);
    }

    @Override
    public void deleteContractlog(Integer contractlogId) throws ApiException {
        this.deleteContractlogModel(contractlogId);
    }

    @Override
    public QueryResult<DisContractlog> queryContractlogPage(Map<String, Object> map) {
        List<DisContractlog> disContractlogList = this.queryContractlogModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractlog(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disContractlogList);
        return queryResult;
    }

    @Override
    public DisContractlog getContractlogByCode(String tenantCode, String contractlogCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractlogCode", contractlogCode);
        return this.getContractlogModelByCode(map);
    }

    @Override
    public void deleteContractlogByCode(String tenantCode, String contractlogCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractlogCode", contractlogCode);
        this.delContractlogModelByCode(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((DisChannelsendBaseService)SpringApplicationContextUtil.getBean((String)"disChannelsendBaseService"));
                for (int i = 0; i < 5; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public List<DisChannelsend> saveSendLog(DisContractlog disContractlog) {
        Map map;
        String paramStr;
        if (null == disContractlog) {
            return null;
        }
        String apiCode = disContractlog.getChannelApiCode();
        if (null == disContractlog.getContractlogNum()) {
            disContractlog.setContractlogNum(BigDecimal.ZERO);
        }
        if (null == disContractlog.getContractlogNo()) {
            disContractlog.setContractlogNo(BigDecimal.ZERO);
        }
        if (null == disContractlog.getContractlogPage()) {
            disContractlog.setContractlogPage(BigDecimal.ZERO);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        int pageNo = Integer.valueOf(String.valueOf(disContractlog.getContractlogNo()));
        int pageSize = Integer.valueOf(String.valueOf(disContractlog.getContractlogPage()));
        List<DisChannelsend> disChannelsendList = null;
        if ("cmc.disOrder.queryTimeOrder".equals(apiCode)) {
            paramStr = disContractlog.getContractlogParam();
            map = JsonUtil.buildNormalBinder().getJsonToMap(paramStr, String.class, Object.class);
            if (null == map) {
                this.logger.error("dis.DisContractlogServiceImpl.saveSendLog.map", (Object)(disContractlog.getContractlogCode() + "-" + disContractlog.getTenantCode()));
                return null;
            }
            map.put("pageNo", pageNo);
            map.put("pageSize", pageSize);
            map.put("tenantCode", disContractlog.getTenantCode());
            map.put("channelCode", disContractlog.getChannelCode());
            paramMap.put("tenantCode", disContractlog.getTenantCode());
            paramMap.put("channelCode", disContractlog.getChannelCode());
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson((Object)map));
        } else {
            paramStr = disContractlog.getContractlogParam();
            map = JsonUtil.buildNormalBinder().getJsonToMap(paramStr, String.class, Object.class);
            if (null == map) {
                this.logger.error("dis.DisContractlogServiceImpl.saveSendLog.map", (Object)(disContractlog.getContractlogCode() + "-" + disContractlog.getTenantCode()));
                return null;
            }
            paramMap.put("tenantCode", disContractlog.getTenantCode());
            paramMap.put("channelCode", disContractlog.getChannelCode());
            paramMap.put("param", map.get("param"));
            paramMap.put("pageNo", pageNo);
            paramMap.put("pageSize", pageSize);
        }
        String returnStr = this.internalInvoke(apiCode, paramMap);
        HashMap<String, Object> callMap = new HashMap<String, Object>();
        callMap.put("contractlogCode", disContractlog.getContractlogCode());
        callMap.put("tenantCode", disContractlog.getTenantCode());
        if (StringUtils.isBlank((String)returnStr)) {
            this.logger.error("dis.DisContractlogServiceImpl.saveSendLog.returnStr", (Object)(disContractlog.getContractlogCode() + "-" + disContractlog.getTenantCode() + "=" + ((Object)paramMap).toString()));
            callMap.put("dataState", 2);
            callMap.put("contractlogRestate", "ok");
            callMap.put("contractlogRestext", ((Object)paramMap).toString());
            this.updateCallContractlogModelByCode(callMap);
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(returnStr, QueryResult.class);
        List list = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), DisContractDomain.class);
        if (ListUtil.isEmpty((Collection)list)) {
            callMap.put("dataState", 2);
            callMap.put("contractlogRestate", "ok");
            callMap.put("contractlogRestext", ((Object)paramMap).toString());
            this.updateCallContractlogModelByCode(callMap);
        } else {
            disContractlog.setContractlogNo(BigDecimal.valueOf(pageNo + 1));
            callMap.put("dataState", 0);
            callMap.put("contractlogNo", BigDecimal.valueOf(pageNo + 1));
            callMap.put("contractlogRestate", "ok");
            callMap.put("contractlogRestext", returnStr);
            this.updateCallContractlogModelByCode(callMap);
            disChannelsendList = this.disContractService.saveContractBatch(list);
            ArrayList<DisContractlog> loglist = new ArrayList<DisContractlog>();
            loglist.add(disContractlog);
            DisContractlogServiceImpl.getSendService().addPutPool(new SendPutThread(DisContractlogServiceImpl.getSendService(), loglist));
        }
        return disChannelsendList;
    }

    public void setDisContractService(DisContractService disContractService) {
        this.disContractService = disContractService;
    }

    @Override
    public void loadCacheDb() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<DisContractlog> result = null;
            do {
                startRow = DisContractlogServiceImpl.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", DisContractlogServiceImpl.getSendService().getPage());
                result = this.queryContractlogPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    DisContractlogServiceImpl.getSendService().addPutPool(new SendPutThread(DisContractlogServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != DisContractlogServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            DisContractlogServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractlogServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    static {
        lock = new Object();
    }
}

