/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDgoodsBuyMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsBuyDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsBuyReDomain;
import com.yqbsoft.laser.service.distribution.model.DisChannel;
import com.yqbsoft.laser.service.distribution.model.DisDgoodsBuy;
import com.yqbsoft.laser.service.distribution.service.DisDgoodsBuyService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisDgoodsBuyServiceImpl
extends BaseServiceImpl
implements DisDgoodsBuyService {
    private static final String SYS_CODE = "dis.DisDgoodsBuyServiceImpl";
    private DisDgoodsBuyMapper disDgoodsBuyMapper;
    private String cache_pro_key = "DisDgoodsBuy_pro";
    private String cache_DisDgoodsBuy_provalue_key = "DisDgoodsBuy_provalue";
    private String str = "-";
    private String cachePcode = "DisChannel-pCode";

    public void setDisDgoodsBuysMapper(DisDgoodsBuyMapper disDgoodsBuysMapper) {
        this.disDgoodsBuyMapper = disDgoodsBuysMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDgoodsBuyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDgoodsBuy(DisDgoodsBuyDomain disDgoodsBuyDomain) {
        if (null == disDgoodsBuyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgoodsBuyDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgoodsBuyDefault(DisDgoodsBuy disDgoodsBuy) {
        if (null == disDgoodsBuy) {
            return;
        }
        if (null == disDgoodsBuy.getDataState()) {
            disDgoodsBuy.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDgoodsBuy.getGmtCreate()) {
            disDgoodsBuy.setGmtCreate(date);
        }
        disDgoodsBuy.setGmtModified(date);
        if (StringUtils.isBlank((String)disDgoodsBuy.getDgoodsBuyCode())) {
            disDgoodsBuy.setDgoodsBuyCode(this.getNo(null, "DisDgoodsBuy", "disDgoodsBuy", disDgoodsBuy.getTenantCode()));
        }
    }

    private int getDgoodsBuyMaxCode() {
        int code = 0;
        try {
            return this.disDgoodsBuyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.getDgoodsBuyMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgoodsBuyUpdataDefault(DisDgoodsBuy disDgoodsBuy) {
        if (null == disDgoodsBuy) {
            return;
        }
        disDgoodsBuy.setGmtModified(this.getSysDate());
    }

    private void saveDgoodsBuyModel(DisDgoodsBuy disDgoodsBuy) throws ApiException {
        if (null == disDgoodsBuy) {
            return;
        }
        try {
            this.disDgoodsBuyMapper.insert(disDgoodsBuy);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.saveDgoodsBuyModel.ex", (Throwable)e);
        }
    }

    private void saveDgoodsBuyBatchModel(List<DisDgoodsBuy> disDgoodsBuyList) throws ApiException {
        if (null == disDgoodsBuyList || disDgoodsBuyList.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsBuyMapper.insertBatch(disDgoodsBuyList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.saveDgoodsBuyBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgoodsBuy getDgoodsBuyModelById(Integer disDgoodsBuyId) {
        if (null == disDgoodsBuyId) {
            return null;
        }
        try {
            return this.disDgoodsBuyMapper.selectByPrimaryKey(disDgoodsBuyId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.getDgoodsBuyModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsBuy getDgoodsBuyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgoodsBuyMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.getDgoodsBuyModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgoodsBuyModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsBuyMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.delDgoodsBuyModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.delDgoodsBuyModelByCode.num");
        }
    }

    private void deleteDgoodsBuyModel(Integer disDgoodsBuyId) throws ApiException {
        if (null == disDgoodsBuyId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsBuyMapper.deleteByPrimaryKey(disDgoodsBuyId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.deleteDgoodsBuyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.deleteDgoodsBuyModel.num");
        }
    }

    private void updateDgoodsBuyModel(DisDgoodsBuy disDgoodsBuy) throws ApiException {
        if (null == disDgoodsBuy) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsBuyMapper.updateByPrimaryKey(disDgoodsBuy);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.updateDgoodsBuyModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.updateDgoodsBuyModel.num");
        }
    }

    private void updateStateDgoodsBuyModel(Integer disDgoodsBuyId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == disDgoodsBuyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("disDgoodsBuyId", disDgoodsBuyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgoodsBuyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.updateStateDgoodsBuyModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.updateStateDgoodsBuyModel.null");
        }
    }

    private void updateStateDgoodsBuyModelByCode(String tenantCode, String disDgoodsBuycode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)disDgoodsBuycode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("disDgoodsBuycode", disDgoodsBuycode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgoodsBuyMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.updateStateDgoodsBuyModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.updateStateDgoodsBuyModelByCode.null");
        }
    }

    private DisDgoodsBuy makeDgoodsBuy(DisDgoodsBuyDomain disDgoodsBuyDomain, DisDgoodsBuy disDgoodsBuy) {
        if (null == disDgoodsBuyDomain) {
            return null;
        }
        if (null == disDgoodsBuy) {
            disDgoodsBuy = new DisDgoodsBuy();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsBuy, (Object)disDgoodsBuyDomain);
            return disDgoodsBuy;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.makeDgoodsBuy", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsBuyReDomain makeDisDgoodsBuyReDomain(DisDgoodsBuy disDgoodsBuy) {
        if (null == disDgoodsBuy) {
            return null;
        }
        DisDgoodsBuyReDomain disDgoodsBuyReDomain = new DisDgoodsBuyReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsBuyReDomain, (Object)disDgoodsBuy);
            return disDgoodsBuyReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.makeDisDgoodsBuyReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgoodsBuy> queryDgoodsBuyModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgoodsBuyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryDgoodsBuyModel", (Throwable)e);
            return null;
        }
    }

    private int countDgoodsBuy(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgoodsBuyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.countDgoodsBuy", (Throwable)e);
        }
        return i;
    }

    private DisDgoodsBuy createDisDgoodsBuy(DisDgoodsBuyDomain disDgoodsBuyDomain) {
        String msg = this.checkDgoodsBuy(disDgoodsBuyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.saveDgoodsBuy.checkDgoodsBuy", msg);
        }
        DisDgoodsBuy disDgoodsBuy = this.makeDgoodsBuy(disDgoodsBuyDomain, null);
        this.setDgoodsBuyDefault(disDgoodsBuy);
        return disDgoodsBuy;
    }

    @Override
    public String saveDgoodsBuy(DisDgoodsBuyDomain disDgoodsBuyDomain) throws ApiException {
        DisDgoodsBuy disDgoodsBuy = this.createDisDgoodsBuy(disDgoodsBuyDomain);
        this.saveDgoodsBuyModel(disDgoodsBuy);
        return disDgoodsBuy.getDgoodsBuyCode();
    }

    @Override
    public String saveDgoodsBuyBatch(List<DisDgoodsBuyDomain> disDgoodsBuyDomainList) throws ApiException {
        if (null == disDgoodsBuyDomainList || disDgoodsBuyDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDgoodsBuy> disDgoodsBuyList = new ArrayList<DisDgoodsBuy>();
        String code = "";
        for (DisDgoodsBuyDomain disDgoodsBuyDomain : disDgoodsBuyDomainList) {
            DisDgoodsBuy disDgoodsBuy = this.createDisDgoodsBuy(disDgoodsBuyDomain);
            code = disDgoodsBuy.getDgoodsCode();
            disDgoodsBuyList.add(disDgoodsBuy);
        }
        this.saveDgoodsBuyBatchModel(disDgoodsBuyList);
        this.load(disDgoodsBuyList);
        return code;
    }

    @Override
    public void updateDgoodsBuyState(Integer disDgoodsBuyId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == disDgoodsBuyId) {
            return;
        }
        this.updateStateDgoodsBuyModel(disDgoodsBuyId, dataState, oldDataState, map);
    }

    @Override
    public void updateDgoodsBuyStateByCode(String tenantCode, String disDgoodsBuycode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)disDgoodsBuycode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgoodsBuyModelByCode(tenantCode, disDgoodsBuycode, dataState, oldDataState, map);
    }

    @Override
    public void updateDgoodsBuy(DisDgoodsBuyDomain disDgoodsBuyDomain) throws ApiException {
        String msg = this.checkDgoodsBuy(disDgoodsBuyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.updateDgoodsBuy.checkDgoodsBuy", msg);
        }
        DisDgoodsBuy oldDisDgoodsBuy = this.getDgoodsBuyModelById(disDgoodsBuyDomain.getDgoodsBuyId());
        if (null == oldDisDgoodsBuy) {
            throw new ApiException("dis.DisDgoodsBuyServiceImpl.updateDgoodsBuy.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgoodsBuy disDgoodsBuy = this.makeDgoodsBuy(disDgoodsBuyDomain, oldDisDgoodsBuy);
        this.setDgoodsBuyUpdataDefault(disDgoodsBuy);
        this.updateDgoodsBuyModel(disDgoodsBuy);
    }

    @Override
    public DisDgoodsBuy getDgoodsBuy(Integer disDgoodsBuyId) {
        if (null == disDgoodsBuyId) {
            return null;
        }
        return this.getDgoodsBuyModelById(disDgoodsBuyId);
    }

    @Override
    public void deleteDgoodsBuy(Integer disDgoodsBuyId) throws ApiException {
        if (null == disDgoodsBuyId) {
            return;
        }
        DisDgoodsBuy disDgoodsBuy = this.getDgoodsBuyModelById(disDgoodsBuyId);
        this.deleteDgoodsBuyModel(disDgoodsBuyId);
        this.deleteCache(disDgoodsBuy);
    }

    @Override
    public QueryResult<DisDgoodsBuy> queryDgoodsBuyPage(Map<String, Object> map) {
        List<DisDgoodsBuy> disDgoodsBuyList = this.queryDgoodsBuyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgoodsBuy(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgoodsBuyList);
        return queryResult;
    }

    @Override
    public DisDgoodsBuy getDgoodsBuyByCode(String tenantCode, String disDgoodsBuycode) throws ApiException {
        if (StringUtils.isBlank((String)disDgoodsBuycode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("disDgoodsBuycode", disDgoodsBuycode);
        return this.getDgoodsBuyModelByCode(map);
    }

    @Override
    public void deleteDgoodsBuyByCode(String tenantCode, String disDgoodsBuycode) throws ApiException {
        if (StringUtils.isBlank((String)disDgoodsBuycode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("disDgoodsBuycode", disDgoodsBuycode);
        this.delDgoodsBuyModelByCode(map);
    }

    private void updateCache(DisDgoodsBuy disDgoodsBuy) {
        if (null == disDgoodsBuy) {
            return;
        }
        if (StringUtils.isBlank((String)disDgoodsBuy.getDgoodsBuyType())) {
            disDgoodsBuy.setDgoodsBuyType("");
        }
        if (StringUtils.isBlank((String)disDgoodsBuy.getDgoodsBuyTerm())) {
            disDgoodsBuy.setDgoodsBuyTerm("=");
        }
        if (StringUtils.isBlank((String)disDgoodsBuy.getDgoodsBuyValue())) {
            disDgoodsBuy.setDgoodsBuyValue("");
        }
        DisUtil.setMap((String)(this.cache_pro_key + this.str + disDgoodsBuy.getTenantCode()), (String)disDgoodsBuy.getChannelCode(), (String)disDgoodsBuy.getChannelName());
        String cacheKey = this.cache_DisDgoodsBuy_provalue_key + this.str + disDgoodsBuy.getTenantCode() + this.str + disDgoodsBuy.getChannelCode();
        String cacheValue = DisUtil.getRemotMap((String)cacheKey, (String)(disDgoodsBuy.getDgoodsBuyType() + this.str + disDgoodsBuy.getDgoodsBuyTerm()));
        if (StringUtils.isNotBlank((String)cacheValue) && !"null".equals(cacheValue)) {
            DisUtil.setMap((String)cacheKey, (String)(disDgoodsBuy.getDgoodsBuyType() + this.str + disDgoodsBuy.getDgoodsBuyTerm()), (String)(cacheValue + "," + disDgoodsBuy.getDgoodsBuyValue()));
        } else {
            DisUtil.setMap((String)cacheKey, (String)(disDgoodsBuy.getDgoodsBuyType() + this.str + disDgoodsBuy.getDgoodsBuyTerm()), (String)disDgoodsBuy.getDgoodsBuyValue());
        }
    }

    private void deleteCache(DisDgoodsBuy disDgoodsBuy) {
        if (null == disDgoodsBuy) {
            return;
        }
        if (StringUtils.isBlank((String)disDgoodsBuy.getDgoodsBuyType())) {
            disDgoodsBuy.setDgoodsBuyType("");
        }
        if (StringUtils.isBlank((String)disDgoodsBuy.getDgoodsBuyTerm())) {
            disDgoodsBuy.setDgoodsBuyTerm("=");
        }
        if (StringUtils.isBlank((String)disDgoodsBuy.getDgoodsBuyValue())) {
            disDgoodsBuy.setDgoodsBuyValue("");
        }
        String channelKeyStr = disDgoodsBuy.getDgoodsBuyType() + this.str + disDgoodsBuy.getDgoodsBuyTerm();
        String cacheKey = this.cache_DisDgoodsBuy_provalue_key + this.str + disDgoodsBuy.getTenantCode() + this.str + disDgoodsBuy.getChannelCode();
        Map valueMap = DisUtil.getRemotMapAll((String)cacheKey);
        CharSequence[] cacheValue = null;
        if (null != valueMap && MapUtil.isNotEmpty((Map)valueMap)) {
            for (String channelKey : valueMap.keySet()) {
                if (!channelKeyStr.equals(channelKey) || !DisDgoodsBuyServiceImpl.useLoop((String[])(cacheValue = ((String)valueMap.get(channelKey)).split(",")), disDgoodsBuy.getDgoodsBuyValue())) continue;
                if ((cacheValue = DisDgoodsBuyServiceImpl.useRemove((String[])cacheValue, disDgoodsBuy.getDgoodsBuyValue())) == null || cacheValue.length == 0) {
                    DisUtil.delMap((String)cacheKey, (String[])new String[]{channelKeyStr});
                    continue;
                }
                DisUtil.setMap((String)cacheKey, (String)channelKeyStr, (String)String.join((CharSequence)",", cacheValue));
            }
        }
        if (cacheValue == null || cacheValue.length == 0) {
            DisUtil.delMap((String)(this.cache_pro_key + this.str + disDgoodsBuy.getTenantCode()), (String[])new String[]{disDgoodsBuy.getChannelCode()});
        }
    }

    private void load(List<DisDgoodsBuy> disDgoodsBuyList) {
        if (ListUtil.isEmpty(disDgoodsBuyList)) {
            return;
        }
        for (DisDgoodsBuy disDgoodsBuy : disDgoodsBuyList) {
            try {
                this.updateCache(disDgoodsBuy);
            }
            catch (Exception e) {
                this.logger.error("dis.DisDgoodsBuyServiceImpl.load.e", (Throwable)e);
            }
        }
    }

    private void deleCache(List<DisDgoodsBuy> disDgoodsBuyList) {
        if (ListUtil.isEmpty(disDgoodsBuyList)) {
            return;
        }
        for (DisDgoodsBuy disDgoodsBuy : disDgoodsBuyList) {
            try {
                this.deleteCache(disDgoodsBuy);
            }
            catch (Exception e) {
                this.logger.error("dis.DisDgoodsBuyServiceImpl.deleCache.e", (Throwable)e);
            }
        }
    }

    @Override
    public void queryLoadCache(String tenantCode) {
        Map paramMapmap = this.getQueryParamMap("tenantCode", new Object[]{tenantCode});
        try {
            List<DisDgoodsBuy> disDgoodsBuyList = this.queryDgoodsBuyModelPage(paramMapmap);
            Map map = DisUtil.getRemotMapAll((String)(this.cache_pro_key + this.str + tenantCode));
            for (String key : map.keySet()) {
                DisUtil.del((String)(this.cache_DisDgoodsBuy_provalue_key + this.str + tenantCode + this.str + key));
            }
            DisUtil.del((String)(this.cache_pro_key + this.str + tenantCode));
            if (ListUtil.isEmpty(disDgoodsBuyList)) {
                return;
            }
            this.load(disDgoodsBuyList);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryLoadCache.e", (Throwable)e);
        }
    }

    @Override
    public void queryChannelLoadCache(String channelCode, String tenantCode) {
        Map map = this.getQueryParamMap("channelCode,tenantCode", new Object[]{channelCode, tenantCode});
        try {
            List<DisDgoodsBuy> disDgoodsBuyList = this.queryDgoodsBuyModelPage(map);
            DisUtil.del((String)(this.cache_DisDgoodsBuy_provalue_key + this.str + tenantCode + this.str + channelCode));
            this.load(disDgoodsBuyList);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryChannelLoadCache.e", (Throwable)e);
        }
    }

    @Override
    public void queryChannelDelCache(String channelCode, String tenantCode) {
        Map map = this.getQueryParamMap("channelCode,tenantCode", new Object[]{channelCode, tenantCode});
        try {
            DisUtil.delMap((String)(this.cache_pro_key + this.str + tenantCode), (String[])new String[]{channelCode});
            DisUtil.del((String)(this.cache_DisDgoodsBuy_provalue_key + this.str + tenantCode + this.str + channelCode));
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryChannelLoadCache.e", (Throwable)e);
        }
    }

    @Override
    public List<String> queryChannelCodeCache(Map<String, Object> map, String tenantCode) {
        if (StringUtils.isBlank((String)tenantCode) || MapUtil.isEmpty(map)) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.null", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        String channelCode = (String)map.get("channelCode");
        if (StringUtils.isBlank((String)channelCode)) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.channelCode", (Object)"channelCode\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        Map pchannelMap = DisUtil.getRemotMapAll((String)this.cachePcode);
        if (MapUtil.isEmpty((Map)pchannelMap)) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.pchannelMap", (Object)"\u7236\u6e20\u9053\u4e3a\u7a7a");
            return null;
        }
        String pchannelListStr = (String)pchannelMap.get(channelCode + "-" + tenantCode);
        if (StringUtils.isBlank((String)pchannelListStr)) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.pchannelListStr", (Object)"pchannelListStr\u4e3a\u7a7a");
            return null;
        }
        List plist = JsonUtil.buildNormalBinder().getJsonToList(pchannelListStr, DisChannel.class);
        if (ListUtil.isEmpty((Collection)plist)) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.plist", (Object)"plist\u4e3a\u7a7a");
            return null;
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        for (DisChannel disChannel : plist) {
            pmap.put(disChannel.getChannelCode(), disChannel.getChannelCode());
        }
        Map tenantMap = DisUtil.getRemotMapAll((String)(this.cache_pro_key + this.str + tenantCode));
        ArrayList<String> returnList = new ArrayList<String>();
        if (MapUtil.isEmpty((Map)tenantMap)) {
            this.logger.error("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.tenantMap", (Object)(this.cache_pro_key + this.str + tenantCode));
            return returnList;
        }
        boolean flag = true;
        for (String key : tenantMap.keySet()) {
            if (!pmap.containsKey(key)) {
                this.logger.debug("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.key", (Object)(key + "=" + pmap));
                continue;
            }
            Map channelMap = DisUtil.getRemotMapAll((String)(this.cache_DisDgoodsBuy_provalue_key + this.str + tenantCode + this.str + key));
            if (MapUtil.isEmpty((Map)channelMap)) {
                this.logger.debug("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.channelMap", (Object)(key + "=" + tenantCode));
                continue;
            }
            this.logger.debug("dis.DisDgoodsBuyServiceImpl.queryChannelCodeCache.info", (Object)(channelMap + "=" + map));
            flag = true;
            for (String channelKey : channelMap.keySet()) {
                String[] channelKeyStr = channelKey.split(this.str);
                String pro = channelKeyStr[0];
                String term = channelKeyStr.length > 1 ? channelKeyStr[1] : "=";
                String[] cacheValue = ((String)channelMap.get(channelKey)).split(",");
                if ("=".equals(term)) {
                    if (DisDgoodsBuyServiceImpl.useLoop(cacheValue, String.valueOf(map.get(pro)))) continue;
                    flag = false;
                    break;
                }
                if (!cacheValue.equals(map.get(pro))) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            returnList.add(key + this.str + (String)tenantMap.get(key));
        }
        if (ListUtil.isEmpty(returnList)) {
            returnList.add(channelCode + this.str + (String)tenantMap.get(channelCode));
        }
        return returnList;
    }

    public static boolean useLoop(String[] arr, String targetValue) {
        for (String s : arr) {
            if (!s.equals(targetValue)) continue;
            return true;
        }
        return false;
    }

    public static String[] useRemove(String[] arr, String targetValue) {
        int num = DisDgoodsBuyServiceImpl.removeE(arr, targetValue);
        return Arrays.copyOf(arr, num);
    }

    private static int removeE(String[] arr, String val) {
        int front = 0;
        int rear = arr.length;
        while (front < rear) {
            if (StringUtils.equals((CharSequence)arr[front], (CharSequence)val)) {
                arr[front] = arr[rear - 1];
                --rear;
                continue;
            }
            ++front;
        }
        return front;
    }

    public static void main(String[] args) {
        String[] arr = new String[]{"0", "1", "2", "2", "3", "4", "2"};
        String val = "2";
        CharSequence[] strings = DisDgoodsBuyServiceImpl.useRemove(arr, val);
        System.out.println(String.join((CharSequence)",", strings));
    }
}

