/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.eq.service.impl;

import com.yqbsoft.laser.service.eq.dao.EqAuctionFileMapper;
import com.yqbsoft.laser.service.eq.domain.EqAuctionFileDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionFileReDomain;
import com.yqbsoft.laser.service.eq.model.EqAuctionFile;
import com.yqbsoft.laser.service.eq.service.EqAuctionFileService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EqAuctionFileServiceImpl
extends BaseServiceImpl
implements EqAuctionFileService {
    private static final String SYS_CODE = "eq.EqAuctionFileServiceImpl";
    private EqAuctionFileMapper eqAuctionFileMapper;

    public void setEqAuctionFileMapper(EqAuctionFileMapper eqAuctionFileMapper) {
        this.eqAuctionFileMapper = eqAuctionFileMapper;
    }

    private Date getSysDate() {
        try {
            return this.eqAuctionFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuctionFile(EqAuctionFileDomain eqAuctionFileDomain) {
        if (null == eqAuctionFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)eqAuctionFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAuctionFileDefault(EqAuctionFile eqAuctionFile) {
        if (null == eqAuctionFile) {
            return;
        }
        if (null == eqAuctionFile.getDataState()) {
            eqAuctionFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == eqAuctionFile.getGmtCreate()) {
            eqAuctionFile.setGmtCreate(date);
        }
        eqAuctionFile.setGmtModified(date);
        if (StringUtils.isBlank((String)eqAuctionFile.getAuctionFileCode())) {
            eqAuctionFile.setAuctionFileCode(this.getNo(null, "EqAuctionFile", "eqAuctionFile", eqAuctionFile.getTenantCode()));
        }
    }

    private int getAuctionFileMaxCode() {
        int code = 0;
        try {
            return this.eqAuctionFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionFileServiceImpl.getAuctionFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctionFileUpdataDefault(EqAuctionFile eqAuctionFile) {
        if (null == eqAuctionFile) {
            return;
        }
        eqAuctionFile.setGmtModified(this.getSysDate());
    }

    private void saveAuctionFileModel(EqAuctionFile eqAuctionFile) throws ApiException {
        if (null == eqAuctionFile) {
            return;
        }
        try {
            this.eqAuctionFileMapper.insert(eqAuctionFile);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.saveAuctionFileModel.ex", (Throwable)e);
        }
    }

    private void saveAuctionFileBatchModel(List<EqAuctionFile> eqAuctionFileList) throws ApiException {
        if (null == eqAuctionFileList || eqAuctionFileList.isEmpty()) {
            return;
        }
        try {
            this.eqAuctionFileMapper.insertBatch(eqAuctionFileList);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.saveAuctionFileBatchModel.ex", (Throwable)e);
        }
    }

    private EqAuctionFile getAuctionFileModelById(Integer auctionFileId) {
        if (null == auctionFileId) {
            return null;
        }
        try {
            return this.eqAuctionFileMapper.selectByPrimaryKey(auctionFileId);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionFileServiceImpl.getAuctionFileModelById", (Throwable)e);
            return null;
        }
    }

    private EqAuctionFile getAuctionFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.eqAuctionFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionFileServiceImpl.getAuctionFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAuctionFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.delAuctionFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.delAuctionFileModelByCode.num");
        }
    }

    private void deleteAuctionFileModel(Integer auctionFileId) throws ApiException {
        if (null == auctionFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionFileMapper.deleteByPrimaryKey(auctionFileId);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.deleteAuctionFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.deleteAuctionFileModel.num");
        }
    }

    private void updateAuctionFileModel(EqAuctionFile eqAuctionFile) throws ApiException {
        if (null == eqAuctionFile) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionFileMapper.updateByPrimaryKey(eqAuctionFile);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.updateAuctionFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.updateAuctionFileModel.num");
        }
    }

    private void updateStateAuctionFileModel(Integer auctionFileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionFileId", auctionFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.updateStateAuctionFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.updateStateAuctionFileModel.null");
        }
    }

    private void updateStateAuctionFileModelByCode(String tenantCode, String auctionFileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionFileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionFileCode", auctionFileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.updateStateAuctionFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.updateStateAuctionFileModelByCode.null");
        }
    }

    private EqAuctionFile makeAuctionFile(EqAuctionFileDomain eqAuctionFileDomain, EqAuctionFile eqAuctionFile) {
        if (null == eqAuctionFileDomain) {
            return null;
        }
        if (null == eqAuctionFile) {
            eqAuctionFile = new EqAuctionFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)eqAuctionFile, (Object)eqAuctionFileDomain);
            return eqAuctionFile;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionFileServiceImpl.makeAuctionFile", (Throwable)e);
            return null;
        }
    }

    private EqAuctionFileReDomain makeEqAuctionFileReDomain(EqAuctionFile eqAuctionFile) {
        if (null == eqAuctionFile) {
            return null;
        }
        EqAuctionFileReDomain eqAuctionFileReDomain = new EqAuctionFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)eqAuctionFileReDomain, (Object)eqAuctionFile);
            return eqAuctionFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionFileServiceImpl.makeEqAuctionFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<EqAuctionFile> queryAuctionFileModelPage(Map<String, Object> parammap) {
        try {
            return this.eqAuctionFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionFileServiceImpl.queryAuctionFileModel", (Throwable)e);
            return null;
        }
    }

    private int countAuctionFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.eqAuctionFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionFileServiceImpl.countAuctionFile", (Throwable)e);
        }
        return i;
    }

    private EqAuctionFile createEqAuctionFile(EqAuctionFileDomain eqAuctionFileDomain) {
        String msg = this.checkAuctionFile(eqAuctionFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.saveAuctionFile.checkAuctionFile", msg);
        }
        EqAuctionFile eqAuctionFile = this.makeAuctionFile(eqAuctionFileDomain, null);
        this.setAuctionFileDefault(eqAuctionFile);
        return eqAuctionFile;
    }

    @Override
    public String saveAuctionFile(EqAuctionFileDomain eqAuctionFileDomain) throws ApiException {
        EqAuctionFile eqAuctionFile = this.createEqAuctionFile(eqAuctionFileDomain);
        this.saveAuctionFileModel(eqAuctionFile);
        return eqAuctionFile.getAuctionFileCode();
    }

    @Override
    public String saveAuctionFileBatch(List<EqAuctionFileDomain> eqAuctionFileDomainList) throws ApiException {
        if (null == eqAuctionFileDomainList || eqAuctionFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<EqAuctionFile> eqAuctionFileList = new ArrayList<EqAuctionFile>();
        String code = "";
        for (EqAuctionFileDomain eqAuctionFileDomain : eqAuctionFileDomainList) {
            EqAuctionFile eqAuctionFile = this.createEqAuctionFile(eqAuctionFileDomain);
            code = eqAuctionFile.getAuctionFileCode();
            eqAuctionFileList.add(eqAuctionFile);
        }
        this.saveAuctionFileBatchModel(eqAuctionFileList);
        return code;
    }

    @Override
    public void updateAuctionFileState(Integer auctionFileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == auctionFileId) {
            return;
        }
        this.updateStateAuctionFileModel(auctionFileId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionFileStateByCode(String tenantCode, String auctionFileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)auctionFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAuctionFileModelByCode(tenantCode, auctionFileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionFile(EqAuctionFileDomain eqAuctionFileDomain) throws ApiException {
        String msg = this.checkAuctionFile(eqAuctionFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.updateAuctionFile.checkAuctionFile", msg);
        }
        EqAuctionFile oldEqAuctionFile = this.getAuctionFileModelById(eqAuctionFileDomain.getAuctionFileId());
        if (null == oldEqAuctionFile) {
            throw new ApiException("eq.EqAuctionFileServiceImpl.updateAuctionFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EqAuctionFile eqAuctionFile = this.makeAuctionFile(eqAuctionFileDomain, oldEqAuctionFile);
        this.setAuctionFileUpdataDefault(eqAuctionFile);
        this.updateAuctionFileModel(eqAuctionFile);
    }

    @Override
    public EqAuctionFile getAuctionFile(Integer auctionFileId) {
        if (null == auctionFileId) {
            return null;
        }
        return this.getAuctionFileModelById(auctionFileId);
    }

    @Override
    public void deleteAuctionFile(Integer auctionFileId) throws ApiException {
        if (null == auctionFileId) {
            return;
        }
        this.deleteAuctionFileModel(auctionFileId);
    }

    @Override
    public QueryResult<EqAuctionFile> queryAuctionFilePage(Map<String, Object> map) {
        List<EqAuctionFile> eqAuctionFileList = this.queryAuctionFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuctionFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(eqAuctionFileList);
        return queryResult;
    }

    @Override
    public EqAuctionFile getAuctionFileByCode(String tenantCode, String auctionFileCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionFileCode", auctionFileCode);
        return this.getAuctionFileModelByCode(map);
    }

    @Override
    public void deleteAuctionFileByCode(String tenantCode, String auctionFileCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionFileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionFileCode", auctionFileCode);
        this.delAuctionFileModelByCode(map);
    }
}

