/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.eq.service.impl;

import com.yqbsoft.laser.service.eq.bo.HtmlJsonReBean;
import com.yqbsoft.laser.service.eq.dao.EqAuctionEnrollMapper;
import com.yqbsoft.laser.service.eq.dao.EqAuctionMapper;
import com.yqbsoft.laser.service.eq.domain.EqAuctionEnrollDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionEnrollReDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionEnrollfileDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionGoodsDomain;
import com.yqbsoft.laser.service.eq.model.EqAuction;
import com.yqbsoft.laser.service.eq.model.EqAuctionEnroll;
import com.yqbsoft.laser.service.eq.model.EqAuctionEnrollfile;
import com.yqbsoft.laser.service.eq.model.EqAuctionGoods;
import com.yqbsoft.laser.service.eq.service.EqAuctionEnrollService;
import com.yqbsoft.laser.service.eq.service.EqAuctionEnrollfileService;
import com.yqbsoft.laser.service.eq.service.EqAuctionFileService;
import com.yqbsoft.laser.service.eq.service.EqAuctionGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmUserinfoQuaMapper;
import com.yqbsoft.laser.service.user.model.UmUserinfoQua;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EqAuctionEnrollServiceImpl
extends BaseServiceImpl
implements EqAuctionEnrollService {
    private static final String SYS_CODE = "eq.EqAuctionEnrollServiceImpl";
    private EqAuctionEnrollMapper eqAuctionEnrollMapper;
    private EqAuctionMapper eqAuctionMapper;
    private EqAuctionFileService eqAuctionFileService;
    private EqAuctionEnrollfileService eqAuctionEnrollfileService;
    private EqAuctionGoodsService eqAuctionGoodsService;
    private UmUserinfoQuaMapper umUserinfoQuaMapper;
    static final String EQ_AUCTION_PRICE_SORT = "EQ_AUCTION_PRICE_SORT";

    public void setEqAuctionMapper(EqAuctionMapper eqAuctionMapper) {
        this.eqAuctionMapper = eqAuctionMapper;
    }

    public EqAuctionFileService getEqAuctionFileService() {
        return this.eqAuctionFileService;
    }

    public void setEqAuctionFileService(EqAuctionFileService eqAuctionFileService) {
        this.eqAuctionFileService = eqAuctionFileService;
    }

    public EqAuctionEnrollfileService getEqAuctionEnrollfileService() {
        return this.eqAuctionEnrollfileService;
    }

    public void setEqAuctionEnrollfileService(EqAuctionEnrollfileService eqAuctionEnrollfileService) {
        this.eqAuctionEnrollfileService = eqAuctionEnrollfileService;
    }

    public EqAuctionGoodsService getEqAuctionGoodsService() {
        return this.eqAuctionGoodsService;
    }

    public void setEqAuctionGoodsService(EqAuctionGoodsService eqAuctionGoodsService) {
        this.eqAuctionGoodsService = eqAuctionGoodsService;
    }

    public void setEqAuctionEnrollMapper(EqAuctionEnrollMapper eqAuctionEnrollMapper) {
        this.eqAuctionEnrollMapper = eqAuctionEnrollMapper;
    }

    public void setUmUserinfoQuaMapper(UmUserinfoQuaMapper umUserinfoQuaMapper) {
        this.umUserinfoQuaMapper = umUserinfoQuaMapper;
    }

    private Date getSysDate() {
        try {
            return this.eqAuctionEnrollMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionEnrollServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuctionEnroll(EqAuctionEnrollDomain eqAuctionEnrollDomain) {
        this.logger.error(".checkAuctionEnroll", (Object)eqAuctionEnrollDomain.getMemberCcode());
        if (null == eqAuctionEnrollDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)eqAuctionEnrollDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAuctionEnrollDefault(EqAuctionEnroll eqAuctionEnroll) {
        if (null == eqAuctionEnroll) {
            return;
        }
        if (null == eqAuctionEnroll.getDataState()) {
            eqAuctionEnroll.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == eqAuctionEnroll.getGmtCreate()) {
            eqAuctionEnroll.setGmtCreate(date);
        }
        eqAuctionEnroll.setGmtModified(date);
        if (StringUtils.isBlank((String)eqAuctionEnroll.getAuctionEnrollCode())) {
            eqAuctionEnroll.setAuctionEnrollCode(this.getNo(null, "EqAuctionEnroll", "eqAuctionEnroll", eqAuctionEnroll.getTenantCode()));
        }
    }

    private int getAuctionEnrollMaxCode() {
        int code = 0;
        try {
            return this.eqAuctionEnrollMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionEnrollServiceImpl.getAuctionEnrollMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctionEnrollUpdataDefault(EqAuctionEnroll eqAuctionEnroll) {
        if (null == eqAuctionEnroll) {
            return;
        }
        eqAuctionEnroll.setGmtModified(this.getSysDate());
    }

    private void saveAuctionEnrollModel(EqAuctionEnroll eqAuctionEnroll) throws ApiException {
        if (null == eqAuctionEnroll) {
            return;
        }
        try {
            this.eqAuctionEnrollMapper.insert(eqAuctionEnroll);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.saveAuctionEnrollModel.ex", (Throwable)e);
        }
    }

    private void saveAuctionEnrollBatchModel(List<EqAuctionEnroll> eqAuctionEnrollList) throws ApiException {
        if (null == eqAuctionEnrollList || eqAuctionEnrollList.isEmpty()) {
            return;
        }
        try {
            this.eqAuctionEnrollMapper.insertBatch(eqAuctionEnrollList);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.saveAuctionEnrollBatchModel.ex", (Throwable)e);
        }
    }

    private EqAuctionEnroll getAuctionEnrollModelById(Integer auctionEnrollId) {
        if (null == auctionEnrollId) {
            return null;
        }
        try {
            return this.eqAuctionEnrollMapper.selectByPrimaryKey(auctionEnrollId);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionEnrollServiceImpl.getAuctionEnrollModelById", (Throwable)e);
            return null;
        }
    }

    private EqAuctionEnroll getAuctionEnrollModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.eqAuctionEnrollMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionEnrollServiceImpl.getAuctionEnrollModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAuctionEnrollModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionEnrollMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.delAuctionEnrollModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.delAuctionEnrollModelByCode.num");
        }
    }

    private void deleteAuctionEnrollModel(Integer auctionEnrollId) throws ApiException {
        if (null == auctionEnrollId) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionEnrollMapper.deleteByPrimaryKey(auctionEnrollId);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.deleteAuctionEnrollModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.deleteAuctionEnrollModel.num");
        }
    }

    private void updateAuctionEnrollModel(EqAuctionEnroll eqAuctionEnroll) throws ApiException {
        if (null == eqAuctionEnroll) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionEnrollMapper.updateByPrimaryKey(eqAuctionEnroll);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.updateAuctionEnrollModel.ex", (Throwable)e);
        }
    }

    private void updateStateAuctionEnrollModel(Integer auctionEnrollId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionEnrollId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionEnrollId", auctionEnrollId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionEnrollMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.updateStateAuctionEnrollModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.updateStateAuctionEnrollModel.null");
        }
    }

    private void updateStateAuctionEnrollModelByCode(String tenantCode, String auctionEnrollCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionEnrollCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionEnrollCode", auctionEnrollCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionEnrollMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.updateStateAuctionEnrollModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.updateStateAuctionEnrollModelByCode.null");
        }
    }

    private EqAuctionEnroll makeAuctionEnroll(EqAuctionEnrollDomain eqAuctionEnrollDomain, EqAuctionEnroll eqAuctionEnroll) {
        if (null == eqAuctionEnrollDomain) {
            return null;
        }
        if (null == eqAuctionEnroll) {
            eqAuctionEnroll = new EqAuctionEnroll();
        }
        try {
            BeanUtils.copyAllPropertys((Object)eqAuctionEnroll, (Object)eqAuctionEnrollDomain);
            return eqAuctionEnroll;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionEnrollServiceImpl.makeAuctionEnroll", (Throwable)e);
            return null;
        }
    }

    private EqAuctionEnrollReDomain makeEqAuctionEnrollReDomain(EqAuctionEnroll eqAuctionEnroll) {
        if (null == eqAuctionEnroll) {
            return null;
        }
        EqAuctionEnrollReDomain eqAuctionEnrollReDomain = new EqAuctionEnrollReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)eqAuctionEnrollReDomain, (Object)eqAuctionEnroll);
            return eqAuctionEnrollReDomain;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionEnrollServiceImpl.makeEqAuctionEnrollReDomain", (Throwable)e);
            return null;
        }
    }

    private List<EqAuctionEnroll> queryAuctionEnrollModelPage(Map<String, Object> parammap) {
        try {
            List<EqAuctionEnroll> eqAuctionEnroll = this.eqAuctionEnrollMapper.query(parammap);
            return eqAuctionEnroll;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionEnrollServiceImpl.queryAuctionEnrollModel", (Throwable)e);
            return null;
        }
    }

    private int countAuctionEnroll(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.eqAuctionEnrollMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionEnrollServiceImpl.countAuctionEnroll", (Throwable)e);
        }
        return i;
    }

    private EqAuctionEnroll createEqAuctionEnrollRe(EqAuctionEnrollReDomain eqAuctionEnrollDomain) {
        this.logger.error(".createEqAuctionEnroll", (Object)eqAuctionEnrollDomain.getMemberCcode());
        String msg = this.checkAuctionEnroll(eqAuctionEnrollDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.saveAuctionEnroll.checkAuctionEnroll", msg);
        }
        EqAuctionEnroll eqAuctionEnroll = this.makeAuctionEnroll(eqAuctionEnrollDomain, null);
        this.setAuctionEnrollDefault(eqAuctionEnroll);
        return eqAuctionEnroll;
    }

    private EqAuctionEnroll createEqAuctionEnroll(EqAuctionEnrollDomain eqAuctionEnrollDomain) {
        this.logger.error(".createEqAuctionEnroll", (Object)eqAuctionEnrollDomain.getMemberCcode());
        String msg = this.checkAuctionEnroll(eqAuctionEnrollDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.saveAuctionEnroll.checkAuctionEnroll", msg);
        }
        EqAuctionEnroll eqAuctionEnroll = this.makeAuctionEnroll(eqAuctionEnrollDomain, null);
        this.setAuctionEnrollDefault(eqAuctionEnroll);
        return eqAuctionEnroll;
    }

    @Override
    public String saveAuctionEnroll1(EqAuctionEnrollReDomain eqAuctionEnrollReDomain) throws ApiException {
        EqAuctionEnroll eqAuctionEnroll = this.createEqAuctionEnrollRe(eqAuctionEnrollReDomain);
        this.saveAuctionEnrollModel(eqAuctionEnroll);
        return eqAuctionEnroll.getAuctionEnrollCode();
    }

    @Override
    public HtmlJsonReBean createAuctionEnroll(EqAuctionEnrollReDomain eqAuctionEnrollReDomain) throws ApiException {
        if (eqAuctionEnrollReDomain == null) {
            return new HtmlJsonReBean("error", "param eqAuctionEnrollReDomain is required but null");
        }
        HtmlJsonReBean result = new HtmlJsonReBean();
        EqAuctionEnroll eqAuctionEnroll = this.createEqAuctionEnrollRe(eqAuctionEnrollReDomain);
        this.saveAuctionEnrollModel(eqAuctionEnroll);
        if (ListUtil.isNotEmpty(eqAuctionEnrollReDomain.getEqAuctionGoodsDomainList())) {
            List<EqAuctionGoodsDomain> goodsList = eqAuctionEnrollReDomain.getEqAuctionGoodsDomainList();
            for (int i = 0; i < goodsList.size(); ++i) {
                goodsList.get(i).setTenantCode(eqAuctionEnroll.getTenantCode());
                goodsList.get(i).setAuctionEnrollCode(eqAuctionEnroll.getAuctionEnrollCode());
                goodsList.get(i).setAuctionCode(eqAuctionEnroll.getAuctionCode());
                goodsList.get(i).setMemberCode(eqAuctionEnroll.getMemberCode());
                goodsList.get(i).setMemberName(eqAuctionEnroll.getMemberName());
                goodsList.get(i).setMemberCcode(eqAuctionEnroll.getMemberCcode());
                goodsList.get(i).setMemberCname(eqAuctionEnroll.getMemberCname());
            }
            if (ListUtil.isNotEmpty(goodsList)) {
                String s = this.eqAuctionGoodsService.saveAuctionGoodsBatch(goodsList);
                result.putMsg("saveAuctionGoodsBatch_result", s);
                this.logger.error("EqAuctionEnrollServiceImpl.goodsList", (Object)JsonUtil.buildNormalBinder().toJson(goodsList));
            }
        }
        return result;
    }

    @Override
    public String saveAuctionEnroll(EqAuctionEnrollReDomain eqAuctionEnrollReDomain) throws ApiException {
        this.logger.error(".saveAuctionEnroll", (Object)eqAuctionEnrollReDomain.getMemberCcode());
        EqAuctionEnroll eqAuctionEnroll = this.createEqAuctionEnrollRe(eqAuctionEnrollReDomain);
        this.logger.error(".eqAuctionEnroll", (Object)eqAuctionEnroll.getDataOpbillstate());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userinfoQuaKey", "userinfoAreaName");
        param.put("userinfoCode", eqAuctionEnrollReDomain.getMemberCcode());
        param.put("tenantCode", eqAuctionEnrollReDomain.getTenantCode());
        List quaList = this.umUserinfoQuaMapper.query(param);
        for (UmUserinfoQua um : quaList) {
            eqAuctionEnroll.setMemberCarea(um.getUserinfoQuaVaule());
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("tenantCode", eqAuctionEnroll.getTenantCode());
        map1.put("auctionCode", eqAuctionEnroll.getAuctionCode());
        EqAuction auctionByCode = this.eqAuctionMapper.getByCode(map1);
        boolean deleteFlag = true;
        HashMap<String, Object> eqUserMap = new HashMap<String, Object>();
        eqUserMap.put("tenantCode", eqAuctionEnroll.getTenantCode());
        eqUserMap.put("auctionCode", eqAuctionEnroll.getAuctionCode());
        eqUserMap.put("memberCcode", eqAuctionEnrollReDomain.getMemberCcode());
        eqUserMap.put("dataOpbillstate", 0);
        this.logger.error("eq.EqAuctionEnrollServiceImpl.eqUserMap", eqUserMap);
        List<EqAuctionEnroll> eqAuctionEnrollsUser = this.queryAuctionEnrollModelPage(eqUserMap);
        if (auctionByCode.getMemberCappoint().equals("1") && ListUtil.isNotEmpty(eqAuctionEnrollsUser)) {
            EqAuctionEnroll enroll = eqAuctionEnrollsUser.get(0);
            try {
                BeanUtils.copyAllPropertysNotNull((Object)enroll, (Object)eqAuctionEnroll);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            enroll.setDataOpbillstate(1);
            this.logger.error("eq.EqAuctionEnrollServiceImpl.enroll", (Object)JsonUtil.buildNormalBinder().toJson((Object)enroll));
            this.updateAuctionEnrollModel(enroll);
        } else {
            eqAuctionEnroll.setDataOpbillstate(1);
            this.logger.error("eq.EqAuctionEnrollServiceImpl.eqAuctionEnroll", (Object)JsonUtil.buildNormalBinder().toJson((Object)eqAuctionEnroll));
            this.saveAuctionEnrollModel(eqAuctionEnroll);
            deleteFlag = false;
        }
        HashMap<String, Object> eqMap = new HashMap<String, Object>();
        eqMap.put("auctionCode", eqAuctionEnroll.getAuctionCode());
        eqMap.put("tenantCode", eqAuctionEnroll.getTenantCode());
        eqMap.put("dataOpbillstate", 1);
        eqMap.put("fuzzy", false);
        this.logger.error("eq.EqAuctionEnrollServiceImpl.eqMap", eqMap);
        List<EqAuctionEnroll> eqAuctionEnrolls = this.queryAuctionEnrollModelPage(eqMap);
        this.logger.error("eq.EqAuctionEnrollServiceImpl.\u6392\u5e8f\u524d:\u62a5\u4ef7", (Object)JsonUtil.buildNormalBinder().toJson(eqAuctionEnrolls));
        if (eqAuctionEnrolls != null && eqAuctionEnrolls.size() > 0) {
            Collections.sort(eqAuctionEnrolls, new Comparator<EqAuctionEnroll>(){

                @Override
                public int compare(EqAuctionEnroll o1, EqAuctionEnroll o2) {
                    return o1.getAuctionPriceAmount().compareTo(o2.getAuctionPriceAmount());
                }
            });
            this.logger.error("eq.EqAuctionEnrollServiceImpl.\u6392\u5e8f\u540e:\u62a5\u4ef7", (Object)JsonUtil.buildNormalBinder().toJson(eqAuctionEnrolls));
            DisUtil.setMapVer((String)EQ_AUCTION_PRICE_SORT, (String)(eqAuctionEnroll.getAuctionCode() + "-" + eqAuctionEnroll.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(eqAuctionEnrolls));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionCode", eqAuctionEnroll.getAuctionCode());
        map.put("memberCcode", eqAuctionEnroll.getMemberCcode());
        map.put("TenantCode", eqAuctionEnroll.getTenantCode());
        QueryResult<EqAuctionEnrollfile> fileQueryResult = this.eqAuctionEnrollfileService.queryAuctionEnrollfilePage(map);
        if (deleteFlag && fileQueryResult != null && !fileQueryResult.getList().isEmpty()) {
            for (EqAuctionEnrollfile f : fileQueryResult.getList()) {
                this.eqAuctionEnrollfileService.deleteAuctionEnrollfile(f.getAuctionEnrollfileId());
            }
        }
        if (ListUtil.isNotEmpty(eqAuctionEnrollReDomain.getEqAuctionEnrollfileDomainList())) {
            List<EqAuctionEnrollfileDomain> enrollfileList = eqAuctionEnrollReDomain.getEqAuctionEnrollfileDomainList();
            for (int i = 0; i < enrollfileList.size(); ++i) {
                enrollfileList.get(i).setTenantCode(eqAuctionEnroll.getTenantCode());
                enrollfileList.get(i).setAuctionEnrollCode(eqAuctionEnroll.getAuctionEnrollCode());
                enrollfileList.get(i).setAuctionCode(eqAuctionEnroll.getAuctionCode());
                enrollfileList.get(i).setMemberCode(eqAuctionEnroll.getMemberCode());
                enrollfileList.get(i).setMemberName(eqAuctionEnroll.getMemberName());
                enrollfileList.get(i).setMemberCcode(eqAuctionEnroll.getMemberCcode());
                enrollfileList.get(i).setMemberCname(eqAuctionEnroll.getMemberCname());
            }
            if (ListUtil.isNotEmpty(enrollfileList)) {
                this.eqAuctionEnrollfileService.saveAuctionEnrollfileBatch(enrollfileList);
            }
        }
        QueryResult<EqAuctionGoods> goodsQueryResult = this.eqAuctionGoodsService.queryAuctionGoodsPage(map);
        if (deleteFlag && goodsQueryResult != null && !goodsQueryResult.getList().isEmpty()) {
            for (EqAuctionGoods g : goodsQueryResult.getList()) {
                this.eqAuctionGoodsService.deleteAuctionGoods(g.getAuctionGoodsId());
            }
        }
        if (ListUtil.isNotEmpty(eqAuctionEnrollReDomain.getEqAuctionGoodsDomainList())) {
            List<EqAuctionGoodsDomain> goodsList = eqAuctionEnrollReDomain.getEqAuctionGoodsDomainList();
            for (int i = 0; i < goodsList.size(); ++i) {
                goodsList.get(i).setTenantCode(eqAuctionEnroll.getTenantCode());
                goodsList.get(i).setAuctionEnrollCode(eqAuctionEnroll.getAuctionEnrollCode());
                goodsList.get(i).setAuctionCode(eqAuctionEnroll.getAuctionCode());
                goodsList.get(i).setMemberCode(eqAuctionEnroll.getMemberCode());
                goodsList.get(i).setMemberName(eqAuctionEnroll.getMemberName());
                goodsList.get(i).setMemberCcode(eqAuctionEnroll.getMemberCcode());
                goodsList.get(i).setMemberCname(eqAuctionEnroll.getMemberCname());
            }
            if (ListUtil.isNotEmpty(goodsList)) {
                this.eqAuctionGoodsService.saveAuctionGoodsBatch(goodsList);
                this.logger.error("EqAuctionEnrollServiceImpl.goodsList", (Object)JsonUtil.buildNormalBinder().toJson(goodsList));
            }
        }
        return eqAuctionEnroll.getAuctionEnrollCode();
    }

    @Override
    public String saveAuctionEnrollBatch(List<EqAuctionEnrollDomain> eqAuctionEnrollDomainList) throws ApiException {
        if (null == eqAuctionEnrollDomainList || eqAuctionEnrollDomainList.isEmpty()) {
            return null;
        }
        ArrayList<EqAuctionEnroll> eqAuctionEnrollList = new ArrayList<EqAuctionEnroll>();
        String code = "";
        for (EqAuctionEnrollDomain eqAuctionEnrollDomain : eqAuctionEnrollDomainList) {
            EqAuctionEnroll eqAuctionEnroll = this.createEqAuctionEnroll(eqAuctionEnrollDomain);
            code = eqAuctionEnroll.getAuctionEnrollCode();
            eqAuctionEnrollList.add(eqAuctionEnroll);
        }
        this.saveAuctionEnrollBatchModel(eqAuctionEnrollList);
        return code;
    }

    @Override
    public void updateAuctionEnrollState(Integer auctionEnrollId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == auctionEnrollId) {
            return;
        }
        this.updateStateAuctionEnrollModel(auctionEnrollId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionEnrollStateByCode(String tenantCode, String auctionEnrollCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)auctionEnrollCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAuctionEnrollModelByCode(tenantCode, auctionEnrollCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionEnroll(EqAuctionEnrollDomain eqAuctionEnrollDomain) throws ApiException {
        String msg = this.checkAuctionEnroll(eqAuctionEnrollDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.updateAuctionEnroll.checkAuctionEnroll", msg);
        }
        EqAuctionEnroll oldEqAuctionEnroll = this.getAuctionEnrollModelById(eqAuctionEnrollDomain.getAuctionEnrollId());
        if (null == oldEqAuctionEnroll) {
            throw new ApiException("eq.EqAuctionEnrollServiceImpl.updateAuctionEnroll.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EqAuctionEnroll eqAuctionEnroll = this.makeAuctionEnroll(eqAuctionEnrollDomain, oldEqAuctionEnroll);
        this.setAuctionEnrollUpdataDefault(eqAuctionEnroll);
        this.updateAuctionEnrollModel(eqAuctionEnroll);
    }

    @Override
    public EqAuctionEnroll getAuctionEnroll(Integer auctionEnrollId) {
        if (null == auctionEnrollId) {
            return null;
        }
        return this.getAuctionEnrollModelById(auctionEnrollId);
    }

    @Override
    public void deleteAuctionEnroll(Integer auctionEnrollId) throws ApiException {
        QueryResult<EqAuctionGoods> goodsList;
        if (null == auctionEnrollId) {
            return;
        }
        this.deleteAuctionEnrollModel(auctionEnrollId);
        EqAuctionEnroll auctionEnroll = this.getAuctionEnroll(auctionEnrollId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionEnrollCode", auctionEnroll.getAuctionEnrollCode());
        map.put("tenantCode", auctionEnroll.getTenantCode());
        QueryResult<EqAuctionEnrollfile> fileList = this.eqAuctionEnrollfileService.queryAuctionEnrollfilePage(map);
        if (fileList != null && !fileList.getList().isEmpty()) {
            for (EqAuctionEnrollfile file : fileList.getList()) {
                this.eqAuctionEnrollfileService.deleteAuctionEnrollfile(file.getAuctionEnrollfileId());
            }
        }
        if ((goodsList = this.eqAuctionGoodsService.queryAuctionGoodsPage(map)) != null && !goodsList.getList().isEmpty()) {
            for (EqAuctionGoods file : goodsList.getList()) {
                this.eqAuctionGoodsService.deleteAuctionGoods(file.getAuctionGoodsId());
            }
        }
    }

    @Override
    public QueryResult<EqAuctionEnroll> queryAuctionEnrollPage(Map<String, Object> map) {
        List<EqAuctionEnroll> eqAuctionEnrollList = this.queryAuctionEnrollModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuctionEnroll(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(eqAuctionEnrollList);
        return queryResult;
    }

    @Override
    public EqAuctionEnroll getAuctionEnrollByCode(String tenantCode, String auctionEnrollCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionEnrollCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionEnrollCode", auctionEnrollCode);
        return this.getAuctionEnrollModelByCode(map);
    }

    @Override
    public void deleteAuctionEnrollByCode(String tenantCode, String auctionEnrollCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionEnrollCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionEnrollCode", auctionEnrollCode);
        this.delAuctionEnrollModelByCode(map);
    }
}

