/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppwarDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AppwarUpdateDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwar;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwarJar;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppRegisterService;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppwarService;
import com.yqbsoft.laser.service.esb.appmanage.service.AppmanageService;
import com.yqbsoft.laser.service.esb.appmanage.thread.RgThread;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class AmAppRegisterServiceImpl
extends BaseServiceImpl
implements AmAppRegisterService {
    private static final String SYS_CODE = "am.ESB.APPMANAGE.AmAppRegisterServiceImpl";
    private AmAppwarService amAppwarService;
    AppmanageService appmanageService;
    public static Map<String, RgThread> rgMap = new ConcurrentHashMap<String, RgThread>();
    private static String cache = "AmAppwar-jar";
    private static String cachewar = "AmAppwar-icode";
    private static String APPMANAGE_KEY = "Appmanage-key-line";
    @Autowired
    RegeditUtil regeditUtil;
    public static final Long REGEDIT_OVER_TIME = 30000L;

    public void setAppmanageService(AppmanageService appmanageService) {
        this.appmanageService = appmanageService;
    }

    public AmAppwarService getAmAppwarService() {
        return this.amAppwarService;
    }

    public void setAmAppwarService(AmAppwarService amAppwarService) {
        this.amAppwarService = amAppwarService;
    }

    private String getNowJobKey() {
        String appmanagerKey = ServletMain.getAppKey();
        String jobkey = "";
        if (StringUtils.isNotBlank((String)jobkey) && null != this.regeditUtil.getRegeditBeanOne(ServletMain.getAppName(), jobkey)) {
            return jobkey;
        }
        String cacheKey = "apprg_mainkey";
        jobkey = DisUtil.getRemot((String)cacheKey);
        if (StringUtils.isNotBlank((String)jobkey) && null != this.regeditUtil.getRegeditBeanOne(ServletMain.getAppName(), jobkey)) {
            return jobkey;
        }
        DisUtil.set((String)cacheKey, (String)appmanagerKey);
        jobkey = DisUtil.getRemot((String)cacheKey);
        if (StringUtils.isNotBlank((String)jobkey) && null != this.regeditUtil.getRegeditBeanOne(ServletMain.getAppName(), jobkey)) {
            return jobkey;
        }
        this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.getNowJobKey.appmanagerKey-jobkey", (Object)(jobkey + "=" + appmanagerKey));
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveCacheToAppwar() {
        try {
            AmAppRegisterServiceImpl amAppRegisterServiceImpl = this;
            synchronized (amAppRegisterServiceImpl) {
                RgThread rgThread;
                String jobkey = this.getNowJobKey();
                String appmanagerKey = ServletMain.getAppKey();
                if (!appmanagerKey.equals(jobkey)) {
                    if (MapUtil.isNotEmpty(rgMap)) {
                        for (String key : rgMap.keySet()) {
                            rgMap.remove(key).stop();
                        }
                    }
                    this.logger.info("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.saveCacheToAppwar.no", (Object)(jobkey + "=" + appmanagerKey));
                    return;
                }
                HashMap<String, String> keyMap = new HashMap<String, String>();
                Map appMap = DisUtil.getRemotMapAll((String)"EcoreAppmanage-lineInfo");
                Map warkeyMap = DisUtil.getRemotMapAll((String)"EcoreAppwar-pro");
                AmAppRegisterService amAppRegisterService = (AmAppRegisterService)SpringApplicationContextUtil.getBean((String)"amAppRegisterService");
                if (MapUtil.isNotEmpty((Map)appMap)) {
                    for (String key : appMap.keySet()) {
                        RegeditBean regeditBean;
                        keyMap.put(key, key);
                        if (rgMap.containsKey(key) || null == (regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject((String)appMap.get(key), RegeditBean.class))) continue;
                        rgThread = new RgThread(amAppRegisterService, regeditBean.getAppIcode(), key);
                        rgMap.put(key, rgThread);
                        rgThread.start();
                    }
                }
                if (MapUtil.isNotEmpty((Map)warkeyMap)) {
                    for (String key : warkeyMap.keySet()) {
                        AmAppwar amAppwar;
                        keyMap.put(key, key);
                        if (rgMap.containsKey(key) || null == (amAppwar = (AmAppwar)JsonUtil.buildNormalBinder().getJsonToObject((String)warkeyMap.get(key), AmAppwar.class)) || !"0".equals(amAppwar.getAppwarApptype()) && !"1".equals(amAppwar.getAppwarApptype())) continue;
                        rgThread = new RgThread(amAppRegisterService, amAppwar.getAppwarIcode(), key);
                        rgMap.put(key, rgThread);
                        rgThread.start();
                    }
                }
                for (String key : rgMap.keySet()) {
                    if (!keyMap.containsKey(key)) {
                        rgMap.remove(key).stop();
                        continue;
                    }
                    this.logger.info("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.queryCacheToAppwar.key", (Object)key);
                }
                this.logger.info("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.queryCacheToAppwar.info", (Object)rgMap.size());
            }
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.queryCacheToAppwar.e", (Object)"", (Throwable)e);
        }
    }

    public List<RegeditBean> getPointAppKeys(String appmanageIcode) {
        if (StringUtils.isBlank((String)appmanageIcode)) {
            return null;
        }
        return this.regeditUtil.getRegeditBeanList(appmanageIcode);
    }

    private void setNgCache(RegeditBean regeditBean, String tenantCode) {
        String listStr;
        if (null == regeditBean) {
            return;
        }
        String type = regeditBean.getApptype();
        if (StringUtils.isBlank((String)type)) {
            type = "1";
        }
        if (StringUtils.isBlank((String)(listStr = DisUtil.getRemotMap((String)cache, (String)(regeditBean.getAppIcode() + "-" + type + "-" + tenantCode))))) {
            return;
        }
        List jarList = (List)JsonUtil.buildNormalBinder().getJsonToList(listStr, AmAppwarJar.class);
        if (null == jarList || jarList.isEmpty()) {
            return;
        }
        List<RegeditBean> list = this.getPointAppKeys(regeditBean.getAppIcode());
        String url = "";
        if (ListUtil.isNotEmpty(list)) {
            String purl = "";
            for (RegeditBean regeditBean1 : list) {
                if (!StringUtils.isNotBlank((String)regeditBean1.getAppIp())) continue;
                if (StringUtils.isNotBlank((String)purl)) {
                    purl = purl + ",";
                }
                purl = purl + regeditBean1.getAppIp() + ":" + regeditBean1.getAppPort() + (StringUtils.isNotBlank((String)regeditBean1.getContextPath()) ? "/" + regeditBean1.getContextPath() : "");
            }
            if (StringUtils.isNotBlank((String)purl)) {
                url = purl;
            }
        }
        for (AmAppwarJar amAppwarJar : jarList) {
            String key = amAppwarJar.getAppmanageIcode();
            if (StringUtils.isBlank((String)key) || key.indexOf(".") < 0) continue;
            key = "/" + key.replace(".", "/");
            if (StringUtils.isBlank((String)url)) {
                DisUtil.del((String)key);
                continue;
            }
            DisUtil.set((String)key, (String)url);
        }
    }

    private void setNgPcodeCache(RegeditBean regeditBean, String tenantCode) {
        String listStr;
        if (null == regeditBean) {
            return;
        }
        String type = regeditBean.getApptype();
        if (StringUtils.isBlank((String)type)) {
            type = "1";
        }
        if (StringUtils.isBlank((String)(listStr = DisUtil.getRemotMap((String)cachewar, (String)(regeditBean.getAppIcode() + "-" + tenantCode))))) {
            return;
        }
        List warList = (List)JsonUtil.buildNormalBinder().getJsonToList(listStr, AmAppwar.class);
        if (null == warList || warList.isEmpty()) {
            return;
        }
        List<RegeditBean> list = this.getPointAppKeys(regeditBean.getAppIcode());
        String url = "";
        if (ListUtil.isNotEmpty(list)) {
            String purl = "";
            for (RegeditBean regeditBean1 : list) {
                if (!StringUtils.isNotBlank((String)regeditBean1.getAppIp())) continue;
                if (StringUtils.isNotBlank((String)purl)) {
                    purl = purl + ",";
                }
                purl = purl + regeditBean1.getAppIp() + ":" + regeditBean1.getAppPort() + (StringUtils.isNotBlank((String)regeditBean1.getContextPath()) ? "/" + regeditBean1.getContextPath() : "");
            }
            if (StringUtils.isNotBlank((String)purl)) {
                url = purl;
            }
        }
        for (AmAppwar amAppwar : warList) {
            String key = amAppwar.getAppwarIcode();
            key = "/" + key;
            if (StringUtils.isBlank((String)url)) {
                DisUtil.del((String)key);
                continue;
            }
            DisUtil.set((String)key, (String)url);
        }
    }

    private boolean checkAppicode(String appICode) {
        if (StringUtils.isBlank((String)appICode)) {
            return true;
        }
        Map appPropertyMap = DisUtil.getRemotMapByListJson((String)"EcoreAppmanage-pro", String.class, AppProperty.class);
        if (MapUtil.isEmpty((Map)appPropertyMap)) {
            return false;
        }
        return null != appPropertyMap.get(appICode) && !ListUtil.isEmpty((Collection)((Collection)appPropertyMap.get(appICode)));
    }

    @Override
    public boolean testAppwar(String appwarAppicode, String appwarAppkey) {
        if (StringUtils.isBlank((String)appwarAppkey) || StringUtils.isBlank((String)appwarAppicode)) {
            return true;
        }
        this.logger.debug("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.testAppwar.start", (Object)(appwarAppicode + "=" + appwarAppkey));
        String appwarjson = DisUtil.getRemotMap((String)"EcoreAppwar-pro", (String)appwarAppkey);
        AmAppwar amAppwar = (AmAppwar)JsonUtil.buildNormalBinder().getJsonToObject(appwarjson, AmAppwar.class);
        RegeditBean regeditBean = this.regeditUtil.getRegeditBeanOne(appwarAppicode, appwarAppkey);
        if (StringUtils.isBlank((String)appwarjson) && null == regeditBean) {
            this.logger.debug("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.testAppwar.null.end", (Object)(appwarAppicode + "=" + appwarAppkey));
            DisUtil.delMap((String)"EcoreAppmanage-lineInfo", (String[])new String[]{appwarAppkey});
            DisUtil.delMap((String)APPMANAGE_KEY, (String[])new String[]{appwarAppkey});
            DisUtil.delMap((String)"EcoreAppmanage-line", (String[])new String[]{appwarAppkey});
            DisUtil.delMap((String)"EcoreAppwar-pro", (String[])new String[]{appwarAppkey});
            return false;
        }
        if (StringUtils.isBlank((String)appwarjson) && null != regeditBean) {
            this.insertAppwar(regeditBean);
            this.setNgCache(regeditBean, "00000000");
            this.setNgPcodeCache(regeditBean, "00000000");
            this.logger.debug("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.testAppwar.insert.end", (Object)(appwarAppicode + "=" + appwarAppkey));
            return true;
        }
        if (null != regeditBean) {
            this.updateAppwar(amAppwar, regeditBean);
            this.setNgCache(regeditBean, amAppwar.getTenantCode());
            this.setNgPcodeCache(regeditBean, amAppwar.getTenantCode());
        } else if (!("2".equals(amAppwar.getAppwarType()) || "laser".equals(appwarAppkey) || "com-mq".equals(appwarAppkey))) {
            DisUtil.delMap((String)"EcoreAppmanage-lineInfo", (String[])new String[]{appwarAppkey});
            DisUtil.delMap((String)APPMANAGE_KEY, (String[])new String[]{appwarAppkey});
            DisUtil.delMap((String)"EcoreAppmanage-line", (String[])new String[]{appwarAppkey});
            DisUtil.delMap((String)"EcoreAppwar-pro", (String[])new String[]{appwarAppkey});
            try {
                this.amAppwarService.delAppwarByCode(this.getQueryMapParam("appwarAppkey,tenantCode", new Object[]{appwarAppkey, "00000000"}));
                this.logger.debug("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.testAppwar.del.end", (Object)(appwarAppicode + "=" + appwarAppkey));
                return false;
            }
            catch (Exception e) {
                this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.testAppwar.e", (Object)(appwarAppkey + "=" + "00000000"));
            }
        }
        this.logger.debug("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.testAppwar.end", (Object)(appwarAppicode + "=" + appwarAppkey));
        return true;
    }

    private void insertAppwar(RegeditBean regeditBean) {
        if (null == regeditBean) {
            return;
        }
        AmAppwarDomain amAppwarDomain = new AmAppwarDomain();
        amAppwarDomain.setAppwarAppkey(regeditBean.getAppkey());
        amAppwarDomain.setAppwarApptype(regeditBean.getApptype());
        amAppwarDomain.setAppwarFwtype("0");
        amAppwarDomain.setAppwarIcode(regeditBean.getAppIcode());
        amAppwarDomain.setAppwarName(regeditBean.getAppIcode());
        amAppwarDomain.setAppwarType(regeditBean.getApptype());
        if (StringUtils.isBlank((String)amAppwarDomain.getAppwarType())) {
            if (regeditBean.getAppIcode().indexOf("con") == 0) {
                amAppwarDomain.setAppwarType("1");
            } else {
                amAppwarDomain.setAppwarType("0");
            }
        }
        if (StringUtils.isBlank((String)regeditBean.getRouterDir())) {
            regeditBean.setRouterDir("0");
        }
        amAppwarDomain.setRouterDire(Integer.valueOf(regeditBean.getRouterDir()));
        amAppwarDomain.setAppwarUuid(regeditBean.getAppUuid());
        amAppwarDomain.setAppwarIp(regeditBean.getAppIp());
        amAppwarDomain.setAppwarVirip(regeditBean.getAppVirIp());
        amAppwarDomain.setAppwarPort(regeditBean.getAppPort());
        amAppwarDomain.setAppwarContext(regeditBean.getContextPath());
        amAppwarDomain.setAppwarDomain("http://" + regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + "/" + regeditBean.getContextPath());
        amAppwarDomain.setTenantCode("00000000");
        amAppwarDomain.setDataStateOld(0);
        this.amAppwarService.saveAppwar(amAppwarDomain);
        this.appmanageService.queryAppmanageLoadCache();
    }

    private boolean delAppCache(RegeditBean regeditBean, String tenantCode) {
        if (null == regeditBean) {
            return false;
        }
        String appkey = regeditBean.getAppkey();
        if ("laser".equals(appkey) || "com-mq".equals(appkey)) {
            return false;
        }
        this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.delAppCache.cache", (Object)(regeditBean.getAppkey() + "=" + DateUtil.getDateString((Date)regeditBean.getLastDate(), (String)"yyyy-MM-dd HH:mm:ss")));
        DisUtil.delMap((String)"EcoreAppmanage-lineInfo", (String[])new String[]{regeditBean.getAppkey()});
        DisUtil.delMap((String)APPMANAGE_KEY, (String[])new String[]{regeditBean.getAppkey()});
        DisUtil.delMap((String)"EcoreAppmanage-line", (String[])new String[]{regeditBean.getAppkey()});
        DisUtil.delMap((String)"EcoreAppwar-pro", (String[])new String[]{regeditBean.getAppkey()});
        try {
            this.amAppwarService.delAppwarByCode(this.getQueryMapParam("appwarAppkey,tenantCode", new Object[]{regeditBean.getAppkey(), tenantCode}));
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.delAppCache.e", (Object)(regeditBean.getAppkey() + "=" + tenantCode));
        }
        return true;
    }

    private void updateAppwaruuid(AmAppwar amAppwar, AppwarUpdateDomain appwarUpdateDomain) {
        if (null == appwarUpdateDomain || null == amAppwar) {
            return;
        }
        if (null == appwarUpdateDomain.getDataStateOld()) {
            appwarUpdateDomain.setDataStateOld(0);
        }
        amAppwar.setAppwarIp(appwarUpdateDomain.getAppwarIp());
        amAppwar.setAppwarDomain(appwarUpdateDomain.getAppwarDomain());
        amAppwar.setAppwarUuid(appwarUpdateDomain.getAppwarUuid());
        amAppwar.setDataStateOld(appwarUpdateDomain.getDataStateOld());
        amAppwar.setAppwarPort(appwarUpdateDomain.getAppwarPort());
        amAppwar.setAppwarContext(appwarUpdateDomain.getAppwarContext());
        amAppwar.setRouterDire(appwarUpdateDomain.getRouterDire());
        amAppwar.setDataState(1);
        this.amAppwarService.updateAppwaruuid(appwarUpdateDomain);
        if (!this.checkAppicode(amAppwar.getAppwarIcode())) {
            this.appmanageService.queryAppmanageLoadCache();
        }
    }

    private void updateAppwar(AmAppwar amAppwar, RegeditBean regeditBean) {
        if (null == amAppwar || null == regeditBean) {
            return;
        }
        AppwarUpdateDomain appwarUpdateDomain = new AppwarUpdateDomain();
        appwarUpdateDomain.setAppwarAppkey(amAppwar.getAppwarAppkey());
        appwarUpdateDomain.setTenantCode(amAppwar.getTenantCode());
        appwarUpdateDomain.setAppwarIcode(amAppwar.getAppwarIcode());
        appwarUpdateDomain.setAppwarIp(regeditBean.getAppIp());
        appwarUpdateDomain.setAppwarVirip(regeditBean.getAppVirIp());
        appwarUpdateDomain.setAppwarUuid(regeditBean.getAppUuid());
        appwarUpdateDomain.setAppwarPort(regeditBean.getAppPort());
        appwarUpdateDomain.setAppwarContext(regeditBean.getContextPath());
        appwarUpdateDomain.setAppwarType(regeditBean.getApptype());
        String domain = "http://" + regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + "/" + regeditBean.getContextPath();
        appwarUpdateDomain.setAppwarDomain(domain);
        if (StringUtils.isBlank((String)regeditBean.getRouterDir())) {
            regeditBean.setRouterDir("0");
        }
        appwarUpdateDomain.setRouterDire(Integer.valueOf(regeditBean.getRouterDir()));
        appwarUpdateDomain.setDataStateOld(0);
        if (this.checkHealthy(domain)) {
            appwarUpdateDomain.setDataStateOld(1);
        } else {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.updateAppwar.checkHealthy", (Object)amAppwar.getAppwarAppkey());
        }
        this.updateAppwaruuid(amAppwar, appwarUpdateDomain);
        if (!this.checkAppicode(amAppwar.getAppwarIcode())) {
            this.appmanageService.queryAppmanageLoadCache();
        }
    }

    public static void main(String[] args) {
        String domain = "http://cms-com-job.qjsoft-app-laser-com:8080/";
        String url = domain + "/laserDirect/healthy";
        if ("/".equals(domain.substring(domain.length() - 1))) {
            url = domain + "laserDirect/healthy";
        }
        System.out.println(url);
    }

    private boolean checkHealthy(String domain) {
        if (StringUtils.isBlank((String)domain)) {
            return false;
        }
        String url = domain + "/laserDirect/healthy";
        if ("/".equals(domain.substring(domain.length() - 1))) {
            url = domain + "laserDirect/healthy";
        }
        try {
            String res = WebUtils.doGet((String)url, null);
            if ("ok".equals(res)) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.checkHealthy.e", (Object)(domain + "/laserDirect/healthy"), (Throwable)e);
        }
        return false;
    }
}

