/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppwarProMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppwarProDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppwarProReDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwarJar;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwarPro;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppwarProService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmAppwarProServiceImpl
extends BaseServiceImpl
implements AmAppwarProService {
    private static final String SYS_CODE = "am.ESB.APPMANAGE.AmAppwarProServiceImpl";
    private AmAppwarProMapper amAppwarProMapper;

    public void setAmAppwarProMapper(AmAppwarProMapper amAppwarProMapper) {
        this.amAppwarProMapper = amAppwarProMapper;
    }

    private Date getSysDate() {
        try {
            return this.amAppwarProMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarProServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAppwarPro(AmAppwarProDomain amAppwarProDomain) {
        if (null == amAppwarProDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppwarProDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAppwarProDefault(AmAppwarPro amAppwarPro) {
        if (null == amAppwarPro) {
            return;
        }
        if (null == amAppwarPro.getDataState()) {
            amAppwarPro.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == amAppwarPro.getGmtCreate()) {
            amAppwarPro.setGmtCreate(date);
        }
        amAppwarPro.setGmtModified(date);
        if (StringUtils.isBlank((String)amAppwarPro.getAppwarIcode())) {
            amAppwarPro.setAppwarIcode(this.getNo(null, "AmAppwarPro", "amAppwarPro", amAppwarPro.getTenantCode()));
        }
    }

    private int getAppwarProMaxCode() {
        int code = 0;
        try {
            return this.amAppwarProMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarProServiceImpl.getAppwarProMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAppwarProUpdataDefault(AmAppwarPro amAppwarPro) {
        if (null == amAppwarPro) {
            return;
        }
        amAppwarPro.setGmtModified(this.getSysDate());
    }

    private void saveAppwarProModel(AmAppwarPro amAppwarPro) throws ApiException {
        if (null == amAppwarPro) {
            return;
        }
        try {
            this.amAppwarProMapper.insert(amAppwarPro);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.saveAppwarProModel.ex", (Throwable)e);
        }
    }

    private void saveAppwarProBatchModel(List<AmAppwarPro> amAppwarProList) throws ApiException {
        if (null == amAppwarProList || amAppwarProList.isEmpty()) {
            return;
        }
        try {
            this.amAppwarProMapper.insertBatch(amAppwarProList);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.saveAppwarProBatchModel.ex", (Throwable)e);
        }
    }

    private AmAppwarPro getAppwarProModelById(Integer appwarId) {
        if (null == appwarId) {
            return null;
        }
        try {
            return this.amAppwarProMapper.selectByPrimaryKey(appwarId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarProServiceImpl.getAppwarProModelById", (Throwable)e);
            return null;
        }
    }

    private AmAppwarPro getAppwarProModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amAppwarProMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarProServiceImpl.getAppwarProModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAppwarProModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppwarProMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.delAppwarProModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.delAppwarProModelByCode.num");
        }
    }

    private void deleteAppwarProModel(Integer appwarId) throws ApiException {
        if (null == appwarId) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppwarProMapper.deleteByPrimaryKey(appwarId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.deleteAppwarProModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.deleteAppwarProModel.num");
        }
    }

    private void updateAppwarProModel(AmAppwarPro amAppwarPro) throws ApiException {
        if (null == amAppwarPro) {
            return;
        }
        int i = 0;
        try {
            i = this.amAppwarProMapper.updateByPrimaryKey(amAppwarPro);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.updateAppwarProModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.updateAppwarProModel.num");
        }
    }

    private void updateStateAppwarProModel(Integer appwarId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == appwarId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appwarId", appwarId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amAppwarProMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.updateStateAppwarProModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.updateStateAppwarProModel.null");
        }
    }

    private void updateStateAppwarProModelByCode(String tenantCode, String appwarIcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)appwarIcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("appwarIcode", appwarIcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amAppwarProMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.updateStateAppwarProModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.updateStateAppwarProModelByCode.null");
        }
    }

    private AmAppwarPro makeAppwarPro(AmAppwarProDomain amAppwarProDomain, AmAppwarPro amAppwarPro) {
        if (null == amAppwarProDomain) {
            return null;
        }
        if (null == amAppwarPro) {
            amAppwarPro = new AmAppwarPro();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amAppwarPro, (Object)amAppwarProDomain);
            return amAppwarPro;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarProServiceImpl.makeAppwarPro", (Throwable)e);
            return null;
        }
    }

    private AmAppwarProReDomain makeAmAppwarProReDomain(AmAppwarPro amAppwarPro) {
        if (null == amAppwarPro) {
            return null;
        }
        AmAppwarProReDomain amAppwarProReDomain = new AmAppwarProReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amAppwarProReDomain, (Object)amAppwarPro);
            return amAppwarProReDomain;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarProServiceImpl.makeAmAppwarProReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AmAppwarPro> queryAppwarProModelPage(Map<String, Object> parammap) {
        try {
            return this.amAppwarProMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarProServiceImpl.queryAppwarProModel", (Throwable)e);
            return null;
        }
    }

    private int countAppwarPro(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppwarProMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppwarProServiceImpl.countAppwarPro", (Throwable)e);
        }
        return i;
    }

    private AmAppwarPro createAmAppwarPro(AmAppwarProDomain amAppwarProDomain) {
        String msg = this.checkAppwarPro(amAppwarProDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.saveAppwarPro.checkAppwarPro", msg);
        }
        AmAppwarPro amAppwarPro = this.makeAppwarPro(amAppwarProDomain, null);
        this.setAppwarProDefault(amAppwarPro);
        return amAppwarPro;
    }

    @Override
    public String saveAppwarPro(AmAppwarProDomain amAppwarProDomain) throws ApiException {
        AmAppwarPro amAppwarPro = this.createAmAppwarPro(amAppwarProDomain);
        this.saveAppwarProModel(amAppwarPro);
        return amAppwarPro.getAppwarIcode();
    }

    @Override
    public String saveAppwarProBatch(List<AmAppwarProDomain> amAppwarProDomainList) throws ApiException {
        if (null == amAppwarProDomainList || amAppwarProDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AmAppwarPro> amAppwarProList = new ArrayList<AmAppwarPro>();
        String code = "";
        for (AmAppwarProDomain amAppwarProDomain : amAppwarProDomainList) {
            AmAppwarPro amAppwarPro = this.createAmAppwarPro(amAppwarProDomain);
            code = amAppwarPro.getAppwarIcode();
            amAppwarProList.add(amAppwarPro);
        }
        this.saveAppwarProBatchModel(amAppwarProList);
        return code;
    }

    @Override
    public void updateAppwarProState(Integer appwarId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == appwarId) {
            return;
        }
        this.updateStateAppwarProModel(appwarId, dataState, oldDataState, map);
    }

    @Override
    public void updateAppwarProStateByCode(String tenantCode, String appwarIcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)appwarIcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAppwarProModelByCode(tenantCode, appwarIcode, dataState, oldDataState, map);
    }

    @Override
    public void updateAppwarPro(AmAppwarProDomain amAppwarProDomain) throws ApiException {
        String msg = this.checkAppwarPro(amAppwarProDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.updateAppwarPro.checkAppwarPro", msg);
        }
        AmAppwarPro oldAmAppwarPro = this.getAppwarProModelById(amAppwarProDomain.getAppwarId());
        if (null == oldAmAppwarPro) {
            throw new ApiException("am.ESB.APPMANAGE.AmAppwarProServiceImpl.updateAppwarPro.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmAppwarPro amAppwarPro = this.makeAppwarPro(amAppwarProDomain, oldAmAppwarPro);
        this.setAppwarProUpdataDefault(amAppwarPro);
        this.updateAppwarProModel(amAppwarPro);
    }

    @Override
    public AmAppwarPro getAppwarPro(Integer appwarId) {
        if (null == appwarId) {
            return null;
        }
        return this.getAppwarProModelById(appwarId);
    }

    @Override
    public void deleteAppwarPro(Integer appwarId) throws ApiException {
        if (null == appwarId) {
            return;
        }
        this.deleteAppwarProModel(appwarId);
    }

    @Override
    public QueryResult<AmAppwarPro> queryAppwarProPage(Map<String, Object> map) {
        List<AmAppwarPro> amAppwarProList = this.queryAppwarProModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAppwarPro(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amAppwarProList);
        return queryResult;
    }

    @Override
    public AmAppwarPro getAppwarProByCode(String tenantCode, String appwarIcode) throws ApiException {
        if (StringUtils.isBlank((String)appwarIcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("appwarIcode", appwarIcode);
        return this.getAppwarProModelByCode(map);
    }

    @Override
    public void deleteAppwarProByCode(String tenantCode, String appwarIcode) throws ApiException {
        if (StringUtils.isBlank((String)appwarIcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("appwarIcode", appwarIcode);
        this.delAppwarProModelByCode(map);
    }

    @Override
    public AmAppwarJar getAppwarJarByManagerICode(Map<String, Object> map) {
        return this.getAppwarJarByManagerICode(map);
    }
}

