/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.AppManageConstants;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmPerrorMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmPparamMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmPerrorDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmPparamDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmPerror;
import com.yqbsoft.laser.service.esb.appmanage.model.AmPparam;
import com.yqbsoft.laser.service.esb.appmanage.service.DataparamService;
import com.yqbsoft.laser.service.esb.appmanage.service.PinfoService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.ApiError;
import com.yqbsoft.laser.service.suppercore.transformer.ApiPparam;
import com.yqbsoft.laser.service.suppercore.transformer.Dataparam;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class PinfoServiceImpl
extends BaseServiceImpl
implements PinfoService {
    public static final String SYS_CODE = "am.ESB.APPMANAGE.PinfoServiceImpl";
    private AmPerrorMapper amPerrorMapper;
    private AmPparamMapper amPparamMapper;
    private DataparamService dataparamService;
    private static final String PPARM_PRO = "AmPparam-pro";

    public void setDataparamService(DataparamService dataparamService) {
        this.dataparamService = dataparamService;
    }

    public AmPerrorMapper getAmPerrorMapper() {
        return this.amPerrorMapper;
    }

    public void setAmPerrorMapper(AmPerrorMapper amPerrorMapper) {
        this.amPerrorMapper = amPerrorMapper;
    }

    public AmPparamMapper getAmPparamMapper() {
        return this.amPparamMapper;
    }

    public void setAmPparamMapper(AmPparamMapper amPparamMapper) {
        this.amPparamMapper = amPparamMapper;
    }

    private String check(AmPerror amPerror) {
        if (null == amPerror) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amPerror.getErrorName())) {
            msg = msg + "ErrorName\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(AmPerror amPerror) {
        if (null == amPerror) {
            return;
        }
        if (null == amPerror.getDataState()) {
            amPerror.setDataState(0);
        }
        if (null == amPerror.getGmtCreate()) {
            amPerror.setGmtCreate(this.getSysDate());
        }
    }

    private void savePerrorMode(AmPerror amPerror) throws ApiException {
        if (null == amPerror) {
            return;
        }
        try {
            this.amPerrorMapper.insert(amPerror);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.savePerrorMode.ex");
        }
    }

    private Date getSysDate() {
        try {
            return this.amPerrorMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.PinfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String check(AmPparam amPparam) {
        if (null == amPparam) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amPparam.getAppmanageIcode())) {
            msg = msg + "AppmanageIcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amPparam.getParamName())) {
            msg = msg + "ParamName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amPparam.getParamType())) {
            msg = msg + "ParamType\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(AmPparam amPparam) {
        if (null == amPparam) {
            return;
        }
        if (null == amPparam.getDataState()) {
            amPparam.setDataState(0);
        }
        if (null == amPparam.getGmtCreate()) {
            amPparam.setGmtCreate(this.getSysDate());
        }
    }

    private void savePparamMode(AmPparam amPparam) throws ApiException {
        if (null == amPparam) {
            return;
        }
        try {
            this.amPparamMapper.insert(amPparam);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.savePparamMode.ex");
        }
    }

    private void updateStatePerrorMode(Integer errorId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == errorId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorId", errorId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amPerrorMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updateStatePerrorMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updateStatePerrorMode.null");
        }
    }

    private void updateStatePparamMode(Integer pparamId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == pparamId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pparamId", pparamId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amPparamMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updateStatePparamMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updateStatePparamMode.null");
        }
    }

    private List<AmPerror> queryPerrorMode(Map<String, Object> parammap) {
        try {
            return this.amPerrorMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.PinfoServiceImpl.queryPerrorMode", (Throwable)e);
            return null;
        }
    }

    private List<AmPparam> queryPparamMode(Map<String, Object> parammap) {
        try {
            return this.amPparamMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.PinfoServiceImpl.queryPparamMode", (Throwable)e);
            return null;
        }
    }

    @Override
    public void savePerror(AmPerror amPerror) throws ApiException {
        String msg = this.check(amPerror);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.savePerror.null", msg);
        }
        this.setDefault(amPerror);
        this.savePerrorMode(amPerror);
    }

    @Override
    public void updatePerrorState(Integer errorId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePerrorMode(errorId, dataState, oldDataState);
        this.refreshPerrorCache(this.getPerror(errorId), dataState);
    }

    @Override
    public List<AmPerror> queryPerror(Map<String, Object> map) {
        return this.queryPerrorMode(map);
    }

    @Override
    public void savePparam(AmPparam amPparam) throws ApiException {
        String msg = this.check(amPparam);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.savePparam.null", msg);
        }
        this.setDefault(amPparam);
        this.savePparamMode(amPparam);
    }

    @Override
    public void updatePparamState(Integer pparamId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePparamMode(pparamId, dataState, oldDataState);
        this.refreshParamCache(this.getPparam(pparamId), dataState);
    }

    private void refreshParamCache(AmPparam amPparam, Integer dataState) {
        boolean addflag = dataState == 1;
        Map map = DisUtil.getMapByListJson((String)PPARM_PRO, String.class, ApiPparam.class);
        if (map == null) {
            return;
        }
        if (addflag) {
            Map<String, List<Dataparam>> dataparamMap = this.dataparamService.queryDataparamToMap();
            this.saveParamCache(amPparam, dataparamMap, map);
        } else {
            this.deleteParamCache(amPparam, map);
        }
        DisUtil.setVer((String)PPARM_PRO, (String)JsonUtil.buildNormalBinder().toJson((Object)map));
    }

    private void saveParamCache(AmPparam amPparam, Map<String, List<Dataparam>> dataparamMap, Map<String, List<ApiPparam>> pparamMap) {
        ApiPparam apiPparam = this.makeApiPparam(amPparam, dataparamMap);
        String key = amPparam.getAppmanageIcode() + "-" + amPparam.getParamDire();
        List<ApiPparam> list = pparamMap.get(key);
        if (list == null) {
            list = new ArrayList<ApiPparam>();
            pparamMap.put(key, list);
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getPparamId().equals(amPparam.getPparamId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, apiPparam);
        } else {
            list.add(apiPparam);
        }
    }

    private void deleteParamCache(AmPparam amPparam, Map<String, List<ApiPparam>> pparamMap) {
        if (pparamMap == null) {
            return;
        }
        String key = amPparam.getAppmanageIcode() + "-" + amPparam.getParamDire();
        List<ApiPparam> list = pparamMap.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getPparamId().equals(amPparam.getPparamId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    @Override
    public List<AmPparam> queryPparam(Map<String, Object> map) {
        return this.queryPparamMode(map);
    }

    @Override
    public QueryResult<AmPparam> queryPparamPage(Map<String, Object> map) {
        List<AmPparam> AmPparamList = this.queryPparamMode(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPparam(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(AmPparamList);
        return queryResult;
    }

    private int countPparam(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amPparamMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.PinfoServiceImpl.countPparam", (Throwable)e);
        }
        return i;
    }

    private int countPerror(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amPerrorMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.PinfoServiceImpl.countPerror", (Throwable)e);
        }
        return i;
    }

    @Override
    public void deletePparam(Integer pparamId) {
        this.amPparamMapper.deleteByPrimaryKey(pparamId);
    }

    @Override
    public void deletePerror(Integer errorId) {
        this.amPerrorMapper.deleteByPrimaryKey(errorId);
    }

    @Override
    public AmPparam getPparam(Integer pparamId) {
        AmPparam amPparam = null;
        amPparam = this.amPparamMapper.selectByPrimaryKey(pparamId);
        return amPparam;
    }

    @Override
    public void updatePparam(AmPparamDomain amPparamDomain) throws ApiException {
        AmPparam amPparam = this.getPparam(amPparamDomain.getPparamId());
        if (amPparam == null) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updatePparam.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(amPparam = this.makeModel(amPparam, amPparamDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updatePparam.null", msg);
        }
        this.setDefault(amPparam);
        this.updatePparamModel(amPparam);
    }

    private void updatePparamModel(AmPparam amPparam) throws ApiException {
        if (null == amPparam) {
            return;
        }
        try {
            this.amPparamMapper.updateByPrimaryKey(amPparam);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updatePparamModel.ex");
        }
    }

    private AmPparam makeModel(AmPparam amPparam, AmPparamDomain amPparamDomain) {
        if (amPparamDomain == null) {
            return null;
        }
        if (amPparam == null) {
            amPparam = new AmPparam();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amPparam, (Object)amPparamDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amPparam;
    }

    @Override
    public QueryResult<AmPerror> queryPerrorPage(Map<String, Object> map) {
        List<AmPerror> amPerrorList = this.queryPerrorMode(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPerror(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amPerrorList);
        return queryResult;
    }

    @Override
    public AmPerror getPerror(Integer errorId) {
        AmPerror amPerror = null;
        amPerror = this.amPerrorMapper.selectByPrimaryKey(errorId);
        return amPerror;
    }

    @Override
    public void updatePerror(AmPerrorDomain amPerrorDomain) throws ApiException {
        AmPerror amPerror = this.getPerror(amPerrorDomain.getErrorId());
        if (amPerror == null) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updatePerror.exsit", "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String msg = this.check(amPerror = this.makeModel(amPerror, amPerrorDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updatePerror.null", msg);
        }
        this.setDefault(amPerror);
        this.updatePerrorModel(amPerror);
    }

    private AmPerror makeModel(AmPerror amPerror, AmPerrorDomain amPerrorDomain) {
        if (amPerrorDomain == null) {
            return null;
        }
        if (amPerror == null) {
            amPerror = new AmPerror();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amPerror, (Object)amPerrorDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amPerror;
    }

    private void updatePerrorModel(AmPerror amPerror) throws ApiException {
        if (null == amPerror) {
            return;
        }
        try {
            this.amPerrorMapper.updateByPrimaryKey(amPerror);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.PinfoServiceImpl.updatePerrorModel.ex");
        }
    }

    @Override
    public void queryPinfoLoadCache() {
        this.info("am.ESB.APPMANAGE.PinfoServiceImpl.queryPinfoLoadCache", "=======Pinfo\u8c03\u5ea6start=======");
        this.queryPparamCache();
        this.queryPerrorCache();
        this.info("am.ESB.APPMANAGE.PinfoServiceImpl.queryPinfoLoadCache", "=======Pinfo\u8c03\u5ea6end=======");
    }

    private void queryPparamCache() {
        String pparamKey = PPARM_PRO;
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<AmPparam> pparamList = this.queryPparamMode(parammap);
        if (null == pparamList || pparamList.isEmpty()) {
            DisUtil.delVer((String)pparamKey);
            return;
        }
        HashMap pparamMap = new HashMap();
        Map<String, List<Dataparam>> dataparamMap = this.dataparamService.queryDataparamToMap();
        for (AmPparam amPparam : pparamList) {
            ArrayList<ApiPparam> apiParamList = (ArrayList<ApiPparam>)pparamMap.get(amPparam.getParamDire().toString());
            if (apiParamList == null) {
                apiParamList = new ArrayList<ApiPparam>();
                pparamMap.put(amPparam.getParamDire().toString(), apiParamList);
            }
            ApiPparam apiPparam = this.makeApiPparam(amPparam, dataparamMap);
            apiParamList.add(apiPparam);
        }
        DisUtil.setVer((String)pparamKey, (String)JsonUtil.buildNormalBinder().toJson(pparamMap));
    }

    private ApiPparam makeApiPparam(AmPparam amPparam, Map<String, List<Dataparam>> dataparamMap) {
        if (null == amPparam) {
            return null;
        }
        ApiPparam apiPparam = new ApiPparam();
        try {
            BeanUtils.copyAllPropertys((Object)apiPparam, (Object)amPparam);
            if (AppManageConstants.API_PARAM_TYPE_DATA.equals(apiPparam.getParamType()) && null != dataparamMap) {
                apiPparam.setDataparamList(dataparamMap.get(apiPparam.getParamClassname()));
            } else if (StringUtils.isNotBlank((String)apiPparam.getParamListtype()) && null != dataparamMap && apiPparam.getParamListtype().indexOf("java.lang.") != 0) {
                apiPparam.setDataparamList(dataparamMap.get(apiPparam.getParamListtype()));
            }
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.PinfoServiceImpl.makeApiPparam", (Throwable)e);
        }
        return apiPparam;
    }

    private void queryPerrorCache() {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<AmPerror> list = this.queryPerrorMode(parammap);
        if (CollectionUtils.isEmpty(list)) {
            DisUtil.delVer((String)"EcorePerror-pro");
            return;
        }
        HashMap<String, List<ApiError>> errorMap = new HashMap<String, List<ApiError>>();
        for (AmPerror amPerror : list) {
            this.savePerrorCache(errorMap, amPerror);
        }
        DisUtil.setVer((String)"EcorePerror-pro", (String)JsonUtil.buildNormalBinder().toJson(errorMap));
    }

    private void savePerrorCache(Map<String, List<ApiError>> errorMap, AmPerror AmPerror2) {
        String key = "system_api_version";
        ApiError apiError = this.makeApiError(AmPerror2);
        List<ApiError> apiErrorList = errorMap.get(key);
        if (ListUtil.isEmpty(apiErrorList)) {
            apiErrorList = new ArrayList<ApiError>();
            errorMap.put(key, apiErrorList);
        }
        apiErrorList.add(apiError);
    }

    private void refreshPerrorCache(AmPerror AmPerror2, Integer dataState) {
        boolean addflag = dataState == 1;
        HashMap<String, List<ApiError>> map = DisUtil.getMapByListJson((String)"EcorePerror-pro", String.class, ApiError.class);
        if (map == null) {
            map = new HashMap<String, List<ApiError>>();
        }
        if (addflag) {
            this.savePerrorCache(map, AmPerror2);
        } else {
            this.deleteErrorCache(AmPerror2, map);
        }
        DisUtil.setVer((String)"EcorePerror-pro", (String)JsonUtil.buildNormalBinder().toJson(map));
    }

    private void deleteErrorCache(AmPerror AmPerror2, Map<String, List<ApiError>> map) {
        if (map == null) {
            return;
        }
        String key = "system_api_version";
        List<ApiError> list = map.get(key);
        if (list == null || list.isEmpty()) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getErrorId().equals(AmPerror2.getErrorId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private ApiError makeApiError(AmPerror AmPerror2) {
        if (null == AmPerror2) {
            return null;
        }
        ApiError apiError = new ApiError();
        try {
            BeanUtils.copyAllPropertys((Object)apiError, (Object)AmPerror2);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.PinfoServiceImpl.makeApi", (Throwable)e);
        }
        return apiError;
    }
}

