/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdl.service.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.yqbsoft.laser.service.cdl.domain.FileIdMode;
import com.yqbsoft.laser.service.cdl.domain.PgLabelDomain;
import com.yqbsoft.laser.service.cdl.domain.PgProductCdlDomain;
import com.yqbsoft.laser.service.cdl.domain.PgProductMasterCdlDomain;
import com.yqbsoft.laser.service.cdl.domain.PgProductPriceCdlDomain;
import com.yqbsoft.laser.service.cdl.domain.PgProductStockDomain;
import com.yqbsoft.laser.service.cdl.service.PgCdlGoodsService;
import com.yqbsoft.laser.service.cdl.tool.cdl.PgProductCDLUtil;
import com.yqbsoft.laser.service.cdl.tool.salesHub.FileIdUtils;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgCdlGoodsServiceImpl
extends BaseServiceImpl
implements PgCdlGoodsService {
    private static Logger log = LoggerFactory.getLogger(PgCdlGoodsServiceImpl.class);

    @Override
    public String getTest() throws Exception {
        log.info("---test----");
        return "success";
    }

    @Override
    public String upLoadPgGoodsJDRpc() throws Exception {
        log.info("---\u4e0a\u4f20\u5546\u54c1\u4eac\u4e1crpc\uff0c\u7ed9\u4e00\u9762----");
        return "success";
    }

    @Override
    public String getPgGoodsJDRpc() throws Exception {
        this.getMasterThread();
        return null;
    }

    @Override
    public String updatePgCdlGoodsPrice() throws Exception {
        log.info("---updatePgCdlGoodsPrice----");
        return null;
    }

    @Override
    public String updatePgCdlGoodsPic() throws Exception {
        log.info("---updatePgCdlGoodsPic----");
        return null;
    }

    @Override
    public String getPgCdlGoodsPic() throws Exception {
        this.getFileIdThread();
        return null;
    }

    @Override
    public String getPgCdlGoodsPrice() throws Exception {
        this.getPriceThread();
        return null;
    }

    @Override
    public String getPgCdlGoods() throws Exception {
        this.getGoodsThread();
        return null;
    }

    @Override
    public String getPgCdlGoodsStock() throws Exception {
        this.getGoodsStockThread();
        return null;
    }

    public void getGoodsThread() throws Exception {
        String tenantCode = PgCdlGoodsServiceImpl.getCode();
        List<List<JSONObject>> product = PgProductCDLUtil.getGoods("product");
        for (int i = 0; i < product.size(); ++i) {
            List collect = product.get(i).stream().map(p -> (PgProductCdlDomain)JSONUtil.toBean((JSONObject)p, PgProductCdlDomain.class)).filter(p -> !"N/A".equals(p.getBrandCn())).filter(p -> !"N/A".equals(p.getProductFormCn())).filter(p -> !"N/A".equals(p.getProductNameCn())).filter(p -> "Promotion Pack".equals(p.getItemNature()) || "Normal Pack".equals(p.getItemNature())).collect(Collectors.toList());
            collect.stream().forEach(p -> p.setTenantCode(tenantCode));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("pgProductCdlDomainList", JsonUtil.buildNormalBinder().toJson(collect));
            String code = this.internalInvoke("pg.pgProductCdl.saveProductCdlBatch", params);
            log.info("\u57fa\u7840\u5546\u54c1-DB\u843d\u5e93\uff0c\u7b2c{}\u6279\u6570\u636e{},{}", new Object[]{i, collect.size(), StringUtils.isNotBlank((CharSequence)code)});
        }
    }

    public void getGoodsStockThread() throws Exception {
        String tenantCode = PgCdlGoodsServiceImpl.getCode();
        List<List<JSONObject>> product = PgProductCDLUtil.getGoods("stock");
        for (int i = 0; i < product.size(); ++i) {
            List collect = product.get(i).stream().map(p -> (PgProductStockDomain)JSONUtil.toBean((JSONObject)p, PgProductStockDomain.class)).collect(Collectors.toList());
            collect.stream().forEach(p -> p.setTenantCode(tenantCode));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("pgProductStockDomainList", JsonUtil.buildNormalBinder().toJson(collect));
            String code = this.internalInvoke("pg.pgProductStock.saveProductStockBatch", params);
            log.info("\u57fa\u7840\u5546\u54c1\u5e93\u5b58\u6570\u636e-DB\u843d\u5e93\uff0c\u7b2c{}\u6279\u6570\u636e{},{}", new Object[]{i, collect.size(), StringUtils.isNotBlank((CharSequence)code)});
        }
    }

    public void getPriceThread() throws Exception {
        String tenantCode = PgCdlGoodsServiceImpl.getCode();
        List<List<JSONObject>> price = PgProductCDLUtil.getGoods("price");
        for (int i = 0; i < price.size(); ++i) {
            List collect = price.get(i).stream().map(p -> (PgProductPriceCdlDomain)JSONUtil.toBean((JSONObject)p, PgProductPriceCdlDomain.class)).filter(p -> p.getLaunchAreaChannelName().indexOf("\"All Normal Channel\"") >= 0 || p.getLaunchAreaChannelName().indexOf("\"D-Partner\"") >= 0).collect(Collectors.toList());
            collect.stream().forEach(p -> p.setTenantCode(tenantCode));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("pgProductPriceCdlDomainList", JsonUtil.buildNormalBinder().toJson(collect));
            String code = this.internalInvoke("pg.pgProductPriceCdl.saveProductPriceCdlBatch", params);
            log.info("\u5546\u54c1\u4ef7\u683c-DB\u843d\u5e93\uff0c\u7b2c{}\u6279\u6570\u636e{},{}", new Object[]{i, collect.size(), code});
        }
    }

    public void getMasterThread() throws Exception {
        String tenantCode = PgCdlGoodsServiceImpl.getCode();
        List<List<JSONObject>> productMaster = PgProductCDLUtil.getGoods("master");
        for (int i = 0; i < productMaster.size(); ++i) {
            List collect = productMaster.get(i).stream().map(p -> (PgProductMasterCdlDomain)JSONUtil.toBean((JSONObject)p, PgProductMasterCdlDomain.class)).filter(p -> "Active".equals(p.getFpcItemStatus())).collect(Collectors.toList());
            collect.stream().forEach(p -> p.setTenantCode(tenantCode));
            HashMap<String, String> params = new HashMap<String, String>(2);
            params.put("pgProductMasterCdlDomainList", JsonUtil.buildNormalBinder().toJson(collect));
            String code = this.internalInvoke("pg.pgProductMasterCdl.saveProductMasterCdlBatch", params);
            log.info("\u5546\u54c1RPC-DB\u843d\u5e93\uff0c\u7b2c{}\u6279\u6570\u636e{},{}", new Object[]{i, collect.size(), code});
        }
    }

    public void getFileIdThread() throws Exception {
        List<FileIdMode> fileIdModeList = FileIdUtils.getFileIdModeList();
        List<List<FileIdMode>> listGroup = PgCdlGoodsServiceImpl.getListGroup(fileIdModeList, 1000);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(50, 50, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        int i = 0;
        while (i < listGroup.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List collect = ((List)listGroup.get(finalI)).stream().map(p -> p.toPgProductFileOss()).collect(Collectors.toList());
                log.info("DB\u843d\u5e93\uff0c\u7b2c{}\u6279\u6570\u636e{},{}", new Object[]{finalI, collect.size(), 4});
            });
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                executorService.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<List<FileIdMode>> getListGroup(List<FileIdMode> list, int groupNum) {
        ArrayList<List<FileIdMode>> mgList = new ArrayList<List<FileIdMode>>();
        int limit = PgCdlGoodsServiceImpl.countStep(list.size(), groupNum);
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(i -> mgList.add(list.stream().skip(i * groupNum).limit(groupNum).collect(Collectors.toList())));
        return mgList;
    }

    private static int countStep(int size, int groupNum) {
        return (size + groupNum - 1) / groupNum;
    }

    private void setPgLabelListByPrice(List<PgLabelDomain> pgLabelList, List<PgProductPriceCdlDomain> priceCollect) {
        pgLabelList.stream().forEach(p -> priceCollect.stream().forEach(t -> {
            if (p.getSkuCode().equals(t.getFpcCode())) {
                p.setLabelInsideprice(new BigDecimal(t.getListPriceForSalesUnitVat200()));
                p.setPricesetNprice(new BigDecimal(t.getSrp()));
                p.setLabelPrefprice(new BigDecimal(t.getTopDmSppTax()));
            }
        }));
    }

    private void setPgLabelListByProduct(List<PgLabelDomain> pgLabelList, List<PgProductCdlDomain> collect) {
        collect.stream().forEach(p -> {
            PgLabelDomain goods = new PgLabelDomain();
            goods.setLabelCode(p.getItemBarcode());
            goods.setGoodsName(p.getProductNameCn());
            goods.setSkuCode(p.getFpcCode());
            goods.setClasstreeName(p.getProductFormCn());
            goods.setBrandName(p.getBrandCn());
            goods.setLabelLength(PgCdlGoodsServiceImpl.toBigDecimal(p.getLength(), p.getDimUnit()));
            goods.setLabelWide(PgCdlGoodsServiceImpl.toBigDecimal(p.getWidth(), p.getDimUnit()));
            goods.setLabelHigh(PgCdlGoodsServiceImpl.toBigDecimal(p.getHeight(), p.getDimUnit()));
            goods.setGoodsSpec(goods.getLabelLength() + "cm*" + goods.getLabelWide() + "cm*" + goods.getLabelHigh() + "cm");
            goods.setLabelSize(PgCdlGoodsServiceImpl.toBigDecimal(p.getCnSizeTotal()));
            goods.setLabelSizeUnit(p.getCnSizeUnit());
            goods.setLabelSizeMl(PgCdlGoodsServiceImpl.toSizeMl(goods.getLabelSize(), goods.getLabelSizeUnit()));
            goods.setLabelNature(PgCdlGoodsServiceImpl.toNature(p.getItemNature()));
            goods.setLabelPspnf("P/SP/NF".equals(p.getFlag()) ? "Y" : "N");
            goods.setProductVariant(p.getVariantCn());
            goods.setSellBarcode(p.getSellBarcode());
            goods.setMemo(p.getCategoryCn());
            pgLabelList.add(goods);
        });
    }

    private static BigDecimal toSizeMl(BigDecimal labelSize, String labelSizeUnit) {
        HashMap<String, Integer> unitMap = new HashMap<String, Integer>(8);
        unitMap.put("KG", 1000);
        unitMap.put("M", 1000);
        unitMap.put("G", 1);
        unitMap.put("ML", 1);
        Integer a = (Integer)unitMap.get(labelSizeUnit);
        return labelSize.multiply(new BigDecimal(a == null ? 0 : a));
    }

    private static String toNature(String itemNature) {
        if ("Normal Pack".equals(itemNature)) {
            return itemNature + "\u6b63\u5e38\u88c5";
        }
        if ("Promotion Pack".equals(itemNature)) {
            return itemNature + "\u4fc3\u9500\u88c5";
        }
        return null;
    }

    private static BigDecimal toBigDecimal(String str, String unit) {
        if ("MM".equals(unit) || "mm".equals(unit)) {
            return PgCdlGoodsServiceImpl.toBigDecimal(str).divide(new BigDecimal(10), 2, 4);
        }
        return PgCdlGoodsServiceImpl.toBigDecimal(str);
    }

    private static BigDecimal toBigDecimal(String str) {
        return new BigDecimal(PgCdlGoodsServiceImpl.isNumeric(str) ? str : "0");
    }

    private static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String getCode() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Date date = new Date();
        return format.format(date);
    }

    public static void main(String[] args) {
        try {
            List<List<JSONObject>> product = PgProductCDLUtil.getGoods("stock");
            System.out.println(JsonUtil.buildNormalBinder().toJson(product));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

