/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdl.tool.cdl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yqbsoft.laser.service.cdl.domain.PgProductArrayJsonCdl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class PgProductCDLUtil {
    private static final Logger log = LoggerFactory.getLogger(PgProductCDLUtil.class);
    private static final RestTemplate REST_TEMPLATE;

    public static List<List<cn.hutool.json.JSONObject>> getGoods(String type) throws JsonProcessingException {
        List<List<cn.hutool.json.JSONObject>> dataList = Collections.synchronizedList(new ArrayList(50));
        PgProductArrayJsonCdl goods = new PgProductArrayJsonCdl();
        if ("product".equals(type)) {
            goods = PgProductCDLUtil.getRemoteGoods(0, 1000);
        } else if ("price".equals(type)) {
            goods = PgProductCDLUtil.getRemotePrice(0, 1000);
        } else if ("master".equals(type)) {
            goods = PgProductCDLUtil.getRemoteMaster(0, 1000);
        } else if ("stock".equals(type)) {
            goods = PgProductCDLUtil.getRemoteStock(0, 1000);
        }
        log.info("\u8fdc\u7a0b\u6570\u636e\u91cf\uff1a{}", (Object)goods.getTotalCount());
        dataList.add(goods.getData());
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(50, 50, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        int i = 1;
        while (i <= goods.getLastPageNumber()) {
            int finalI = i++;
            executorService.submit(() -> {
                PgProductArrayJsonCdl goods1 = null;
                try {
                    if ("product".equals(type)) {
                        goods1 = PgProductCDLUtil.getRemoteGoods(finalI, 1000);
                    } else if ("price".equals(type)) {
                        goods1 = PgProductCDLUtil.getRemotePrice(finalI, 1000);
                    } else if ("master".equals(type)) {
                        goods1 = PgProductCDLUtil.getRemoteMaster(finalI, 1000);
                    } else if ("stock".equals(type)) {
                        goods1 = PgProductCDLUtil.getRemoteStock(finalI, 1000);
                    }
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                }
                dataList.add(goods1.getData());
            });
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                executorService.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.info("\u672c\u5730\u6570\u636e\u91cf\uff1a{},\u5206\u7ec4\u91cf\uff1a{}", (Object)dataList.stream().mapToInt(p -> p.size()).sum(), (Object)dataList.size());
        return dataList;
    }

    public static PgProductArrayJsonCdl getRemotePrice(int pageNumber, int pageSize) throws JsonProcessingException {
        LinkedHashMap<String, Object> talosApiParam = new LinkedHashMap<String, Object>();
        talosApiParam.put("apiName", "pg.mdm.price.cph.prod.fpc.dim.get");
        talosApiParam.put("pageNumber", pageNumber);
        talosApiParam.put("pageSize", pageSize);
        talosApiParam.put("itemStatus", "Active");
        talosApiParam.put("dwIsCurrentFlag", "1");
        String dirPath = "/data/cdl-price/";
        return PgProductCDLUtil.getRemote(talosApiParam, dirPath);
    }

    public static PgProductArrayJsonCdl getRemoteGoods(int pageNumber, int pageSize) throws JsonProcessingException {
        LinkedHashMap<String, Object> talosApiParam = new LinkedHashMap<String, Object>();
        talosApiParam.put("apiName", "pg.mdm.product.cph.fpc.dim.get");
        talosApiParam.put("pageNumber", pageNumber);
        talosApiParam.put("pageSize", pageSize);
        talosApiParam.put("itemStatus", "Active");
        talosApiParam.put("dwIsCurrentFlag", "1");
        String dirPath = "/data/cdl-goods/";
        return PgProductCDLUtil.getRemote(talosApiParam, dirPath);
    }

    public static PgProductArrayJsonCdl getRemoteMaster(int pageNumber, int pageSize) throws JsonProcessingException {
        LinkedHashMap<String, Object> talosApiParam = new LinkedHashMap<String, Object>();
        talosApiParam.put("apiName", "pg.mdm.product.cph.rpc.gtin.dim.get");
        talosApiParam.put("pageNumber", pageNumber);
        talosApiParam.put("pageSize", pageSize);
        talosApiParam.put("custId", "70000010");
        talosApiParam.put("fpcItemStatus", "Active");
        talosApiParam.put("dwIsInsertFlag", "1");
        String dirPath = "/data/cdl-master/";
        return PgProductCDLUtil.getRemote(talosApiParam, dirPath);
    }

    public static PgProductArrayJsonCdl getRemoteStock(int pageNumber, int pageSize) throws JsonProcessingException {
        LinkedHashMap<String, Object> talosApiParam = new LinkedHashMap<String, Object>();
        talosApiParam.put("apiName", "pg.do.inventory.on.hand.flag.daily.get");
        talosApiParam.put("pageNumber", pageNumber);
        talosApiParam.put("pageSize", pageSize);
        try {
            talosApiParam.put("stateDate", DateUtils.parseDateToString((Date)DateUtils.addDays((Date)new Date(), (int)-1), (String)"yyyy-MM-dd"));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        String dirPath = "/data/cdl-stock/";
        return PgProductCDLUtil.getRemote(talosApiParam, dirPath);
    }

    public static PgProductArrayJsonCdl getRemote(Map<String, Object> talosApiParam, String dirPath) throws JsonProcessingException {
        log.info("\u7b2c{}\u9875,\u6bcf\u9875{}\u6761", talosApiParam.get("pageNumber"), talosApiParam.get("pageSize"));
        String strValue = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"2022011000000021-cdl_config-cdl_config");
        JSONObject object = JSONObject.json2object((String)strValue);
        String apiKey = "cph-42874";
        String secret = object.getString("secret");
        String apimSubscriptionKey = object.getString("apimSubscriptionKey");
        String nonceStr = "random string";
        String timestamp = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        LinkedHashMap<String, String> apimSignParam = new LinkedHashMap<String, String>();
        apimSignParam.put("api_key", "cph-42874");
        apimSignParam.put("nonce_str", "random string");
        apimSignParam.put("timestamp", timestamp);
        talosApiParam.put("apiAccessCode", "CPH");
        talosApiParam.put("apiSessionKey", object.getString("apiSessionKey"));
        ObjectMapper objectMapper = new ObjectMapper();
        String body = objectMapper.writeValueAsString(talosApiParam);
        String sign = PgProductCDLUtil.sign(apimSignParam, body, secret);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json;charset=UTF-8");
        httpHeaders.add("Accept", "*/*");
        httpHeaders.add("Ocp-Apim-Subscription-Key", apimSubscriptionKey);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        String url = String.format(object.getString("url"), "cph-42874", "random string", timestamp, sign);
        try {
            ResponseEntity responseEntity = REST_TEMPLATE.exchange(url, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            PgProductArrayJsonCdl productArrayJsonDo = (PgProductArrayJsonCdl)JSONUtil.toBean((String)((String)responseEntity.getBody()), PgProductArrayJsonCdl.class);
            if (StringUtils.isNotBlank((CharSequence)dirPath)) {
                PgProductCDLUtil.setFile(dirPath, (Integer)talosApiParam.get("pageNumber"), JSONUtil.parseArray(productArrayJsonDo.getData()).toString());
            }
            return productArrayJsonDo;
        }
        catch (HttpStatusCodeException e) {
            System.out.println(".test.error=" + e.getResponseBodyAsString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String sign(Map<String, String> apimSignParam, String body, String secret) {
        ArrayList paramList = new ArrayList();
        apimSignParam.forEach((key, value) -> Collections.addAll(paramList, key + "=" + value));
        if (StringUtils.isNotBlank((CharSequence)body)) {
            Collections.addAll(paramList, "body=" + body);
        }
        Collections.sort(paramList);
        String paramStr = String.format("%s%s%s", secret, StringUtils.join(paramList, (String)"&"), secret);
        return DigestUtils.sha256Hex((String)paramStr).toUpperCase();
    }

    public static void setFile(String path, int index, String data) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(file = new File(path = path + "file-" + index + ".json")).exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(data);
            bw.close();
            log.info("File\u843d\u76d8\uff0c\u7b2c{}\u6279\u6570\u636eDone,{}", (Object)index, (Object)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <T> List<List<T>> splitList(List<T> list, int len) {
        if (list == null || list.size() == 0 || len < 1) {
            return null;
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List<T> subList = list.subList(i * len, (i + 1) * len > size ? size : len * (i + 1));
            result.add(subList);
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            System.out.println(DateUtils.parseDateToString((Date)DateUtils.addDays((Date)new Date(), (int)-1), (String)"yyyy/MM/dd"));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        CloseableHttpClient httpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient((HttpClient)httpClient);
        REST_TEMPLATE = new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }
}

