/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdl.tool.salesHub;

import cn.hutool.json.JSONUtil;
import com.yqbsoft.laser.service.cdl.domain.FileIdMode;
import com.yqbsoft.laser.service.cdl.tool.cdl.PgProductCDLUtil;
import com.yqbsoft.laser.service.cdl.tool.salesHub.ExcelRead;
import com.yqbsoft.laser.service.cdl.tool.salesHub.FileUpload;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileIdUtils {
    private static final Logger log = LoggerFactory.getLogger(FileIdUtils.class);
    public static List<FileIdMode> fileIdModeList = Collections.synchronizedList(new ArrayList());

    public static void main(String[] args) throws Exception {
        FileIdMode mode = new FileIdMode();
        mode.setFpcCode("82310209");
        mode.setFileId("9fef9d62e148442a8f62b15214681e2e");
        FileIdUtils.getRemoteFile(mode);
    }

    public static List<FileIdMode> getFileIdModeList() throws Exception {
        String dirPath = "/data/file-id/file_service_id.xlsx";
        File file = new File(dirPath);
        ExcelRead.setFileIdModeList(file);
        Long startTime = System.currentTimeMillis();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(50, 50, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        for (FileIdMode fileIdMode : fileIdModeList) {
            executorService.submit(() -> {
                try {
                    FileIdUtils.getRemoteFile(fileIdMode);
                }
                catch (Exception e) {
                    log.error(fileIdMode.toString());
                }
            });
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                executorService.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        PgProductCDLUtil.setFile(dirPath, 0, JSONUtil.toJsonStr(fileIdModeList));
        log.info("50\u7ebf\u7a0b-\u83b7\u53d6\u8fdc\u7a0b\u6570\u636e\u8017\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
        return fileIdModeList;
    }

    public static String getRemoteFile(FileIdMode fileIdMode) throws Exception {
        String subscriptionKey = "one-sales-portal";
        String subscriptionSecret = "ea0a9834c64c44d4e167cc75479b31ee326dadca";
        String fileId = fileIdMode.getFileId();
        Date date = new Date();
        Long timestamp = date.getTime();
        Object[] str = new String[]{"subscriptionKey=" + subscriptionKey, "subscriptionSecret=" + subscriptionSecret, "timestamp=" + timestamp, "fileId=" + fileId};
        Arrays.sort(str);
        String rawStr = (String)str[0] + (String)str[1] + (String)str[2] + (String)str[3];
        String signature = FileIdUtils.sha1(rawStr);
        String url = "https://storage.pg.com.cn/v1/files/" + fileId + "?signature=" + signature + "&subscriptionKey=" + subscriptionKey + "&timestamp=" + timestamp;
        String redirectUrl = FileIdUtils.getRedirectUrl(url);
        fileIdMode.setFilePath(redirectUrl);
        log.info(" == fpcCode={}\uff0c\u83b7\u53d6salesHub\u7684\u5546\u54c1\u56fe\u7247\u94fe\u63a5\u6210\u529f\uff0c\u51c6\u5907\u4e0b\u8f7d\u56fe\u7247", (Object)fileIdMode.getFpcCode());
        return FileUpload.OSSUploadFile(fileIdMode);
    }

    private static String sha1(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return DigestUtils.sha1Hex((String)s);
    }

    private static String getRedirectUrl(String path) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(path).openConnection();
        conn.setInstanceFollowRedirects(false);
        conn.setConnectTimeout(5000);
        return conn.getHeaderField("Location");
    }
}

