/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cdl.tool.salesHub;

import java.net.URLConnection;

public enum ImageTypeUtil {
    PNG(".png", "image/png"),
    JPG(".jpg", "image/jpeg"),
    BMP(".bmp", "image/bmp"),
    JPEG(".jpeg", "image/jpeg"),
    GIF(".gif", "image/gif"),
    TIF(".tif", "image/tiff"),
    TIFF(".tiff", "image/tiff"),
    FAX(".fax", "image/fax"),
    ICO(".ico", "image/x-icon"),
    JFIF(".jfif", "image/jpeg"),
    JPE(".jpe", "image/jpeg"),
    NET(".net", "image/pnetvue"),
    WBMP(".wbmp", "image/vnd.wap.wbmp");

    final String mSuffix;
    final String mMIME;

    private ImageTypeUtil(String suffix, String mime) {
        this.mSuffix = suffix;
        this.mMIME = mime;
    }

    public static String getSuffixFromUrl(String url) {
        for (ImageTypeUtil fileType : ImageTypeUtil.values()) {
            if (!url.contains(fileType.suffix())) continue;
            return fileType.suffix();
        }
        String contentType = ImageTypeUtil.getMIMETypeFromUrl(url);
        if (contentType == null) {
            return null;
        }
        return ImageTypeUtil.mimeMapingSuffix(contentType);
    }

    public static String getMIMETypeFromUrl(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        return URLConnection.guessContentTypeFromName(url);
    }

    public static String mimeMapingSuffix(String mime) {
        for (ImageTypeUtil fileType : ImageTypeUtil.values()) {
            if (!fileType.mime().equals(mime)) continue;
            return fileType.suffix();
        }
        return null;
    }

    public String mime() {
        return this.mMIME;
    }

    public String suffix() {
        return this.mSuffix;
    }
}

