/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.file.service.impl;

import com.yqbsoft.laser.service.dynamic.GroovyUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.file.FileConstants;
import com.yqbsoft.laser.service.file.dao.FmUsermfileListMapper;
import com.yqbsoft.laser.service.file.dao.FmUsermfileMapper;
import com.yqbsoft.laser.service.file.domain.FmFileReDomainBean;
import com.yqbsoft.laser.service.file.domain.FmUsermfileDomain;
import com.yqbsoft.laser.service.file.domain.FmUsermfileListDomain;
import com.yqbsoft.laser.service.file.domain.FmUsermfileListReDomain;
import com.yqbsoft.laser.service.file.domain.FmUsermfileReDomain;
import com.yqbsoft.laser.service.file.es.MfileSendPollThread;
import com.yqbsoft.laser.service.file.es.MfileSendPutThread;
import com.yqbsoft.laser.service.file.es.MfileSendService;
import com.yqbsoft.laser.service.file.model.FmFile;
import com.yqbsoft.laser.service.file.model.FmMfile;
import com.yqbsoft.laser.service.file.model.FmUsermfile;
import com.yqbsoft.laser.service.file.model.FmUsermfileList;
import com.yqbsoft.laser.service.file.service.FileService;
import com.yqbsoft.laser.service.file.service.FmMfileService;
import com.yqbsoft.laser.service.file.service.FmUsermfileService;
import com.yqbsoft.laser.service.file.util.DataCall;
import com.yqbsoft.laser.service.file.util.DataCallEx;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.quartz.CronExpression;

public class FmUsermfileImpl
extends BaseServiceImpl
implements FmUsermfileService {
    private static final String SYS_CODE = "fm.FILE.FmUsermfileImpl";
    private FmUsermfileMapper fmUsermfileMapper;
    private FmUsermfileListMapper fmUsermfileListMapper;
    private FileService fileService;
    private FmMfileService fmMfileService;
    private static MfileSendService mfileSendService;
    private static Object lock;
    private static String dao_startRow;
    private static String dao_endRow;

    public void setFmUsermfileMapper(FmUsermfileMapper fmUsermfileMapper) {
        this.fmUsermfileMapper = fmUsermfileMapper;
    }

    public void setFmUsermfileListMapper(FmUsermfileListMapper fmUsermfileListMapper) {
        this.fmUsermfileListMapper = fmUsermfileListMapper;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public void setFmMfileService(FmMfileService fmMfileService) {
        this.fmMfileService = fmMfileService;
    }

    private Date getSysDate() {
        try {
            return this.fmUsermfileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUsermfile(FmUsermfileDomain fmUsermfileDomain) {
        if (null == fmUsermfileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fmUsermfileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUsermfileDefault(FmUsermfile fmUsermfile) {
        if (null == fmUsermfile) {
            return;
        }
        if (null == fmUsermfile.getDataState()) {
            fmUsermfile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == fmUsermfile.getGmtCreate()) {
            fmUsermfile.setGmtCreate(date);
        }
        fmUsermfile.setGmtModified(date);
        if (StringUtils.isBlank((String)fmUsermfile.getUsermfileCode())) {
            fmUsermfile.setUsermfileCode(this.createUUIDString());
        }
    }

    private int getUsermfileMaxCode() {
        int code = 0;
        try {
            return this.fmUsermfileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getUsermfileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUsermfileUpdataDefault(FmUsermfile fmUsermfile) {
        if (null == fmUsermfile) {
            return;
        }
        fmUsermfile.setGmtModified(this.getSysDate());
    }

    private void saveUsermfileModel(FmUsermfile fmUsermfile) throws ApiException {
        if (null == fmUsermfile) {
            return;
        }
        try {
            this.fmUsermfileMapper.insert(fmUsermfile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.saveUsermfileModel.ex", (Throwable)e);
        }
    }

    private void saveUsermfileBatchModel(List<FmUsermfile> fmUsermfileList) throws ApiException {
        if (null == fmUsermfileList || fmUsermfileList.isEmpty()) {
            return;
        }
        try {
            this.fmUsermfileMapper.insertBatch(fmUsermfileList);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.saveUsermfileBatchModel.ex", (Throwable)e);
        }
    }

    private FmUsermfile getUsermfileModelById(Integer usermfileId) {
        if (null == usermfileId) {
            return null;
        }
        try {
            return this.fmUsermfileMapper.selectByPrimaryKey(usermfileId);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getUsermfileModelById", (Throwable)e);
            return null;
        }
    }

    private FmUsermfile getUsermfileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fmUsermfileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getUsermfileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUsermfileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUsermfileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.delUsermfileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.delUsermfileModelByCode.num");
        }
    }

    private void deleteUsermfileModel(Integer usermfileId) throws ApiException {
        if (null == usermfileId) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUsermfileMapper.deleteByPrimaryKey(usermfileId);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.deleteUsermfileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.deleteUsermfileModel.num");
        }
    }

    private void updateUsermfileModel(FmUsermfile fmUsermfile) throws ApiException {
        if (null == fmUsermfile) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUsermfileMapper.updateByPrimaryKey(fmUsermfile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateUsermfileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateUsermfileModel.num");
        }
    }

    private void updateStateUsermfileModel(Integer usermfileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == usermfileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usermfileId", usermfileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmUsermfileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateStateUsermfileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateStateUsermfileModel.null");
        }
    }

    private void updateStateUsermfileModelByCode(String tenantCode, String usermfileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)usermfileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usermfileCode", usermfileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmUsermfileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateStateUsermfileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateStateUsermfileModelByCode.null");
        }
    }

    private FmUsermfile makeUsermfile(FmUsermfileDomain fmUsermfileDomain, FmUsermfile fmUsermfile) {
        if (null == fmUsermfileDomain) {
            return null;
        }
        if (null == fmUsermfile) {
            fmUsermfile = new FmUsermfile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fmUsermfile, (Object)fmUsermfileDomain);
            return fmUsermfile;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.makeUsermfile", (Throwable)e);
            return null;
        }
    }

    private FmUsermfileReDomain makeFmUsermfileReDomain(FmUsermfile fmUsermfile) {
        if (null == fmUsermfile) {
            return null;
        }
        FmUsermfileReDomain fmUsermfileReDomain = new FmUsermfileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fmUsermfileReDomain, (Object)fmUsermfile);
            return fmUsermfileReDomain;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.makeFmUsermfileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FmUsermfile> queryUsermfileModelPage(Map<String, Object> parammap) {
        try {
            return this.fmUsermfileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.queryUsermfileModel", (Throwable)e);
            return null;
        }
    }

    private int countUsermfile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fmUsermfileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.countUsermfile", (Throwable)e);
        }
        return i;
    }

    private FmUsermfile createFmUsermfile(FmUsermfileDomain fmUsermfileDomain) {
        String msg = this.checkUsermfile(fmUsermfileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.saveUsermfile.checkUsermfile", msg);
        }
        FmUsermfile fmUsermfile = this.makeUsermfile(fmUsermfileDomain, null);
        this.setUsermfileDefault(fmUsermfile);
        return fmUsermfile;
    }

    private String checkUsermfileList(FmUsermfileListDomain fmUsermfileListDomain) {
        if (null == fmUsermfileListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fmUsermfileListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUsermfileListDefault(FmUsermfileList fmUsermfileList) {
        if (null == fmUsermfileList) {
            return;
        }
        if (null == fmUsermfileList.getDataState()) {
            fmUsermfileList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == fmUsermfileList.getGmtCreate()) {
            fmUsermfileList.setGmtCreate(date);
        }
        fmUsermfileList.setGmtModified(date);
        if (StringUtils.isBlank((String)fmUsermfileList.getUsermfileListCode())) {
            fmUsermfileList.setUsermfileListCode(this.createUUIDString());
        }
    }

    private int getUsermfileListMaxCode() {
        int code = 0;
        try {
            return this.fmUsermfileListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getUsermfileListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUsermfileListUpdataDefault(FmUsermfileList fmUsermfileList) {
        if (null == fmUsermfileList) {
            return;
        }
        fmUsermfileList.setGmtModified(this.getSysDate());
    }

    private void saveUsermfileListModel(FmUsermfileList fmUsermfileList) throws ApiException {
        if (null == fmUsermfileList) {
            return;
        }
        try {
            this.fmUsermfileListMapper.insert(fmUsermfileList);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.saveUsermfileListModel.ex", (Throwable)e);
        }
    }

    private void saveUsermfileListBatchModel(List<FmUsermfileList> fmUsermfileListList) throws ApiException {
        if (null == fmUsermfileListList || fmUsermfileListList.isEmpty()) {
            return;
        }
        try {
            this.fmUsermfileListMapper.insertBatch(fmUsermfileListList);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.saveUsermfileListBatchModel.ex", (Throwable)e);
        }
    }

    private FmUsermfileList getUsermfileListModelById(Integer usermfileListId) {
        if (null == usermfileListId) {
            return null;
        }
        try {
            return this.fmUsermfileListMapper.selectByPrimaryKey(usermfileListId);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getUsermfileListModelById", (Throwable)e);
            return null;
        }
    }

    private FmUsermfileList getUsermfileListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fmUsermfileListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getUsermfileListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUsermfileListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUsermfileListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.delUsermfileListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.delUsermfileListModelByCode.num");
        }
    }

    private void deleteUsermfileListModel(Integer usermfileListId) throws ApiException {
        if (null == usermfileListId) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUsermfileListMapper.deleteByPrimaryKey(usermfileListId);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.deleteUsermfileListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.deleteUsermfileListModel.num");
        }
    }

    private void updateUsermfileListModel(FmUsermfileList fmUsermfileList) throws ApiException {
        if (null == fmUsermfileList) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUsermfileListMapper.updateByPrimaryKey(fmUsermfileList);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateUsermfileListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateUsermfileListModel.num");
        }
    }

    private void updateStateUsermfileListModel(Integer usermfileListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == usermfileListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usermfileListId", usermfileListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmUsermfileListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateStateUsermfileListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateStateUsermfileListModel.null");
        }
    }

    private void updateStateUsermfileListModelByCode(String tenantCode, String usermfileListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)usermfileListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usermfileListCode", usermfileListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmUsermfileListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateStateUsermfileListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateStateUsermfileListModelByCode.null");
        }
    }

    private FmUsermfileList makeUsermfileList(FmUsermfileListDomain fmUsermfileListDomain, FmUsermfileList fmUsermfileList) {
        if (null == fmUsermfileListDomain) {
            return null;
        }
        if (null == fmUsermfileList) {
            fmUsermfileList = new FmUsermfileList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fmUsermfileList, (Object)fmUsermfileListDomain);
            return fmUsermfileList;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.makeUsermfileList", (Throwable)e);
            return null;
        }
    }

    private FmUsermfileListReDomain makeFmUsermfileListReDomain(FmUsermfileList fmUsermfileList) {
        if (null == fmUsermfileList) {
            return null;
        }
        FmUsermfileListReDomain fmUsermfileListReDomain = new FmUsermfileListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fmUsermfileListReDomain, (Object)fmUsermfileList);
            return fmUsermfileListReDomain;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.makeFmUsermfileListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FmUsermfileList> queryUsermfileListModelPage(Map<String, Object> parammap) {
        try {
            return this.fmUsermfileListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.queryUsermfileListModel", (Throwable)e);
            return null;
        }
    }

    private int countUsermfileList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fmUsermfileListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.countUsermfileList", (Throwable)e);
        }
        return i;
    }

    private FmUsermfileList createFmUsermfileList(FmUsermfileListDomain fmUsermfileListDomain) {
        String msg = this.checkUsermfileList(fmUsermfileListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.saveUsermfileList.checkUsermfileList", msg);
        }
        FmUsermfileList fmUsermfileList = this.makeUsermfileList(fmUsermfileListDomain, null);
        this.setUsermfileListDefault(fmUsermfileList);
        return fmUsermfileList;
    }

    @Override
    public String saveUsermfile(FmUsermfileDomain fmUsermfileDomain) throws ApiException {
        FmUsermfile fmUsermfile = this.createFmUsermfile(fmUsermfileDomain);
        this.saveUsermfileModel(fmUsermfile);
        return fmUsermfile.getUsermfileCode();
    }

    @Override
    public String saveUsermfileBatch(List<FmUsermfileDomain> fmUsermfileDomainList) throws ApiException {
        if (null == fmUsermfileDomainList || fmUsermfileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FmUsermfile> fmUsermfileList = new ArrayList<FmUsermfile>();
        String code = "";
        for (FmUsermfileDomain fmUsermfileDomain : fmUsermfileDomainList) {
            FmUsermfile fmUsermfile = this.createFmUsermfile(fmUsermfileDomain);
            code = fmUsermfile.getUsermfileCode();
            fmUsermfileList.add(fmUsermfile);
        }
        this.saveUsermfileBatchModel(fmUsermfileList);
        return code;
    }

    @Override
    public void updateUsermfileState(Integer usermfileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == usermfileId) {
            return;
        }
        this.updateStateUsermfileModel(usermfileId, dataState, oldDataState, map);
    }

    @Override
    public void updateUsermfileStateByCode(String tenantCode, String usermfileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)usermfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUsermfileModelByCode(tenantCode, usermfileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUsermfile(FmUsermfileDomain fmUsermfileDomain) throws ApiException {
        String msg = this.checkUsermfile(fmUsermfileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateUsermfile.checkUsermfile", msg);
        }
        FmUsermfile oldFmUsermfile = this.getUsermfileModelById(fmUsermfileDomain.getUsermfileId());
        if (null == oldFmUsermfile) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateUsermfile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FmUsermfile fmUsermfile = this.makeUsermfile(fmUsermfileDomain, oldFmUsermfile);
        this.setUsermfileUpdataDefault(fmUsermfile);
        this.updateUsermfileModel(fmUsermfile);
    }

    @Override
    public FmUsermfile getUsermfile(Integer usermfileId) {
        if (null == usermfileId) {
            return null;
        }
        return this.getUsermfileModelById(usermfileId);
    }

    @Override
    public void deleteUsermfile(Integer usermfileId) throws ApiException {
        if (null == usermfileId) {
            return;
        }
        this.deleteUsermfileModel(usermfileId);
    }

    @Override
    public QueryResult<FmUsermfile> queryUsermfilePage(Map<String, Object> map) {
        List<FmUsermfile> fmUsermfileList = this.queryUsermfileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUsermfile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fmUsermfileList);
        return queryResult;
    }

    @Override
    public FmUsermfile getUsermfileByCode(String tenantCode, String usermfileCode) throws ApiException {
        if (StringUtils.isBlank((String)usermfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usermfileCode", usermfileCode);
        return this.getUsermfileModelByCode(map);
    }

    @Override
    public void deleteUsermfileByCode(String tenantCode, String usermfileCode) throws ApiException {
        if (StringUtils.isBlank((String)usermfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usermfileCode", usermfileCode);
        this.delUsermfileModelByCode(map);
    }

    @Override
    public String saveUsermfileList(FmUsermfileListDomain fmUsermfileListDomain) throws ApiException {
        FmUsermfileList fmUsermfileList = this.createFmUsermfileList(fmUsermfileListDomain);
        this.saveUsermfileListModel(fmUsermfileList);
        return fmUsermfileList.getUsermfileListCode();
    }

    @Override
    public String saveUsermfileListBatch(List<FmUsermfileListDomain> fmUsermfileListDomainList) throws ApiException {
        if (null == fmUsermfileListDomainList || fmUsermfileListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FmUsermfileList> fmUsermfileListList = new ArrayList<FmUsermfileList>();
        String code = "";
        for (FmUsermfileListDomain fmUsermfileListDomain : fmUsermfileListDomainList) {
            FmUsermfileList fmUsermfileList = this.createFmUsermfileList(fmUsermfileListDomain);
            code = fmUsermfileList.getUsermfileListCode();
            fmUsermfileListList.add(fmUsermfileList);
        }
        this.saveUsermfileListBatchModel(fmUsermfileListList);
        return code;
    }

    @Override
    public void updateUsermfileListState(Integer usermfileListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == usermfileListId) {
            return;
        }
        this.updateStateUsermfileListModel(usermfileListId, dataState, oldDataState, map);
    }

    @Override
    public void updateUsermfileListStateByCode(String tenantCode, String usermfileListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)usermfileListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUsermfileListModelByCode(tenantCode, usermfileListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUsermfileList(FmUsermfileListDomain fmUsermfileListDomain) throws ApiException {
        String msg = this.checkUsermfileList(fmUsermfileListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateUsermfileList.checkUsermfileList", msg);
        }
        FmUsermfileList oldFmUsermfileList = this.getUsermfileListModelById(fmUsermfileListDomain.getUsermfileListId());
        if (null == oldFmUsermfileList) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.updateUsermfileList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FmUsermfileList fmUsermfileList = this.makeUsermfileList(fmUsermfileListDomain, oldFmUsermfileList);
        this.setUsermfileListUpdataDefault(fmUsermfileList);
        this.updateUsermfileListModel(fmUsermfileList);
    }

    @Override
    public FmUsermfileList getUsermfileList(Integer usermfileListId) {
        if (null == usermfileListId) {
            return null;
        }
        return this.getUsermfileListModelById(usermfileListId);
    }

    @Override
    public void deleteUsermfileList(Integer usermfileListId) throws ApiException {
        if (null == usermfileListId) {
            return;
        }
        this.deleteUsermfileListModel(usermfileListId);
    }

    @Override
    public QueryResult<FmUsermfileList> queryUsermfileListPage(Map<String, Object> map) {
        List<FmUsermfileList> fmUsermfileListList = this.queryUsermfileListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUsermfileList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fmUsermfileListList);
        return queryResult;
    }

    @Override
    public FmUsermfileList getUsermfileListByCode(String tenantCode, String usermfileListCode) throws ApiException {
        if (StringUtils.isBlank((String)usermfileListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usermfileListCode", usermfileListCode);
        return this.getUsermfileListModelByCode(map);
    }

    @Override
    public void deleteUsermfileListByCode(String tenantCode, String usermfileListCode) throws ApiException {
        if (StringUtils.isBlank((String)usermfileListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("usermfileListCode", usermfileListCode);
        this.delUsermfileListModelByCode(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MfileSendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == mfileSendService) {
                mfileSendService = new MfileSendService((FmUsermfileService)SpringApplicationContextUtil.getBean((String)"fmUsermfileService"));
                for (int i = 0; i < 10; ++i) {
                    mfileSendService.addPollPool(new MfileSendPollThread(mfileSendService));
                }
            }
            return mfileSendService;
        }
    }

    @Override
    public void doUsermfileStartAll() throws ApiException {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", 0);
            QueryResult<FmUsermfile> result = this.queryUsermfilePage(map);
            if (null == result || ListUtil.isEmpty((Collection)result.getList())) {
                return;
            }
            Date sysDate = this.getSysDate();
            this.logger.error("fm.FILE.FmUsermfileImpl.doUsermfileStartAll", (Object)JsonUtil.buildNormalBinder().toJson((Object)sysDate));
            ArrayList<FmUsermfile> fmUsermfileList = new ArrayList<FmUsermfile>();
            for (FmUsermfile fmUsermfile : result.getList()) {
                if (!this.getCron(sysDate, fmUsermfile).booleanValue()) continue;
                fmUsermfileList.add(fmUsermfile);
            }
            if (null != fmUsermfileList && ListUtil.isNotEmpty(fmUsermfileList)) {
                FmUsermfileImpl.getSendService().addPutPool(new MfileSendPutThread(FmUsermfileImpl.getSendService(), fmUsermfileList));
            }
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUsermfileImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public void sendUsermfile(FmUsermfile fmUsermfile) throws ApiException {
        if (null == fmUsermfile) {
            this.logger.error("fm.FILE.FmUsermfileImpl.startUsermfile.fmUsermfile", (Object)"fmUsermfile is null");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        FmMfile mfile = this.fmMfileService.getMfileByCode(fmUsermfile.getTenantCode(), fmUsermfile.getMfileCode());
        if (null == mfile) {
            mfile = this.fmMfileService.getMfileByCode("00000000", fmUsermfile.getMfileCode());
        }
        if (null == mfile) {
            this.logger.error("fm.FILE.FmUsermfileImpl.startUsermfile.fmUsermfile", (Object)"fmUsermfile is null");
            map.put("memo", "\u6267\u884c\u5931\u8d25 FmMfile is null");
            this.updateStateUsermfileModel(fmUsermfile.getUsermfileId(), FileConstants.fmUsermFileDataState_1, FileConstants.fmUsermFileDataState0, map);
            return;
        }
        map.put("memo", "\u5f00\u59cb\u6267\u884c");
        this.updateStateUsermfileModel(fmUsermfile.getUsermfileId(), FileConstants.fmUsermFileDataState1, FileConstants.fmUsermFileDataState0, map);
        if (this.inExecution(mfile, fmUsermfile).booleanValue()) {
            map.put("memo", "\u6267\u884c\u5b8c\u6210");
            this.updateStateUsermfileModel(fmUsermfile.getUsermfileId(), FileConstants.fmUsermFileDataState2, FileConstants.fmUsermFileDataState1, map);
        } else {
            map.put("memo", "\u6267\u884c\u5931\u8d25");
            this.updateStateUsermfileModel(fmUsermfile.getUsermfileId(), FileConstants.fmUsermFileDataState_1, FileConstants.fmUsermFileDataState1, map);
        }
    }

    private Boolean inExecution(FmMfile mfile, FmUsermfile fmUsermfile) {
        Object showName;
        boolean mfileCut = true;
        Integer mfileCutsizeTotal = 0;
        Integer mfileNum = 0;
        Integer starMfileNum = 0;
        Integer endMfileNum = 0;
        if (null == mfile.getMfileCutsize() || mfile.getMfileCutsize() < 0) {
            mfile.setMfileCutsize(10000);
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        Integer rows = fmUsermfile.getMfileSize();
        if (null == rows || 0 >= rows) {
            rows = 1000;
        }
        Integer page = 1;
        List<Map<String, Object>> headMapList = this.getExcelParam(mfile.getMfileEcontext(), fmUsermfile.getUsermfileWhere());
        if (ListUtil.isEmpty(headMapList)) {
            this.logger.error("fm.FILE.FmUsermfileImpl.startUsermfile.headMapList is null");
            return false;
        }
        ArrayList<String> excelHeader = new ArrayList<String>();
        for (Map<String, Object> map : headMapList) {
            showName = map.get("showName").toString();
            excelHeader.add((String)showName);
        }
        String[] headers = excelHeader.toArray(new String[excelHeader.size()]);
        do {
            starMfileNum = mfile.getMfileCutsize() * mfileNum;
            Integer n = mfileNum;
            mfileNum = mfileNum + 1;
            showName = mfileNum;
            endMfileNum = mfile.getMfileCutsize() * mfileNum;
            FmUsermfileListDomain fmUsermfileListDomain = new FmUsermfileListDomain();
            try {
                BeanUtils.copyAllPropertys((Object)fmUsermfileListDomain, (Object)fmUsermfile);
            }
            catch (Exception e) {
                this.logger.error("fm.FILE.FmUsermfileImpl.makeUsermfileList", (Throwable)e);
                return false;
            }
            fmUsermfileListDomain.setUsermfileSize(rows);
            fmUsermfileListDomain.setUsermfileNsize(page);
            String srcFile = "/" + fmUsermfileListDomain.getMfileName() + fmUsermfileListDomain.getUsermfileCode() + mfileNum + "." + fmUsermfile.getMfileCtype();
            fmUsermfileListDomain.setUsermfileUrlpath(srcFile);
            String code = this.saveUsermfileList(fmUsermfileListDomain);
            fmUsermfileListDomain.setUsermfileListCode(code);
            SXSSFWorkbook workBook = new SXSSFWorkbook();
            Sheet sheet = workBook.createSheet(fmUsermfile.getMfileName());
            Row title = sheet.createRow(0);
            FmUsermfileImpl.getTitleStyle(workBook, title);
            FmUsermfileImpl.InitExcelHead(workBook, sheet, headers);
            Map<String, Object> map = this.makeParam(fmUsermfile.getUsermfileWhere());
            map.put("tenantCode", fmUsermfile.getTenantCode());
            boolean boo = true;
            while (boo) {
                map.put("page", page);
                map.put("rows", rows);
                map.put(dao_startRow, Long.valueOf(Long.valueOf(rows.intValue()).intValue() * (Long.valueOf(page.intValue()).intValue() - 1)).intValue());
                map.put(dao_endRow, Long.valueOf(rows.intValue()).intValue() * Long.valueOf(page.intValue()).intValue());
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("map", JsonUtil.buildNormalBinder().toJson(map));
                this.logger.error("fm.FILE.FmUsermfileImpl.getData.param", (Object)JsonUtil.buildNormalBinder().toJson(params));
                String data = this.getData(fmUsermfile.getMfileApicode(), params);
                if (StringUtils.isEmpty((String)data)) {
                    this.logger.error("fm.FILE.FmUsermfileImpl.returnCallEx.data is null");
                    return false;
                }
                Map param = (Map)JsonUtil.buildNormalBinder().getJsonToMap(data, String.class, Object.class);
                if (MapUtil.isEmpty((Map)param)) {
                    this.logger.error("fm.FILE.FmUsermfileImpl.returnCallEx.param is null");
                    return false;
                }
                List maps = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(param.get("list")), Map.class);
                if (ListUtil.isEmpty((Collection)maps)) {
                    this.logger.error("fm.FILE.FmUsermfileImpl.returnCallEx.maps is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)param));
                    return false;
                }
                List<Object[]> objects = this.returnCallEx(mfile.getMfileEcontext(), maps, headMapList, map);
                StringBuffer buffer = new StringBuffer();
                int i = Long.valueOf(Long.valueOf(rows.intValue()).intValue() * (Long.valueOf(page.intValue()).intValue() - 1)).intValue();
                for (Object[] object : objects) {
                    Row row = sheet.createRow(i + 1 - starMfileNum);
                    ++i;
                    for (int j = 0; j < object.length; ++j) {
                        buffer.append(object[j]);
                        row.createCell(j).setCellValue(buffer.toString());
                        buffer.delete(0, buffer.length());
                    }
                }
                Integer total = rows * page;
                Integer rtotal = (int)((Integer)param.get("total"));
                mfileCutsizeTotal = mfile.getMfileCutsize() * mfileNum;
                if (mfileCutsizeTotal >= rtotal) {
                    mfileCut = false;
                }
                if (total >= rtotal || total >= endMfileNum) {
                    boo = false;
                }
                this.logger.error("fm.FILE.FmUsermfileImpl.returnCallEx.rtotal", (Object)rtotal);
                this.logger.error("fm.FILE.FmUsermfileImpl.returnCallEx.total", (Object)total);
                this.logger.error("fm.FILE.FmUsermfileImpl.returnCallEx.mfileCutsizeTotal", (Object)mfileCutsizeTotal);
                this.logger.error("fm.FILE.FmUsermfileImpl.returnCallEx.endMfileNum", (Object)endMfileNum);
                Integer n2 = page;
                Integer n3 = page = Integer.valueOf(page + 1);
            }
            this.excelExport(workBook, fmUsermfileListDomain, fmUsermfile);
            this.updateUsermfileListStateByCode(fmUsermfile.getTenantCode(), code, FileConstants.fmUsermFileListDataState1, FileConstants.fmUsermFileListDataState0, null);
            fileNames.add(fmUsermfileListDomain.getUsermfileUrlpath());
        } while (mfileCut);
        if (null != mfile.getMfileCom() && 1 == mfile.getMfileCom() || "zip".equals(fmUsermfile.getMfileCtype())) {
            fmUsermfile.setUsermfileUrlpath("/" + fmUsermfile.getMfileName() + fmUsermfile.getUsermfileCode() + ".zip");
            fmUsermfile.setMfileCtype("zip");
            File file = new File(fmUsermfile.getUsermfileUrlpath());
            File[] srcfile = new File[fileNames.size()];
            int n = fileNames.size();
            for (int i = 0; i < n; ++i) {
                srcfile[i] = new File((String)fileNames.get(i));
            }
            FmUsermfileImpl.zipFiles(srcfile, file);
            FmUsermfileImpl.deleteFile(fileNames);
        }
        this.logger.error("fm.FILE.FmUsermfileImpl.returnCallEx.fmUsermfile ", (Object)JsonUtil.buildNormalBinder().toJson((Object)fmUsermfile));
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(fmUsermfile.getMfileName());
        fmFileReDomainBean.setFileOwner(fmUsermfile.getUserCode());
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileSort("FILE_usermfile");
        fmFileReDomainBean.setTenantCode(fmUsermfile.getTenantCode());
        fmFileReDomainBean.setRootPath(fmUsermfile.getTenantCode() + "/");
        byte[] bytes = null;
        try {
            bytes = FmUsermfileImpl.InputStreamByteArray(fmUsermfile.getUsermfileUrlpath());
        }
        catch (Exception e) {
            this.logger.error(".Exception", (Throwable)e);
            return false;
        }
        ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(fmUsermfile.getMfileCtype());
        fileBean.setOriginalFilename(fmUsermfile.getMfileName());
        fileBean.setSize(Long.valueOf(1L));
        fileBeanList.add(fileBean);
        FmFile fmFile = this.fileService.saveFileByType(fmFileReDomainBean, fileBeanList);
        this.logger.error(".saveFileByType", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)fmFile));
        File file = new File(fmUsermfile.getUsermfileUrlpath());
        if (file.exists()) {
            file.delete();
        }
        FmUsermfile usermfileByCode = this.getUsermfileByCode(fmUsermfile.getTenantCode(), fmUsermfile.getUsermfileCode());
        this.logger.error(".usermfileByCode", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)usermfileByCode));
        usermfileByCode.setUsermfileUrl(fmFile.getFileUrl());
        this.updateUsermfileModel(usermfileByCode);
        return true;
    }

    public static void deleteFile(List<String> fileNames) {
        String sPath = null;
        File file = null;
        boolean flag = false;
        try {
            for (int i = 0; i < fileNames.size(); ++i) {
                sPath = fileNames.get(i);
                file = new File(sPath);
                if (!file.exists()) continue;
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipFiles(File[] srcFiles, File zipFile) {
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = null;
            for (int i = 0; i < srcFiles.length; ++i) {
                int len;
                fileInputStream = new FileInputStream(srcFiles[i]);
                zipEntry = new ZipEntry(srcFiles[i].getName());
                zipOutputStream.putNextEntry(zipEntry);
                byte[] buffer = new byte[1024];
                while ((len = fileInputStream.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
            }
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getData(String mfileApicode, Map<String, Object> param) {
        if (StringUtils.isEmpty((String)mfileApicode)) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getData", (Object)"mfileApicode is null");
            return null;
        }
        String s = null;
        try {
            s = (String)this.getInternalRouter().inInvoke(mfileApicode, param);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.getData.s", (Object)s);
            this.logger.error("fm.FILE.FmUsermfileImpl.getData.e", (Throwable)e);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excelExport(SXSSFWorkbook workBook, FmUsermfileListDomain fmUsermfileList, FmUsermfile usermfile) {
        FileOutputStream fileOut = null;
        try {
            File file = new File(fmUsermfileList.getUsermfileUrlpath());
            this.logger.error("fm.FILE.FmUsermfileImpl.excelExport.srcFile1", (Object)JsonUtil.buildNormalBinder().toJson((Object)file));
            if (file.exists()) {
                this.logger.error("fm.FILE.FmUsermfileImpl.excelExport.srcFile", (Object)fmUsermfileList.getUsermfileUrlpath());
                file.delete();
            }
            fileOut = new FileOutputStream(file);
            workBook.write((OutputStream)fileOut);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void getTitleStyle(SXSSFWorkbook workbook, Row title) {
        CellStyle style = workbook.createCellStyle();
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)16);
        font.setBoldweight((short)700);
        style.setFont(font);
    }

    public static Row InitExcelHead(SXSSFWorkbook workBook, Sheet sheet, String[] head) {
        Row row = sheet.createRow(0);
        CellStyle style = FmUsermfileImpl.getHeaderStyle(workBook);
        for (int i = 0; i < head.length; ++i) {
            row.createCell(i).setCellValue(head[i]);
            row.getCell(i).setCellStyle(style);
        }
        return row;
    }

    public static CellStyle getHeaderStyle(SXSSFWorkbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setBorderBottom((short)2);
        style.setBorderLeft((short)2);
        style.setBorderRight((short)2);
        style.setBorderTop((short)2);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        style.setTopBorderColor((short)8);
        style.setBottomBorderColor((short)8);
        style.setLeftBorderColor((short)8);
        style.setRightBorderColor((short)8);
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)14);
        font.setBoldweight((short)700);
        style.setFont(font);
        return style;
    }

    private void error(FmUsermfileListDomain fmUsermfileListDomain, String memo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.logger.error("fm.FILE.FmUsermfileImpl.startUsermfile.saveFileParam", (Object)memo);
        map.put("memo", memo);
        this.updateUsermfileListStateByCode(fmUsermfileListDomain.getTenantCode(), fmUsermfileListDomain.getUsermfileListCode(), FileConstants.fmUsermFileListDataState_1, FileConstants.fmUsermFileListDataState0, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] InputStreamByteArray(String filePath) throws IOException {
        byte[] var3;
        FileInputStream in = null;
        try {
            byte[] data;
            in = new FileInputStream(filePath);
            var3 = data = FmUsermfileImpl.toByteArray(in);
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            byte[] var4;
            int n;
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            boolean var3 = false;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = var4 = out.toByteArray();
            return byArray;
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    private Map<String, Object> makeParam(String usermfileWhere) {
        Map<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)usermfileWhere)) {
            param = (Map)JsonUtil.buildNormalBinder().getJsonToMap(usermfileWhere, String.class, Object.class);
        }
        return param;
    }

    private List<Map<String, Object>> getExcelParam(String reparseStr, String paramStr) {
        Object dataCall;
        Map<String, Object> param;
        if (StringUtils.isEmpty((String)reparseStr)) {
            this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.reparseStr", (Object)"reparseStr is null");
            return null;
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)paramStr) && null != (param = this.makeParam(paramStr)) && "true".equals(param.get("isParam"))) {
            flag = true;
        }
        if (flag) {
            dataCall = (DataCallEx)GroovyUtil.executeCalculate((String)reparseStr);
            if (null == dataCall) {
                this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.dataCall", (Object)JsonUtil.buildNormalBinder().toJson((Object)reparseStr));
                return null;
            }
            List<Map<String, Object>> param2 = null;
            try {
                param2 = dataCall.callEx();
                if (ListUtil.isEmpty(param2)) {
                    this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.param", (Object)reparseStr);
                    return null;
                }
            }
            catch (Exception e) {
                this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.e", (Object)(e + "-" + reparseStr));
                return null;
            }
            return param2;
        }
        dataCall = (DataCall)GroovyUtil.executeCalculate((String)reparseStr);
        if (null == dataCall) {
            this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.dataCall", (Object)JsonUtil.buildNormalBinder().toJson((Object)reparseStr));
            return null;
        }
        List<Map<String, Object>> param3 = null;
        try {
            param3 = dataCall.callEx();
            if (ListUtil.isEmpty(param3)) {
                this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.param", (Object)reparseStr);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.e", (Object)(e + "-" + reparseStr));
            return null;
        }
        return param3;
    }

    private List<Object[]> returnCallEx(String reparseStr, List<Map<String, Object>> maps, List<Map<String, Object>> headMapList, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)reparseStr)) {
            this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.reparseStr", (Object)"reparseStr is null");
            return null;
        }
        if (null != map.get("isParam") && "true".equals(map.get("isParam"))) {
            DataCallEx dataCall = (DataCallEx)GroovyUtil.executeCalculate((String)reparseStr);
            if (null == dataCall) {
                this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.dataCall", (Object)JsonUtil.buildNormalBinder().toJson((Object)reparseStr));
                return null;
            }
            List<Object[]> param = null;
            try {
                param = dataCall.returnCallEx(maps, headMapList, map);
                if (ListUtil.isEmpty(param)) {
                    this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.param", (Object)reparseStr);
                    return null;
                }
            }
            catch (Exception e) {
                this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.e", (Object)(e + "-" + reparseStr));
                return null;
            }
            return param;
        }
        DataCall dataCall = (DataCall)GroovyUtil.executeCalculate((String)reparseStr);
        if (null == dataCall) {
            this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.dataCall", (Object)JsonUtil.buildNormalBinder().toJson((Object)reparseStr));
            return null;
        }
        List<Object[]> param = null;
        try {
            param = dataCall.returnCallEx(maps, headMapList);
            if (ListUtil.isEmpty(param)) {
                this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.param", (Object)reparseStr);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUsermfileImpl.analysisData.e", (Object)(e + "-" + reparseStr));
            return null;
        }
        return param;
    }

    private Boolean getCron(Date sysDate, FmUsermfile fmUsermfile) {
        if (StringUtils.isEmpty((String)fmUsermfile.getMfileQcon())) {
            this.logger.error("fm.FILE.FmUsermfileImpl.doUsermfileStartAll.fmUsermfile is null ", (Object)JsonUtil.buildNormalBinder().toJson((Object)fmUsermfile));
            return false;
        }
        CronExpression cronExpression = null;
        try {
            cronExpression = new CronExpression(fmUsermfile.getMfileQcon());
            if (null == cronExpression) {
                this.logger.error("fm.FILE.FmUsermfileImpl.doUsermfileStartAll.cronExpression is null ", (Object)JsonUtil.buildNormalBinder().toJson((Object)fmUsermfile));
                return false;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return cronExpression.isSatisfiedBy(sysDate);
    }

    static {
        lock = new Object();
        dao_startRow = "startRow";
        dao_endRow = "endRow";
    }
}

