/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.file.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;

public class PngDPIProcessor {
    public static void updatePngImageDpiByImage(BufferedImage image, String path, String imageName, String imageType, int dpi) throws IOException {
        String imageInputPath = path + "\\" + imageName + "." + imageType;
        File output = new File(imageInputPath);
        PngDPIProcessor.updatePngImageDpi(output, image, dpi);
    }

    public static void updatePngImageDpi(String path, String imageName, String imageType, int dpi) throws IOException {
        String imageInputPath = path + "\\" + imageName + "." + imageType;
        File input = new File(imageInputPath);
        File output = new File(imageInputPath);
        BufferedImage image = ImageIO.read(input);
        PngDPIProcessor.updatePngImageDpi(output, image, dpi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePngImageDpi(File output, BufferedImage gridImage, int dpi) throws IOException {
        output.delete();
        String formatName = "png";
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName("png");
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            PngDPIProcessor.setDPI(metadata, dpi);
            try (ImageOutputStream stream = ImageIO.createImageOutputStream(output);){
                writer.setOutput(stream);
                writer.write(metadata, new IIOImage(gridImage, null, metadata), writeParam);
                break;
            }
        }
    }

    private static void setDPI(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double INCH_2_CM = 2.54;
        double dotsPerMilli = 1.0 * (double)dpi / 10.0 / INCH_2_CM;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }
}

