/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.file.service.impl;

import com.yqbsoft.laser.service.dynamic.GroovyUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.file.dao.FmUpUserFileMapper;
import com.yqbsoft.laser.service.file.domain.FmUpUserFileDomain;
import com.yqbsoft.laser.service.file.domain.FmUpUserFileListDomain;
import com.yqbsoft.laser.service.file.domain.FmUpUserFileListReDomain;
import com.yqbsoft.laser.service.file.domain.FmUpUserFileReDomain;
import com.yqbsoft.laser.service.file.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.file.model.FmFile;
import com.yqbsoft.laser.service.file.model.FmUpFile;
import com.yqbsoft.laser.service.file.model.FmUpUserFile;
import com.yqbsoft.laser.service.file.service.FileService;
import com.yqbsoft.laser.service.file.service.FmUpFileService;
import com.yqbsoft.laser.service.file.service.FmUpUserFileListService;
import com.yqbsoft.laser.service.file.service.FmUpUserFileService;
import com.yqbsoft.laser.service.file.util.DataCall;
import com.yqbsoft.laser.service.file.util.DataCallEx;
import com.yqbsoft.laser.service.file.util.DoDataCall;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FmUpUserFileServiceImpl
extends BaseServiceImpl
implements FmUpUserFileService {
    private static final String SYS_CODE = "fm.FILE.FmUpUserFileServiceImpl";
    private FmUpUserFileMapper fmUpUserFileMapper;
    private static String dao_startRow = "startRow";
    private static String dao_endRow = "endRow";
    private FileService fileService;
    private FmUpFileService fmUpFileService;
    private FmUpUserFileListService fmUpUserFileListService;

    public void setFmUpUserFileMapper(FmUpUserFileMapper fmUpUserFileMapper) {
        this.fmUpUserFileMapper = fmUpUserFileMapper;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public void setFmUpFileService(FmUpFileService fmUpFileService) {
        this.fmUpFileService = fmUpFileService;
    }

    public void setFmUpUserFileListService(FmUpUserFileListService fmUpUserFileListService) {
        this.fmUpUserFileListService = fmUpUserFileListService;
    }

    private Date getSysDate() {
        try {
            return this.fmUpUserFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFmUpUserFile(FmUpUserFileDomain fmUpUserFileDomain) {
        if (null == fmUpUserFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fmUpUserFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFmUpUserFileDefault(FmUpUserFile fmUpUserFile) {
        if (null == fmUpUserFile) {
            return;
        }
        if (null == fmUpUserFile.getDataState()) {
            fmUpUserFile.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == fmUpUserFile.getGmtCreate()) {
            fmUpUserFile.setGmtCreate(date);
        }
        fmUpUserFile.setGmtModified(date);
        if (StringUtils.isBlank((String)fmUpUserFile.getUpuserfileCode())) {
            fmUpUserFile.setUpuserfileCode(this.getNo(null, "FmUpUserFile", "fmUpUserFile", fmUpUserFile.getTenantCode()));
        }
    }

    private int getFmUpUserFileMaxCode() {
        int code = 0;
        try {
            return this.fmUpUserFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.getFmUpUserFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFmUpUserFileUpdataDefault(FmUpUserFile fmUpUserFile) {
        if (null == fmUpUserFile) {
            return;
        }
        fmUpUserFile.setGmtModified(this.getSysDate());
    }

    private void saveFmUpUserFileModel(FmUpUserFile fmUpUserFile) throws ApiException {
        if (null == fmUpUserFile) {
            return;
        }
        try {
            this.fmUpUserFileMapper.insert(fmUpUserFile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.saveFmUpUserFileModel.ex", (Throwable)e);
        }
    }

    private void saveFmUpUserFileBatchModel(List<FmUpUserFile> fmUpUserFileList) throws ApiException {
        if (null == fmUpUserFileList || fmUpUserFileList.isEmpty()) {
            return;
        }
        try {
            this.fmUpUserFileMapper.insertBatch(fmUpUserFileList);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.saveFmUpUserFileBatchModel.ex", (Throwable)e);
        }
    }

    private FmUpUserFile getFmUpUserFileModelById(Integer upuserfileId) {
        if (null == upuserfileId) {
            return null;
        }
        try {
            return this.fmUpUserFileMapper.selectByPrimaryKey(upuserfileId);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.getFmUpUserFileModelById", (Throwable)e);
            return null;
        }
    }

    private FmUpUserFile getFmUpUserFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.fmUpUserFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.getFmUpUserFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delFmUpUserFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUpUserFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.delFmUpUserFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.delFmUpUserFileModelByCode.num");
        }
    }

    private void deleteFmUpUserFileModel(Integer upuserfileId) throws ApiException {
        if (null == upuserfileId) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUpUserFileMapper.deleteByPrimaryKey(upuserfileId);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.deleteFmUpUserFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.deleteFmUpUserFileModel.num");
        }
    }

    private void updateFmUpUserFileModel(FmUpUserFile fmUpUserFile) throws ApiException {
        if (null == fmUpUserFile) {
            return;
        }
        int i = 0;
        try {
            i = this.fmUpUserFileMapper.updateByPrimaryKey(fmUpUserFile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.updateFmUpUserFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.updateFmUpUserFileModel.num");
        }
    }

    private void updateStateFmUpUserFileModel(Integer upuserfileId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upuserfileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upuserfileId", upuserfileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmUpUserFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.updateStateFmUpUserFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.updateStateFmUpUserFileModel.null");
        }
    }

    private void updateStateFmUpUserFileModelByCode(String tenantCode, String upuserfileCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upuserfileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upuserfileCode", upuserfileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.fmUpUserFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.updateStateFmUpUserFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.updateStateFmUpUserFileModelByCode.null");
        }
    }

    private FmUpUserFile makeFmUpUserFile(FmUpUserFileDomain fmUpUserFileDomain, FmUpUserFile fmUpUserFile) {
        if (null == fmUpUserFileDomain) {
            return null;
        }
        if (null == fmUpUserFile) {
            fmUpUserFile = new FmUpUserFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fmUpUserFile, (Object)fmUpUserFileDomain);
            return fmUpUserFile;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.makeFmUpUserFile", (Throwable)e);
            return null;
        }
    }

    private FmUpUserFileReDomain makeFmUpUserFileReDomain(FmUpUserFile fmUpUserFile) {
        if (null == fmUpUserFile) {
            return null;
        }
        FmUpUserFileReDomain fmUpUserFileReDomain = new FmUpUserFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)fmUpUserFileReDomain, (Object)fmUpUserFile);
            return fmUpUserFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.makeFmUpUserFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<FmUpUserFile> queryFmUpUserFileModelPage(Map<String, Object> parammap) {
        try {
            return this.fmUpUserFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.queryFmUpUserFileModel", (Throwable)e);
            return null;
        }
    }

    private int countFmUpUserFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fmUpUserFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.countFmUpUserFile", (Throwable)e);
        }
        return i;
    }

    private FmUpUserFile createFmUpUserFile(FmUpUserFileDomain fmUpUserFileDomain) {
        String msg = this.checkFmUpUserFile(fmUpUserFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.saveFmUpUserFile.checkFmUpUserFile", msg);
        }
        FmUpUserFile fmUpUserFile = this.makeFmUpUserFile(fmUpUserFileDomain, null);
        this.setFmUpUserFileDefault(fmUpUserFile);
        return fmUpUserFile;
    }

    @Override
    public String saveFmUpUserFile(FmUpUserFileDomain fmUpUserFileDomain) throws ApiException {
        FmUpUserFile fmUpUserFile = this.createFmUpUserFile(fmUpUserFileDomain);
        this.saveFmUpUserFileModel(fmUpUserFile);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("upfileSort", fmUpUserFileDomain.getUpfileSort());
        map.put("upfileType", fmUpUserFileDomain.getUpfileType());
        map.put("tenantCode", fmUpUserFileDomain.getTenantCode());
        map.put("order", true);
        map.put("fuzzy", true);
        QueryResult<FmUpFile> fmUpFileQueryResult = this.fmUpFileService.queryFmUpFilePage(map);
        if (null == fmUpFileQueryResult || ListUtil.isEmpty((Collection)fmUpFileQueryResult.getList())) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.saveFmUpUserFile.fmUpFile is null");
            return null;
        }
        if (!this.inExecution((FmUpFile)fmUpFileQueryResult.getList().get(0), fmUpUserFile).booleanValue()) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.saveFmUpUserFile.inExecution.e", (Object)"\u89e3\u6790\u5f02\u5e38");
            return "error";
        }
        return fmUpUserFile.getUpuserfileCode();
    }

    @Override
    public String saveFmUpUserFileBatch(List<FmUpUserFileDomain> fmUpUserFileDomainList) throws ApiException {
        if (null == fmUpUserFileDomainList || fmUpUserFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<FmUpUserFile> fmUpUserFileList = new ArrayList<FmUpUserFile>();
        String code = "";
        for (FmUpUserFileDomain fmUpUserFileDomain : fmUpUserFileDomainList) {
            FmUpUserFile fmUpUserFile = this.createFmUpUserFile(fmUpUserFileDomain);
            code = fmUpUserFile.getUpuserfileCode();
            fmUpUserFileList.add(fmUpUserFile);
        }
        this.saveFmUpUserFileBatchModel(fmUpUserFileList);
        return code;
    }

    @Override
    public void updateFmUpUserFileState(Integer upuserfileId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upuserfileId) {
            return;
        }
        this.updateStateFmUpUserFileModel(upuserfileId, dataState, oldDataState, map);
    }

    @Override
    public void updateFmUpUserFileStateByCode(String tenantCode, String upuserfileCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upuserfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateFmUpUserFileModelByCode(tenantCode, upuserfileCode, dataState, oldDataState, map);
    }

    @Override
    public void updateFmUpUserFile(FmUpUserFileDomain fmUpUserFileDomain) throws ApiException {
        String msg = this.checkFmUpUserFile(fmUpUserFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.updateFmUpUserFile.checkFmUpUserFile", msg);
        }
        FmUpUserFile oldFmUpUserFile = this.getFmUpUserFileModelById(fmUpUserFileDomain.getUpuserfileId());
        if (null == oldFmUpUserFile) {
            throw new ApiException("fm.FILE.FmUpUserFileServiceImpl.updateFmUpUserFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FmUpUserFile fmUpUserFile = this.makeFmUpUserFile(fmUpUserFileDomain, oldFmUpUserFile);
        this.setFmUpUserFileUpdataDefault(fmUpUserFile);
        this.updateFmUpUserFileModel(fmUpUserFile);
    }

    @Override
    public FmUpUserFile getFmUpUserFile(Integer upuserfileId) {
        if (null == upuserfileId) {
            return null;
        }
        return this.getFmUpUserFileModelById(upuserfileId);
    }

    @Override
    public void deleteFmUpUserFile(Integer upuserfileId) throws ApiException {
        if (null == upuserfileId) {
            return;
        }
        this.deleteFmUpUserFileModel(upuserfileId);
    }

    @Override
    public QueryResult<FmUpUserFile> queryFmUpUserFilePage(Map<String, Object> map) {
        List<FmUpUserFile> fmUpUserFileList = this.queryFmUpUserFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFmUpUserFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fmUpUserFileList);
        return queryResult;
    }

    @Override
    public FmUpUserFile getFmUpUserFileByCode(String tenantCode, String upuserfileCode) throws ApiException {
        if (StringUtils.isBlank((String)upuserfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upuserfileCode", upuserfileCode);
        return this.getFmUpUserFileModelByCode(map);
    }

    @Override
    public void deleteFmUpUserFileByCode(String tenantCode, String upuserfileCode) throws ApiException {
        if (StringUtils.isBlank((String)upuserfileCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upuserfileCode", upuserfileCode);
        this.delFmUpUserFileModelByCode(map);
    }

    protected void makeDefPage(Map<String, Object> param) {
        this.logger.debug("SupperFacade.makeDefPage.", param);
        if (null != param) {
            int page = 1;
            int rows = 10;
            if (null == param.get("page")) {
                param.put("page", page);
                param.put("rows", rows);
                param.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
                param.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            } else {
                rows = Integer.valueOf(String.valueOf(param.get("rows")));
                page = Integer.valueOf(String.valueOf(param.get("page")));
                if (rows > 100) {
                    rows = 100;
                    param.put("rows", rows);
                }
                param.put(dao_startRow, Long.valueOf(Long.valueOf(rows).intValue() * (Long.valueOf(page).intValue() - 1)).intValue());
                param.put(dao_endRow, Long.valueOf(Long.valueOf(rows).intValue() * Long.valueOf(page).intValue()).intValue());
            }
        }
    }

    private FmUpUserFileListReDomain makeUpUserFileList(FmUpUserFile fmUpUserFile, FmUpUserFileListReDomain fmUpUserFileListDomain) {
        if (null == fmUpUserFile) {
            return null;
        }
        if (null == fmUpUserFileListDomain) {
            fmUpUserFileListDomain = new FmUpUserFileListReDomain();
        }
        fmUpUserFileListDomain.setUpuserfileCode(fmUpUserFile.getUpuserfileCode());
        fmUpUserFileListDomain.setTenantCode(fmUpUserFile.getTenantCode());
        fmUpUserFileListDomain.setMemberCode(fmUpUserFile.getMemberCode());
        fmUpUserFileListDomain.setGoodsClass(fmUpUserFile.getGoodsClass());
        return fmUpUserFileListDomain;
    }

    private void saveDataStateflow(FmUpUserFile fmUpUserFile, List<RsResourceGoodsDomain> goodsList) {
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.debug("fm.FILE.FmUpUserFileServiceImpl.importResourceGoodsPass", (Object)"goodsList is null");
        }
        this.logger.error("fm.FILE.FmUpUserFileServiceImpl.saveDataStateflow.goodsList", (Object)JsonUtil.buildNormalBinder().toJson(goodsList));
        AtomicInteger success = new AtomicInteger(0);
        AtomicInteger error = new AtomicInteger(0);
        ArrayList onResourceGoodsList = new ArrayList();
        ArrayList downResourceGoodsList = new ArrayList();
        List collect = goodsList.stream().filter(item -> {
            FmUpUserFileListReDomain fmUpUserFileListDomain = this.makeUpUserFileList(fmUpUserFile, null);
            if (StringUtils.isBlank((Integer)item.getDataOpbillstate()) || StringUtils.isBlank((String)item.getSkuBarcode())) {
                fmUpUserFileListDomain.setUpuserfileListNo(item.getSkuBarcode());
                fmUpUserFileListDomain.setDataState(0);
                this.fmUpUserFileListService.saveFmUpUserFileList(fmUpUserFileListDomain);
                error.getAndIncrement();
                return false;
            }
            return true;
        }).collect(Collectors.toMap(RsResourceGoodsDomain::getSkuBarcode, Function.identity(), (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
        List<CompletableFuture> futures = collect.stream().map(rsResourceGoodsDomain -> CompletableFuture.runAsync(() -> {
            FmUpUserFileListReDomain fmUpUserFileListDomain = this.makeUpUserFileList(fmUpUserFile, null);
            HashMap map = new HashMap();
            HashMap<String, String> paramStr = new HashMap<String, String>();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("memberCode", fmUpUserFile.getMemberCode());
            param.put("tenantCode", fmUpUserFile.getTenantCode());
            param.put("goodsOrigin", "0");
            param.put("skuBarcode", rsResourceGoodsDomain.getSkuBarcode());
            paramStr.put("map", JsonUtil.buildNormalBinder().toJson(param));
            String result = (String)this.getInternalRouter().inInvoke("rs.sku.querySkuOnePage", paramStr);
            SupQueryResult skuPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(result, SupQueryResult.class);
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.onResourceGoodsList.skuPage" + paramStr, (Object)JsonUtil.buildNormalBinder().toJson((Object)skuPage));
            if (skuPage != null && ListUtil.isNotEmpty((Collection)skuPage.getList())) {
                this.logger.error("fm.FILE.FmUpUserFileServiceImpl.rsResourceGoodsDomain.value", (Object)JsonUtil.buildNormalBinder().toJson(rsResourceGoodsDomain));
                Map rsSkuReDomainStr = (Map)skuPage.getList().get(0);
                Integer dataState = (Integer)rsSkuReDomainStr.get("dataOpbillstate");
                Integer skuId = (Integer)rsSkuReDomainStr.get("skuId");
                if (rsResourceGoodsDomain.getDataOpbillstate().equals(dataState)) {
                    fmUpUserFileListDomain.setUpuserfileError("\u72b6\u6001\u5f02\u5e38\uff0c\u5546\u54c1\u73b0\u72b6\u6001\u4e3a\uff1a" + dataState);
                    fmUpUserFileListDomain.setUpuserfileListNo(rsResourceGoodsDomain.getSkuBarcode());
                    fmUpUserFileListDomain.setDataState(0);
                    this.fmUpUserFileListService.saveFmUpUserFileList(fmUpUserFileListDomain);
                    error.getAndIncrement();
                } else {
                    this.logger.error("fm.FILE.FmUpUserFileServiceImpl.sucess");
                    if (1 == rsResourceGoodsDomain.getDataOpbillstate()) {
                        onResourceGoodsList.add(skuId);
                    } else {
                        downResourceGoodsList.add(skuId);
                    }
                    fmUpUserFileListDomain.setUpuserfileError("\u64cd\u4f5c\u6210\u529f");
                    fmUpUserFileListDomain.setUpuserfileListNo(rsResourceGoodsDomain.getSkuBarcode());
                    fmUpUserFileListDomain.setDataState(1);
                    this.logger.error("fm.FILE.FmUpUserFileServiceImpl.fmUpUserFileListDomain.params", (Object)JsonUtil.buildNormalBinder().toJson((Object)fmUpUserFileListDomain));
                    this.fmUpUserFileListService.saveFmUpUserFileList(fmUpUserFileListDomain);
                    success.getAndIncrement();
                }
            } else {
                fmUpUserFileListDomain.setUpuserfileError("\u5546\u54c1\u4e0d\u5b58\u5728");
                fmUpUserFileListDomain.setUpuserfileListNo(rsResourceGoodsDomain.getSkuBarcode());
                fmUpUserFileListDomain.setDataState(0);
                this.fmUpUserFileListService.saveFmUpUserFileList(fmUpUserFileListDomain);
                error.getAndIncrement();
            }
        })).collect(Collectors.toList());
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            allFutures.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.debug("importResourceGoodsPass.error", (Throwable)e);
        }
        this.logger.error("fm.FILE.FmUpUserFileServiceImpl.onResourceGoodsList.message", (Object)JsonUtil.buildNormalBinder().toJson(onResourceGoodsList));
        try {
            HashMap<String, String> param;
            if (ListUtil.isNotEmpty(onResourceGoodsList)) {
                param = new HashMap<String, String>();
                param.put("skuIdList", JsonUtil.buildNormalBinder().toJson(onResourceGoodsList));
                this.getInternalRouter().inInvoke("rs.resource.sendUpdateShelveBatchSku", param);
            }
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.onResourceGoodsList.message", (Object)JsonUtil.buildNormalBinder().toJson(downResourceGoodsList));
            if (ListUtil.isNotEmpty(downResourceGoodsList)) {
                param = new HashMap();
                param.put("skuIdList", JsonUtil.buildNormalBinder().toJson(downResourceGoodsList));
                this.getInternalRouter().inInvoke("rs.resource.sendUpdateSoldOutBatchSku", param);
            }
        }
        catch (Exception e) {
            this.logger.debug(".error", (Throwable)e);
        }
    }

    private Object getCellValue(Cell cell) {
        if (cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        if (cell.getCellType() == 0) {
            return (int)cell.getNumericCellValue();
        }
        if (cell.getCellType() == 4) {
            return cell.getBooleanCellValue();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean inExecution(FmUpFile fmUpFile, FmUpUserFile fmUpUserFile) {
        FmFile file = this.fileService.getFileByCode(fmUpUserFile.getTenantCode(), fmUpUserFile.getUpuserfileCode());
        byte[] fileContext = file.getFileContext();
        if (null == fileContext) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.inExecution.fileContext is null");
            return false;
        }
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        HttpURLConnection conn = null;
        try {
            URL url = new URL(fmUpFile.getUpfileUrl() + fmUpUserFile.getUpuserfileUrl());
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (InputStream inputStream = conn.getInputStream();){
            HashMap<String, Object> map = null;
            XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
            Sheet sheet = workbook.getSheetAt(0);
            String[] paramHeader = null;
            int skipfirst = 0;
            List<Map<String, Object>> headMapList = null;
            for (Row row : sheet) {
                if (skipfirst == 0) {
                    headMapList = this.getExcelParam(fmUpFile.getUpfileApiparam(), null);
                    if (ListUtil.isEmpty(headMapList)) {
                        this.logger.error("fm.FILE.FmUpUserFileServiceImpl.inExecution.headMapList is null");
                        Boolean bl = false;
                        return bl;
                    }
                    paramHeader = new String[headMapList.size()];
                } else {
                    map = new HashMap<String, Object>();
                }
                int colum = 0;
                int headnum = 0;
                for (Cell cell : row) {
                    if (skipfirst == 0) {
                        for (Map<String, Object> head : headMapList) {
                            if (!head.get("showName").equals(this.getCellValue(cell))) continue;
                            paramHeader[headnum] = (String)head.get("dataName");
                            ++headnum;
                        }
                        continue;
                    }
                    map.put(paramHeader[colum], this.getCellValue(cell));
                    if (++colum < headMapList.size()) continue;
                }
                ++skipfirst;
                if (null == map) continue;
                data.add(map);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (ListUtil.isEmpty(data)) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.inExecution.data is null");
            return false;
        }
        List<Map<String, Object>> upUserFileListMap = this.doStart(fmUpFile.getUpfileReturn(), fmUpUserFile, data);
        if (null == upUserFileListMap) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.inExecution.upUserFileListMap is null");
            return false;
        }
        this.logger.error("fm.FILE.FmUpUserFileServiceImpl.json.value", (Object)JsonUtil.buildNormalBinder().toJson(upUserFileListMap));
        ArrayList<FmUpUserFileListDomain> fmUpUserFileListDomainList = new ArrayList<FmUpUserFileListDomain>();
        for (Map<String, Object> map : upUserFileListMap) {
            FmUpUserFileListDomain fmUpUserFileListDomain = new FmUpUserFileListDomain();
            fmUpUserFileListDomain.setMemberCode((String)map.get("memberCode"));
            fmUpUserFileListDomain.setUpuserfileListNo((String)map.get("upuserfileListNo"));
            fmUpUserFileListDomain.setGoodsClass((String)map.get("goodsClass"));
            fmUpUserFileListDomain.setUpuserfileError1((String)map.get("dataState"));
            fmUpUserFileListDomain.setTenantCode((String)map.get("tenantCode"));
            fmUpUserFileListDomain.setUpuserfileCode((String)map.get("upuserfileCode"));
            fmUpUserFileListDomain.setUpuserfileError((String)map.get("upuserfileError"));
            fmUpUserFileListDomainList.add(fmUpUserFileListDomain);
        }
        if (ListUtil.isEmpty(fmUpUserFileListDomainList)) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.inExecution.fmUpUserFileListDomainList is null");
            return false;
        }
        this.fmUpUserFileListService.saveFmUpUserFileListBatch(fmUpUserFileListDomainList);
        return true;
    }

    private List<Map<String, Object>> getExcelParam(String reparseStr, String paramStr) {
        Object dataCall;
        Map<String, Object> param;
        if (StringUtils.isEmpty((String)reparseStr)) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.reparseStr", (Object)"reparseStr is null");
            return null;
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)paramStr) && null != (param = this.makeParam(paramStr)) && "true".equals(param.get("isParam"))) {
            flag = true;
        }
        if (flag) {
            dataCall = (DataCallEx)GroovyUtil.executeCalculate((String)reparseStr);
            if (null == dataCall) {
                this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.dataCall", (Object)JsonUtil.buildNormalBinder().toJson((Object)reparseStr));
                return null;
            }
            List<Map<String, Object>> param2 = null;
            try {
                param2 = dataCall.callEx();
                if (ListUtil.isEmpty(param2)) {
                    this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.param", (Object)reparseStr);
                    return null;
                }
            }
            catch (Exception e) {
                this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.e", (Object)(e + "-" + reparseStr));
                return null;
            }
            return param2;
        }
        dataCall = (DataCall)GroovyUtil.executeCalculate((String)reparseStr);
        if (null == dataCall) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.dataCall", (Object)JsonUtil.buildNormalBinder().toJson((Object)reparseStr));
            return null;
        }
        List<Map<String, Object>> param3 = null;
        try {
            param3 = dataCall.callEx();
            if (ListUtil.isEmpty(param3)) {
                this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.param", (Object)reparseStr);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.e", (Object)(e + "-" + reparseStr));
            return null;
        }
        return param3;
    }

    private List<Map<String, Object>> doStart(String reparseStr, FmUpUserFile fmUpUserFile, List<Map<String, Object>> goodsList) {
        if (StringUtils.isEmpty((String)reparseStr)) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.reparseStr", (Object)"reparseStr is null");
            return null;
        }
        DoDataCall doDataCall = (DoDataCall)GroovyUtil.executeCalculate((String)reparseStr);
        if (null == doDataCall) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.dataCall", (Object)JsonUtil.buildNormalBinder().toJson((Object)reparseStr));
            return null;
        }
        List<Map<String, Object>> param = null;
        try {
            param = doDataCall.saveDataStateflow(fmUpUserFile, goodsList, this.getInternalRouter());
            if (ListUtil.isEmpty(param)) {
                this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.param", (Object)reparseStr);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FmUpUserFileServiceImpl.analysisData.e", (Object)(e + "-" + reparseStr));
            return null;
        }
        return param;
    }

    private Map<String, Object> makeParam(String usermfileWhere) {
        Map<String, Object> param = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)usermfileWhere)) {
            param = JsonUtil.buildNormalBinder().getJsonToMap(usermfileWhere, String.class, Object.class);
        }
        return param;
    }
}

