/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.file.service.impl;

import com.yqbsoft.laser.service.dynamic.GroovyUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.file.domain.FmUpUserFileDomain;
import com.yqbsoft.laser.service.file.es.UpUserFileSendPollThread;
import com.yqbsoft.laser.service.file.es.UpUserFileSendPutThread;
import com.yqbsoft.laser.service.file.es.UpUserFileSendService;
import com.yqbsoft.laser.service.file.model.FmUpFile;
import com.yqbsoft.laser.service.file.model.FmUpUserFile;
import com.yqbsoft.laser.service.file.model.FmUpUserFileList;
import com.yqbsoft.laser.service.file.service.FmUpFileService;
import com.yqbsoft.laser.service.file.service.FmUpUserFileBaseService;
import com.yqbsoft.laser.service.file.service.FmUpUserFileListService;
import com.yqbsoft.laser.service.file.service.FmUpUserFileService;
import com.yqbsoft.laser.service.file.util.UpDataCallApi;
import com.yqbsoft.laser.service.file.util.UpDataReturnApi;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FmUpUserFileBaseServiceImpl
extends BaseServiceImpl
implements FmUpUserFileBaseService {
    private static final String SYS_CODE = "fm.FILE.FmUpUserFileBaseServiceImpl";
    private FmUpFileService fmUpFileService;
    private FmUpUserFileService fmUpUserFileService;
    private FmUpUserFileListService fmUpUserFileListService;
    private static UpUserFileSendService upUserFileSendService;
    private static Object lock;

    public void setFmUpUserFileService(FmUpUserFileService fmUpUserFileService) {
        this.fmUpUserFileService = fmUpUserFileService;
    }

    public void setFmUpFileService(FmUpFileService fmUpFileService) {
        this.fmUpFileService = fmUpFileService;
    }

    public void setFmUpUserFileListService(FmUpUserFileListService fmUpUserFileListService) {
        this.fmUpUserFileListService = fmUpUserFileListService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpUserFileSendService getUpUserFileSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == upUserFileSendService) {
                upUserFileSendService = new UpUserFileSendService((FmUpUserFileBaseService)SpringApplicationContextUtil.getBean((String)"fmUpUserFileBaseService"));
                for (int i = 0; i < 100; ++i) {
                    upUserFileSendService.addPollPool(new UpUserFileSendPollThread(upUserFileSendService));
                }
            }
            return upUserFileSendService;
        }
    }

    @Override
    public void doUpUserFileStartAll(String tenantCode, int rows) throws ApiException {
        QueryResult<FmUpUserFileList> relist;
        FmUpUserFile fmUpUserFile;
        int i;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("order", true);
        map.put("orderStr", "UPUSERFILE_ID desc");
        map.put("tenantCode", tenantCode);
        map.put("dataStateStr", "0,1");
        map.put("page", 1);
        map.put("rows", 10);
        map.put("startRow", 0);
        map.put("endRow", 10);
        QueryResult<FmUpUserFile> qlist = this.fmUpUserFileService.queryFmUpUserFilePage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.doUpUserFileStartAll.list", (Object)((Object)map).toString());
            return;
        }
        HashMap<String, Object> listmap = new HashMap<String, Object>();
        listmap.put("tenantCode", tenantCode);
        listmap.put("dataStateStr", "0");
        for (i = 0; i <= rows; ++i) {
            fmUpUserFile = (FmUpUserFile)qlist.getList().get(i);
            listmap.put("upuserfileCode", fmUpUserFile.getUpuserfileCode());
            relist = this.fmUpUserFileListService.queryFmUpUserFileListPage(listmap);
            if (!ListUtil.isNotEmpty((Collection)relist.getList())) continue;
            FmUpUserFileBaseServiceImpl.getUpUserFileSendService().addPutPool(new UpUserFileSendPutThread(FmUpUserFileBaseServiceImpl.getUpUserFileSendService(), relist.getList()));
        }
        listmap.put("dataStateStr", "1");
        for (i = 0; i <= rows; ++i) {
            fmUpUserFile = (FmUpUserFile)qlist.getList().get(i);
            listmap.put("upuserfileCode", fmUpUserFile.getUpuserfileCode());
            relist = this.fmUpUserFileListService.queryFmUpUserFileListPage(listmap);
            if (!ListUtil.isNotEmpty((Collection)relist.getList())) continue;
            FmUpUserFileBaseServiceImpl.getUpUserFileSendService().addPutPool(new UpUserFileSendPutThread(FmUpUserFileBaseServiceImpl.getUpUserFileSendService(), relist.getList()));
        }
    }

    @Override
    public void sendSaveUpUserFile(FmUpUserFileDomain fmUpUserFileDomain) throws ApiException {
        String upUserFileCode = this.fmUpUserFileService.saveFmUpUserFile(fmUpUserFileDomain);
        if (StringUtils.isBlank((String)upUserFileCode)) {
            this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.sendUpUserFile.upUserFileCode");
            return;
        }
    }

    @Override
    public void sendUpUserFileList(FmUpUserFileList fmUpUserFileList) throws ApiException {
        String json;
        QueryResult<FmUpFile> flist;
        if (null == fmUpUserFileList) {
            return;
        }
        FmUpUserFile fmUpUserFile = this.fmUpUserFileService.getFmUpUserFileByCode(fmUpUserFileList.getTenantCode(), fmUpUserFileList.getUpuserfileCode());
        if (null == fmUpUserFile) {
            this.updateFmUpUserFileListStateByCode(fmUpUserFileList.getTenantCode(), fmUpUserFileList.getUpuserfileCode(), fmUpUserFileList.getUpuserfileListCode(), 2, fmUpUserFileList.getDataState(), null);
            return;
        }
        FmUpFile fmUpFile = this.fmUpFileService.getFmUpFileByCode(fmUpUserFile.getTenantCode(), fmUpUserFile.getUpfileCode());
        if (null == fmUpFile) {
            this.updateFmUpUserFileListStateByCode(fmUpUserFileList.getTenantCode(), fmUpUserFileList.getUpuserfileCode(), fmUpUserFileList.getUpuserfileListCode(), 2, fmUpUserFileList.getDataState(), null);
            return;
        }
        if (StringUtils.isNotBlank((String)fmUpUserFileList.getUpuserfileListNo2()) && null != (flist = this.fmUpFileService.queryFmUpFilePage(this.getQueryParamMap("tenantCode,upfileSort,upfileType", new Object[]{fmUpUserFileList.getTenantCode(), fmUpUserFileList.getUpuserfileListNo2(), fmUpUserFileList.getUpuserfileListNo1()}))) && ListUtil.isNotEmpty((Collection)flist.getList())) {
            fmUpFile = (FmUpFile)flist.getList().get(0);
        }
        if (StringUtils.isBlank((String)(json = fmUpUserFileList.getUpuserfileListJson()))) {
            this.updateFmUpUserFileListStateByCode(fmUpUserFileList.getTenantCode(), fmUpUserFileList.getUpuserfileCode(), fmUpUserFileList.getUpuserfileListCode(), 2, fmUpUserFileList.getDataState(), null);
            return;
        }
        Map odatamap = JsonUtil.getNotNullJsonUtil().getJsonToMap(json, String.class, Object.class);
        String apicode = fmUpFile.getUpfileApicode();
        if (StringUtils.isBlank((String)apicode)) {
            this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.sendUpUserFileList.apicode", (Object)(fmUpUserFile.getTenantCode() + "-" + fmUpUserFile.getUpfileCode()));
            return;
        }
        String reparseStr = fmUpFile.getUpfileApiparam();
        if (StringUtils.isBlank((String)reparseStr)) {
            this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.sendUpUserFileList.reparseStr", (Object)(fmUpUserFile.getTenantCode() + "-" + fmUpUserFile.getUpfileCode()));
            return;
        }
        String returnStr = fmUpFile.getUpfileReturn();
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        boolean refalg = false;
        Integer dataState = 2;
        if (1 != fmUpUserFileList.getDataState()) {
            refalg = this.sendApi(apicode, reparseStr, returnStr, odatamap, pmap);
            dataState = 2;
            if (refalg) {
                dataState = 1;
            } else {
                pmap.put("upuserfileError", pmap.get("msg"));
            }
            this.updateFmUpUserFileListStateByCode(fmUpUserFileList.getTenantCode(), fmUpUserFileList.getUpuserfileCode(), fmUpUserFileList.getUpuserfileListCode(), dataState, fmUpUserFileList.getDataState(), pmap);
        } else {
            refalg = true;
        }
        if (refalg) {
            String reparseStr1;
            String apicode1 = fmUpFile.getUpfileApicode1();
            if (StringUtils.isBlank((String)apicode1)) {
                this.updateFmUpUserFileListStateByCode(fmUpUserFileList.getTenantCode(), fmUpUserFileList.getUpuserfileCode(), fmUpUserFileList.getUpuserfileListCode(), 3, fmUpUserFileList.getDataState(), pmap);
            }
            if (StringUtils.isBlank((String)(reparseStr1 = fmUpFile.getUpfileApiparam1()))) {
                this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.sendUpUserFileList.reparseStr1", (Object)(fmUpUserFile.getTenantCode() + "-" + fmUpUserFile.getUpfileCode()));
                return;
            }
            String returnStr1 = fmUpFile.getUpfileReturn1();
            pmap = new HashMap();
            refalg = this.sendApi(apicode1, reparseStr1, returnStr1, odatamap, pmap);
            dataState = 4;
            if (refalg) {
                dataState = 3;
            } else {
                pmap.put("upuserfileError1", pmap.get("msg"));
            }
            this.updateFmUpUserFileListStateByCode(fmUpUserFileList.getTenantCode(), fmUpUserFileList.getUpuserfileCode(), fmUpUserFileList.getUpuserfileListCode(), dataState, fmUpUserFileList.getDataState(), pmap);
        }
    }

    private void updateFmUpUserFileListStateByCode(String tenantCode, String upuserfileCode, String upuserfileListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        HashMap<String, Object> mmap = new HashMap<String, Object>();
        if (dataState == 3) {
            mmap.put("upuserfileMnum", 1);
        } else if (dataState == 2 || dataState == 4) {
            mmap.put("upuserfileEnum", 1);
        }
        this.fmUpUserFileService.updateFmUpUserFileStateByCode(tenantCode, upuserfileCode, 1, null, mmap);
        this.fmUpUserFileListService.updateFmUpUserFileListStateByCode(tenantCode, upuserfileListCode, dataState, oldDataState, map);
        FmUpUserFile fmUpUserFile = this.fmUpUserFileService.getFmUpUserFileByCode(tenantCode, upuserfileCode);
        if (null != fmUpUserFile) {
            if (null == fmUpUserFile.getUpuserfileEnum()) {
                fmUpUserFile.setUpuserfileEnum(0);
            }
            if (null == fmUpUserFile.getUpuserfileMnum()) {
                fmUpUserFile.setUpuserfileMnum(0);
            }
            if (null == fmUpUserFile.getUpuserfileNum()) {
                fmUpUserFile.setUpuserfileNum(0);
            }
            if (fmUpUserFile.getUpuserfileNum() >= fmUpUserFile.getUpuserfileEnum() + fmUpUserFile.getUpuserfileMnum()) {
                this.fmUpUserFileService.updateFmUpUserFileStateByCode(tenantCode, upuserfileCode, 2, null, null);
            }
        }
    }

    private boolean sendApi(String apicode, String reparseStr, String returnStr, Map<String, Object> odatamap, Map<String, Object> pmap) {
        if (StringUtils.isBlank((String)apicode)) {
            this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.sendApi.apicode", (Object)apicode);
            return false;
        }
        if (StringUtils.isBlank((String)reparseStr)) {
            this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.sendApi.reparseStr", (Object)apicode);
            return false;
        }
        UpDataCallApi upDataCallApi = (UpDataCallApi)GroovyUtil.executeCalculate((String)reparseStr);
        if (null == upDataCallApi) {
            this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.sendApi.upDataCallApi");
            return false;
        }
        Map<String, Object> paramMap = upDataCallApi.returnCallEx(odatamap);
        String returnstr = this.internalInvoke(apicode, paramMap);
        boolean refalg = false;
        if (StringUtils.isNotBlank((String)returnStr)) {
            UpDataReturnApi upDataReturnApi = (UpDataReturnApi)GroovyUtil.executeCalculate((String)returnStr);
            if (null == upDataReturnApi) {
                this.logger.error("fm.FILE.FmUpUserFileBaseServiceImpl.sendApi.upDataReturnApi");
                return false;
            }
            refalg = upDataReturnApi.returnCallEx(returnstr);
        } else if (StringUtils.isBlank((String)returnstr)) {
            refalg = true;
        }
        if (!refalg) {
            if (StringUtils.isNotBlank((String)returnstr)) {
                returnstr = returnstr.trim();
                returnstr = returnstr.substring(0, 200);
            }
            pmap.put("msg", returnstr);
        }
        return refalg;
    }

    static {
        lock = new Object();
    }
}

