/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.file.service.impl;

import com.yqbsoft.laser.service.adapter.ftp.FtpClientUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.BaseAuth;
import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.file.dao.FmFileMapper;
import com.yqbsoft.laser.service.file.dao.FmFilelistMapper;
import com.yqbsoft.laser.service.file.domain.DownloadFileDomainBean;
import com.yqbsoft.laser.service.file.domain.FmFileDomainBean;
import com.yqbsoft.laser.service.file.domain.FmFilelistDomainBean;
import com.yqbsoft.laser.service.file.domain.ImageBean;
import com.yqbsoft.laser.service.file.es.SendPollThread;
import com.yqbsoft.laser.service.file.es.SendPutThread;
import com.yqbsoft.laser.service.file.es.SendService;
import com.yqbsoft.laser.service.file.model.CdCardplist;
import com.yqbsoft.laser.service.file.model.FmFchannel;
import com.yqbsoft.laser.service.file.model.FmFile;
import com.yqbsoft.laser.service.file.model.FmFilelist;
import com.yqbsoft.laser.service.file.remote.PgUtils;
import com.yqbsoft.laser.service.file.service.FchannelService;
import com.yqbsoft.laser.service.file.service.FileService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.FileUtil;
import com.yqbsoft.laser.service.tool.util.ImageUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sun.misc.BASE64Decoder;

public class FileServiceImpl
extends BaseServiceImpl
implements FileService {
    public static final String SYS_CODE = "fm.FILE.FileServiceImpl";
    private FmFileMapper fmFileMapper;
    private FmFilelistMapper fmFilelistMapper;
    private FchannelService fchannelService;
    private Object UUIDLock = new Object();
    public static final String VFOAPPMANAGE_LINEINFO = "EcoreAppmanage-lineInfo";
    private static SendService sendService;
    private static Object lock;

    public void setFchannelService(FchannelService fchannelService) {
        this.fchannelService = fchannelService;
    }

    public void setFmFileMapper(FmFileMapper fmFileMapper) {
        this.fmFileMapper = fmFileMapper;
    }

    public void setFmFilelistMapper(FmFilelistMapper fmFilelistMapper) {
        this.fmFilelistMapper = fmFilelistMapper;
    }

    private Date getSysDate() {
        try {
            return this.fmFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void checkFile(FmFileDomainBean fmFileDomainBean) {
        String msg = "";
        if (null == fmFileDomainBean) {
            msg = "\u53c2\u6570\u4e3a\u7a7a";
            throw new ApiException("fm.FILE.FileServiceImpl.saveFile.checkFile", "fmFileDomainBean   can`t be null");
        }
        if (StringUtils.isBlank((String)fmFileDomainBean.getFileType())) {
            msg = "\u53c2\u6570\u4e3a\u7a7a";
            throw new ApiException("fm.FILE.FileServiceImpl.saveFile.checkFile", " fileType can`t be null");
        }
    }

    private void setFileDefault(FmFile fmFile) {
        if (null == fmFile) {
            return;
        }
        fmFile.setFileId(null);
        if (null == fmFile.getDataState()) {
            fmFile.setDataState(1);
        }
        if (null == fmFile.getGmtCreate()) {
            fmFile.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)fmFile.getFileCode())) {
            fmFile.setFileCode(this.createUUIDString());
        }
        fmFile.setGmtModified(this.getSysDate());
    }

    private void setFileUpdataDefault(FmFile fmFile) {
        if (null == fmFile) {
            return;
        }
        fmFile.setGmtModified(this.getSysDate());
    }

    private void saveFileModel(FmFile fmFile) throws ApiException {
        if (null == fmFile) {
            return;
        }
        try {
            this.fmFileMapper.insert(fmFile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveFtpserverModel.ex", (Throwable)e);
        }
    }

    private FmFile getFileModelById(Integer fileId) {
        if (null == fileId) {
            return null;
        }
        try {
            return this.fmFileMapper.selectByPrimaryKey(fileId);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.getFileModelById", (Throwable)e);
            return null;
        }
    }

    private FmFile getFileModelByCode(String fileCode, String tenantCode) {
        if (null == fileCode) {
            return null;
        }
        try {
            return this.fmFileMapper.getByCode(this.getQueryMapParam("fileCode,tenantCode", new Object[]{fileCode, tenantCode}));
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.getFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void deleteFileModel(Integer fileId) throws ApiException {
        if (null == fileId) {
            return;
        }
        int i = 0;
        try {
            i = this.fmFileMapper.deleteByPrimaryKey(fileId);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.deleteFileModel.ex");
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FileServiceImpl.deleteFileModel.num");
        }
    }

    private void updateFileModel(FmFile fmFile) throws ApiException {
        if (null == fmFile) {
            return;
        }
        try {
            this.fmFileMapper.updateByPrimaryKey(fmFile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateFileModel.ex");
        }
    }

    private void updateOcodeModel(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        try {
            this.fmFilelistMapper.updateOcode(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateOcodeModel.ex");
        }
    }

    private void updateStateFileModel(Integer fileId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == fileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileId", fileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.fmFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateStateFileModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateStateFileModel.null");
        }
    }

    private FmFile makeFile(FmFileDomainBean fmFileDomainBean, FmFile fmFile) {
        if (null == fmFileDomainBean) {
            return null;
        }
        if (null == fmFile) {
            fmFile = new FmFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fmFile, (Object)fmFileDomainBean);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.makeFile", (Throwable)e);
        }
        return fmFile;
    }

    private List<FmFile> queryFileModelPage(Map<String, Object> parammap) {
        try {
            return this.fmFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.queryFileModel", (Throwable)e);
            return null;
        }
    }

    private int countFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fmFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.countFile", (Throwable)e);
        }
        return i;
    }

    private int countFilelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.fmFilelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.countFile", (Throwable)e);
        }
        return i;
    }

    private String checkFilelist(FmFilelistDomainBean fmFilelistDomainBean) {
        if (null == fmFilelistDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)fmFilelistDomainBean.getFileCode())) {
            msg = msg + "FileCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)fmFilelistDomainBean.getFchannelCode())) {
            msg = msg + "FchannelCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFilelistDefault(FmFilelist fmFilelist) {
        if (null == fmFilelist) {
            return;
        }
        fmFilelist.setFilelistId(null);
        if (null == fmFilelist.getDataState()) {
            fmFilelist.setDataState(0);
        }
        if (null == fmFilelist.getGmtCreate()) {
            fmFilelist.setGmtCreate(this.getSysDate());
        }
        fmFilelist.setGmtModified(this.getSysDate());
    }

    private void setFilelistUpdataDefault(FmFilelist fmFilelist) {
        if (null == fmFilelist) {
            return;
        }
        fmFilelist.setGmtModified(this.getSysDate());
    }

    private void saveFilelistModel(FmFilelist fmFilelist) throws ApiException {
        if (null == fmFilelist) {
            return;
        }
        try {
            this.fmFilelistMapper.insert(fmFilelist);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveFtpserverModel.ex");
        }
    }

    private FmFilelist getFilelistModelById(Integer filelistId) {
        if (null == filelistId) {
            return null;
        }
        try {
            return this.fmFilelistMapper.selectByPrimaryKey(filelistId);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.getFilelistModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteFilelistModel(Integer filelistId) throws ApiException {
        if (null == filelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.fmFilelistMapper.deleteByPrimaryKey(filelistId);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.deleteFilelistModel.ex");
        }
        if (1 != i) {
            throw new ApiException("fm.FILE.FileServiceImpl.deleteFilelistModel.num");
        }
    }

    private void updateFilelistModel(FmFilelist fmFilelist) throws ApiException {
        if (null == fmFilelist) {
            return;
        }
        try {
            this.fmFilelistMapper.updateByPrimaryKey(fmFilelist);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateFilelistModel.ex");
        }
    }

    private void updateStateFilelistModel(Integer filelistId, Integer dataState, Integer oldDataState, String filelistOcode) throws ApiException {
        if (null == filelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filelistId", filelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("filelistOcode", filelistOcode);
        int i = 0;
        try {
            i = this.fmFilelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateStateFilelistModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateStateFilelistModel.null", ((Object)map).toString());
        }
    }

    private FmFilelist makeFilelist(FmFilelistDomainBean fmFilelistDomainBean, FmFilelist fmFilelist) {
        if (null == fmFilelistDomainBean) {
            return null;
        }
        if (null == fmFilelist) {
            fmFilelist = new FmFilelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)fmFilelist, (Object)fmFilelistDomainBean);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.makeFilelist", (Throwable)e);
        }
        return fmFilelist;
    }

    private List<FmFilelist> queryFilelistModelPage(Map<String, Object> parammap) {
        try {
            return this.fmFilelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.queryFilelistModel", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createUUIDString() {
        Object object = this.UUIDLock;
        synchronized (object) {
            return UUID.randomUUID().toString().replace("-", "");
        }
    }

    private List<FmFilelistDomainBean> uploadFile(String fileSort, String tenantCode, String path, List<FileBean> fileBeanList) throws ApiException {
        if (null == fileBeanList || fileBeanList.isEmpty()) {
            return null;
        }
        List<FmFchannel> fchannelList = this.fchannelService.queryFchannel(fileSort, tenantCode);
        if (null == fchannelList || fchannelList.isEmpty()) {
            fchannelList = this.fchannelService.queryFchannel(fileSort, "00000000");
        }
        if (null == fchannelList || fchannelList.isEmpty()) {
            throw new ApiException("fm.FILE.FileServiceImpl.uploadFile.null");
        }
        FtpClientUtil ftpClientUtil = new FtpClientUtil();
        ArrayList<FmFilelistDomainBean> filelistList = new ArrayList<FmFilelistDomainBean>();
        FmFilelistDomainBean fmFilelistDomainBean = null;
        String filenametype = "";
        for (FmFchannel fmFchannel : fchannelList) {
            Object appkey;
            String fileCode;
            filenametype = fmFchannel.getFchannelFilename();
            if (StringUtils.isBlank((String)filenametype)) {
                filenametype = "0";
            }
            ArrayList<FileBean> newfileBeanList = new ArrayList<FileBean>();
            for (FileBean fileBean1 : fileBeanList) {
                fileCode = !"0".equals(filenametype) ? fileBean1.getOriginalFilename() + "." + fileBean1.getFileType() : this.createUUIDString() + "." + fileBean1.getFileType();
                fileBean1.setName(fileCode);
                fmFilelistDomainBean = new FmFilelistDomainBean();
                fmFilelistDomainBean.setFchannelType(fmFchannel.getFchannelType());
                if (!"3".equals(String.valueOf(fmFchannel.getFchannelType()))) {
                    fmFilelistDomainBean.setFilelistPath((null == fmFchannel.getFchannelPath() ? "" : fmFchannel.getFchannelPath()) + path + "/" + fileBean1.getName());
                }
                fmFilelistDomainBean.setFchannelCode(fmFchannel.getFchannelCode());
                fmFilelistDomainBean.setFileCode(fileCode);
                fmFilelistDomainBean.setFchannelPush(fmFchannel.getFchannelPush());
                filelistList.add(fmFilelistDomainBean);
                FileBean newFileBean = new FileBean();
                try {
                    BeanUtils.copyAllPropertys((Object)newFileBean, (Object)fileBean1);
                }
                catch (Exception e) {
                    this.logger.error("fm.FILE.FileServiceImpl.uploadFile.copy", (Throwable)e);
                }
                newFileBean.setBytes(Base64.decodeBase64((byte[])fileBean1.getBytes()));
                newfileBeanList.add(newFileBean);
            }
            if (null != fmFchannel.getFchannelPush() && fmFchannel.getFchannelPush() == 1) continue;
            if ("0".equals(String.valueOf(fmFchannel.getFchannelType()))) {
                RegeditBean regeditBean;
                String str;
                String ftpurl = fmFchannel.getFchannelUrl();
                if (StringUtils.isNotBlank((String)ftpurl) && "{".equals(ftpurl.substring(0, 1)) && StringUtils.isNotBlank((String)(str = SupDisUtil.getMap((String)VFOAPPMANAGE_LINEINFO, (String)(appkey = ftpurl.substring(1, ftpurl.length() - 1))))) && null != (regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(str, RegeditBean.class))) {
                    ftpurl = regeditBean.getAppIp();
                    fmFchannel.setFchannelUrl(ftpurl);
                }
                if (ftpClientUtil.uploadFileList(fmFchannel.getFchannelUrl(), fmFchannel.getFchannelPort().intValue(), fmFchannel.getFchannelUser(), fmFchannel.getFchannelPasswd(), (null == fmFchannel.getFchannelPath() ? "" : fmFchannel.getFchannelPath()) + path, null, newfileBeanList)) continue;
                throw new ApiException("fm.FILE.FileServiceImpl.uploadFile.ftp");
            }
            if ("4".equals(String.valueOf(fmFchannel.getFchannelType()))) {
                int i = 0;
                appkey = fileBeanList.iterator();
                while (appkey.hasNext()) {
                    FileBean FileBean1 = appkey.next();
                    fileCode = this.createUUIDString();
                    ImageBean imageBean = new ImageBean();
                    imageBean.setImage(FileBean1.getBytes());
                    imageBean.setFchannelCode(fmFchannel.getFchannelCode());
                    imageBean.setFileCode(fileCode);
                    imageBean.setFileType(FileBean1.getFileType());
                    imageBean.setTenantCode(tenantCode);
                    HashMap<String, String> maps = new HashMap<String, String>();
                    maps.put("tenantCode", tenantCode);
                    maps.put("channelCode", fmFchannel.getFchannelCode());
                    maps.put("imageBean", JsonUtil.buildNormalBinder().toJson((Object)imageBean));
                    String flagStr = (String)this.getInternalRouter().inInvoke("cmc.disGoods.uploadImage", maps);
                    if (StringUtils.isBlank((String)flagStr)) {
                        throw new ApiException("fm.FILE.FileServiceImpl.flagStr", flagStr);
                    }
                    ((FmFilelistDomainBean)filelistList.get(i++)).setFilelistOcode(flagStr);
                }
                continue;
            }
            if ("1".equals(String.valueOf(fmFchannel.getFchannelType()))) {
                if (!ListUtil.isNotEmpty(newfileBeanList)) continue;
                int i = 0;
                appkey = newfileBeanList.iterator();
                while (appkey.hasNext()) {
                    FileBean fileBean2 = (FileBean)appkey.next();
                    FileUtil.makeMoreDir((String)(fmFchannel.getFchannelPath() + path));
                    File file1 = new File(fmFchannel.getFchannelPath() + path);
                    if (!file1.exists()) {
                        file1.mkdirs();
                    }
                    try {
                        ImageUtils.writeImageToDisk((byte[])fileBean2.getBytes(), (String)(fmFchannel.getFchannelPath() + path + "/" + fileBean2.getName()));
                    }
                    catch (Exception e) {
                        this.logger.info("==1===", (Object)e);
                    }
                    ((FmFilelistDomainBean)filelistList.get(i)).setFilelistOcode(fileBean2.getFilelistOcode());
                    ((FmFilelistDomainBean)filelistList.get(i)).setFilelistPath(path + "/" + fileBean2.getName());
                    ++i;
                }
                continue;
            }
            if ("2".equals(String.valueOf(fmFchannel.getFchannelType())) || "3".equals(String.valueOf(fmFchannel.getFchannelType()))) continue;
            if ("5".equals(String.valueOf(fmFchannel.getFchannelType()))) {
                String url = PgUtils.updateFile(fmFchannel, (FileBean)newfileBeanList.get(0));
                ((FmFilelistDomainBean)filelistList.get(0)).setFilelistOcode(((FileBean)newfileBeanList.get(0)).getFilelistOcode());
                ((FmFilelistDomainBean)filelistList.get(0)).setFilelistPath(url);
                continue;
            }
            if (!"6".equals(String.valueOf(fmFchannel.getFchannelType()))) continue;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            HashMap<String, String> params = new HashMap<String, String>();
            paramMap.put("accessKeyId", fmFchannel.getFchannelUser());
            paramMap.put("accessKeySecret", fmFchannel.getFchannelPasswd());
            paramMap.put("objectNamePath", fmFchannel.getFchannelPath());
            paramMap.put("ossUrl", fmFchannel.getFchannelRemark());
            if (StringUtils.isNotBlank((String)fmFchannel.getFchannelParam())) {
                paramMap.putAll(JsonUtil.buildNormalBinder().getJsonToMap(fmFchannel.getFchannelParam(), String.class, Object.class));
            }
            params.put("paramMap", JsonUtil.buildNormalBinder().toJson(paramMap));
            params.put("fileBean", JsonUtil.buildNormalBinder().toJson(newfileBeanList.get(0)));
            String url = this.internalInvoke(fmFchannel.getFchannelUrl(), params);
            if (StringUtils.isBlank((String)url) || "error".equals(url)) {
                this.logger.error(SYS_CODE, (Object)url);
                throw new ApiException("\u4e0a\u4f20\u5931\u8d25");
            }
            ((FmFilelistDomainBean)filelistList.get(0)).setFilelistOcode(((FileBean)newfileBeanList.get(0)).getFilelistOcode());
            ((FmFilelistDomainBean)filelistList.get(0)).setFilelistPath(url);
        }
        return filelistList;
    }

    public static void main(String[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sdaf", "asdf");
        params.put("asdf", "sds");
        Map paramMap = new HashMap();
        paramMap = JsonUtil.buildNormalBinder().getJsonToMap("{\"endPoint\":\"https://oss-cn-shanghai.aliyuncs.com\",\"bucketName\":\"oss\"}", String.class, Object.class);
        params.putAll(paramMap);
        System.out.println(JsonUtil.buildNormalBinder().toJson(params));
    }

    private void download(DownloadFileDomainBean file, List<FmFilelist> fmFilelistList) {
        if (null == fmFilelistList || fmFilelistList.isEmpty() || null == file) {
            this.logger.error("fm.FILE.FileServiceImpl.download.null", (Object)"");
            return;
        }
        FtpClientUtil ftpClientUtil = new FtpClientUtil();
        List<FmFchannel> fchannelList = this.fchannelService.queryFchannel(file.getFileSort(), file.getTenantCode());
        if (null == fchannelList || fchannelList.isEmpty()) {
            this.logger.error("fm.FILE.FileServiceImpl.download.query", (Object)"");
            return;
        }
        Map<String, FmFchannel> map = this.makeMap(fchannelList);
        FmFchannel fmFchannel = null;
        for (FmFilelist fmFilelist : fmFilelistList) {
            fmFchannel = map.get(fmFilelist.getFchannelCode());
            if ("0".equals(String.valueOf(fmFilelist.getFchannelType()))) {
                String filenametype;
                String fileName = file.getFileCode() + "." + file.getFileCtype();
                String string = filenametype = fmFchannel != null ? fmFchannel.getFchannelFilename() : null;
                if (StringUtils.isBlank((String)filenametype)) {
                    filenametype = "0";
                }
                if (!"0".equals(filenametype)) {
                    fileName = file.getFileName() + "." + file.getFileCtype();
                }
                file.setFilecontent(ftpClientUtil.downFile(fmFchannel.getFchannelUrl(), fmFchannel.getFchannelPort().intValue(), fmFchannel.getFchannelUser(), fmFchannel.getFchannelPasswd(), fmFilelist.getFilelistPath(), fileName, null));
                continue;
            }
            if (!"1".equals(String.valueOf(fmFchannel.getFchannelType())) && !"2".equals(String.valueOf(fmFchannel.getFchannelType()))) continue;
        }
    }

    private Map<String, FmFchannel> makeMap(List<FmFchannel> fchannelList) {
        if (null == fchannelList || fchannelList.isEmpty()) {
            return null;
        }
        HashMap<String, FmFchannel> map = new HashMap<String, FmFchannel>();
        for (FmFchannel fmFchannel : fchannelList) {
            map.put(fmFchannel.getFchannelCode(), fmFchannel);
        }
        return map;
    }

    @Override
    public FmFile saveTFile(FmFileDomainBean fmFileDomainBean, List<FileBean> fileBeanList, FmFileDomainBean fmle) throws ApiException {
        this.checkFile(fmFileDomainBean);
        FmFile fmFile = this.makeFile(fmFileDomainBean, null);
        this.setFileDefault(fmFile);
        String rootPath = fmFileDomainBean.getRootPath();
        String path = "";
        boolean flag = fmFileDomainBean.isFlag();
        if (flag) {
            path = StringUtils.isBlank((String)rootPath) ? "" : rootPath;
        } else {
            if (StringUtils.isBlank((String)rootPath)) {
                rootPath = "/uploadFile/";
            } else if (rootPath.indexOf("_") > 0) {
                if (rootPath.indexOf("_") > 0) {
                    String[] s = rootPath.split("_");
                    rootPath = "/" + s[0] + "/" + s[1] + "/";
                } else {
                    rootPath = "/" + rootPath.substring(0, 8) + "/" + rootPath.substring(8) + "/";
                }
            }
            path = rootPath;
            path = path + DateUtils.getDateString((Date)this.getSysDate(), (String)"yyyy-MM-dd");
        }
        List<FmFilelistDomainBean> filelistList = null;
        if (null != fileBeanList && !fileBeanList.isEmpty()) {
            try {
                filelistList = this.uploadFile(fmFile.getFileSort(), fmFile.getTenantCode(), path, fileBeanList);
            }
            catch (Exception e) {
                throw new ApiException("fm.FILE.FileServiceImpl.upload.e", (Throwable)e);
            }
            fmFile.setFileCtype(fileBeanList.get(0).getFileType());
            fmFile.setFileName(fmle.getFileName());
            fmFile.setFileRemark(fmFile.getFileRemark());
            fmFile.setFileType(fmle.getFileType());
            fmFile.setFileCode(filelistList.get(0).getFileCode());
            if (!"html".equals(fmFile.getFileCtype())) {
                fmFile.setFileContext(fileBeanList.get(0).getBytes());
            }
            fmFile.setFileSize(Integer.valueOf(String.valueOf(fileBeanList.get(0).getSize())));
            String fileUrl = fmFile.getFileUrl();
            if (StringUtils.isBlank((String)fileUrl)) {
                fileUrl = "";
            }
            for (FmFilelistDomainBean fmFilelistDomainBean : filelistList) {
                if (StringUtils.isNotBlank((String)fmFilelistDomainBean.getFilelistOcode())) {
                    fmFile.setMemo(fmFilelistDomainBean.getFilelistOcode());
                }
                if (!StringUtils.isNotBlank((String)fmFilelistDomainBean.getFilelistPath()) || null == fmFilelistDomainBean.getFchannelType() || 3 == fmFilelistDomainBean.getFchannelType()) continue;
                if (fmFilelistDomainBean.getFilelistPath().indexOf("http") != 0) {
                    fileUrl = fileUrl + fmFilelistDomainBean.getFilelistPath();
                    break;
                }
                fileUrl = fmFilelistDomainBean.getFilelistPath();
                break;
            }
            fmFile.setFileUrl(fileUrl);
        }
        try {
            this.saveFileModel(fmFile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveFile.e", (Throwable)e);
        }
        if (null == filelistList || filelistList.isEmpty()) {
            return null;
        }
        for (FmFilelistDomainBean fmFilelistDomainBean : filelistList) {
            fmFilelistDomainBean.setFileCode(fmFile.getFileCode());
            fmFilelistDomainBean.setTenantCode(fmFile.getTenantCode());
            this.saveFilelist(fmFilelistDomainBean);
        }
        fmFile.setFileContext(null);
        return fmFile;
    }

    @Override
    public FmFile saveFileForString(String fmFileDomainBeanStr, List<FileBean> fileBeanList) throws ApiException {
        if (null == fmFileDomainBeanStr || ListUtil.isEmpty(fileBeanList)) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveFile.request is null");
        }
        FmFileDomainBean fmFileDomainBean = (FmFileDomainBean)JsonUtil.buildNonDefaultBinder().getJsonToObject(fmFileDomainBeanStr, FmFileDomainBean.class);
        return this.saveFile(fmFileDomainBean, fileBeanList);
    }

    @Override
    public FmFile saveFile(FmFileDomainBean fmFileDomainBean, List<FileBean> fileBeanList) throws ApiException {
        if (Objects.isNull(fmFileDomainBean) || ListUtil.isEmpty(fileBeanList)) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveFile.request is null");
        }
        this.checkFile(fmFileDomainBean);
        FmFile fmFile = this.makeFile(fmFileDomainBean, null);
        this.setFileDefault(fmFile);
        String rootPath = fmFileDomainBean.getRootPath();
        String path = "";
        boolean flag = fmFileDomainBean.isFlag();
        if (flag) {
            path = StringUtils.isBlank((String)rootPath) ? "" : rootPath;
        } else {
            if (StringUtils.isBlank((String)rootPath)) {
                rootPath = "/uploadFile/";
            } else if (rootPath.indexOf("_") > 0) {
                if (rootPath.indexOf("_") > 0) {
                    String[] s = rootPath.split("_");
                    rootPath = "/" + s[0] + "/" + s[1] + "/";
                } else {
                    rootPath = "/" + rootPath.substring(0, 8) + "/" + rootPath.substring(8) + "/";
                }
            }
            path = rootPath;
            if (StringUtils.isNotBlank((String)fmFileDomainBean.getFileCode()) && !fmFileDomainBean.getFileCode().equals("FILE_08")) {
                path = path + DateUtils.getDateString((Date)this.getSysDate(), (String)"yyyy-MM-dd");
            }
        }
        List<FmFilelistDomainBean> filelistList = null;
        if (null != fileBeanList && !fileBeanList.isEmpty()) {
            String fileUrl;
            try {
                filelistList = this.uploadFile(fmFile.getFileSort(), fmFile.getTenantCode(), path, fileBeanList);
            }
            catch (Exception e) {
                throw new ApiException("fm.FILE.FileServiceImpl.upload.e", (Throwable)e);
            }
            fmFile.setFileCtype(fileBeanList.get(0).getFileType());
            fmFile.setFileName(fileBeanList.get(0).getOriginalFilename());
            fmFile.setFileCode(filelistList.get(0).getFileCode());
            this.logger.info("fm.FILE.FileServiceImpl.file.type", (Object)fmFile.getFileCtype());
            if (!("html".equals(fmFile.getFileCtype()) || "xls".equals(fmFile.getFileCtype()) || "avi".equals(fmFile.getFileCtype()) || "mp4".equals(fmFile.getFileCtype()))) {
                fmFile.setFileContext(fileBeanList.get(0).getBytes());
            }
            if (fileBeanList.get(0).getSize() != null) {
                fmFile.setFileSize(Integer.valueOf(String.valueOf(fileBeanList.get(0).getSize())));
            }
            if (StringUtils.isBlank((String)(fileUrl = fmFile.getFileUrl()))) {
                fileUrl = "";
            }
            for (FmFilelistDomainBean fmFilelistDomainBean : filelistList) {
                if (StringUtils.isNotBlank((String)fmFilelistDomainBean.getFilelistOcode())) {
                    fmFile.setMemo(fmFilelistDomainBean.getFilelistOcode());
                }
                if (5 == fmFilelistDomainBean.getFchannelType()) {
                    fileUrl = fmFilelistDomainBean.getFilelistPath();
                    continue;
                }
                if (!StringUtils.isNotBlank((String)fmFilelistDomainBean.getFilelistPath()) || null == fmFilelistDomainBean.getFchannelType() || 3 == fmFilelistDomainBean.getFchannelType()) continue;
                if (fmFilelistDomainBean.getFilelistPath().trim().indexOf("http") == 0) {
                    fileUrl = fmFilelistDomainBean.getFilelistPath();
                    break;
                }
                fileUrl = fileUrl + fmFilelistDomainBean.getFilelistPath();
                break;
            }
            fmFile.setFileUrl(fileUrl);
        }
        try {
            this.saveFileModel(fmFile);
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveFile.e", (Throwable)e);
        }
        if (null == filelistList || filelistList.isEmpty()) {
            return null;
        }
        for (FmFilelistDomainBean fmFilelistDomainBean : filelistList) {
            fmFilelistDomainBean.setFileCode(fmFile.getFileCode());
            fmFilelistDomainBean.setTenantCode(fmFile.getTenantCode());
            this.saveFilelist(fmFilelistDomainBean);
        }
        fmFile.setFileContext(null);
        return fmFile;
    }

    @Override
    public FmFile saveFileByType(FmFileDomainBean fmFileDomainBean, List<FileBean> fileBeanList) throws ApiException {
        this.checkFile(fmFileDomainBean);
        FmFile fmFile = this.makeFile(fmFileDomainBean, null);
        this.setFileDefault(fmFile);
        String rootPath = fmFileDomainBean.getRootPath();
        String path = "";
        boolean flag = fmFileDomainBean.isFlag();
        if (flag) {
            path = StringUtils.isBlank((String)rootPath) ? "" : rootPath;
        } else {
            if (StringUtils.isBlank((String)rootPath)) {
                rootPath = "/uploadFile/";
            } else if (rootPath.indexOf("_") > 0) {
                if (rootPath.indexOf("_") > 0) {
                    String[] s = rootPath.split("_");
                    rootPath = "/" + s[0] + "/" + s[1] + "/";
                } else {
                    rootPath = "/" + rootPath.substring(0, 8) + "/" + rootPath.substring(8) + "/";
                }
            }
            path = rootPath;
            path = path + DateUtils.getDateString((Date)this.getSysDate(), (String)"yyyy-MM-dd");
        }
        List<FmFilelistDomainBean> filelistList = null;
        if (null != fileBeanList && !fileBeanList.isEmpty()) {
            try {
                filelistList = this.uploadFile(fmFile.getFileSort(), fmFile.getTenantCode(), path, fileBeanList);
            }
            catch (Exception e) {
                throw new ApiException("fm.FILE.FileServiceImpl.upload.e", (Throwable)e);
            }
            fmFile.setFileCtype(fileBeanList.get(0).getFileType());
            fmFile.setFileName(fileBeanList.get(0).getOriginalFilename());
            fmFile.setFileCode(filelistList.get(0).getFileCode());
            if (!"html".equals(fmFile.getFileCtype())) {
                fmFile.setFileContext(fileBeanList.get(0).getBytes());
            }
            fmFile.setFileSize(Integer.valueOf(String.valueOf(fileBeanList.get(0).getSize())));
            String fileUrl = fmFile.getFileUrl();
            if (StringUtils.isBlank((String)fileUrl)) {
                fileUrl = "";
            }
            for (FmFilelistDomainBean fmFilelistDomainBean : filelistList) {
                if (StringUtils.isNotBlank((String)fmFilelistDomainBean.getFilelistOcode())) {
                    fmFile.setMemo(fmFilelistDomainBean.getFilelistOcode());
                }
                if (5 == fmFilelistDomainBean.getFchannelType()) {
                    fileUrl = fmFilelistDomainBean.getFilelistPath();
                    continue;
                }
                if (!StringUtils.isNotBlank((String)fmFilelistDomainBean.getFilelistPath()) || null == fmFilelistDomainBean.getFchannelType() || 3 == fmFilelistDomainBean.getFchannelType()) continue;
                if (fmFilelistDomainBean.getFilelistPath().trim().indexOf("http") == 0) {
                    fileUrl = fmFilelistDomainBean.getFilelistPath();
                    break;
                }
                fileUrl = fileUrl + fmFilelistDomainBean.getFilelistPath();
                break;
            }
            fmFile.setFileUrl(fileUrl);
        }
        fmFile.setFileContext(null);
        return fmFile;
    }

    private FmFile isExists(FmFile fmFile) throws ApiException {
        String fileSort = fmFile.getFileSort();
        String fileOwner = fmFile.getFileOwner();
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("fileSort", fileSort);
        parammap.put("fileOwner", fileOwner);
        List<FmFile> list = this.queryFileModelPage(parammap);
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        if (list != null && list.size() > 1) {
            throw new ApiException("fm.FILE.FileServiceImpl.isExists.num");
        }
        return null;
    }

    @Override
    public void updateFileState(Integer fileId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFileModel(fileId, dataState, oldDataState);
    }

    @Override
    public void updateFile(FmFileDomainBean fmFileDomainBean) throws ApiException {
        this.checkFile(fmFileDomainBean);
        FmFile oldFmFile = this.getFileModelById(fmFileDomainBean.getFileId());
        if (null == oldFmFile) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FmFile fmFile = this.makeFile(fmFileDomainBean, oldFmFile);
        this.setFileUpdataDefault(fmFile);
        this.updateFileModel(fmFile);
    }

    @Override
    public void updateFileByCode(FmFileDomainBean fmFileDomainBean) throws ApiException {
        this.checkFile(fmFileDomainBean);
        FmFile oldFmFile = this.getFileModelByCode(fmFileDomainBean.getFileCode(), fmFileDomainBean.getTenantCode());
        if (null == oldFmFile) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        fmFileDomainBean.setFileId(oldFmFile.getFileId());
        fmFileDomainBean.setFileUrl(oldFmFile.getFileUrl());
        FmFile fmFile = this.makeFile(fmFileDomainBean, oldFmFile);
        this.setFileUpdataDefault(fmFile);
        this.logger.error("updateFile-------", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)fmFile));
        this.updateFileModel(fmFile);
    }

    @Override
    public FmFile getFile(Integer fileId) {
        return this.getFileModelById(fileId);
    }

    @Override
    public DownloadFileDomainBean getDownloadFile(String fileCode, String tenantCode) {
        FmFile fmFile = this.getFileModelByCode(fileCode, tenantCode);
        if (null == fmFile) {
            return null;
        }
        DownloadFileDomainBean file = new DownloadFileDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)file, (Object)fmFile);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.getDownloadFile.copy", (Throwable)e);
            return null;
        }
        List<FmFilelist> fmFilelistList = this.queryFilelist(fileCode, tenantCode);
        this.download(file, fmFilelistList);
        return file;
    }

    @Override
    public void deleteFile(Integer fileId) throws ApiException {
        if (null == fileId) {
            return;
        }
        this.deleteFileModel(fileId);
    }

    @Override
    public QueryResult<FmFile> queryFilePage(Map<String, Object> map) {
        List<FmFile> fmFileList = this.queryFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fmFileList);
        return queryResult;
    }

    @Override
    public void saveFilelist(FmFilelistDomainBean fmFilelistDomainBean) throws ApiException {
        String msg = this.checkFilelist(fmFilelistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveFilelist.checkFilelist", msg);
        }
        FmFilelist fmFilelist = this.makeFilelist(fmFilelistDomainBean, null);
        this.setFilelistDefault(fmFilelist);
        if (null == fmFilelistDomainBean.getFchannelPush() || 0 == fmFilelistDomainBean.getFchannelPush()) {
            fmFilelist.setDataState(1);
        } else {
            fmFilelist.setDataState(0);
        }
        this.saveFilelistModel(fmFilelist);
    }

    @Override
    public void updateFilelistState(Integer filelistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFilelistModel(filelistId, dataState, oldDataState, null);
    }

    @Override
    public void updateFilelist(FmFilelistDomainBean fmFilelistDomainBean) throws ApiException {
        String msg = this.checkFilelist(fmFilelistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateFilelist.checkFilelist", msg);
        }
        FmFilelist oldFmFilelist = this.getFilelistModelById(fmFilelistDomainBean.getFilelistId());
        if (null == oldFmFilelist) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateFilelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FmFilelist fmFilelist = this.makeFilelist(fmFilelistDomainBean, oldFmFilelist);
        this.setFilelistUpdataDefault(fmFilelist);
        this.updateFilelistModel(fmFilelist);
    }

    @Override
    public FmFilelist getFilelist(Integer filelistId) {
        return this.getFilelistModelById(filelistId);
    }

    @Override
    public void deleteFilelist(Integer filelistId) throws ApiException {
        this.deleteFilelistModel(filelistId);
    }

    @Override
    public List<FmFilelist> queryFilelist(String fileCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileCode", fileCode);
        map.put("tenantCode", tenantCode);
        List<FmFilelist> fmFilelistList = this.queryFilelistModelPage(map);
        return fmFilelistList;
    }

    @Override
    public DownloadFileDomainBean downloadFileDirect(String filePath, String tenantCode) {
        DownloadFileDomainBean file = new DownloadFileDomainBean();
        file.setFileSort("counter.ufs");
        this.downloadDirect(file, filePath);
        return file;
    }

    private void downloadDirect(DownloadFileDomainBean file, String filePath) {
    }

    @Override
    public DownloadFileDomainBean downloadFileByName(String fileName, String tenantCode) {
        Map paramMap = this.getQueryParamMap("fileName,tenantCode", new Object[]{fileName, tenantCode});
        paramMap.put("order", true);
        List<FmFile> list = this.queryFileModelPage(paramMap);
        FmFile fmFile = null;
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        fmFile = list.get(0);
        DownloadFileDomainBean file = new DownloadFileDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)file, (Object)fmFile);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.getDownloadFile.copy", (Throwable)e);
            return null;
        }
        List<FmFilelist> fmFilelistList = this.queryFilelist(fmFile.getFileCode(), fmFile.getTenantCode());
        this.download(file, fmFilelistList);
        return file;
    }

    @Override
    public void deleteFileByCode(String tenantCode, String fileCode) throws ApiException {
        FmFile fmfile = this.getFileModelByCode(fileCode, tenantCode);
        if (fmfile != null) {
            this.deleteFile(fmfile.getFileId());
        }
    }

    @Override
    public void deleteFileListByCode(String tenantCode, String fileCode) throws ApiException {
        FmFilelist fmfilelist = this.getFileListModelByCode(fileCode);
        if (fmfilelist != null) {
            this.deleteFilelist(fmfilelist.getFilelistId());
        }
    }

    private FmFilelist getFileListModelByCode(String fileCode) {
        if (null == fileCode) {
            return null;
        }
        try {
            return this.fmFilelistMapper.selectByCode(fileCode);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.getFileListModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public FmFile getFileByCode(String tenantCode, String fileCode) throws ApiException {
        if (StringUtils.isBlank((String)fileCode)) {
            return null;
        }
        return this.getFileModelByCode(fileCode, tenantCode);
    }

    @Override
    public DownloadFileDomainBean getDownloadFileById(Integer fileId) {
        FmFile fmFile = this.getFileModelById(fileId);
        if (null == fmFile) {
            return null;
        }
        DownloadFileDomainBean file = new DownloadFileDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)file, (Object)fmFile);
        }
        catch (Exception e) {
            this.logger.error("fm.FILE.FileServiceImpl.getDownloadFile.copy", (Throwable)e);
            return null;
        }
        List<FmFilelist> fmFilelistList = this.queryFilelist(fmFile.getFileCode(), fmFile.getTenantCode());
        if (ListUtil.isEmpty(fmFilelistList)) {
            return null;
        }
        this.download(file, fmFilelistList);
        return file;
    }

    @Override
    public void updateFileOcode(String fileCode, String fchannelCode, String imageCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)fileCode) || StringUtils.isBlank((String)fileCode) || StringUtils.isBlank((String)fchannelCode) || StringUtils.isBlank((String)imageCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("fm.FILE.FileServiceImpl.updateFileOcode.param");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fileCode", fileCode);
        map.put("fchannelCode", fchannelCode);
        map.put("filelistOcode", imageCode);
        map.put("tenantCode", tenantCode);
        this.updateOcodeModel(map);
    }

    @Override
    public String getFileOcode(String fileCode, String fchannelCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)fileCode) || StringUtils.isBlank((String)fileCode) || StringUtils.isBlank((String)fchannelCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("fm.FILE.FileServiceImpl.getFileOcode.param");
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("fileCode", fileCode);
        parammap.put("fchannelCode", fchannelCode);
        parammap.put("tenantCode", tenantCode);
        List<FmFilelist> fmFilelistList = this.queryFilelistModelPage(parammap);
        if (ListUtil.isEmpty(fmFilelistList)) {
            return null;
        }
        return fmFilelistList.get(0).getFilelistOcode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((FileService)SpringApplicationContextUtil.getBean((String)"fileService"));
                for (int i = 0; i < 10; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public void autoFile() throws ApiException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("fchannelPush", 1);
        List list = this.fchannelService.queryFchannelPage(param).getList();
        if (ListUtil.isEmpty((Collection)list)) {
            return;
        }
        for (FmFchannel fmFchannel : list) {
            this.loadDb(fmFchannel.getFchannelCode());
        }
    }

    public QueryResult<FmFilelist> queryFilelistPage(Map<String, Object> map) {
        List<FmFilelist> fmFileList = this.queryFilelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFilelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fmFileList);
        return queryResult;
    }

    private void loadDb(String fchannelCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fchannelCode", fchannelCode);
            map.put("dataState", 0);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            int startRow = 0;
            boolean flag = true;
            QueryResult<FmFilelist> result = null;
            do {
                startRow = FileServiceImpl.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", FileServiceImpl.getSendService().getPage());
                result = this.queryFilelistPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    FileServiceImpl.getSendService().addPutPool(new SendPutThread(FileServiceImpl.getSendService(), result.getRows()));
                    if (result.getRows().size() != FileServiceImpl.getSendService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            FileServiceImpl.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("fm.FILE.FileServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public void saveSendFilelist(FmFilelist fmFilelist) throws ApiException {
        if (null == fmFilelist) {
            return;
        }
        FmFile fmFile = this.getFileByCode(fmFilelist.getTenantCode(), fmFilelist.getFileCode());
        if (null == fmFile) {
            return;
        }
        this.updateStateFilelistModel(fmFilelist.getFilelistId(), 1, 0, null);
        ImageBean imageBean = new ImageBean();
        imageBean.setImage(fmFile.getFileContext());
        imageBean.setFchannelCode(fmFilelist.getFchannelCode());
        imageBean.setFileCode(fmFile.getFileCode());
        imageBean.setTenantCode(fmFile.getTenantCode());
        HashMap<String, String> maps = new HashMap<String, String>();
        maps.put("tenantCode", fmFile.getTenantCode());
        maps.put("channelCode", fmFilelist.getFchannelCode());
        maps.put("imageBean", JsonUtil.buildNormalBinder().toJson((Object)imageBean));
        String flagStr = (String)this.getInternalRouter().inInvoke("cmc.disGoods.uploadImage", maps);
        if (StringUtils.isBlank((String)flagStr)) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveSendFilelist.flagStr", flagStr);
        }
        this.updateStateFilelistModel(fmFilelist.getFilelistId(), 1, 1, flagStr);
    }

    @Override
    public QueryResult<FmFile> queryFilePagePlus(Map<String, Object> map) {
        List<FmFile> fmFileList = this.queryFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(fmFileList);
        return queryResult;
    }

    @Override
    public String saveFolder(FmFileDomainBean fmFileDomainBean) {
        if (fmFileDomainBean == null) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveSendFilelist.fmfile");
        }
        String pcode = "-1";
        String ctype = "folder";
        if (!StringUtils.isEmpty((String)fmFileDomainBean.getFilePcode())) {
            pcode = fmFileDomainBean.getFilePcode();
        }
        if (!StringUtils.isEmpty((String)fmFileDomainBean.getFileCtype())) {
            ctype = fmFileDomainBean.getFileCtype();
        }
        FmFile fmFile = this.makeFile(fmFileDomainBean, null);
        fmFile.setFilePcode(pcode);
        fmFile.setFileCtype(ctype);
        this.setFileDefault(fmFile);
        this.saveFileModel(fmFile);
        return fmFile.getFileCode();
    }

    @Override
    public String saveFolde(FmFileDomainBean fmFileDomainBean) {
        if (fmFileDomainBean == null) {
            throw new ApiException("fm.FILE.FileServiceImpl.saveSendFilelist.fmfile");
        }
        this.logger.error(fmFileDomainBean.toString());
        FmFile fmFile = this.makeFile(fmFileDomainBean, null);
        this.setFileDefault(fmFile);
        this.saveFileModel(fmFile);
        return null;
    }

    @Override
    public void deleteSensitByIdBatch(List<Integer> idList) throws ApiException {
        for (int senitId : idList) {
            this.deleteFile(senitId);
        }
    }

    @Override
    public void sendUserCardpmfile() throws ApiException {
        HashMap<String, Object> fileMap = new HashMap<String, Object>();
        fileMap.put("dataState", 0);
        fileMap.put("fileCtype", "zip");
        fileMap.put("fileSort", "FILE_11");
        QueryResult<FmFile> filePage = this.queryFilePage(fileMap);
        if (filePage == null || ListUtil.isEmpty((Collection)filePage.getList())) {
            return;
        }
        for (FmFile file : filePage.getList()) {
            String check_path;
            String width;
            this.updateFileState(file.getFileId(), 2, 0);
            if (StringUtils.isBlank((String)file.getFileOpcode()) && StringUtils.isBlank((String)file.getFileOpcode1())) {
                this.logger.error("fm.FILE.FileServiceImpl.sendUserCardpfile.file", (Object)JsonUtil.buildNormalBinder().toJson((Object)file));
                continue;
            }
            String fileOpcode = file.getFileOpcode();
            String fileOpcode1 = file.getFileOpcode1();
            String tenantCode = file.getTenantCode();
            List<CdCardplist> cardpLists = new ArrayList<CdCardplist>();
            if (StringUtils.isNotBlank((String)fileOpcode1)) {
                this.queryCardpListById(fileOpcode1, cardpLists);
            } else {
                cardpLists = this.queryCardpListByBatch(fileOpcode, tenantCode);
            }
            if (ListUtil.isEmpty(cardpLists)) {
                this.logger.error("fm.FILE.FileServiceImpl.sendUserCardpfile.cardpLists is null", (Object)JsonUtil.buildNormalBinder().toJson((Object)file));
                this.updateFileState(file.getFileId(), -1, 2);
                return;
            }
            String page = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-default-page"));
            if (StringUtils.isBlank((String)page)) {
                page = "pages/cardCoupon/cardCoupon";
            }
            if (StringUtils.isBlank((String)(width = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-default-width"))))) {
                width = "430";
            }
            if (StringUtils.isBlank((String)(check_path = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-default-check_path"))))) {
                check_path = "true";
            }
            Integer num = 0;
            String directory = "/tmp/cardpQRCodeImages" + System.currentTimeMillis();
            File directoryFile = new File(directory);
            if (!directoryFile.exists()) {
                directoryFile.mkdirs();
            }
            BASE64Decoder decoder = new BASE64Decoder();
            for (CdCardplist cdCardplist : cardpLists) {
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
                String access_token = this.getAccessToken(tenantCode);
                if (access_token == null) {
                    return;
                }
                String scene = "cardpId=" + String.valueOf(cdCardplist.getCardplistId());
                String cardpQRCodeBase64Str = this.getCardpQRCodeBase64(tenantCode, page, width, access_token, check_path, scene);
                if (cardpQRCodeBase64Str == null) {
                    return;
                }
                String tempPath = directory + "/" + num + "_" + cdCardplist.getCardpNumber() + ".jpg";
                this.makeQRCodeImage(decoder, cardpQRCodeBase64Str, tempPath);
            }
            this.packDirectory(directory);
            String filelistPath = this.upload(directory, file);
            file.setFileUrl(filelistPath);
            file.setDataState(1);
            this.updateFileModel(file);
        }
    }

    private void queryCardpListById(String fileOpcode1, List<CdCardplist> cardpLists) {
        String[] cardplistIdList;
        for (String cardplistId : cardplistIdList = fileOpcode1.split(",")) {
            HashMap<String, Integer> cardplistIdPmap = new HashMap<String, Integer>();
            cardplistIdPmap.put("cardplistId", Integer.valueOf(cardplistId));
            String cardpListStr = (String)BaseAuth.internalRouter.inInvoke("cd.cdCardplist.getCardplist", "1.0", "0", cardplistIdPmap);
            if (StringUtils.isBlank((String)cardpListStr)) {
                this.logger.error("fm.FILE.FileServiceImpl.sendUserCardpfile.cardplistId", (Object)cardplistId);
                continue;
            }
            CdCardplist cdCardplist = (CdCardplist)JsonUtil.buildNormalBinder().getJsonToObject(cardpListStr, CdCardplist.class);
            cardpLists.add(cdCardplist);
        }
    }

    private List<CdCardplist> queryCardpListByBatch(String fileOpcode, String tenantCode) {
        HashMap<String, String> cardpMap = new HashMap<String, String>();
        cardpMap.put("tenantCode", tenantCode);
        cardpMap.put("cardpBatch", fileOpcode);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(cardpMap));
        String cardpListStr = (String)BaseAuth.internalRouter.inInvoke("cd.cdCardplist.queryCardplistPage", "1.0", "0", pmap);
        QueryResult cardpListQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(cardpListStr, QueryResult.class);
        List cardpLists = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)cardpListQuery.getList()), CdCardplist.class);
        return cardpLists;
    }

    private String upload(String directory, FmFile file) {
        byte[] bytes = null;
        try {
            bytes = FileServiceImpl.InputStreamByteArray(directory + ".zip");
        }
        catch (Exception e) {
            this.logger.error(".Exception", (Throwable)e);
        }
        ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])bytes));
        fileBean.setFileType(file.getFileCtype());
        fileBean.setOriginalFilename(file.getFileName());
        fileBean.setSize(Long.valueOf(1L));
        fileBeanList.add(fileBean);
        String path = file.getTenantCode() + "/" + DateUtils.getDateString((Date)this.getSysDate(), (String)"yyyy-MM-dd");
        List<FmFilelistDomainBean> filelistDomainBeanList = this.uploadFile(file.getFileSort(), file.getTenantCode(), path, fileBeanList);
        if (ListUtil.isEmpty(filelistDomainBeanList)) {
            this.logger.error("fm.FILE.FileServiceImpl.sendUserCardpfile.filelistDomainBeanList", (Object)path);
            return null;
        }
        return filelistDomainBeanList.get(0).getFilelistPath();
    }

    private void packDirectory(String directory) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(directory + ".zip");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        File fileToZip = new File(directory);
        try {
            FileServiceImpl.zipFile(fileToZip, fileToZip.getName(), zipOut);
            zipOut.close();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void makeQRCodeImage(BASE64Decoder decoder, String cardpQRCodeBase64Str, String tempPath) {
        try {
            byte[] bytes = decoder.decodeBuffer(cardpQRCodeBase64Str);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
            File tempPathFile = new File(tempPath);
            if (!tempPathFile.exists()) {
                tempPathFile.delete();
            }
            FileOutputStream out = new FileOutputStream(tempPath);
            ((OutputStream)out).write(bytes);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getCardpQRCodeBase64(String tenantCode, String page, String width, String access_token, String check_path, String scene) {
        HashMap<String, Object> pmap4 = new HashMap<String, Object>();
        pmap4.put("access_token", access_token);
        pmap4.put("scene", scene);
        pmap4.put("page", page);
        pmap4.put("width", Integer.valueOf(width));
        pmap4.put("check_path", Boolean.parseBoolean(check_path));
        pmap4.put("auto_color", false);
        pmap4.put("tenantCode", tenantCode);
        String cardpQRCodeBase64Str = (String)BaseAuth.internalRouter.inInvoke("os.third.wxacodeGetUnlimited", "1.0", "0", pmap4);
        if (StringUtils.isBlank((String)cardpQRCodeBase64Str)) {
            this.logger.error("fm.FILE.FileServiceImpl.sendUserCardpfile.cardpQRCodeBase64Str", (Object)JsonUtil.buildNormalBinder().toJson(pmap4));
            return null;
        }
        return cardpQRCodeBase64Str;
    }

    private String getAccessToken(String tenantCode) {
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("fchannelCode", "wechatmini");
        tokenMap.put("tenantCode", tenantCode);
        HashMap<String, String> pmap3 = new HashMap<String, String>();
        pmap3.put("map", JsonUtil.buildNormalBinder().toJson(tokenMap));
        pmap3.put("fchannelCode", "wechatmini");
        String access_token = (String)BaseAuth.internalRouter.inInvoke("cmc.channelToken.getToken", "1.0", "0", pmap3);
        if (StringUtils.isBlank((String)access_token)) {
            this.logger.error("fm.FILE.FileServiceImpl.sendUserCardpfile.access_token", (Object)JsonUtil.buildNormalBinder().toJson(pmap3));
            return null;
        }
        return access_token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            byte[] var4;
            int n;
            out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            boolean var3 = false;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = var4 = out.toByteArray();
            return byArray;
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] InputStreamByteArray(String filePath) throws IOException {
        byte[] var3;
        FileInputStream in = null;
        try {
            byte[] data;
            in = new FileInputStream(filePath);
            var3 = data = FileServiceImpl.toByteArray(in);
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
        return var3;
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                FileServiceImpl.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    static {
        lock = new Object();
    }
}

