/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.file.util;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Element;

public class JpegDPIProcessor {
    private String formatName = "jpg";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] process(BufferedImage image, int dpi) throws IOException {
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(this.formatName);
        if (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParams = writer.getDefaultWriteParam();
            writeParams.setCompressionMode(2);
            writeParams.setCompressionQuality(1.0f);
            IIOMetadata data = writer.getDefaultImageMetadata(new ImageTypeSpecifier(image), writeParams);
            Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", dpi + "");
            jfif.setAttribute("Ydensity", dpi + "");
            jfif.setAttribute("resUnits", "1");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ImageOutputStream stream = null;){
                stream = ImageIO.createImageOutputStream(out);
                writer.setOutput(stream);
                writer.write(data, new IIOImage(image, null, null), writeParams);
            }
            return out.toByteArray();
        }
        return null;
    }
}

