/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.api.flow.Deployment;
import com.yqbsoft.laser.service.flowable.convert.BpmProcessDefinitionConvert;
import com.yqbsoft.laser.service.flowable.dao.BpmProcessDefinitionExtMapper;
import com.yqbsoft.laser.service.flowable.domain.BpmFormDO;
import com.yqbsoft.laser.service.flowable.domain.BpmProcessDefinitionExtDO;
import com.yqbsoft.laser.service.flowable.dto.BpmProcessDefinitionCreateReqDTO;
import com.yqbsoft.laser.service.flowable.pojo.PageResult;
import com.yqbsoft.laser.service.flowable.service.BpmFormService;
import com.yqbsoft.laser.service.flowable.service.BpmProcessDefinitionService;
import com.yqbsoft.laser.service.flowable.util.BpmnModelUtils;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.flowable.util.object.PageUtils;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessDefinitionListReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessDefinitionPageItemRespVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessDefinitionPageReqVO;
import com.yqbsoft.laser.service.flowable.vo.BpmProcessDefinitionRespVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.common.engine.impl.util.io.BytesStreamSource;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmProcessDefinitionServiceImpl
extends BaseServiceImpl
implements BpmProcessDefinitionService {
    private static final Logger log = LoggerFactory.getLogger(BpmProcessDefinitionServiceImpl.class);
    private static final String BPMN_FILE_SUFFIX = ".bpmn";
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private BpmProcessDefinitionExtMapper processDefinitionMapper;
    @Resource
    private BpmFormService bpmFormService;

    @Override
    public com.yqbsoft.laser.service.flowable.api.flow.ProcessDefinition getProcessDefinition(String id) {
        return (com.yqbsoft.laser.service.flowable.api.flow.ProcessDefinition)this.repositoryService.getProcessDefinition(id);
    }

    @Override
    public ProcessDefinition getProcessDefinition2(String id) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
    }

    @Override
    public com.yqbsoft.laser.service.flowable.api.flow.ProcessDefinition getProcessDefinitionByDeploymentId(String deploymentId) {
        if (StrUtil.isEmpty((CharSequence)deploymentId)) {
            return null;
        }
        return (com.yqbsoft.laser.service.flowable.api.flow.ProcessDefinition)((Object)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult());
    }

    @Override
    public ProcessDefinition getProcessDefinitionByDeploymentId1(String deploymentId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
    }

    @Override
    public List<com.yqbsoft.laser.service.flowable.api.flow.ProcessDefinition> getProcessDefinitionListByDeploymentIds(Set<String> deploymentIds) {
        if (CollUtil.isEmpty(deploymentIds)) {
            return Collections.emptyList();
        }
        return BpmProcessDefinitionConvert.INSTANCE.convertList5(this.repositoryService.createProcessDefinitionQuery().deploymentIds(deploymentIds).list());
    }

    @Override
    public List<ProcessDefinition> getProcessDefinitionListByDeploymentIds1(Set<String> deploymentIds) {
        if (CollUtil.isEmpty(deploymentIds)) {
            return Collections.emptyList();
        }
        return this.repositoryService.createProcessDefinitionQuery().deploymentIds(deploymentIds).list();
    }

    @Override
    public com.yqbsoft.laser.service.flowable.api.flow.ProcessDefinition getActiveProcessDefinition(String key) {
        return (com.yqbsoft.laser.service.flowable.api.flow.ProcessDefinition)((Object)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).active().singleResult());
    }

    @Override
    public ProcessDefinition getActiveProcessDefinition1(String key) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).active().singleResult();
    }

    @Override
    public List<Deployment> getDeployments(Set<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        ArrayList<Deployment> list = new ArrayList<Deployment>(ids.size());
        for (String id : ids) {
            CollectionUtils.addIfNotNull(list, this.getDeployment(id));
        }
        return list;
    }

    @Override
    public List<org.flowable.engine.repository.Deployment> getDeployments1(Set<String> ids) {
        if (CollUtil.isEmpty(ids)) {
            return Collections.emptyList();
        }
        ArrayList<org.flowable.engine.repository.Deployment> list = new ArrayList<org.flowable.engine.repository.Deployment>(ids.size());
        for (String id : ids) {
            CollectionUtils.addIfNotNull(list, this.getDeployment1(id));
        }
        return list;
    }

    @Override
    public Deployment getDeployment(String id) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        return (Deployment)((Object)this.repositoryService.createDeploymentQuery().deploymentId(id).singleResult());
    }

    @Override
    public org.flowable.engine.repository.Deployment getDeployment1(String id) {
        if (StrUtil.isEmpty((CharSequence)id)) {
            return null;
        }
        return (org.flowable.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().deploymentId(id).singleResult();
    }

    @Override
    public BpmnModel getBpmnModel(String processDefinitionId) {
        return this.repositoryService.getBpmnModel(processDefinitionId);
    }

    @Override
    public String createProcessDefinition(@Valid BpmProcessDefinitionCreateReqDTO createReqDTO) {
        org.flowable.engine.repository.Deployment deploy = this.repositoryService.createDeployment().key(createReqDTO.getKey()).name(createReqDTO.getName()).category(createReqDTO.getCategory()).addBytes(createReqDTO.getKey() + BPMN_FILE_SUFFIX, createReqDTO.getBpmnBytes()).deploy();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploy.getId()).singleResult();
        this.repositoryService.setProcessDefinitionCategory(definition.getId(), createReqDTO.getCategory());
        if (!Objects.equals(definition.getKey(), createReqDTO.getKey())) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_DEFINITION_KEY_NOT_MATCH, createReqDTO.getKey(), definition.getKey());
        }
        if (!Objects.equals(definition.getName(), createReqDTO.getName())) {
            throw ServiceExceptionUtil.exception(ErrorCodeConstants.PROCESS_DEFINITION_NAME_NOT_MATCH, createReqDTO.getName(), definition.getName());
        }
        BpmProcessDefinitionExtDO definitionDO = BpmProcessDefinitionConvert.INSTANCE.convert2(createReqDTO);
        definitionDO.setProcessDefinitionId(definition.getId());
        this.processDefinitionMapper.insert(definitionDO);
        return definition.getId();
    }

    @Override
    public void updateProcessDefinitionState(String id, Integer state) {
        if (Objects.equals(SuspensionState.ACTIVE.getStateCode(), state)) {
            this.repositoryService.activateProcessDefinitionById(id, false, null);
            return;
        }
        if (Objects.equals(SuspensionState.SUSPENDED.getStateCode(), state)) {
            this.repositoryService.suspendProcessDefinitionById(id, false, null);
            return;
        }
        log.error("[updateProcessDefinitionState][\u6d41\u7a0b\u5b9a\u4e49({}) \u4fee\u6539\u672a\u77e5\u72b6\u6001({})]", (Object)id, (Object)state);
    }

    @Override
    public String getProcessDefinitionBpmnXML(String id) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(id);
        if (bpmnModel == null) {
            return null;
        }
        BpmnXMLConverter converter = new BpmnXMLConverter();
        return StrUtil.utf8Str((Object)converter.convertToXML(bpmnModel));
    }

    @Override
    public boolean isProcessDefinitionEquals(@Valid BpmProcessDefinitionCreateReqDTO createReqDTO) {
        ProcessDefinition oldProcessDefinition = this.getActiveProcessDefinition1(createReqDTO.getKey());
        if (oldProcessDefinition == null) {
            return false;
        }
        BpmProcessDefinitionExtDO oldProcessDefinitionExt = this.getProcessDefinitionExt(oldProcessDefinition.getId());
        if (!(StrUtil.equals((CharSequence)createReqDTO.getName(), (CharSequence)oldProcessDefinition.getName()) && StrUtil.equals((CharSequence)createReqDTO.getDescription(), (CharSequence)oldProcessDefinitionExt.getDescription()) && StrUtil.equals((CharSequence)createReqDTO.getCategory(), (CharSequence)oldProcessDefinition.getCategory()))) {
            return false;
        }
        if (!(ObjectUtil.equal((Object)createReqDTO.getFormType(), (Object)oldProcessDefinitionExt.getFormType()) && ObjectUtil.equal((Object)createReqDTO.getFormId(), (Object)oldProcessDefinitionExt.getFormId()) && ObjectUtil.equal((Object)createReqDTO.getFormConf(), (Object)oldProcessDefinitionExt.getFormConf()) && ObjectUtil.equal((Object)createReqDTO.getFormFields(), (Object)oldProcessDefinitionExt.getFormFields()) && ObjectUtil.equal((Object)createReqDTO.getFormCustomCreatePath(), (Object)oldProcessDefinitionExt.getFormCustomCreatePath()) && ObjectUtil.equal((Object)createReqDTO.getFormCustomViewPath(), (Object)oldProcessDefinitionExt.getFormCustomViewPath()))) {
            return false;
        }
        BpmnModel newModel = this.buildBpmnModel(createReqDTO.getBpmnBytes());
        BpmnModel oldModel = this.getBpmnModel(oldProcessDefinition.getId());
        return BpmnModelUtils.equals(oldModel, newModel);
    }

    private BpmnModel buildBpmnModel(byte[] bpmnBytes) {
        BpmnXMLConverter converter = new BpmnXMLConverter();
        return converter.convertToBpmnModel((InputStreamProvider)new BytesStreamSource(bpmnBytes), true, true);
    }

    @Override
    public BpmProcessDefinitionExtDO getProcessDefinitionExt(String id) {
        return this.processDefinitionMapper.selectByProcessDefinitionId(id);
    }

    @Override
    public List<BpmProcessDefinitionRespVO> getProcessDefinitionList(BpmProcessDefinitionListReqVO listReqVO) {
        ProcessDefinitionQuery definitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (Objects.equals(SuspensionState.SUSPENDED.getStateCode(), listReqVO.getSuspensionState())) {
            definitionQuery.suspended();
        } else if (Objects.equals(SuspensionState.ACTIVE.getStateCode(), listReqVO.getSuspensionState())) {
            definitionQuery.active();
        }
        List processDefinitions = definitionQuery.list();
        if (CollUtil.isEmpty((Collection)processDefinitions)) {
            return Collections.emptyList();
        }
        List<BpmProcessDefinitionExtDO> processDefinitionDOs = this.processDefinitionMapper.queryByDefinitionIds(CollectionUtils.convertList(processDefinitions, ProcessDefinition::getId));
        Map<String, BpmProcessDefinitionExtDO> processDefinitionDOMap = CollectionUtils.convertMap(processDefinitionDOs, BpmProcessDefinitionExtDO::getProcessDefinitionId);
        return BpmProcessDefinitionConvert.INSTANCE.convertList3(processDefinitions, processDefinitionDOMap);
    }

    @Override
    public PageResult<BpmProcessDefinitionPageItemRespVO> getProcessDefinitionPage(BpmProcessDefinitionPageReqVO pageVO) {
        List processDefinitions;
        ProcessDefinitionQuery definitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (StrUtil.isNotBlank((CharSequence)pageVO.getKey())) {
            definitionQuery.processDefinitionKey(pageVO.getKey());
        }
        if (CollUtil.isEmpty((Collection)(processDefinitions = ((ProcessDefinitionQuery)definitionQuery.orderByProcessDefinitionVersion().desc()).listPage(PageUtils.getStart(pageVO), pageVO.getPageSize().intValue())))) {
            return new PageResult<BpmProcessDefinitionPageItemRespVO>(Collections.emptyList(), definitionQuery.count());
        }
        HashSet deploymentIds = new HashSet();
        processDefinitions.forEach(definition -> CollectionUtils.addIfNotNull(deploymentIds, definition.getDeploymentId()));
        Map deploymentMap = this.getDeploymentMap1(deploymentIds);
        List<BpmProcessDefinitionExtDO> processDefinitionDOs = this.processDefinitionMapper.queryByDefinitionIds(CollectionUtils.convertList(processDefinitions, ProcessDefinition::getId));
        Map<String, BpmProcessDefinitionExtDO> processDefinitionDOMap = CollectionUtils.convertMap(processDefinitionDOs, BpmProcessDefinitionExtDO::getProcessDefinitionId);
        Set<Long> formIds = CollectionUtils.convertSet(processDefinitionDOs, BpmProcessDefinitionExtDO::getFormId);
        Map<Long, BpmFormDO> formMap = this.bpmFormService.getFormMap(formIds);
        long definitionCount = definitionQuery.count();
        return new PageResult<BpmProcessDefinitionPageItemRespVO>(BpmProcessDefinitionConvert.INSTANCE.convertList(processDefinitions, deploymentMap, processDefinitionDOMap, formMap), definitionCount);
    }
}

