/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.api.dept;

import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.flowable.api.dept.DeptApi;
import com.yqbsoft.laser.service.flowable.api.dept.dto.DeptRespDTO;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApiImpl;
import com.yqbsoft.laser.service.flowable.enums.CommonStatusEnum;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.organize.model.OrgDepart;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeptApiImpl
implements DeptApi {
    @Autowired
    InternalRouter internalRouter;

    @Override
    public DeptRespDTO getDept(String id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", "733997198045540435");
        map.put("departCode", id);
        String o = (String)this.internalRouter.inInvoke("org.depart.getDepartByCode", map);
        OrgDepart json = (OrgDepart)JsonUtil.buildNonDefaultBinder().getJsonToObject(o, OrgDepart.class);
        DeptRespDTO deptRespDTO = new DeptRespDTO();
        if (null != o) {
            deptRespDTO.setId(json.getDepartCode());
            deptRespDTO.setName(json.getDepartName());
            deptRespDTO.setParentId(json.getDepartPcode());
            deptRespDTO.setStatus(json.getDataState());
        }
        return deptRespDTO;
    }

    @Override
    public List<DeptRespDTO> getDeptList(Collection<String> ids) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String id : ids) {
            stringBuilder.append(id).append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("departCode", stringBuilder.toString());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String s = (String)this.internalRouter.inInvoke("org.depart.queryDepartPage", param);
        SupQueryResult departPage = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(s, QueryResult.class);
        List departs = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)departPage.getList()), OrgDepart.class);
        ArrayList<DeptRespDTO> list = new ArrayList<DeptRespDTO>();
        for (OrgDepart depart : departs) {
            DeptRespDTO deptRespDTO = new DeptRespDTO();
            deptRespDTO.setId(depart.getDepartCode());
            deptRespDTO.setName(depart.getDepartName());
            deptRespDTO.setParentId(depart.getDepartPcode());
            deptRespDTO.setStatus(depart.getDataState());
            list.add(deptRespDTO);
        }
        return list;
    }

    @Override
    public void validateDeptList(Collection<String> ids) {
        String departCoeds = AdminUserApiImpl.extracted(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("departCode", departCoeds);
        map.put("tenantCode", "733997198045540435");
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String s = (String)this.internalRouter.inInvoke("org.depart.queryDepartPage", parma);
        SupQueryResult departPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(s, QueryResult.class);
        List departs = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)departPage.getList()), OrgDepart.class);
        Map<String, OrgDepart> departMap = CollectionUtils.convertMap(departs, OrgDepart::getDepartCode);
        ids.forEach(id -> {
            OrgDepart orgDepart = (OrgDepart)departMap.get(id);
            if (orgDepart == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.DEPART_NOT_EXISTS);
            }
            if (!CommonStatusEnum.ENABLE.getStatus().equals(orgDepart.getDataState())) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.DEPART_IS_DISABLE, orgDepart.getDepartName());
            }
        });
    }
}

