/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.api.user;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.flowable.api.user.AdminUserApi;
import com.yqbsoft.laser.service.flowable.api.user.dto.AdminUserRespDTO;
import com.yqbsoft.laser.service.flowable.domain.OrgPositionEmpReDomain;
import com.yqbsoft.laser.service.flowable.enums.CommonStatusEnum;
import com.yqbsoft.laser.service.flowable.util.collection.CollectionUtils;
import com.yqbsoft.laser.service.flowable.util.exception.ErrorCodeConstants;
import com.yqbsoft.laser.service.flowable.util.exception.ServiceExceptionUtil;
import com.yqbsoft.laser.service.organize.domain.OrgDepartempReDomain;
import com.yqbsoft.laser.service.organize.domain.OrgPositionReDomain;
import com.yqbsoft.laser.service.organize.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.organize.domain.UmUserReDomainBean;
import com.yqbsoft.laser.service.organize.model.OrgDepart;
import com.yqbsoft.laser.service.organize.model.OrgEmployee;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminUserApiImpl
implements AdminUserApi {
    private static final Logger log = LoggerFactory.getLogger(AdminUserApiImpl.class);
    public static final String TENANTCODE = "733997198045540435";
    @Autowired
    InternalRouter internalRouter;

    @Override
    public AdminUserRespDTO getUser(String id) {
        AdminUserRespDTO adminUserRespDTO = new AdminUserRespDTO();
        adminUserRespDTO.setId(id);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", id);
        map.put("tenantCode", TENANTCODE);
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String emp = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", parma);
        SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(emp, QueryResult.class);
        List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
        log.error(JsonUtil.buildNormalBinder().toJson((Object)("===========================" + emps)));
        String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", parma);
        SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
        List users = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
        log.error(JsonUtil.buildNormalBinder().toJson((Object)("===========================" + users)));
        List departs = null;
        if (ListUtil.isNotEmpty((Collection)emps)) {
            HashMap<String, String> departMap = new HashMap<String, String>();
            departMap.put("employeeCode", ((OrgEmployee)emps.get(0)).getEmployeeCode());
            String departstr = (String)this.internalRouter.inInvoke("org.depart.queryDepartempPage", departMap);
            SupQueryResult departPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(departstr, QueryResult.class);
            departs = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)departPage.getList()), OrgDepartempReDomain.class);
        }
        log.error(JsonUtil.buildNormalBinder().toJson((Object)("===========================" + departs)));
        if (ListUtil.isNotEmpty((Collection)users) && ListUtil.isNotEmpty((Collection)emps) && ListUtil.isNotEmpty(departs)) {
            UmUserReDomainBean umUserReDomainBean = (UmUserReDomainBean)users.get(0);
            OrgEmployee orgEmployee = (OrgEmployee)emps.get(0);
            adminUserRespDTO.setMobile(umUserReDomainBean.getUserPhone());
            adminUserRespDTO.setNickname(orgEmployee.getEmployeeName());
            adminUserRespDTO.setDeptId(((OrgDepartempReDomain)departs.get(0)).getDepartCode());
        }
        return adminUserRespDTO;
    }

    @Override
    public List<AdminUserRespDTO> getUserList(Collection<String> ids) throws ApiException {
        ArrayList<AdminUserRespDTO> userList = new ArrayList<AdminUserRespDTO>();
        for (String id : ids) {
            AdminUserRespDTO adminUserRespDTO = new AdminUserRespDTO();
            adminUserRespDTO.setId(id);
            userList.add(adminUserRespDTO);
        }
        String extracted = AdminUserApiImpl.extracted(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", extracted);
        map.put("tenantCode", TENANTCODE);
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String emp = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", parma);
        SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(emp, QueryResult.class);
        List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
        String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", parma);
        SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
        List users = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
        for (UmUserReDomainBean umUserReDomainBean : users) {
            userList.stream().filter(u -> u.getId().equals(umUserReDomainBean.getUserCode())).forEach(u -> {
                u.setMobile(umUserReDomainBean.getUserPhone());
                u.setStatus(umUserReDomainBean.getDataState());
            });
        }
        String employeeCodes = null;
        if (null != emps && emps.size() > 0) {
            List<String> collect = emps.stream().map(e -> e.getEmployeeCode()).collect(Collectors.toList());
            employeeCodes = AdminUserApiImpl.extracted(collect);
            HashMap<String, String> departMap = new HashMap<String, String>();
            departMap.put("employeeCode", employeeCodes);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(departMap));
            String departstr = (String)this.internalRouter.inInvoke("org.depart.queryDepartempPage", hashMap);
            SupQueryResult departPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(departstr, QueryResult.class);
            List departs = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)departPage.getList()), OrgDepartempReDomain.class);
            if (departs.size() > 0) {
                for (OrgDepartempReDomain orgDepartempReDomain : departs) {
                    emps.stream().filter(e -> e.getEmployeeCode().equals(orgDepartempReDomain.getEmployeeCode())).forEach(e -> e.setMemo(orgDepartempReDomain.getDepartCode()));
                }
            }
            for (OrgEmployee orgEmployee : emps) {
                userList.stream().filter(u -> u.getId().equals(orgEmployee.getUserCode())).forEach(u -> {
                    u.setDeptId(orgEmployee.getMemo());
                    u.setNickname(orgEmployee.getEmployeeName());
                });
            }
        }
        return userList;
    }

    public static String extracted(Collection<String> ids) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String id : ids) {
            stringBuilder.append(id).append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<AdminUserRespDTO> getUserListByDeptIds(Collection<String> deptIds) {
        ArrayList<AdminUserRespDTO> adminUserRespDTOS = new ArrayList<AdminUserRespDTO>();
        for (String deptId : deptIds) {
            HashMap<String, String> departMap = new HashMap<String, String>();
            departMap.put("departCode", deptId);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(departMap));
            String departstr = (String)this.internalRouter.inInvoke("org.depart.queryDepartempPage", hashMap);
            log.error("==================" + departstr);
            SupQueryResult departPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(departstr, QueryResult.class);
            List departs = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)departPage.getList()), OrgDepartempReDomain.class);
            List<String> empCodes = departs.stream().map(d -> d.getEmployeeCode()).collect(Collectors.toList());
            String eCodes = AdminUserApiImpl.extracted(empCodes);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("employeeCode", eCodes);
            HashMap<String, String> emap = new HashMap<String, String>();
            emap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
            String emp = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", emap);
            log.error("==================" + emp);
            SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(emp, QueryResult.class);
            if (null == empPage || null == empPage.getList()) {
                return null;
            }
            List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
            List<String> userCodes = emps.stream().map(p -> p.getUserCode()).collect(Collectors.toList());
            String users = AdminUserApiImpl.extracted(userCodes);
            HashMap<String, String> usermap = new HashMap<String, String>();
            usermap.put("userCode", users);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("map", JsonUtil.buildNonDefaultBinder().toJson(usermap));
            String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", param);
            log.error("==================" + userstr);
            SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
            List userss = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
            for (UmUserReDomainBean d2 : userss) {
                emps.stream().filter(e -> e.getUserCode().equals(d2.getUserCode())).forEach(e -> {
                    AdminUserRespDTO adminUserRespDTO = new AdminUserRespDTO();
                    adminUserRespDTO.setId(e.getUserCode());
                    adminUserRespDTO.setNickname(d2.getUserNickname());
                    adminUserRespDTO.setMobile(d2.getUserPhone());
                    adminUserRespDTO.setDeptId(deptId);
                    adminUserRespDTOS.add(adminUserRespDTO);
                });
            }
        }
        return adminUserRespDTOS;
    }

    @Override
    public List<AdminUserRespDTO> getUsersByPostIds(Collection<String> postIds) {
        ArrayList<AdminUserRespDTO> adminUserRespDTOS = new ArrayList<AdminUserRespDTO>();
        String extracted = AdminUserApiImpl.extracted(postIds);
        HashMap<String, String> positionMap = new HashMap<String, String>();
        positionMap.put("positionCode", extracted);
        SupQueryResult positionEmpPage = (SupQueryResult)this.internalRouter.inInvoke("org.OrgPositionEmp.queryPositionEmpPage", positionMap);
        List empPositions = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)positionEmpPage.getList()), OrgPositionEmpReDomain.class);
        List<String> empCodes = empPositions.stream().map(e -> e.getEmployeeCode()).collect(Collectors.toList());
        String eCodes = AdminUserApiImpl.extracted(empCodes);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("employeeCode", eCodes);
        String emp = (String)this.internalRouter.inInvoke("org.employee.getEmployeeauByCode", map);
        SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(emp, QueryResult.class);
        if (null == empPage || null == empPage.getList()) {
            return null;
        }
        List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
        List<String> userCodes = emps.stream().map(p -> p.getUserCode()).collect(Collectors.toList());
        String users = AdminUserApiImpl.extracted(userCodes);
        HashMap<String, String> usermap = new HashMap<String, String>();
        usermap.put("userCode", users);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("map", JsonUtil.buildNonDefaultBinder().toJson(usermap));
        String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", map2);
        SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
        List userss = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
        emps.stream().forEach(e -> {
            AdminUserRespDTO convert = AdminUserApiImpl.convert(empPositions, e, userss);
            adminUserRespDTOS.add(convert);
        });
        return adminUserRespDTOS;
    }

    private static AdminUserRespDTO convert(List<OrgPositionEmpReDomain> empPositions, OrgEmployee e, List<UmUserReDomainBean> userss) {
        AdminUserRespDTO adminUserRespDTO = new AdminUserRespDTO();
        adminUserRespDTO.setNickname(e.getEmployeeName());
        HashSet<String> se = new HashSet<String>();
        for (OrgPositionEmpReDomain empPosition : empPositions) {
            if (!e.getEmployeeCode().equals(empPosition.getEmployeeCode())) continue;
            se.add(empPosition.getPositionCode());
        }
        adminUserRespDTO.setPostIds(se);
        userss.stream().filter(u -> u.getUserCode().equals(e.getUserCode())).forEach(u -> {
            adminUserRespDTO.setMobile(u.getUserPhone());
            adminUserRespDTO.setId(u.getUserCode());
            adminUserRespDTO.setStatus(u.getDataState());
            adminUserRespDTO.setNickname(e.getEmployeeName());
        });
        return adminUserRespDTO;
    }

    @Override
    public void validateUserList(Collection<String> ids) {
        String userCodes = AdminUserApiImpl.extracted(ids);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userCode", userCodes);
        map.put("tenantCode", TENANTCODE);
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", parma);
        SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
        List users = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
        Map<String, UmUserReDomainBean> userMap = CollectionUtils.convertMap(users, UmUserDomainBean::getUserCode);
        ids.forEach(id -> {
            UmUserReDomainBean umUserReDomainBean = (UmUserReDomainBean)userMap.get(id);
            if (umUserReDomainBean == null) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_NOT_EXISTS);
            }
            if (!CommonStatusEnum.ENABLE.getStatus().equals(umUserReDomainBean.getDataState())) {
                throw ServiceExceptionUtil.exception(ErrorCodeConstants.USER_IS_DISABLE, umUserReDomainBean.getUserNickname());
            }
        });
    }

    @Override
    public List<AdminUserRespDTO> getUserListByPostIds(Collection<String> postIds) {
        ArrayList<AdminUserRespDTO> adminUserRespDTOS = new ArrayList<AdminUserRespDTO>();
        String extracted = AdminUserApiImpl.extracted(postIds);
        HashMap<String, String> positionMap = new HashMap<String, String>();
        positionMap.put("positionCode", extracted);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(positionMap));
        String positionEmpPages = (String)this.internalRouter.inInvoke("org.OrgPositionEmp.queryPositionEmpPage", hashMap);
        SupQueryResult positionEmpPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(positionEmpPages, QueryResult.class);
        List empPositions = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)positionEmpPage.getList()), OrgPositionEmpReDomain.class);
        List<String> empCodes = empPositions.stream().map(e -> e.getEmployeeCode()).collect(Collectors.toList());
        String eCodes = AdminUserApiImpl.extracted(empCodes);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("employeeCode", eCodes);
        HashMap<String, String> emap = new HashMap<String, String>();
        emap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String emp = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", emap);
        SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(emp, QueryResult.class);
        if (null == empPage || null == empPage.getList()) {
            return null;
        }
        List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
        List<String> userCodes = emps.stream().map(p -> p.getUserCode()).collect(Collectors.toList());
        String users = AdminUserApiImpl.extracted(userCodes);
        HashMap<String, String> usermap = new HashMap<String, String>();
        usermap.put("userCode", users);
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(usermap));
        String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", parma);
        SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
        List userss = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
        emps.stream().forEach(e -> {
            AdminUserRespDTO convert = AdminUserApiImpl.convert(empPositions, e, userss);
            adminUserRespDTOS.add(convert);
        });
        return adminUserRespDTOS;
    }

    @Override
    public List<AdminUserRespDTO> getUserListByDeptIdsStroes(List<String> descList, String userPcode) {
        ArrayList<AdminUserRespDTO> adminUserRespDTOS = new ArrayList<AdminUserRespDTO>();
        for (String deptName : descList) {
            HashMap<String, String> departMap = new HashMap<String, String>();
            departMap.put("departName", deptName);
            departMap.put("companyCode", userPcode);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(departMap));
            String departs = (String)this.internalRouter.inInvoke("org.depart.queryDepartPage", hashMap);
            if (StringUtils.isEmpty((String)departs)) {
                log.error("getUserListByDeptIdsStroes.queryDepartPage.isnull", hashMap);
                continue;
            }
            SupQueryResult departPage = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(departs, QueryResult.class);
            if (departPage == null || org.springframework.util.CollectionUtils.isEmpty((Collection)departPage.getList())) {
                log.error("getUserListByDeptIdsStroes.departPage.isnull", hashMap);
                continue;
            }
            List departList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)departPage.getList()), OrgDepart.class);
            HashMap<String, String> departempMap = new HashMap<String, String>();
            departempMap.put("departCode", ((OrgDepart)departList.get(0)).getDepartCode());
            String departstr = (String)this.internalRouter.inInvoke("org.depart.queryDepartempPage", departempMap);
            log.error("==================" + departstr);
            SupQueryResult orgDepartempPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(departstr, QueryResult.class);
            List orgDepartemps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)orgDepartempPage.getList()), OrgDepartempReDomain.class);
            List<String> empCodes = orgDepartemps.stream().map(d -> d.getEmployeeCode()).collect(Collectors.toList());
            String eCodes = AdminUserApiImpl.extracted(empCodes);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("employeeCode", eCodes);
            HashMap<String, String> emap = new HashMap<String, String>();
            emap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
            String emp = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", emap);
            log.error("==================" + emp);
            SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(emp, QueryResult.class);
            if (null == empPage || null == empPage.getList()) {
                return null;
            }
            List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
            List<String> userCodes = emps.stream().map(p -> p.getUserCode()).collect(Collectors.toList());
            String users = AdminUserApiImpl.extracted(userCodes);
            HashMap<String, String> usermap = new HashMap<String, String>();
            usermap.put("userCode", users);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("map", JsonUtil.buildNonDefaultBinder().toJson(usermap));
            String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", param);
            log.error("==================" + userstr);
            SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
            List userss = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
            for (UmUserReDomainBean d2 : userss) {
                emps.stream().filter(e -> e.getUserCode().equals(d2.getUserCode())).forEach(e -> {
                    AdminUserRespDTO adminUserRespDTO = new AdminUserRespDTO();
                    adminUserRespDTO.setId(e.getUserCode());
                    adminUserRespDTO.setNickname(d2.getUserNickname());
                    adminUserRespDTO.setMobile(d2.getUserPhone());
                    adminUserRespDTO.setDeptId(((OrgDepart)departList.get(0)).getDepartCode());
                    adminUserRespDTOS.add(adminUserRespDTO);
                });
            }
        }
        return adminUserRespDTOS;
    }

    @Override
    public List<AdminUserRespDTO> getUserListByPostIdsStores(List<String> descList, String userPcode) {
        String positionNames = descList.stream().collect(Collectors.joining(","));
        HashMap<String, String> positionMaps = new HashMap<String, String>();
        positionMaps.put("positionName", positionNames);
        positionMaps.put("companyCode", userPcode);
        HashMap<String, String> hashMaps = new HashMap<String, String>();
        hashMaps.put("map", JsonUtil.buildNonDefaultBinder().toJson(positionMaps));
        String positionPages = (String)this.internalRouter.inInvoke("org.OrgPosition.queryPositionPage", hashMaps);
        SupQueryResult positionPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(positionPages, QueryResult.class);
        List empPositionList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)positionPage.getList()), OrgPositionReDomain.class);
        ArrayList<AdminUserRespDTO> adminUserRespDTOS = new ArrayList<AdminUserRespDTO>();
        HashMap<String, String> positionMap = new HashMap<String, String>();
        positionMap.put("positionCode", empPositionList.stream().map(u -> u.getPositionCode()).collect(Collectors.joining(",")));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(positionMap));
        String positionEmpPages = (String)this.internalRouter.inInvoke("org.OrgPositionEmp.queryPositionEmpPage", hashMap);
        SupQueryResult positionEmpPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(positionEmpPages, QueryResult.class);
        List empPositions = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)positionEmpPage.getList()), OrgPositionEmpReDomain.class);
        List<String> empCodes = empPositions.stream().map(e -> e.getEmployeeCode()).collect(Collectors.toList());
        String eCodes = AdminUserApiImpl.extracted(empCodes);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("employeeCode", eCodes);
        HashMap<String, String> emap = new HashMap<String, String>();
        emap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        String emp = (String)this.internalRouter.inInvoke("org.employee.queryEmployeePage", emap);
        SupQueryResult empPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(emp, QueryResult.class);
        if (null == empPage || null == empPage.getList()) {
            return null;
        }
        List emps = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)empPage.getList()), OrgEmployee.class);
        List<String> userCodes = emps.stream().map(p -> p.getUserCode()).collect(Collectors.toList());
        String users = AdminUserApiImpl.extracted(userCodes);
        HashMap<String, String> usermap = new HashMap<String, String>();
        usermap.put("userCode", users);
        HashMap<String, String> parma = new HashMap<String, String>();
        parma.put("map", JsonUtil.buildNonDefaultBinder().toJson(usermap));
        String userstr = (String)this.internalRouter.inInvoke("um.user.queryUserPage", parma);
        SupQueryResult userPage = (SupQueryResult)JsonUtil.buildNonDefaultBinder().getJsonToObject(userstr, QueryResult.class);
        List userss = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)userPage.getList()), UmUserReDomainBean.class);
        emps.stream().forEach(e -> {
            AdminUserRespDTO convert = AdminUserApiImpl.convert(empPositions, e, userss);
            adminUserRespDTOS.add(convert);
        });
        return adminUserRespDTOS;
    }

    @Override
    public Map<String, AdminUserRespDTO> getUserMap(Collection<String> ids) {
        return AdminUserApi.super.getUserMap(ids);
    }
}

