/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.flowable.api.sms.SmsSendApi;
import com.yqbsoft.laser.service.flowable.convert.BpmMessageConvert;
import com.yqbsoft.laser.service.flowable.dto.BpmMessageSendWhenProcessInstanceApproveReqDTO;
import com.yqbsoft.laser.service.flowable.dto.BpmMessageSendWhenProcessInstanceRejectReqDTO;
import com.yqbsoft.laser.service.flowable.dto.BpmMessageSendWhenTaskCreatedReqDTO;
import com.yqbsoft.laser.service.flowable.enums.BpmMessageEnum;
import com.yqbsoft.laser.service.flowable.service.BpmMessageService;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

@Validated
public class BpmMessageServiceImpl
extends BaseServiceImpl
implements BpmMessageService {
    private static final Logger log = LoggerFactory.getLogger(BpmMessageServiceImpl.class);
    @Resource
    private SmsSendApi smsSendApi;

    @Override
    public void sendMessageWhenProcessInstanceApprove(BpmMessageSendWhenProcessInstanceApproveReqDTO reqDTO) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        templateParams.put("processInstanceName", reqDTO.getProcessInstanceName());
        templateParams.put("detailUrl", this.getProcessInstanceDetailUrl(reqDTO.getProcessInstanceId()));
        this.smsSendApi.sendSingleSmsToAdmin(BpmMessageConvert.INSTANCE.convert(reqDTO.getStartUserId(), BpmMessageEnum.PROCESS_INSTANCE_APPROVE.getSmsTemplateCode(), templateParams));
    }

    @Override
    public void sendMessageWhenProcessInstanceReject(BpmMessageSendWhenProcessInstanceRejectReqDTO reqDTO) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        templateParams.put("processInstanceName", reqDTO.getProcessInstanceName());
        templateParams.put("reason", reqDTO.getReason());
        templateParams.put("detailUrl", this.getProcessInstanceDetailUrl(reqDTO.getProcessInstanceId()));
        this.smsSendApi.sendSingleSmsToAdmin(BpmMessageConvert.INSTANCE.convert(reqDTO.getStartUserId(), BpmMessageEnum.PROCESS_INSTANCE_REJECT.getSmsTemplateCode(), templateParams));
    }

    @Override
    public void sendMessageWhenTaskAssigned(BpmMessageSendWhenTaskCreatedReqDTO reqDTO) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        templateParams.put("processInstanceName", reqDTO.getProcessInstanceName());
        templateParams.put("taskName", reqDTO.getTaskName());
        templateParams.put("startUserNickname", reqDTO.getStartUserNickname());
        templateParams.put("detailUrl", this.getProcessInstanceDetailUrl(reqDTO.getProcessInstanceId()));
        this.smsSendApi.sendSingleSmsToAdmin(BpmMessageConvert.INSTANCE.convert(reqDTO.getAssigneeUserId(), BpmMessageEnum.TASK_ASSIGNED.getSmsTemplateCode(), templateParams));
    }

    private String getProcessInstanceDetailUrl(String taskId) {
        return null;
    }
}

