/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.flowable.util.json;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static void init(ObjectMapper objectMapper) {
        JsonUtils.objectMapper = objectMapper;
    }

    public static String toJsonString(Object object) {
        return objectMapper.writeValueAsString(object);
    }

    public static byte[] toJsonByte(Object object) {
        return objectMapper.writeValueAsBytes(object);
    }

    public static String toJsonPrettyString(Object object) {
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(text, clazz);
        }
        catch (IOException e) {
            log.error("json parse err,json:{}", (Object)text, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject2(String text, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)text)) {
            return null;
        }
        return (T)JSONUtil.toBean((String)text, clazz);
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (ArrayUtil.isEmpty((byte[])bytes)) {
            return null;
        }
        try {
            return (T)objectMapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            log.error("json parse err,json:{}", (Object)bytes, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(text, typeReference);
        }
        catch (IOException e) {
            log.error("json parse err,json:{}", (Object)text, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        if (StrUtil.isEmpty((CharSequence)text)) {
            return new ArrayList();
        }
        try {
            return (List)objectMapper.readValue(text, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            log.error("json parse err,json:{}", (Object)text, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static JsonNode parseTree(String text) {
        try {
            return objectMapper.readTree(text);
        }
        catch (IOException e) {
            log.error("json parse err,json:{}", (Object)text, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static JsonNode parseTree(byte[] text) {
        try {
            return objectMapper.readTree(text);
        }
        catch (IOException e) {
            log.error("json parse err,json:{}", (Object)text, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isJson(String text) {
        return JSONUtil.isTypeJSON((String)text);
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.registerModules(new Module[]{new JavaTimeModule()});
    }
}

