/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ftp.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.ftp.FtpConfig;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ftp.dao.FtpFtpserverMapper;
import com.yqbsoft.laser.service.ftp.domain.FtpFtpserverDomainBean;
import com.yqbsoft.laser.service.ftp.model.FtpFtpserver;
import com.yqbsoft.laser.service.ftp.service.FtpserverService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FtpserverServiceImpl
extends BaseServiceImpl
implements FtpserverService {
    public static final String SYS_CODE = "ftp.BUG.FtpserverServiceImpl";
    private FtpFtpserverMapper ftpFtpserverMapper;

    public void setFtpFtpserverMapper(FtpFtpserverMapper ftpFtpserverMapper) {
        this.ftpFtpserverMapper = ftpFtpserverMapper;
    }

    private String check(FtpFtpserverDomainBean ftpFtpserverDomainBean) {
        if (null == ftpFtpserverDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ftpFtpserverDomainBean.getFtpserverUrl())) {
            msg = msg + "FtpserverUrl\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ftpFtpserverDomainBean.getFtpserverPort())) {
            msg = msg + "FtpserverPort\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(FtpFtpserver ftpFtpserver) {
        if (null == ftpFtpserver) {
            return;
        }
        if (null == ftpFtpserver.getDataState()) {
            ftpFtpserver.setDataState(0);
        }
        if (null == ftpFtpserver.getGmtCreate()) {
            ftpFtpserver.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)ftpFtpserver.getFtpserverCode())) {
            int code = this.getMaxCode();
            ftpFtpserver.setFtpserverCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ftpFtpserverMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpserverServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUpdataDefault(FtpFtpserver ftpFtpserver) {
        if (null == ftpFtpserver) {
            return;
        }
    }

    private void saveFtpserverModel(FtpFtpserver ftpFtpserver) throws ApiException {
        if (null == ftpFtpserver) {
            return;
        }
        try {
            this.ftpFtpserverMapper.insert(ftpFtpserver);
        }
        catch (Exception e) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.saveFtpserverModel.ex");
        }
    }

    private FtpFtpserver getFtpserverModelById(Integer ftpserverId) {
        if (null == ftpserverId) {
            return null;
        }
        try {
            return this.ftpFtpserverMapper.selectByPrimaryKey(ftpserverId);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpserverServiceImpl.getFtpserverModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteFtpserverModel(Integer ftpserverId) throws ApiException {
        if (null == ftpserverId) {
            return;
        }
        int i = 0;
        try {
            i = this.ftpFtpserverMapper.deleteByPrimaryKey(ftpserverId);
        }
        catch (Exception e) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.deleteFtpserverModel.ex");
        }
        if (1 != i) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.deleteFtpserverModel.num");
        }
    }

    private void updateFtpserverModel(FtpFtpserver ftpFtpserver) throws ApiException {
        if (null == ftpFtpserver) {
            return;
        }
        try {
            this.ftpFtpserverMapper.updateByPrimaryKey(ftpFtpserver);
        }
        catch (Exception e) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.updateFtpserverModel.ex");
        }
    }

    private Date getSysDate() {
        try {
            return this.ftpFtpserverMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpserverServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void updateStateFtpserverMode(Integer ftpserverId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == ftpserverId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ftpserverId", ftpserverId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ftpFtpserverMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.updateStateFtpserverModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.updateStateFtpserverModel.null");
        }
    }

    private List<FtpFtpserver> queryFtpserverModelPage(Map<String, Object> parammap) {
        try {
            return this.ftpFtpserverMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpserverServiceImpl.queryFtpserverModel", (Throwable)e);
            return null;
        }
    }

    private FtpFtpserver makeFtpserver(FtpFtpserverDomainBean ftpFtpserverDomainBean, FtpFtpserver ftpFtpserver) {
        if (null == ftpFtpserverDomainBean) {
            return null;
        }
        if (null == ftpFtpserver) {
            ftpFtpserver = new FtpFtpserver();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ftpFtpserver, (Object)ftpFtpserverDomainBean);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpserverServiceImpl.makeFtpserver", (Throwable)e);
        }
        return ftpFtpserver;
    }

    private int countFtpserver(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ftpFtpserverMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpserverServiceImpl.countFtpserver", (Throwable)e);
        }
        return i;
    }

    private List<FtpFtpserver> queryFtpserver(Map<String, Object> parammap) {
        try {
            return this.ftpFtpserverMapper.queryFtpserver(parammap);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpserverServiceImpl.queryAdaptation", (Throwable)e);
            return null;
        }
    }

    private FtpConfig createFtp(FtpFtpserver ftpFtpserver) {
        if (null == ftpFtpserver) {
            return null;
        }
        FtpConfig ftpConfig = new FtpConfig();
        try {
            BeanUtils.copyAllPropertys((Object)ftpConfig, (Object)ftpFtpserver);
        }
        catch (Exception e) {
            this.logger.error("ftp.BUG.FtpserverServiceImpl.createFtp", (Throwable)e);
        }
        return ftpConfig;
    }

    @Override
    public void saveFtpserver(FtpFtpserverDomainBean ftpFtpserverDomainBean) throws ApiException {
        String msg = this.check(ftpFtpserverDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.saveFtpserver.check", msg);
        }
        FtpFtpserver ftpFtpserver = this.makeFtpserver(ftpFtpserverDomainBean, null);
        this.setDefault(ftpFtpserver);
        this.saveFtpserverModel(ftpFtpserver);
    }

    @Override
    public void updateFtpserverState(Integer ftpserverId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFtpserverMode(ftpserverId, dataState, oldDataState);
    }

    @Override
    public void updateFtpserver(FtpFtpserverDomainBean ftpFtpserverDomainBean) throws ApiException {
        String msg = this.check(ftpFtpserverDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.updateFtpserver.check", msg);
        }
        FtpFtpserver oldFtpFtpserver = this.getFtpserverModelById(ftpFtpserverDomainBean.getFtpserverId());
        if (null == oldFtpFtpserver) {
            throw new ApiException("ftp.BUG.FtpserverServiceImpl.updateFtpserver.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        FtpFtpserver ftpFtpserver = this.makeFtpserver(ftpFtpserverDomainBean, oldFtpFtpserver);
        this.setUpdataDefault(ftpFtpserver);
        this.updateFtpserverModel(ftpFtpserver);
    }

    @Override
    public FtpFtpserver getFtpserver(Integer ftpserverId) {
        return this.getFtpserverModelById(ftpserverId);
    }

    @Override
    public void deleteFtpserver(Integer ftpserverId) throws ApiException {
        this.deleteFtpserverModel(ftpserverId);
    }

    @Override
    public QueryResult<FtpFtpserver> queryFtpserverPage(Map<String, Object> map) {
        List<FtpFtpserver> ftpFtpserverList = this.queryFtpserverModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFtpserver(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ftpFtpserverList);
        return queryResult;
    }

    @Override
    public void queryFtpserverLoadCache() {
        this.logger.info("FtpFtpserver", (Object)"=======\u8c03\u5ea6start=======");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<FtpFtpserver> ftpFtpserverList = this.queryFtpserver(parammap);
        String cachekey = "FtpFtpserver-list";
        if (null == ftpFtpserverList || ftpFtpserverList.isEmpty()) {
            DisUtil.delVer((String)cachekey);
            this.logger.info("FtpFtpserver", (Object)"=======\u8c03\u5ea6end==del=======");
            return;
        }
        HashMap<String, ArrayList<FtpConfig>> ftpmap = new HashMap<String, ArrayList<FtpConfig>>();
        ArrayList<FtpConfig> ftpConfigList = null;
        for (FtpFtpserver ftpFtpserver : ftpFtpserverList) {
            if (StringUtils.isBlank((String)ftpFtpserver.getAppmanageAppkey())) {
                ftpFtpserver.setAppmanageAppkey(ftpFtpserver.getAppmanageIcode());
            }
            if (null == (ftpConfigList = (ArrayList<FtpConfig>)ftpmap.get(ftpFtpserver.getAppmanageAppkey()))) {
                ftpConfigList = new ArrayList<FtpConfig>();
                ftpmap.put(ftpFtpserver.getAppmanageAppkey(), ftpConfigList);
            }
            ftpConfigList.add(this.createFtp(ftpFtpserver));
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        for (String key : ftpmap.keySet()) {
            cacheMap.put(key, JsonUtil.buildNormalBinder().toJson(ftpmap.get(key)));
        }
        DisUtil.setJsonVer((String)cachekey, cacheMap);
        this.logger.info("FtpFtpserver", (Object)"=======\u8c03\u5ea6end=======");
    }
}

