/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftUserMapper;
import com.yqbsoft.laser.service.gt.domain.BuyGiftBean;
import com.yqbsoft.laser.service.gt.domain.CdCardpUserDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserBean;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserReDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserRedeemDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserrelDomain;
import com.yqbsoft.laser.service.gt.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.gt.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.gt.domain.OcContractReDomain;
import com.yqbsoft.laser.service.gt.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.gt.domain.ReceiveGiftUserDomain;
import com.yqbsoft.laser.service.gt.domain.TaTransferaDomain;
import com.yqbsoft.laser.service.gt.domain.TaTransferaListDomain;
import com.yqbsoft.laser.service.gt.domain.UmUserinfo;
import com.yqbsoft.laser.service.gt.domain.UpmUpointsClearDomain;
import com.yqbsoft.laser.service.gt.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.gt.model.GtGift;
import com.yqbsoft.laser.service.gt.model.GtGiftUser;
import com.yqbsoft.laser.service.gt.model.GtGiftUserrel;
import com.yqbsoft.laser.service.gt.service.GtGiftService;
import com.yqbsoft.laser.service.gt.service.GtGiftUserRedeemService;
import com.yqbsoft.laser.service.gt.service.GtGiftUserService;
import com.yqbsoft.laser.service.gt.service.GtGiftUserrelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GtGiftUserServiceImpl
extends BaseServiceImpl
implements GtGiftUserService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftUserServiceImpl";
    private GtGiftUserMapper gtGiftUserMapper;
    private GtGiftService gtGiftService;
    private GtGiftUserrelService gtGiftUserrelService;
    private GtGiftUserRedeemService gtGiftUserRedeemService;
    private String api_userinfo = "um.user.getUserinfoByUserCode";
    private static final ExecutorService pool = Executors.newFixedThreadPool(2);

    public void setGtGiftUserrelService(GtGiftUserrelService gtGiftUserrelService) {
        this.gtGiftUserrelService = gtGiftUserrelService;
    }

    public GtGiftUserRedeemService getGtGiftUserRedeemService() {
        return this.gtGiftUserRedeemService;
    }

    public void setGtGiftUserRedeemService(GtGiftUserRedeemService gtGiftUserRedeemService) {
        this.gtGiftUserRedeemService = gtGiftUserRedeemService;
    }

    public void setGtGiftService(GtGiftService gtGiftService) {
        this.gtGiftService = gtGiftService;
    }

    public void setGtGiftUserMapper(GtGiftUserMapper gtGiftUserMapper) {
        this.gtGiftUserMapper = gtGiftUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftUser(GtGiftUserDomain gtGiftUserDomain) {
        if (null == gtGiftUserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftUserDomain.getMemberBcode())) {
            msg = msg + "MemberBcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)gtGiftUserDomain.getMemberBname())) {
            msg = msg + "MemberBname\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)gtGiftUserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftUserDefault(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return;
        }
        if (null == gtGiftUser.getDataState()) {
            gtGiftUser.setDataState(4);
        }
        if (null == gtGiftUser.getGmtCreate()) {
            gtGiftUser.setGmtCreate(this.getSysDate());
        }
        gtGiftUser.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftUser.getGiftUserCode())) {
            gtGiftUser.setGiftUserCode(this.createUUIDString());
        }
    }

    private int getGiftUserMaxCode() {
        int code = 0;
        try {
            return this.gtGiftUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftUserUpdataDefault(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return;
        }
        gtGiftUser.setGmtModified(this.getSysDate());
    }

    private void saveGiftUserModel(GtGiftUser gtGiftUser) throws ApiException {
        if (null == gtGiftUser) {
            return;
        }
        try {
            this.gtGiftUserMapper.insert(gtGiftUser);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUserModel.ex", (Throwable)e);
        }
    }

    private void saveGiftUserBatchModel(List<GtGiftUser> gtGiftUserList) throws ApiException {
        if (null == gtGiftUserList || gtGiftUserList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftUserMapper.insertBatch(gtGiftUserList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUserBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftUser getGiftUserModelById(Integer giftUserId) {
        if (null == giftUserId) {
            return null;
        }
        try {
            return this.gtGiftUserMapper.selectByPrimaryKey(giftUserId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftUser getGiftUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.delGiftUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.delGiftUserModelByCode.num");
        }
    }

    private void deleteGiftUserModel(Integer giftUserId) throws ApiException {
        if (null == giftUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.deleteByPrimaryKey(giftUserId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.deleteGiftUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.deleteGiftUserModel.num");
        }
    }

    private void updateGiftUserModel(GtGiftUser gtGiftUser) throws ApiException {
        if (null == gtGiftUser) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateByPrimaryKeySelective(gtGiftUser);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserModel.num");
        }
    }

    private void updateGiftUserModelByCode(GtGiftUser gtGiftUser) throws ApiException {
        if (null == gtGiftUser) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateByCode(gtGiftUser);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserModelByCode.num");
        }
    }

    private void updateGiftUserTimeModelByCode(GtGiftUser gtGiftUser) throws ApiException {
        if (null == gtGiftUser) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateTimeByCode(gtGiftUser);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserTimeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserTimeModelByCode.num");
        }
    }

    private void updateStateGiftUserModel(Integer giftUserId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftUserId", giftUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModel.null");
        }
    }

    private void updateStateGiftUserModelByCode(String tenantCode, String giftUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModelByCode.null");
        }
    }

    private GtGiftUser makeGiftUser(GtGiftUserDomain gtGiftUserDomain, GtGiftUser gtGiftUser) {
        if (null == gtGiftUserDomain) {
            return null;
        }
        if (null == gtGiftUser) {
            gtGiftUser = new GtGiftUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUser, (Object)gtGiftUserDomain);
            return gtGiftUser;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.makeGiftUser", (Throwable)e);
            return null;
        }
    }

    private GtGiftUserReDomain makeGtGiftUserReDomain(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = new GtGiftUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUserReDomain, (Object)gtGiftUser);
            return gtGiftUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.makeGtGiftUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftUser> queryGiftUserModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.queryGiftUserModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.countGiftUser", (Throwable)e);
        }
        return i;
    }

    private GtGiftUser createGtGiftUser(GtGiftUserDomain gtGiftUserDomain) {
        String msg = this.checkGiftUser(gtGiftUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUser.checkGiftUser", msg);
        }
        GtGiftUser gtGiftUser = this.makeGiftUser(gtGiftUserDomain, null);
        if (null == gtGiftUser.getDataState()) {
            gtGiftUser.setDataState(4);
        }
        this.setGiftUserDefault(gtGiftUser);
        return gtGiftUser;
    }

    @Override
    public String saveGiftUser(GtGiftUserDomain gtGiftUserDomain) throws ApiException {
        GtGiftUser gtGiftUser = this.createGtGiftUser(gtGiftUserDomain);
        this.saveGiftUserModel(gtGiftUser);
        GtGiftUserRedeemDomain gtGiftUserRedeemDomain = new GtGiftUserRedeemDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUserRedeemDomain, (Object)gtGiftUser);
            gtGiftUserRedeemDomain.setGiftRedeem(this.getSysDate());
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.saveGiftUser", (Throwable)e);
        }
        this.gtGiftUserRedeemService.saveGiftUserRedeem(gtGiftUserRedeemDomain);
        return gtGiftUser.getGiftUserCode();
    }

    @Override
    public String saveGiftUserBatch(List<GtGiftUserDomain> gtGiftUserDomainList) throws ApiException {
        if (null == gtGiftUserDomainList || gtGiftUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftUser> gtGiftUserList = new ArrayList<GtGiftUser>();
        GtGiftUser gtGiftUser = null;
        String code = "";
        for (GtGiftUserDomain gtGiftUserDomain : gtGiftUserDomainList) {
            gtGiftUser = this.createGtGiftUser(gtGiftUserDomain);
            code = gtGiftUser.getGiftUserCode();
            gtGiftUserList.add(gtGiftUser);
        }
        this.saveGiftUserBatchModel(gtGiftUserList);
        for (GtGiftUser gtGiftUser1 : gtGiftUserList) {
            this.sendMns(gtGiftUser1);
        }
        return code;
    }

    @Override
    public void sendGiftUserMsg(String giftUserCode, String tenantCode) {
        if (StringUtils.isBlank((String)giftUserCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        GtGiftUser gtGiftUser = this.getGiftUserByCode(tenantCode, giftUserCode);
        if (null == gtGiftUser) {
            return;
        }
        this.sendMns(gtGiftUser);
    }

    public void sendMns(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return;
        }
        if (!"1".equals(gtGiftUser.getGiftUserType()) || !"0".equals(gtGiftUser.getSendState().toString())) {
            return;
        }
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("userinfoCode", gtGiftUser.getMemberBcode());
        paramMap1.put("tenantCode", gtGiftUser.getTenantCode());
        UmUserinfo umUserinfo = (UmUserinfo)this.readObj("um.user.getUserinfoByUserCode", paramMap1, "object", new Object[]{UmUserinfo.class});
        if (null == umUserinfo) {
            return;
        }
        String phone = umUserinfo.getUserinfoPhone();
        if (StringUtils.isBlank((String)phone)) {
            return;
        }
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        mnsMap.put("mnslistSubject", "");
        mnsMap.put("mnslistSource", "0");
        mnsMap.put("mnslistBusType", "g1");
        ArrayList<Map<String, String>> receiverList = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("telphone", phone);
        map.put("name", umUserinfo.getUserinfoCompname());
        receiverList.add(map);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("memberName", gtGiftUser.getCompanyShortname());
        contentMap.put("giftName", gtGiftUser.getGiftName());
        contentMap.put("name", umUserinfo.getUserinfoCompname());
        mnsMap.put("mnslistExp", this.getMnslistExp(contentMap, receiverList));
        mnsMap.put("tenantCode", gtGiftUser.getTenantCode());
        HashMap paramMap = new HashMap();
    }

    private String getMnslistExp(Map<String, String> contentMap, List<Map<String, String>> receiverList) {
        HashMap<String, String> expMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(contentMap);
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        expMap.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        expMap.put("theme", "");
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(expMap);
    }

    @Override
    public void updateGiftUserState(Integer giftUserId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftUserModel(giftUserId, dataState, oldDataState);
    }

    @Override
    public void updateGiftUserStateByCode(String tenantCode, String giftUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftUserModelByCode(tenantCode, giftUserCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftUser(GtGiftUserDomain gtGiftUserDomain) throws ApiException {
        String msg = this.checkGiftUser(gtGiftUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.checkGiftUser", msg);
        }
        GtGiftUser oldGtGiftUser = this.getGiftUserModelById(gtGiftUserDomain.getGiftUserId());
        if (null == oldGtGiftUser) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftUser gtGiftUser = this.makeGiftUser(gtGiftUserDomain, oldGtGiftUser);
        this.setGiftUserUpdataDefault(gtGiftUser);
        this.updateGiftUserModel(gtGiftUser);
    }

    @Override
    public GtGiftUser getGiftUser(Integer giftUserId) {
        return this.getGiftUserModelById(giftUserId);
    }

    @Override
    public void deleteGiftUser(Integer giftUserId) throws ApiException {
        this.deleteGiftUserModel(giftUserId);
    }

    @Override
    public QueryResult<GtGiftUser> queryGiftUserPage(Map<String, Object> map) {
        List<GtGiftUser> gtGiftUserList = this.queryGiftUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftUserList);
        return queryResult;
    }

    @Override
    public void updateScontractDataState() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("order", true);
        param.put("fuzzy", true);
        param.put("tenantCode", "2020063000000001");
        QueryResult<GtGiftUser> gtGiftUserReDomainSupQueryResult = this.queryGiftUserPage(param);
        if (null != gtGiftUserReDomainSupQueryResult && ListUtil.isNotEmpty((Collection)gtGiftUserReDomainSupQueryResult.getList())) {
            this.logger.error("-------------------------\u67e5\u8be2\u7ed3\u679c\u4e0d\u4e3a\u7a7a,\u6709\u6570\u636e \u6761\u6570-------------------" + gtGiftUserReDomainSupQueryResult.getRows().size());
            this.logger.error("-------------------------\u67e5\u8be2\u7ed3\u679c\u4e0d\u4e3a\u7a7a,\u6709\u6570\u636e-------------------" + JsonUtil.buildNormalBinder().toJson((Object)gtGiftUserReDomainSupQueryResult.getList()));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (GtGiftUser gtGiftUserDomain : gtGiftUserReDomainSupQueryResult.getList()) {
                try {
                    Integer dataState = -1;
                    if (null != gtGiftUserDomain.getCompanyCode() && !"".equals(gtGiftUserDomain.getCompanyCode())) {
                        dataState = Integer.valueOf(gtGiftUserDomain.getCompanyCode());
                    }
                    if (null == gtGiftUserDomain.getMemberCcode() || null == gtGiftUserDomain.getMemberCname()) continue;
                    Date start = null;
                    Date end = null;
                    start = sdf.parse(gtGiftUserDomain.getMemberCcode());
                    end = sdf.parse(gtGiftUserDomain.getMemberCname());
                    long endDate = end.getTime();
                    long startDate = start.getTime();
                    long nowDate = new Date().getTime();
                    if (dataState != 5) {
                        if (startDate > nowDate) {
                            dataState = 0;
                        } else if (nowDate >= startDate && nowDate <= endDate) {
                            if (dataState == 2) {
                                dataState = 2;
                            } else if (gtGiftUserDomain.getAppmanageIcode() != null && !"".equals(gtGiftUserDomain.getAppmanageIcode())) {
                                dataState = Double.valueOf(gtGiftUserDomain.getAppmanageIcode()) == 0.0 ? Integer.valueOf(4) : Integer.valueOf(1);
                            }
                        } else if (gtGiftUserDomain.getAppmanageIcode() != null && !"".equals(gtGiftUserDomain.getAppmanageIcode())) {
                            dataState = Double.valueOf(gtGiftUserDomain.getAppmanageIcode()) > 0.0 ? Integer.valueOf(3) : Integer.valueOf(4);
                        }
                    }
                    gtGiftUserDomain.setCompanyCode(dataState.toString());
                    GtGiftUserDomain gtGiftUserDomain1 = new GtGiftUserDomain();
                    BeanUtils.copyAllPropertys((Object)gtGiftUserDomain1, (Object)gtGiftUserDomain);
                    this.logger.error("------------gtGiftUserDomain1---------------" + JsonUtil.buildNormalBinder().toJson((Object)gtGiftUserDomain1));
                    this.updateGiftUser(gtGiftUserDomain1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("--------\u6570\u636e\u6709\u95ee\u9898---------" + gtGiftUserDomain.getGiftUserId());
                }
            }
        }
    }

    @Override
    public GtGiftUser getGiftUserByCode(String tenantCode, String giftUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        return this.getGiftUserModelByCode(map);
    }

    @Override
    public void deleteGiftUserByCode(String tenantCode, String giftUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        this.delGiftUserModelByCode(map);
    }

    private void updateGiftUserState() {
        try {
            this.gtGiftUserMapper.updateGiftUserState();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserState", (Throwable)e);
        }
    }

    private void updateGiftUserValid(Map<String, Object> map) {
        try {
            this.gtGiftUserMapper.updateGiftUserValidState(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserValid", (Throwable)e);
        }
    }

    private void updateGiftUserValidDataState(GtGiftUser gtGiftUser, GtGift gtGift) {
        if (null == gtGiftUser || null == gtGift || !"3".equals(gtGift.getGiftOver())) {
            return;
        }
        String tenantCode = gtGiftUser.getTenantCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftUserCode", gtGiftUser.getGiftUserCode());
        map.put("tenantCode", tenantCode);
        if ("0".equals(gtGift.getGiftOver())) {
            map.put("dataState", 6);
            map.put("oldDataState", 0);
        }
        if ("2".equals(gtGift.getGiftOver()) || "1".equals(gtGift.getGiftOver())) {
            map.put("dataState", 5);
            map.put("oldDataState", 0);
        }
        try {
            this.gtGiftUserMapper.updateGiftUserValidDataStat(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserValidDataState", (Throwable)e);
        }
    }

    private List<GtGiftUser> queryVaildGiftUser() {
        try {
            return this.gtGiftUserMapper.queryVaildGiftUser();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.queryVaildGiftUser", (Throwable)e);
            return null;
        }
    }

    @Override
    public String saveGiftUserByBuyGift(List<BuyGiftBean> buyGiftBeanList) throws ApiException {
        this.logger.error("saveGiftUserByBuyGift************buyGiftBeanList", (Object)JsonUtil.buildNormalBinder().toJson(buyGiftBeanList));
        if (null == buyGiftBeanList || buyGiftBeanList.size() == 0) {
            return "false";
        }
        for (BuyGiftBean buyGiftBean : buyGiftBeanList) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("userinfoCode", buyGiftBean.getUserinfoCode());
            paramMap.put("tenantCode", buyGiftBean.getTenantCode());
            String userinfoStr = this.internalInvoke(this.api_userinfo, paramMap);
            if (StringUtils.isBlank((String)userinfoStr)) {
                return "false";
            }
            UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
            this.logger.error("saveGiftUserByBuyGift************umUserinfo", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfo));
            GtGift gtGift = this.gtGiftService.getGiftByCode(buyGiftBean.getTenantCode(), buyGiftBean.getGiftCode());
            this.logger.error("saveGiftUserByBuyGift************gtGift", (Object)JsonUtil.buildNormalBinder().toJson((Object)gtGift));
            if (null == gtGift) {
                return "false";
            }
            ArrayList<GtGiftUserBean> gtGiftUserBeanList = new ArrayList<GtGiftUserBean>();
            GtGiftUserBean gtGiftUserBean = new GtGiftUserBean();
            gtGiftUserBean.setGiftCode(buyGiftBean.getGiftCode());
            gtGiftUserBean.setGiftUserType(umUserinfo.getUserinfoType() + "");
            gtGiftUserBean.setGiftUserNum(buyGiftBean.getBuyAmount());
            gtGiftUserBean.setMemberBcode(buyGiftBean.getUserinfoCode());
            gtGiftUserBean.setMemberBname(umUserinfo.getUserinfoCompname());
            gtGiftUserBean.setTenantCode(buyGiftBean.getTenantCode());
            gtGiftUserBean.setGiftStart(gtGift.getGiftStart());
            gtGiftUserBean.setGiftEnd(gtGift.getGiftEnd());
            gtGiftUserBean.setGiftUrl(gtGift.getGiftUrl());
            gtGiftUserBean.setMemberCode(gtGift.getMemberCode());
            gtGiftUserBean.setMemberName(gtGift.getMemberName());
            gtGiftUserBean.setSendState(1);
            gtGiftUserBean.setDataState(4);
            gtGiftUserBean.setGiftUserPhone(umUserinfo.getUserinfoPhone());
            gtGiftUserBeanList.add(gtGiftUserBean);
            this.logger.error("saveGiftUserByBuyGift************gtGiftUserBeanList", (Object)JsonUtil.buildNormalBinder().toJson(gtGiftUserBeanList));
            HashMap<String, String> paramMap1 = new HashMap<String, String>();
            paramMap1.put("gtGiftUserBeanList", JsonUtil.buildNormalBinder().toJson(gtGiftUserBeanList));
            this.logger.error("saveGiftUserByBuyGift************paramMap1", paramMap1);
            this.internalInvoke("gt.gtgiftuserlist.saveGiftUserAndList", paramMap1);
        }
        this.logger.error("saveGiftUserByBuyGift************sucess");
        return "success";
    }

    @Override
    public String updateGiftUserCallBackLock(List<ReceiveGiftUserDomain> receiveGiftUserDomainList) throws ApiException {
        return this.updateGiftUserLock(receiveGiftUserDomainList, "0");
    }

    private String updateGiftUserLock(List<ReceiveGiftUserDomain> receiveGiftUserDomainList, String direction) {
        this.logger.info("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBack", (Object)JsonUtil.buildNormalBinder().toJson(receiveGiftUserDomainList));
        if (null == receiveGiftUserDomainList || receiveGiftUserDomainList.size() == 0) {
            return "error";
        }
        for (ReceiveGiftUserDomain receiveGiftUserDomain : receiveGiftUserDomainList) {
            String giftUserCode = receiveGiftUserDomain.getGiftUserCode();
            String tenantCode = receiveGiftUserDomain.getTenantCode();
            GtGiftUser gtGiftUser = this.getGiftUserByCode(tenantCode, giftUserCode);
            if (null == gtGiftUser.getGiftUserCamt()) {
                gtGiftUser.setGiftUserCamt(BigDecimal.ZERO);
            }
            if (null == gtGiftUser.getGiftUserCnum()) {
                gtGiftUser.setGiftUserCnum(BigDecimal.ZERO);
            }
            if (direction.equals("0")) {
                gtGiftUser.setGiftUserCamt(receiveGiftUserDomain.getGiftUserCamt());
                gtGiftUser.setGiftUserCnum(receiveGiftUserDomain.getGiftUserCnum());
            } else if (direction.equals("-1")) {
                gtGiftUser.setGiftUserCamt(receiveGiftUserDomain.getGiftUserCamt());
                gtGiftUser.setGiftUserCnum(receiveGiftUserDomain.getGiftUserCnum());
            }
            if (gtGiftUser.getGiftUserCamt().compareTo(BigDecimal.ZERO) < 0 || gtGiftUser.getGiftUserCnum().compareTo(BigDecimal.ZERO) < 0) {
                return "error";
            }
            if (null != gtGiftUser.getValidState() && 1 == gtGiftUser.getValidState()) {
                gtGiftUser.setDataState(3);
            }
            if ("1".equals(gtGiftUser.getGiftCtype())) {
                BigDecimal allNum;
                BigDecimal giftCnum;
                BigDecimal userrelNum = gtGiftUser.getGiftUserNum();
                if (null == userrelNum) {
                    userrelNum = BigDecimal.ZERO;
                }
                if (null == (giftCnum = gtGiftUser.getGiftCnum())) {
                    giftCnum = BigDecimal.ZERO;
                }
                if (null == (allNum = giftCnum.multiply(userrelNum))) {
                    allNum = BigDecimal.ZERO;
                }
                if (gtGiftUser.getGiftUserCnum().compareTo(allNum) == 0) {
                    gtGiftUser.setDataState(1);
                } else if (1 != gtGiftUser.getDataState()) {
                    gtGiftUser.setDataState(2);
                } else {
                    gtGiftUser.setDataState(1);
                }
                if ("0".equals(gtGiftUser.getGiftChange())) {
                    BigDecimal allNum1;
                    BigDecimal giftCnum1;
                    BigDecimal userrelNum1 = gtGiftUser.getGiftUserNum();
                    if (null == userrelNum1) {
                        userrelNum1 = BigDecimal.ZERO;
                    }
                    if (null == (giftCnum1 = gtGiftUser.getGiftCnum())) {
                        giftCnum1 = BigDecimal.ZERO;
                    }
                    if (null == (allNum1 = giftCnum1.multiply(userrelNum1))) {
                        allNum1 = BigDecimal.ZERO;
                    }
                    if (gtGiftUser.getGiftUserCamt().compareTo(allNum1) == 0) {
                        gtGiftUser.setDataState(1);
                    } else {
                        gtGiftUser.setDataState(2);
                    }
                }
            } else {
                gtGiftUser.setDataState(1);
            }
            int i = 0;
            try {
                i = this.gtGiftUserMapper.updateAmtByPrimaryKeyLock(gtGiftUser);
            }
            catch (Exception e) {
                throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateAmtByPrimaryKeyLock.ex", JsonUtil.buildNonDefaultBinder().toJson((Object)gtGiftUser), (Throwable)e);
            }
            if (i <= 0) {
                throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateAmtByPrimaryKeyLock.null", JsonUtil.buildNonDefaultBinder().toJson((Object)gtGiftUser));
            }
            if (null == gtGiftUser) continue;
            GtGiftUser oldgtGiftUser = gtGiftUser;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuCode", receiveGiftUserDomain.getSkuCode());
            map.put("tenantCode", tenantCode);
            map.put("giftUserCode", receiveGiftUserDomain.getGiftUserCode());
            map.put("memberBcode", receiveGiftUserDomain.getMemeberBcode());
            QueryResult<GtGiftUserrel> gtGiftUserrelQueryResult = this.gtGiftUserrelService.queryGiftUserrelPage(map);
            List gtGiftUserrelList = gtGiftUserrelQueryResult.getList();
            if (null != gtGiftUserrelList && gtGiftUserrelList.size() > 0) {
                GtGiftUserrel gtGiftUserrel = (GtGiftUserrel)gtGiftUserrelList.get(0);
                GtGiftUserrelDomain gtGiftUserrelDomain = new GtGiftUserrelDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)gtGiftUserrelDomain, (Object)gtGiftUserrel);
                }
                catch (Exception e) {
                    this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBack.e", (Throwable)e);
                }
                if (null == gtGiftUserrelDomain.getGiftUserrelNum()) {
                    gtGiftUserrelDomain.setGiftUserrelNum(BigDecimal.ZERO);
                }
                if (null == gtGiftUserrelDomain.getGiftUserrelAmt()) {
                    gtGiftUserrelDomain.setGiftUserrelAmt(BigDecimal.ZERO);
                }
                gtGiftUserrelDomain.setGiftUserCode(receiveGiftUserDomain.getGiftUserCode());
                if (null == gtGiftUserrelDomain.getGiftUserrelNum()) {
                    gtGiftUserrelDomain.setGiftUserrelNum(BigDecimal.ZERO);
                }
                if (null == gtGiftUserrelDomain.getGiftUserrelAmt()) {
                    gtGiftUserrelDomain.setGiftUserrelAmt(BigDecimal.ZERO);
                }
                if (direction.equals("0")) {
                    gtGiftUserrelDomain.setGiftUserrelNum(gtGiftUserrelDomain.getGiftUserrelNum().add(receiveGiftUserDomain.getGiftUserCnum()));
                    gtGiftUserrelDomain.setGiftUserrelAmt(gtGiftUserrelDomain.getGiftUserrelAmt().add(receiveGiftUserDomain.getGiftUserCamt()));
                } else if (direction.equals("-1")) {
                    gtGiftUserrelDomain.setGiftUserrelNum(gtGiftUserrelDomain.getGiftUserrelNum().subtract(receiveGiftUserDomain.getGiftUserCnum()));
                    gtGiftUserrelDomain.setGiftUserrelAmt(gtGiftUserrelDomain.getGiftUserrelAmt().subtract(receiveGiftUserDomain.getGiftUserCamt()));
                }
                this.gtGiftUserrelService.updateGiftUserrel(gtGiftUserrelDomain);
            }
            this.sendNMS(gtGiftUser, oldgtGiftUser);
        }
        return "success";
    }

    private void updateCardpUser(GtGiftUser gtGiftUser) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantCode", gtGiftUser.getTenantCode());
        param.put("cardplistCode", gtGiftUser.getGiftUserOcode2());
        HashMap<String, String> pMap = new HashMap<String, String>();
        this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateCardpUser.map", (Object)JsonUtil.buildNormalBinder().toJson(param));
        pMap.put("map", JsonUtil.buildNormalBinder().toJson(param));
        String invoke = this.internalInvoke("cd.cdcardpuser.queryCardpUserPage", pMap);
        if (StringUtils.isNotBlank((String)invoke)) {
            CdCardpUserDomain cdCardpUserDomain;
            QueryResult jsonToObject = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(invoke, QueryResult.class);
            List cdCardpUserList = JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)jsonToObject.getList()), CdCardpUserDomain.class);
            if (ListUtil.isNotEmpty((Collection)cdCardpUserList) && (null == (cdCardpUserDomain = (CdCardpUserDomain)cdCardpUserList.get(0)).getCardpOpstate() || !cdCardpUserDomain.getCardpOpstate().equals(gtGiftUser.getDataState()))) {
                this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateCardpUser.dataState", (Object)gtGiftUser.getDataState());
                cdCardpUserDomain.setCardpOpstate(gtGiftUser.getDataState());
                HashMap<String, String> pMap2 = new HashMap<String, String>();
                pMap2.put("cdCardpUserDomain", JsonUtil.buildNormalBinder().toJson((Object)cdCardpUserDomain));
                this.internalInvoke("cd.cdcardpuser.updateCardpUser", pMap2);
            }
        }
    }

    @Override
    public void autoGiftUserDataState() {
        try {
            this.updateGiftUserState();
        }
        catch (Exception e) {
            this.logger.error(".updateGiftUserState", (Throwable)e);
        }
        List<GtGiftUser> gtGiftUserList = this.queryVaildGiftUser();
        if (ListUtil.isEmpty(gtGiftUserList)) {
            return;
        }
        GtGift gtGift = null;
        for (GtGiftUser gtGiftUser : gtGiftUserList) {
            try {
                this.updateGiftUserValid(this.getQueryParamMap("giftUserCode,tenantCode", new Object[]{gtGiftUser.getGiftUserCode(), gtGiftUser.getTenantCode()}));
                gtGift = this.gtGiftService.getGiftByCode(gtGiftUser.getTenantCode(), gtGiftUser.getGiftCode());
                if (null == gtGift || StringUtils.isBlank((String)gtGift.getGiftOver())) continue;
                this.updateGiftUserValidDataState(gtGiftUser, gtGift);
                this.sendTransfer(gtGiftUser, gtGift);
                this.updateUpmBack(gtGiftUser, gtGift);
            }
            catch (Exception e) {
                this.logger.error(".updateGiftUserValid", (Throwable)e);
            }
        }
        this.updateGiftUserupmBack();
    }

    private void updateGiftUserupmBack() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", 7);
            map.put("validState", 1);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<GtGiftUser> result = null;
            int startRow = 0;
            int page = 100;
            boolean flag = true;
            GtGift gtGift = null;
            do {
                map.put("startRow", startRow);
                map.put("rows", page);
                result = this.queryGiftUserPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    if (result.getRows().size() != page) {
                        flag = false;
                    }
                    for (GtGiftUser gtGiftUser : result.getRows()) {
                        gtGift = this.gtGiftService.getGiftByCode(gtGiftUser.getTenantCode(), gtGiftUser.getGiftCode());
                        this.updateUpmBack(gtGiftUser, gtGift);
                    }
                    startRow = startRow + page - 1;
                    continue;
                }
                flag = false;
            } while (flag);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.loadSendDb.e", (Throwable)e);
        }
    }

    private void updateUpmBack(GtGiftUser gtGiftUser, GtGift gtGift) {
        if (null == gtGiftUser || null == gtGift || !"3".equals(gtGift.getGiftOver()) || !"0".equals(gtGift.getGiftChange())) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftUserCode", gtGiftUser.getGiftUserCode());
        map.put("tenantCode", gtGiftUser.getTenantCode());
        map.put("oldDataState", gtGiftUser.getDataState());
        String s = this.sendUpointsClear(gtGiftUser);
        if (StringUtils.isBlank((String)s) || !s.equals("success")) {
            map.put("dataState", 7);
        } else {
            map.put("dataState", 3);
        }
        this.gtGiftUserMapper.updateGiftUserValidDataStat(map);
    }

    private String sendUpointsClear(GtGiftUser gtGiftUser) {
        BigDecimal userAmt = BigDecimal.ZERO;
        if (null != gtGiftUser.getGiftUserCamt()) {
            userAmt = gtGiftUser.getGiftUserCamt();
        }
        BigDecimal userNum = gtGiftUser.getGiftUserNum();
        BigDecimal amt = gtGiftUser.getGiftCnum().multiply(userNum).subtract(userAmt);
        UpmUpointsClearDomain upmUpointsClearDomain = new UpmUpointsClearDomain();
        upmUpointsClearDomain.setUpointsClearNum(amt);
        upmUpointsClearDomain.setPointsRuleApi("giftUserUpmBack");
        upmUpointsClearDomain.setUpointsClearDirection("10");
        upmUpointsClearDomain.setUpointsType("1");
        upmUpointsClearDomain.setMemberCode(gtGiftUser.getMemberBcode());
        upmUpointsClearDomain.setMemberName(gtGiftUser.getMemberBname());
        upmUpointsClearDomain.setTenantCode(gtGiftUser.getTenantCode());
        upmUpointsClearDomain.setUpointsClearOpcode(gtGiftUser.getGiftUserCode());
        upmUpointsClearDomain.setUpointsType("0");
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("upmUpointsClearDomain", JsonUtil.buildNormalBinder().toJson((Object)upmUpointsClearDomain));
        return this.internalInvoke("upm.upointsClearBase.sendUpointsClear", pmap);
    }

    private void sendTransfer(GtGiftUser gtGiftUser, GtGift gtGift) {
        List vdFaccountInfoList;
        List vdFaccountInfoList2;
        if (null == gtGiftUser || null == gtGift || !"1".equals(gtGift.getGiftOver())) {
            return;
        }
        String saveTransfera = "ta.taTransfera.saveTransfera";
        String queryOuterFaccount = "vd.faccount.queryOuterFaccount";
        TaTransferaDomain taTransferaDomain = new TaTransferaDomain();
        ArrayList<TaTransferaListDomain> taTransferaListDomainList = new ArrayList<TaTransferaListDomain>();
        TaTransferaListDomain taTransferaListDomain = new TaTransferaListDomain();
        String type = gtGiftUser.getMemberCode().substring(0, 1);
        String faccountType = "101";
        if ("2".equals(type)) {
            faccountType = "201";
        }
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("merchantCode", gtGiftUser.getMemberCode());
        paramMap1.put("faccountType", faccountType);
        paramMap1.put("tenantCode", gtGiftUser.getTenantCode());
        String result = this.internalInvoke(queryOuterFaccount, paramMap1);
        String outerNo = "";
        if (!StringUtils.isBlank((String)result) && null != (vdFaccountInfoList2 = JsonUtil.buildNonDefaultBinder().getJsonToList(result, VdFaccountInfo.class)) && vdFaccountInfoList2.size() > 0) {
            outerNo = ((VdFaccountInfo)vdFaccountInfoList2.get(0)).getFaccountOuterNo();
            if (null == gtGift.getGiftOnum()) {
                gtGift.setGiftOnum(new BigDecimal("0"));
            }
            if (BigDecimal.ZERO.compareTo(gtGift.getGiftOnum()) == 0) {
                return;
            }
            if (null == gtGiftUser.getGiftUserNum()) {
                gtGiftUser.setGiftUserNum(new BigDecimal("1"));
            }
            taTransferaDomain.setTransferaCategory(gtGiftUser.getMemberCode().substring(0, 1));
            taTransferaDomain.setTenantCode(gtGiftUser.getTenantCode());
            taTransferaDomain.setTransferaOpcode(gtGiftUser.getGiftUserCode());
            taTransferaDomain.setTransferaType("07");
            taTransferaDomain.setTransferaMode("1");
            taTransferaDomain.setFaccountId(outerNo);
            taTransferaDomain.setTransferaMoney(gtGiftUser.getGiftUserNum().multiply(gtGift.getGiftOnum()));
            taTransferaDomain.setUserinfoCode(gtGiftUser.getMemberCode());
            taTransferaDomain.setUserinfoName(gtGiftUser.getMemberName());
            taTransferaDomain.setFchannelPmodeCode("web");
            taTransferaDomain.setFundType("01");
        }
        type = gtGiftUser.getMemberBcode().substring(0, 1);
        faccountType = "101";
        if ("2".equals(type)) {
            faccountType = "201";
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("merchantCode", gtGiftUser.getMemberBcode());
        paramMap.put("faccountType", faccountType);
        paramMap.put("tenantCode", gtGiftUser.getTenantCode());
        result = this.internalInvoke(queryOuterFaccount, paramMap);
        outerNo = "";
        if (!StringUtils.isBlank((String)result) && null != (vdFaccountInfoList = JsonUtil.buildNonDefaultBinder().getJsonToList(result, VdFaccountInfo.class)) && vdFaccountInfoList.size() > 0) {
            outerNo = ((VdFaccountInfo)vdFaccountInfoList.get(0)).getFaccountOuterNo();
            taTransferaListDomain.setUserinfoCode(gtGiftUser.getMemberCode());
            taTransferaListDomain.setTransferaListCategory(type);
            taTransferaListDomain.setUserinfoName(gtGiftUser.getMemberName());
            taTransferaListDomain.setTransferaListUcode(gtGiftUser.getMemberBcode());
            taTransferaListDomain.setTransferaListUname(gtGiftUser.getMemberBname());
            taTransferaListDomain.setTransferaListUno(outerNo);
            taTransferaListDomain.setTransferaListFtype("01");
            taTransferaListDomain.setTransferaListMoney(gtGift.getGiftOnum());
            taTransferaListDomainList.add(taTransferaListDomain);
            taTransferaDomain.setTaTransferaListDomainList(taTransferaListDomainList);
            HashMap<String, String> paramMap2 = new HashMap<String, String>();
            paramMap2.put("taTransferaDomain", JsonUtil.buildNormalBinder().toJson((Object)taTransferaDomain));
            this.internalInvoke(saveTransfera, paramMap2);
        }
    }

    @Override
    public String updateGiftUserCallBack(List<ReceiveGiftUserDomain> receiveGiftUserDomainList) throws ApiException {
        return this.updateGiftUser(receiveGiftUserDomainList, "0");
    }

    @Override
    public String updateGiftUserTimeCallBack(List<ReceiveGiftUserDomain> receiveGiftUserDomainList) throws ApiException {
        return this.updateGiftUserTime(receiveGiftUserDomainList, "0");
    }

    @Override
    public String updateGiftUserBackOff(List<ReceiveGiftUserDomain> receiveGiftUserDomainList) throws ApiException {
        return this.updateGiftUser(receiveGiftUserDomainList, "-1");
    }

    private String updateGiftUserTime(List<ReceiveGiftUserDomain> receiveGiftUserDomainList, String direction) {
        this.logger.info("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserTime", (Object)JsonUtil.buildNormalBinder().toJson(receiveGiftUserDomainList));
        if (null == receiveGiftUserDomainList || receiveGiftUserDomainList.size() == 0) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserTime", (Object)"isnull");
            return "error";
        }
        GtGiftUser gtGiftUser = new GtGiftUser();
        BigDecimal giftUserCnum = BigDecimal.ZERO;
        ReceiveGiftUserDomain receiveGiftUserDomain1 = receiveGiftUserDomainList.get(0);
        HashMap<String, Object> maplock = new HashMap<String, Object>();
        maplock.put("giftUserCode", receiveGiftUserDomain1.getGiftUserCode());
        maplock.put("tenantCode", receiveGiftUserDomain1.getTenantCode());
        this.updateStateByUserCode(maplock);
        for (ReceiveGiftUserDomain receiveGiftUserDomain : receiveGiftUserDomainList) {
            giftUserCnum = giftUserCnum.add(receiveGiftUserDomain.getGiftUserCnum());
            String giftUserCode = receiveGiftUserDomain.getGiftUserCode();
            String tenantCode = receiveGiftUserDomain.getTenantCode();
            gtGiftUser = this.getGiftUserByCode(tenantCode, giftUserCode);
            gtGiftUser.setGiftRedeem(new Date());
            this.updateGiftUserTimeModelByCode(gtGiftUser);
        }
        return "success";
    }

    private String updateGiftUser(List<ReceiveGiftUserDomain> receiveGiftUserDomainList, String direction) {
        this.logger.info("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBack", (Object)JsonUtil.buildNormalBinder().toJson(receiveGiftUserDomainList));
        if (null == receiveGiftUserDomainList || receiveGiftUserDomainList.size() == 0) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.updateGiftUser", (Object)"isnull");
            return "error";
        }
        GtGiftUser gtGiftUser = new GtGiftUser();
        BigDecimal giftUserCnum = BigDecimal.ZERO;
        ReceiveGiftUserDomain receiveGiftUserDomain1 = receiveGiftUserDomainList.get(0);
        HashMap<String, Object> maplock = new HashMap<String, Object>();
        maplock.put("giftUserCode", receiveGiftUserDomain1.getGiftUserCode());
        maplock.put("tenantCode", receiveGiftUserDomain1.getTenantCode());
        this.updateStateByUserCode(maplock);
        for (ReceiveGiftUserDomain receiveGiftUserDomain : receiveGiftUserDomainList) {
            BigDecimal allNum;
            BigDecimal giftCnum;
            BigDecimal userrelNum;
            giftUserCnum = giftUserCnum.add(receiveGiftUserDomain.getGiftUserCnum());
            String giftUserCode = receiveGiftUserDomain.getGiftUserCode();
            String tenantCode = receiveGiftUserDomain.getTenantCode();
            gtGiftUser = this.getGiftUserByCode(tenantCode, giftUserCode);
            if (null == gtGiftUser.getGiftUserCamt()) {
                gtGiftUser.setGiftUserCamt(BigDecimal.ZERO);
            }
            if (null == gtGiftUser.getGiftUserCnum()) {
                gtGiftUser.setGiftUserCnum(BigDecimal.ZERO);
            }
            if (direction.equals("0")) {
                gtGiftUser.setGiftUserCamt(gtGiftUser.getGiftUserCamt().add(receiveGiftUserDomain.getGiftUserCamt()));
                gtGiftUser.setGiftUserCnum(gtGiftUser.getGiftUserCnum().add(receiveGiftUserDomain.getGiftUserCnum()));
            } else if (direction.equals("-1")) {
                gtGiftUser.setGiftUserCamt(gtGiftUser.getGiftUserCamt().subtract(receiveGiftUserDomain.getGiftUserCamt()));
                gtGiftUser.setGiftUserCnum(gtGiftUser.getGiftUserCnum().subtract(receiveGiftUserDomain.getGiftUserCnum()));
            }
            if (gtGiftUser.getGiftUserCamt().compareTo(BigDecimal.ZERO) < 0 || gtGiftUser.getGiftUserCnum().compareTo(BigDecimal.ZERO) < 0) {
                this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.updateGiftUser.2", (Object)JsonUtil.buildNormalBinder().toJson((Object)gtGiftUser));
                return "error";
            }
            BigDecimal num = BigDecimal.ZERO;
            num = "0".equals(gtGiftUser.getGiftChange()) ? gtGiftUser.getGiftUserCamt() : gtGiftUser.getGiftUserCnum();
            if (num == null) {
                num = BigDecimal.ZERO;
            }
            if (null == (userrelNum = gtGiftUser.getGiftUserNum())) {
                userrelNum = BigDecimal.ZERO;
            }
            if (null == (giftCnum = gtGiftUser.getGiftCnum())) {
                giftCnum = BigDecimal.ZERO;
            }
            if (null == (allNum = giftCnum.multiply(userrelNum))) {
                allNum = BigDecimal.ZERO;
            }
            if (num.compareTo(allNum) > 0) {
                this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.num", (Object)(num + ":allNum:" + allNum + "--giftUserCode:" + giftUserCode));
                return "error";
            }
            if (null != gtGiftUser.getValidState() && 1 == gtGiftUser.getValidState()) {
                gtGiftUser.setDataState(3);
            }
            if ("1".equals(gtGiftUser.getGiftCtype())) {
                if (num.compareTo(allNum) == 0) {
                    gtGiftUser.setDataState(1);
                } else if (num.compareTo(BigDecimal.ZERO) > 0 && num.compareTo(allNum) < 0) {
                    gtGiftUser.setDataState(2);
                } else if (num.compareTo(BigDecimal.ZERO) == 0) {
                    gtGiftUser.setDataState(0);
                } else {
                    gtGiftUser.setDataState(1);
                }
            } else if (direction.equals("-1")) {
                gtGiftUser.setDataState(0);
            } else {
                gtGiftUser.setDataState(1);
            }
            this.updateGiftUserModelByCode(gtGiftUser);
            if (null != gtGiftUser) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("skuCode", receiveGiftUserDomain.getSkuCode());
                map.put("tenantCode", tenantCode);
                map.put("giftUserCode", receiveGiftUserDomain.getGiftUserCode());
                map.put("memberBcode", receiveGiftUserDomain.getMemeberBcode());
                QueryResult<GtGiftUserrel> gtGiftUserrelQueryResult = this.gtGiftUserrelService.queryGiftUserrelPage(map);
                List gtGiftUserrelList = gtGiftUserrelQueryResult.getList();
                if (null != gtGiftUserrelList && gtGiftUserrelList.size() > 0) {
                    GtGiftUserrel gtGiftUserrel = (GtGiftUserrel)gtGiftUserrelList.get(0);
                    GtGiftUserrelDomain gtGiftUserrelDomain = new GtGiftUserrelDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)gtGiftUserrelDomain, (Object)gtGiftUserrel);
                    }
                    catch (Exception e) {
                        this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBack.e", (Throwable)e);
                    }
                    if (null == gtGiftUserrelDomain.getGiftUserrelNum()) {
                        gtGiftUserrelDomain.setGiftUserrelNum(BigDecimal.ZERO);
                    }
                    if (null == gtGiftUserrelDomain.getGiftUserrelAmt()) {
                        gtGiftUserrelDomain.setGiftUserrelAmt(BigDecimal.ZERO);
                    }
                    gtGiftUserrelDomain.setGiftUserCode(receiveGiftUserDomain.getGiftUserCode());
                    if (null == gtGiftUserrelDomain.getGiftUserrelNum()) {
                        gtGiftUserrelDomain.setGiftUserrelNum(BigDecimal.ZERO);
                    }
                    if (null == gtGiftUserrelDomain.getGiftUserrelAmt()) {
                        gtGiftUserrelDomain.setGiftUserrelAmt(BigDecimal.ZERO);
                    }
                    if (direction.equals("0")) {
                        gtGiftUserrelDomain.setGiftUserrelNum(gtGiftUserrelDomain.getGiftUserrelNum().add(receiveGiftUserDomain.getGiftUserCnum()));
                        gtGiftUserrelDomain.setGiftUserrelAmt(gtGiftUserrelDomain.getGiftUserrelAmt().add(receiveGiftUserDomain.getGiftUserCamt()));
                    } else if (direction.equals("-1")) {
                        gtGiftUserrelDomain.setGiftUserrelNum(gtGiftUserrelDomain.getGiftUserrelNum().subtract(receiveGiftUserDomain.getGiftUserCnum()));
                        gtGiftUserrelDomain.setGiftUserrelAmt(gtGiftUserrelDomain.getGiftUserrelAmt().subtract(receiveGiftUserDomain.getGiftUserCamt()));
                    }
                    if (gtGiftUserrelDomain.getGiftUserrelNum().compareTo(BigDecimal.ZERO) < 0 || gtGiftUserrelDomain.getGiftUserrelAmt().compareTo(BigDecimal.ZERO) < 0) {
                        this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.updateGiftUser.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)gtGiftUserrelDomain));
                        return "error";
                    }
                    this.gtGiftUserrelService.updateGiftUserrel(gtGiftUserrelDomain);
                } else if (null != receiveGiftUserDomain.getOcContractGoodsDomain()) {
                    GtGiftUserrelDomain gtGiftUserrelDomain = new GtGiftUserrelDomain();
                    try {
                        BeanUtils.copyAllPropertys((Object)gtGiftUserrelDomain, (Object)receiveGiftUserDomain.getOcContractGoodsDomain());
                    }
                    catch (Exception e) {
                        this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBack.e", (Throwable)e);
                    }
                    if (null == gtGiftUserrelDomain.getGiftUserrelNum()) {
                        gtGiftUserrelDomain.setGiftUserrelNum(BigDecimal.ZERO);
                    }
                    if (null == gtGiftUserrelDomain.getGiftUserrelAmt()) {
                        gtGiftUserrelDomain.setGiftUserrelAmt(BigDecimal.ZERO);
                    }
                    gtGiftUserrelDomain.setGiftUserCode(receiveGiftUserDomain.getGiftUserCode());
                    gtGiftUserrelDomain.setMemberBcode(receiveGiftUserDomain.getMemeberBcode());
                    if (null == gtGiftUserrelDomain.getGiftUserrelNum()) {
                        gtGiftUserrelDomain.setGiftUserrelNum(BigDecimal.ZERO);
                    }
                    if (null == gtGiftUserrelDomain.getGiftUserrelAmt()) {
                        gtGiftUserrelDomain.setGiftUserrelAmt(BigDecimal.ZERO);
                    }
                    if (direction.equals("0")) {
                        gtGiftUserrelDomain.setGiftUserrelNum(gtGiftUserrelDomain.getGiftUserrelNum().add(receiveGiftUserDomain.getGiftUserCnum()));
                        gtGiftUserrelDomain.setGiftUserrelAmt(gtGiftUserrelDomain.getGiftUserrelAmt().add(receiveGiftUserDomain.getGiftUserCamt()));
                    } else if (direction.equals("-1")) {
                        gtGiftUserrelDomain.setGiftUserrelNum(gtGiftUserrelDomain.getGiftUserrelNum().subtract(receiveGiftUserDomain.getGiftUserCnum()));
                        gtGiftUserrelDomain.setGiftUserrelAmt(gtGiftUserrelDomain.getGiftUserrelAmt().subtract(receiveGiftUserDomain.getGiftUserCamt()));
                    }
                    if (gtGiftUserrelDomain.getGiftUserrelNum().compareTo(BigDecimal.ZERO) < 0 || gtGiftUserrelDomain.getGiftUserrelAmt().compareTo(BigDecimal.ZERO) < 0) {
                        this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.updateGiftUser.1", (Object)JsonUtil.buildNormalBinder().toJson((Object)gtGiftUserrelDomain));
                        return "error";
                    }
                    this.gtGiftUserrelService.saveGiftUserrel(gtGiftUserrelDomain);
                }
            }
            if (!StringUtils.isNotBlank((String)gtGiftUser.getGiftUserOcode2()) || !StringUtils.isBlank((String)gtGiftUser.getGiftUserOcode1())) continue;
            this.updateCardpUser(gtGiftUser);
        }
        return "success";
    }

    private void sendNMS(final GtGiftUser gtGiftUser, final GtGiftUser oldGtGiftUser) {
        if (null != pool && null != gtGiftUser && null != oldGtGiftUser) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    GtGiftUserServiceImpl.this.sendOrderDomain(gtGiftUser, oldGtGiftUser);
                }
            });
        }
    }

    private void sendOrderDomain(GtGiftUser gtGiftUser, GtGiftUser oldGtGiftUser) throws ApiException {
        this.logger.error("gt.GIFT.GtGiftUserServiceImpl.sendOrderDomain", (Object)JsonUtil.buildNormalBinder().toJson((Object)gtGiftUser));
        this.logger.error("gt.GIFT.GtGiftUserServiceImpl.sendOrderDomain.oldGtGiftUser", (Object)JsonUtil.buildNormalBinder().toJson((Object)oldGtGiftUser));
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        String type = "";
        if ("1".equals(gtGiftUser.getGiftCtype())) {
            BigDecimal allNum;
            BigDecimal multiply60;
            BigDecimal giftCnum;
            BigDecimal userrelNum = gtGiftUser.getGiftUserNum();
            if (null == userrelNum) {
                userrelNum = BigDecimal.ZERO;
            }
            if (null == (giftCnum = gtGiftUser.getGiftCnum())) {
                giftCnum = BigDecimal.ZERO;
            }
            if ((multiply60 = (allNum = giftCnum.multiply(userrelNum)).multiply(new BigDecimal(0.6))).compareTo(gtGiftUser.getGiftUserCnum()) < 1 && multiply60.compareTo(oldGtGiftUser.getGiftUserCnum()) == 1) {
                type = "60";
            }
            if (allNum.compareTo(gtGiftUser.getGiftUserCnum()) < 1 && allNum.compareTo(oldGtGiftUser.getGiftUserCnum()) == 1) {
                type = "100";
            }
        }
        mnsMnslistDomainBean.setMnslistBustype("gt" + gtGiftUser.getDataState() + type);
        mnsMnslistDomainBean.setMnslistBusname("\u793c\u5305\u53d1\u9001\u6d88\u606f");
        mnsMnslistDomainBean.setMemberCode(gtGiftUser.getMemberBcode());
        mnsMnslistDomainBean.setDataTenant(gtGiftUser.getTenantCode());
        mnsMnslistDomainBean.setTenantCode(gtGiftUser.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", gtGiftUser.getMemberBcode());
        listReceiver.put("name", gtGiftUser.getMemberBname());
        listReceiver.put("gtGiftUser", JsonUtil.buildNonEmptyBinder().toJson((Object)gtGiftUser));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.logger.error("gt.GIFT.GtGiftUserServiceImpl.sendOrderDomain.mnsMnslistDomainBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        HashMap<String, String> paramsend = new HashMap<String, String>();
        paramsend.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
    }

    @Override
    public void updateGiftUserRule(Map<String, Object> map) {
        this.updateGiftUserRuleByGiftCode(map);
    }

    @Override
    public String updateGiftUserCallBackCombination(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBackCombination.s", (Object)"isnull");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBackCombination.goodsList", (Object)"isnull");
            return "error";
        }
        ArrayList<ReceiveGiftUserDomain> receiveGiftUserDomainList = new ArrayList<ReceiveGiftUserDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            ReceiveGiftUserDomain receiveGiftUserDomain = new ReceiveGiftUserDomain();
            receiveGiftUserDomain.setGiftUserCode(ocContractGoodsDomain.getGoodsContract());
            receiveGiftUserDomain.setTenantCode(ocContractGoodsDomain.getTenantCode());
            receiveGiftUserDomain.setGiftUserCnum(ocContractGoodsDomain.getGoodsNum());
            receiveGiftUserDomain.setGiftUserCamt(ocContractGoodsDomain.getContractGoodsOremoney());
            receiveGiftUserDomain.setMemeberBcode(ocContractGoodsDomain.getMemberBcode());
            receiveGiftUserDomain.setSkuCode(ocContractGoodsDomain.getSkuCode());
            receiveGiftUserDomainList.add(receiveGiftUserDomain);
        }
        return this.updateGiftUser(receiveGiftUserDomainList, "0");
    }

    @Override
    public String updateGiftUserCallBackCombinationBackOff(OcContractReDomain ocContractDomain) {
        if (null == ocContractDomain) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBackCombinationBackOff.s", (Object)"isnull");
            return "error";
        }
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isEmpty(goodsList)) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBackCombinationBackOff.goodsList", (Object)"isnull");
            return "error";
        }
        List<OcContractSettlDomain> ocContractSettlList = ocContractDomain.getOcContractSettlList();
        if (ListUtil.isEmpty(ocContractSettlList)) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBackCombinationBackOff.ocContractSettlList", (Object)"isnull");
            return "error";
        }
        BigDecimal money = BigDecimal.ZERO;
        BigDecimal sum = BigDecimal.ZERO;
        boolean falg = false;
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlList) {
            if (!"LB".equals(ocContractSettlDomain.getContractSettlBlance())) continue;
            money = ocContractSettlDomain.getContractSettlGmoney();
            falg = true;
            break;
        }
        if (!falg) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBackCombinationBackOff.ocContractSettlList.falg", (Object)"isnull");
            return "error";
        }
        BigDecimal dataBmoney = ocContractDomain.getDataBmoney();
        for (int i = 0; i < goodsList.size(); ++i) {
            OcContractGoodsDomain ocContractGoodsDomain = goodsList.get(i);
            if (i == goodsList.size() - 1) {
                ocContractGoodsDomain.setContractGoodsInmoney(money.subtract(sum));
                continue;
            }
            ocContractGoodsDomain.setContractGoodsInmoney(ocContractGoodsDomain.getContractGoodsInmoney().divide(dataBmoney, 2, 5).multiply(money));
            sum = sum.add(ocContractGoodsDomain.getContractGoodsInmoney());
        }
        ArrayList<ReceiveGiftUserDomain> receiveGiftUserDomainList = new ArrayList<ReceiveGiftUserDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            ReceiveGiftUserDomain receiveGiftUserDomain = new ReceiveGiftUserDomain();
            receiveGiftUserDomain.setGiftUserCode(ocContractGoodsDomain.getGoodsContract());
            receiveGiftUserDomain.setTenantCode(ocContractGoodsDomain.getTenantCode());
            receiveGiftUserDomain.setGiftUserCnum(ocContractGoodsDomain.getGoodsNum());
            receiveGiftUserDomain.setGiftUserCamt(ocContractGoodsDomain.getContractGoodsInmoney());
            receiveGiftUserDomain.setMemeberBcode(ocContractGoodsDomain.getMemberBcode());
            receiveGiftUserDomain.setSkuCode(ocContractGoodsDomain.getSkuCode());
            receiveGiftUserDomainList.add(receiveGiftUserDomain);
        }
        return this.updateGiftUser(receiveGiftUserDomainList, "-1");
    }

    private void updateGiftUserRuleByGiftCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        try {
            this.gtGiftUserMapper.updateGiftUserRuleByGiftCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserRuleByGiftCode.ex", (Throwable)e);
        }
    }

    private void updateStateByUserCode(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateStateByUserCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateByUserCode.ex", map.toString(), (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateByUserCode.null", map.toString());
        }
    }
}

