/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ia.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ia.dao.IaInsuranceMapper;
import com.yqbsoft.laser.service.ia.domain.IaInsuranceDomain;
import com.yqbsoft.laser.service.ia.domain.IaInsuranceReDomain;
import com.yqbsoft.laser.service.ia.domain.OcContractDomain;
import com.yqbsoft.laser.service.ia.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.ia.model.IaInsurance;
import com.yqbsoft.laser.service.ia.model.IaInsurancelist;
import com.yqbsoft.laser.service.ia.service.IaInsuranceService;
import com.yqbsoft.laser.service.ia.service.IaInsurancelistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IaInsuranceServiceImpl
extends BaseServiceImpl
implements IaInsuranceService {
    private static final String SYS_CODE = "ia.tk.IaInsuranceServiceImpl";
    private IaInsuranceMapper iaInsuranceMapper;
    private IaInsurancelistService iaInsurancelistService;

    public void setIaInsuranceMapper(IaInsuranceMapper iaInsuranceMapper) {
        this.iaInsuranceMapper = iaInsuranceMapper;
    }

    public void setIaInsurancelistService(IaInsurancelistService iaInsurancelistService) {
        this.iaInsurancelistService = iaInsurancelistService;
    }

    private Date getSysDate() {
        try {
            return this.iaInsuranceMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ia.tk.IaInsuranceServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkInsurance(IaInsuranceDomain iaInsuranceDomain) {
        if (null == iaInsuranceDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)iaInsuranceDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInsuranceDefault(IaInsurance iaInsurance) {
        if (null == iaInsurance) {
            return;
        }
        if (null == iaInsurance.getDataState()) {
            iaInsurance.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == iaInsurance.getGmtCreate()) {
            iaInsurance.setGmtCreate(date);
        }
        iaInsurance.setGmtModified(date);
        if (StringUtils.isBlank((String)iaInsurance.getInsuranceCode())) {
            iaInsurance.setInsuranceCode(this.getNo(null, "IaInsurance", "iaInsurance", iaInsurance.getTenantCode()));
        }
    }

    private int getInsuranceMaxCode() {
        int code = 0;
        try {
            return this.iaInsuranceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ia.tk.IaInsuranceServiceImpl.getInsuranceMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setInsuranceUpdataDefault(IaInsurance iaInsurance) {
        if (null == iaInsurance) {
            return;
        }
        iaInsurance.setGmtModified(this.getSysDate());
    }

    private void saveInsuranceModel(IaInsurance iaInsurance) throws ApiException {
        if (null == iaInsurance) {
            return;
        }
        try {
            this.iaInsuranceMapper.insert(iaInsurance);
        }
        catch (Exception e) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.saveInsuranceModel.ex", (Throwable)e);
        }
    }

    private void saveInsuranceBatchModel(List<IaInsurance> iaInsuranceList) throws ApiException {
        if (null == iaInsuranceList || iaInsuranceList.isEmpty()) {
            return;
        }
        try {
            this.iaInsuranceMapper.insertBatch(iaInsuranceList);
        }
        catch (Exception e) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.saveInsuranceBatchModel.ex", (Throwable)e);
        }
    }

    private IaInsurance getInsuranceModelById(Integer insuranceId) {
        if (null == insuranceId) {
            return null;
        }
        try {
            return this.iaInsuranceMapper.selectByPrimaryKey(insuranceId);
        }
        catch (Exception e) {
            this.logger.error("ia.tk.IaInsuranceServiceImpl.getInsuranceModelById", (Throwable)e);
            return null;
        }
    }

    private IaInsurance getInsuranceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.iaInsuranceMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ia.tk.IaInsuranceServiceImpl.getInsuranceModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delInsuranceModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.iaInsuranceMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.delInsuranceModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.delInsuranceModelByCode.num");
        }
    }

    private void deleteInsuranceModel(Integer insuranceId) throws ApiException {
        if (null == insuranceId) {
            return;
        }
        int i = 0;
        try {
            i = this.iaInsuranceMapper.deleteByPrimaryKey(insuranceId);
        }
        catch (Exception e) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.deleteInsuranceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.deleteInsuranceModel.num");
        }
    }

    private void updateInsuranceModel(IaInsurance iaInsurance) throws ApiException {
        if (null == iaInsurance) {
            return;
        }
        int i = 0;
        try {
            i = this.iaInsuranceMapper.updateByPrimaryKey(iaInsurance);
        }
        catch (Exception e) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.updateInsuranceModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.updateInsuranceModel.num");
        }
    }

    private void updateStateInsuranceModel(Integer insuranceId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == insuranceId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("insuranceId", insuranceId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.iaInsuranceMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.updateStateInsuranceModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.updateStateInsuranceModel.null");
        }
    }

    private void updateStateInsuranceModelByCode(String tenantCode, String insuranceCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)insuranceCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("insuranceCode", insuranceCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.iaInsuranceMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.updateStateInsuranceModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.updateStateInsuranceModelByCode.null");
        }
    }

    private IaInsurance makeInsurance(IaInsuranceDomain iaInsuranceDomain, IaInsurance iaInsurance) {
        if (null == iaInsuranceDomain) {
            return null;
        }
        if (null == iaInsurance) {
            iaInsurance = new IaInsurance();
        }
        try {
            BeanUtils.copyAllPropertys((Object)iaInsurance, (Object)iaInsuranceDomain);
            return iaInsurance;
        }
        catch (Exception e) {
            this.logger.error("ia.tk.IaInsuranceServiceImpl.makeInsurance", (Throwable)e);
            return null;
        }
    }

    private IaInsuranceReDomain makeIaInsuranceReDomain(IaInsurance iaInsurance) {
        if (null == iaInsurance) {
            return null;
        }
        IaInsuranceReDomain iaInsuranceReDomain = new IaInsuranceReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)iaInsuranceReDomain, (Object)iaInsurance);
            return iaInsuranceReDomain;
        }
        catch (Exception e) {
            this.logger.error("ia.tk.IaInsuranceServiceImpl.makeIaInsuranceReDomain", (Throwable)e);
            return null;
        }
    }

    private List<IaInsurance> queryInsuranceModelPage(Map<String, Object> parammap) {
        try {
            return this.iaInsuranceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ia.tk.IaInsuranceServiceImpl.queryInsuranceModel", (Throwable)e);
            return null;
        }
    }

    private int countInsurance(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.iaInsuranceMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ia.tk.IaInsuranceServiceImpl.countInsurance", (Throwable)e);
        }
        return i;
    }

    private IaInsurance createIaInsurance(IaInsuranceDomain iaInsuranceDomain) {
        String msg = this.checkInsurance(iaInsuranceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.saveInsurance.checkInsurance", msg);
        }
        IaInsurance iaInsurance = this.makeInsurance(iaInsuranceDomain, null);
        this.setInsuranceDefault(iaInsurance);
        return iaInsurance;
    }

    @Override
    public String saveInsurance(IaInsuranceDomain iaInsuranceDomain) throws ApiException {
        IaInsurance iaInsurance = this.createIaInsurance(iaInsuranceDomain);
        this.saveInsuranceModel(iaInsurance);
        return iaInsurance.getInsuranceCode();
    }

    @Override
    public String saveInsuranceBatch(List<IaInsuranceDomain> iaInsuranceDomainList) throws ApiException {
        if (null == iaInsuranceDomainList || iaInsuranceDomainList.isEmpty()) {
            return null;
        }
        ArrayList<IaInsurance> iaInsuranceList = new ArrayList<IaInsurance>();
        String code = "";
        for (IaInsuranceDomain iaInsuranceDomain : iaInsuranceDomainList) {
            IaInsurance iaInsurance = this.createIaInsurance(iaInsuranceDomain);
            code = iaInsurance.getInsuranceCode();
            iaInsuranceList.add(iaInsurance);
        }
        this.saveInsuranceBatchModel(iaInsuranceList);
        return code;
    }

    @Override
    public void updateInsuranceState(Integer insuranceId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == insuranceId) {
            return;
        }
        this.updateStateInsuranceModel(insuranceId, dataState, oldDataState, map);
    }

    @Override
    public void updateInsuranceStateByCode(String tenantCode, String insuranceCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)insuranceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateInsuranceModelByCode(tenantCode, insuranceCode, dataState, oldDataState, map);
    }

    @Override
    public void updateInsurance(IaInsuranceDomain iaInsuranceDomain) throws ApiException {
        String msg = this.checkInsurance(iaInsuranceDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.updateInsurance.checkInsurance", msg);
        }
        IaInsurance oldIaInsurance = this.getInsuranceModelById(iaInsuranceDomain.getInsuranceId());
        if (null == oldIaInsurance) {
            throw new ApiException("ia.tk.IaInsuranceServiceImpl.updateInsurance.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        IaInsurance iaInsurance = this.makeInsurance(iaInsuranceDomain, oldIaInsurance);
        this.setInsuranceUpdataDefault(iaInsurance);
        this.updateInsuranceModel(iaInsurance);
    }

    @Override
    public IaInsurance getInsurance(Integer insuranceId) {
        if (null == insuranceId) {
            return null;
        }
        return this.getInsuranceModelById(insuranceId);
    }

    @Override
    public void deleteInsurance(Integer insuranceId) throws ApiException {
        if (null == insuranceId) {
            return;
        }
        this.deleteInsuranceModel(insuranceId);
    }

    @Override
    public QueryResult<IaInsurance> queryInsurancePage(Map<String, Object> map) {
        List<IaInsurance> iaInsuranceList = this.queryInsuranceModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInsurance(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        for (IaInsurance iaInsurance : iaInsuranceList) {
            this.getIaInsuranceReRelatedData(iaInsurance);
        }
        queryResult.setList(iaInsuranceList);
        return queryResult;
    }

    @Override
    public IaInsurance getInsuranceByCode(String tenantCode, String insuranceCode) throws ApiException {
        if (StringUtils.isBlank((String)insuranceCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("insuranceCode", insuranceCode);
        return this.getInsuranceModelByCode(map);
    }

    @Override
    public void deleteInsuranceByCode(String tenantCode, String insuranceCode) throws ApiException {
        if (StringUtils.isBlank((String)insuranceCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("insuranceCode", insuranceCode);
        this.delInsuranceModelByCode(map);
    }

    @Override
    public String sendOrderInsurance(OcContractDomain ocContractDomain) {
        this.logger.error("ia.tk.IaInsuranceServiceImpl.sendOrderInsurance", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)ocContractDomain));
        if (null == ocContractDomain) {
            return null;
        }
        IaInsuranceDomain iaInsuranceDomain = new IaInsuranceDomain();
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (goodsList != null || ListUtil.isNotEmpty(goodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                if (!"3".equals(ocContractGoodsDomain.getContractGoodsGtype()) || !"13".equals(ocContractGoodsDomain.getGoodsPro())) continue;
                iaInsuranceDomain.setInsuranceDes(String.valueOf(ocContractGoodsDomain.getGoodsNum()));
            }
        }
        iaInsuranceDomain.setInsuranceOpcode(ocContractDomain.getContractBillcode());
        iaInsuranceDomain.setInsuranceName("\u4fdd\u9669");
        iaInsuranceDomain.setMemberCode(ocContractDomain.getMemberCode());
        iaInsuranceDomain.setMemberName(ocContractDomain.getMemberCode());
        iaInsuranceDomain.setTenantCode(ocContractDomain.getTenantCode());
        this.saveInsurance(iaInsuranceDomain);
        return "success";
    }

    void getIaInsuranceReRelatedData(IaInsurance iaInsurance) {
        if (null == iaInsurance) {
            return;
        }
        String tenantCode = iaInsurance.getTenantCode();
        String insuranceCode = iaInsurance.getInsuranceCode();
        Map paramMap = this.getQueryParamMap("insuranceCode,tenantCode", new Object[]{insuranceCode, tenantCode});
        QueryResult<IaInsurancelist> iaInsurancelistQueryResult = this.iaInsurancelistService.queryInsurancelistPage(paramMap);
        if (null != iaInsurancelistQueryResult && null != iaInsurancelistQueryResult.getList()) {
            iaInsurance.setIaInsurancelistList(iaInsurancelistQueryResult.getList());
        }
    }
}

