/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ifb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ifb.dao.IfbApprovalMapper;
import com.yqbsoft.laser.service.ifb.domain.IfbApprovalDomain;
import com.yqbsoft.laser.service.ifb.domain.IfbApprovalReDomain;
import com.yqbsoft.laser.service.ifb.model.IfbApproval;
import com.yqbsoft.laser.service.ifb.model.IfbRequest;
import com.yqbsoft.laser.service.ifb.service.IfbApprovalService;
import com.yqbsoft.laser.service.ifb.service.IfbRequestService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IfbApprovalServiceImpl
extends BaseServiceImpl
implements IfbApprovalService {
    private static final String SYS_CODE = "ifb.PICK.IfbApprovalServiceImpl";
    private IfbApprovalMapper ifbApprovalMapper;
    private IfbRequestService ifbRequestService;

    public void setIfbRequestService(IfbRequestService ifbRequestService) {
        this.ifbRequestService = ifbRequestService;
    }

    public void setIfbApprovalMapper(IfbApprovalMapper ifbApprovalMapper) {
        this.ifbApprovalMapper = ifbApprovalMapper;
    }

    private Date getSysDate() {
        try {
            return this.ifbApprovalMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbApprovalServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkbApproval(IfbApprovalDomain ifbApprovalDomain) {
        if (null == ifbApprovalDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ifbApprovalDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setbApprovalDefault(IfbApproval ifbApproval) {
        if (null == ifbApproval) {
            return;
        }
        if (null == ifbApproval.getDataState()) {
            ifbApproval.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ifbApproval.getGmtCreate()) {
            ifbApproval.setGmtCreate(date);
        }
        ifbApproval.setGmtModified(date);
        if (StringUtils.isBlank((String)ifbApproval.getApprovalCode())) {
            ifbApproval.setApprovalCode(this.getNo(null, "IfbApproval", "ifbApproval", ifbApproval.getTenantCode()));
        }
    }

    private int getbApprovalMaxCode() {
        int code = 0;
        try {
            return this.ifbApprovalMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbApprovalServiceImpl.getbApprovalMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setbApprovalUpdataDefault(IfbApproval ifbApproval) {
        if (null == ifbApproval) {
            return;
        }
        ifbApproval.setGmtModified(this.getSysDate());
    }

    private void savebApprovalModel(IfbApproval ifbApproval) throws ApiException {
        if (null == ifbApproval) {
            return;
        }
        try {
            this.ifbApprovalMapper.insertSelective(ifbApproval);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.savebApprovalModel.ex", (Throwable)e);
        }
    }

    private void savebApprovalBatchModel(List<IfbApproval> ifbApprovalList) throws ApiException {
        if (null == ifbApprovalList || ifbApprovalList.isEmpty()) {
            return;
        }
        try {
            this.ifbApprovalMapper.insertBatch(ifbApprovalList);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.savebApprovalBatchModel.ex", (Throwable)e);
        }
    }

    private IfbApproval getbApprovalModelById(Integer bApprovalId) {
        if (null == bApprovalId) {
            return null;
        }
        try {
            return this.ifbApprovalMapper.selectByPrimaryKey(bApprovalId);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbApprovalServiceImpl.getbApprovalModelById", (Throwable)e);
            return null;
        }
    }

    private IfbApproval getbApprovalModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ifbApprovalMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbApprovalServiceImpl.getbApprovalModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delbApprovalModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbApprovalMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.delbApprovalModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.delbApprovalModelByCode.num");
        }
    }

    private void deletebApprovalModel(Integer bApprovalId) throws ApiException {
        if (null == bApprovalId) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbApprovalMapper.deleteByPrimaryKey(bApprovalId);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.deletebApprovalModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.deletebApprovalModel.num");
        }
    }

    private void updatebApprovalModel(IfbApproval ifbApproval) throws ApiException {
        if (null == ifbApproval) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbApprovalMapper.updateByPrimaryKeySelective(ifbApproval);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.updatebApprovalModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.updatebApprovalModel.num");
        }
    }

    private void updateStatebApprovalModel(Integer bApprovalId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == bApprovalId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("approvalId", bApprovalId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ifbApprovalMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.updateStatebApprovalModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.updateStatebApprovalModel.null");
        }
    }

    private void updateStatebApprovalModelByCode(String tenantCode, String bApprovalCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)bApprovalCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("approvalCode", bApprovalCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ifbApprovalMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.updateStatebApprovalModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.updateStatebApprovalModelByCode.null");
        }
    }

    private IfbApproval makebApproval(IfbApprovalDomain ifbApprovalDomain, IfbApproval ifbApproval) {
        if (null == ifbApprovalDomain) {
            return null;
        }
        if (null == ifbApproval) {
            ifbApproval = new IfbApproval();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ifbApproval, (Object)ifbApprovalDomain);
            return ifbApproval;
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbApprovalServiceImpl.makebApproval", (Throwable)e);
            return null;
        }
    }

    private IfbApprovalReDomain makeIfbApprovalReDomain(IfbApproval ifbApproval) {
        if (null == ifbApproval) {
            return null;
        }
        IfbApprovalReDomain ifbApprovalReDomain = new IfbApprovalReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ifbApprovalReDomain, (Object)ifbApproval);
            return ifbApprovalReDomain;
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbApprovalServiceImpl.makeIfbApprovalReDomain", (Throwable)e);
            return null;
        }
    }

    private List<IfbApproval> querybApprovalModelPage(Map<String, Object> parammap) {
        try {
            return this.ifbApprovalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbApprovalServiceImpl.querybApprovalModel", (Throwable)e);
            return null;
        }
    }

    private int countbApproval(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ifbApprovalMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbApprovalServiceImpl.countbApproval", (Throwable)e);
        }
        return i;
    }

    private IfbApproval createIfbApproval(IfbApprovalDomain ifbApprovalDomain) {
        String msg = this.checkbApproval(ifbApprovalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.savebApproval.checkbApproval", msg);
        }
        IfbApproval ifbApproval = this.makebApproval(ifbApprovalDomain, null);
        this.setbApprovalDefault(ifbApproval);
        return ifbApproval;
    }

    @Override
    public String savebApproval(IfbApprovalDomain ifbApprovalDomain) throws ApiException {
        this.logger.error("saveapprpval", (Object)JsonUtil.buildNormalBinder().toJson((Object)ifbApprovalDomain));
        IfbApproval ifbApproval = this.createIfbApproval(ifbApprovalDomain);
        this.savebApprovalModel(ifbApproval);
        return ifbApproval.getApprovalCode();
    }

    @Override
    public String savebApprovalBatch(List<IfbApprovalDomain> ifbApprovalDomainList) throws ApiException {
        if (null == ifbApprovalDomainList || ifbApprovalDomainList.isEmpty()) {
            return null;
        }
        ArrayList<IfbApproval> ifbApprovalList = new ArrayList<IfbApproval>();
        String code = "";
        for (IfbApprovalDomain ifbApprovalDomain : ifbApprovalDomainList) {
            IfbApproval ifbApproval = this.createIfbApproval(ifbApprovalDomain);
            code = ifbApproval.getApprovalCode();
            ifbApprovalList.add(ifbApproval);
        }
        this.savebApprovalBatchModel(ifbApprovalList);
        return code;
    }

    @Override
    public void updatebApprovalState(Integer bApprovalId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == bApprovalId) {
            return;
        }
        this.updateStatebApprovalModel(bApprovalId, dataState, oldDataState, map);
    }

    @Override
    public void updatebApprovalStateByCode(String tenantCode, String bApprovalCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)bApprovalCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatebApprovalModelByCode(tenantCode, bApprovalCode, dataState, oldDataState, map);
    }

    @Override
    public void updatebApproval(IfbApprovalDomain ifbApprovalDomain) throws ApiException {
        String msg = this.checkbApproval(ifbApprovalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.updatebApproval.checkbApproval", msg);
        }
        IfbApproval oldIfbApproval = this.getbApprovalModelById(ifbApprovalDomain.getApprovalId());
        if (null == oldIfbApproval) {
            throw new ApiException("ifb.PICK.IfbApprovalServiceImpl.updatebApproval.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        IfbApproval ifbApproval = this.makebApproval(ifbApprovalDomain, oldIfbApproval);
        this.setbApprovalUpdataDefault(ifbApproval);
        this.updatebApprovalModel(ifbApproval);
    }

    @Override
    public IfbApproval getbApproval(Integer bApprovalId) {
        if (null == bApprovalId) {
            return null;
        }
        return this.getbApprovalModelById(bApprovalId);
    }

    @Override
    public void deletebApproval(Integer bApprovalId) throws ApiException {
        if (null == bApprovalId) {
            return;
        }
        this.deletebApprovalModel(bApprovalId);
    }

    @Override
    public QueryResult<IfbApproval> querybApprovalPage(Map<String, Object> map) {
        List<IfbApproval> ifbApprovalList = this.querybApprovalModelPage(map);
        ifbApprovalList = this.makeRequest(ifbApprovalList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countbApproval(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ifbApprovalList);
        return queryResult;
    }

    private List<IfbApproval> makeRequest(List<IfbApproval> ifbApprovalList) {
        if (null == ifbApprovalList) {
            return null;
        }
        for (IfbApproval ifbApproval : ifbApprovalList) {
            IfbRequest ifbRequest = this.ifbRequestService.getbRequestByCode(ifbApproval.getTenantCode(), ifbApproval.getRequestCode());
            ifbApproval.setIfbRequest(ifbRequest);
        }
        return ifbApprovalList;
    }

    @Override
    public IfbApproval getbApprovalByCode(String tenantCode, String bApprovalCode) throws ApiException {
        if (StringUtils.isBlank((String)bApprovalCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("approvalCode", bApprovalCode);
        return this.getbApprovalModelByCode(map);
    }

    @Override
    public void deletebApprovalByCode(String tenantCode, String bApprovalCode) throws ApiException {
        if (StringUtils.isBlank((String)bApprovalCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("approvalCode", bApprovalCode);
        this.delbApprovalModelByCode(map);
    }
}

