/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ifb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ifb.dao.IfbRequestMapper;
import com.yqbsoft.laser.service.ifb.domain.IfbApprovalDomain;
import com.yqbsoft.laser.service.ifb.domain.IfbRequestDomain;
import com.yqbsoft.laser.service.ifb.domain.IfbRequestFileDomain;
import com.yqbsoft.laser.service.ifb.domain.IfbRequestReDomain;
import com.yqbsoft.laser.service.ifb.model.IfbRequest;
import com.yqbsoft.laser.service.ifb.service.IfbApprovalService;
import com.yqbsoft.laser.service.ifb.service.IfbRequestFileService;
import com.yqbsoft.laser.service.ifb.service.IfbRequestService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IfbRequestServiceImpl
extends BaseServiceImpl
implements IfbRequestService {
    private static final String SYS_CODE = "ifb.PICK.IfbRequestServiceImpl";
    private IfbRequestMapper ifbRequestMapper;
    private IfbApprovalService ifbApprovalService;
    private IfbRequestFileService ifbRequestFileService;

    public void setIfbRequestMapper(IfbRequestMapper ifbRequestMapper) {
        this.ifbRequestMapper = ifbRequestMapper;
    }

    public void setIfbRequestFileService(IfbRequestFileService ifbRequestFileService) {
        this.ifbRequestFileService = ifbRequestFileService;
    }

    public void setIfbApprovalService(IfbApprovalService ifbApprovalService) {
        this.ifbApprovalService = ifbApprovalService;
    }

    private Date getSysDate() {
        try {
            return this.ifbRequestMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkbRequest(IfbRequestDomain ifbRequestDomain) {
        if (null == ifbRequestDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ifbRequestDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setbRequestDefault(IfbRequest ifbRequest) {
        if (null == ifbRequest) {
            return;
        }
        if (null == ifbRequest.getDataState()) {
            ifbRequest.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ifbRequest.getGmtCreate()) {
            ifbRequest.setGmtCreate(date);
        }
        ifbRequest.setGmtModified(date);
        if (StringUtils.isBlank((String)ifbRequest.getRequestCode())) {
            ifbRequest.setRequestCode(this.getNo(null, "IfbRequest", "ifbRequest", ifbRequest.getTenantCode()));
        }
    }

    private int getbRequestMaxCode() {
        int code = 0;
        try {
            return this.ifbRequestMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.getbRequestMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setbRequestUpdataDefault(IfbRequest ifbRequest) {
        if (null == ifbRequest) {
            return;
        }
        ifbRequest.setGmtModified(this.getSysDate());
    }

    private void savebRequestModel(IfbRequest ifbRequest) throws ApiException {
        if (null == ifbRequest) {
            return;
        }
        try {
            this.ifbRequestMapper.insertSelective(ifbRequest);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.savebRequestModel.ex", (Throwable)e);
        }
    }

    private void savebRequestBatchModel(List<IfbRequest> ifbRequestList) throws ApiException {
        if (null == ifbRequestList || ifbRequestList.isEmpty()) {
            return;
        }
        try {
            this.ifbRequestMapper.insertBatch(ifbRequestList);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.savebRequestBatchModel.ex", (Throwable)e);
        }
    }

    private IfbRequest getbRequestModelById(Integer bRequestId) {
        if (null == bRequestId) {
            return null;
        }
        try {
            return this.ifbRequestMapper.selectByPrimaryKey(bRequestId);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.getbRequestModelById", (Throwable)e);
            return null;
        }
    }

    private IfbRequest getbRequestModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ifbRequestMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.getbRequestModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delbRequestModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.delbRequestModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.delbRequestModelByCode.num");
        }
    }

    private void deletebRequestModel(Integer bRequestId) throws ApiException {
        if (null == bRequestId) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.deleteByPrimaryKey(bRequestId);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.deletebRequestModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.deletebRequestModel.num");
        }
    }

    private void updatebRequestModel(IfbRequest ifbRequest) throws ApiException {
        if (null == ifbRequest) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.updateRequestById(ifbRequest);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequestModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequestModel.num");
        }
    }

    private void updateStatebRequestModel(Integer bRequestId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == bRequestId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", bRequestId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updateStatebRequestModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updateStatebRequestModel.null");
        }
    }

    private void updateStatebRequestModelByCode(String tenantCode, String bRequestCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)bRequestCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestCode", bRequestCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updateStatebRequestModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updateStatebRequestModelByCode.null");
        }
    }

    private IfbRequest makebRequest(IfbRequestDomain ifbRequestDomain, IfbRequest ifbRequest) {
        if (null == ifbRequestDomain) {
            return null;
        }
        if (null == ifbRequest) {
            ifbRequest = new IfbRequest();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ifbRequest, (Object)ifbRequestDomain);
            return ifbRequest;
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.makebRequest", (Throwable)e);
            return null;
        }
    }

    private IfbRequestReDomain makeIfbRequestReDomain(IfbRequest ifbRequest) {
        if (null == ifbRequest) {
            return null;
        }
        IfbRequestReDomain ifbRequestReDomain = new IfbRequestReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ifbRequestReDomain, (Object)ifbRequest);
            return ifbRequestReDomain;
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.makeIfbRequestReDomain", (Throwable)e);
            return null;
        }
    }

    private List<IfbRequest> querybRequestModelPage(Map<String, Object> parammap) {
        try {
            return this.ifbRequestMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.querybRequestModel", (Throwable)e);
            return null;
        }
    }

    private int countbRequest(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ifbRequestMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.countbRequest", (Throwable)e);
        }
        return i;
    }

    private IfbRequest createIfbRequest(IfbRequestDomain ifbRequestDomain) {
        String msg = this.checkbRequest(ifbRequestDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.savebRequest.checkbRequest", msg);
        }
        IfbRequest ifbRequest = this.makebRequest(ifbRequestDomain, null);
        this.setbRequestDefault(ifbRequest);
        return ifbRequest;
    }

    @Override
    public String savebRequest(IfbRequestDomain ifbRequestDomain) throws ApiException {
        IfbRequest ifbRequest = this.createIfbRequest(ifbRequestDomain);
        this.savebRequestModel(ifbRequest);
        if (!EmptyUtil.isEmpty((Object)ifbRequestDomain.getIfbRequestFileDomain())) {
            IfbRequestFileDomain ifbRequestFileDomain = ifbRequestDomain.getIfbRequestFileDomain();
            ifbRequestFileDomain.setRequestCode(ifbRequest.getRequestCode());
            ifbRequestFileDomain.setTenantCode(ifbRequestDomain.getTenantCode());
            this.ifbRequestFileService.savebRequestFile(ifbRequestFileDomain);
        }
        this.ifbApprovalService.savebApproval(this.makeApproval(ifbRequest));
        return ifbRequest.getRequestCode();
    }

    private IfbApprovalDomain makeApproval(IfbRequest ifbRequest) {
        if (null == ifbRequest) {
            return null;
        }
        IfbApprovalDomain ifbApprovalDomain = new IfbApprovalDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ifbApprovalDomain, (Object)ifbRequest);
            ifbApprovalDomain.setBiddingResult("0");
            return ifbApprovalDomain;
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.makeApproval", (Throwable)e);
            return null;
        }
    }

    @Override
    public String savebRequestBatch(List<IfbRequestDomain> ifbRequestDomainList) throws ApiException {
        if (null == ifbRequestDomainList || ifbRequestDomainList.isEmpty()) {
            return null;
        }
        ArrayList<IfbRequest> ifbRequestList = new ArrayList<IfbRequest>();
        String code = "";
        for (IfbRequestDomain ifbRequestDomain : ifbRequestDomainList) {
            IfbRequest ifbRequest = this.createIfbRequest(ifbRequestDomain);
            code = ifbRequest.getRequestCode();
            ifbRequestList.add(ifbRequest);
        }
        this.savebRequestBatchModel(ifbRequestList);
        return code;
    }

    @Override
    public void updatebRequestState(Integer bRequestId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == bRequestId) {
            return;
        }
        this.updateStatebRequestModel(bRequestId, dataState, oldDataState, map);
    }

    @Override
    public void updatebRequestStateByCode(String tenantCode, String bRequestCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)bRequestCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatebRequestModelByCode(tenantCode, bRequestCode, dataState, oldDataState, map);
    }

    @Override
    public void updatebRequest(IfbRequestDomain ifbRequestDomain) throws ApiException {
        String msg = this.checkbRequest(ifbRequestDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequest.checkbRequest", msg);
        }
        IfbRequest oldIfbRequest = this.getbRequestModelById(ifbRequestDomain.getRequestId());
        if (null == oldIfbRequest) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequest.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        IfbRequest ifbRequest = this.makebRequest(ifbRequestDomain, oldIfbRequest);
        this.setbRequestUpdataDefault(ifbRequest);
        this.logger.error("ifb.PICK.IfbRequestServiceImpl.updatebRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)ifbRequest));
        this.updatebRequestModel(ifbRequest);
    }

    @Override
    public IfbRequest getbRequest(Integer bRequestId) {
        if (null == bRequestId) {
            return null;
        }
        return this.getbRequestModelById(bRequestId);
    }

    @Override
    public void deletebRequest(Integer bRequestId) throws ApiException {
        if (null == bRequestId) {
            return;
        }
        this.deletebRequestModel(bRequestId);
    }

    @Override
    public QueryResult<IfbRequest> querybRequestPage(Map<String, Object> map) {
        List<IfbRequest> ifbRequestList = this.querybRequestModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countbRequest(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ifbRequestList);
        return queryResult;
    }

    @Override
    public IfbRequest getbRequestByCode(String tenantCode, String bRequestCode) throws ApiException {
        if (StringUtils.isBlank((String)bRequestCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestCode", bRequestCode);
        return this.getbRequestModelByCode(map);
    }

    @Override
    public void deletebRequestByCode(String tenantCode, String bRequestCode) throws ApiException {
        if (StringUtils.isBlank((String)bRequestCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestCode", bRequestCode);
        this.delbRequestModelByCode(map);
    }
}

