/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ifb.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ifb.dao.IfbRequestFileMapper;
import com.yqbsoft.laser.service.ifb.dao.IfbRequestMapper;
import com.yqbsoft.laser.service.ifb.domain.FmFileReDomainBean;
import com.yqbsoft.laser.service.ifb.domain.IfbApprovalDomain;
import com.yqbsoft.laser.service.ifb.domain.IfbRequestDomain;
import com.yqbsoft.laser.service.ifb.domain.IfbRequestFileDomain;
import com.yqbsoft.laser.service.ifb.domain.IfbRequestReDomain;
import com.yqbsoft.laser.service.ifb.es.SendPollThread;
import com.yqbsoft.laser.service.ifb.es.SendService;
import com.yqbsoft.laser.service.ifb.model.IfbRequest;
import com.yqbsoft.laser.service.ifb.model.IfbRequestFile;
import com.yqbsoft.laser.service.ifb.service.IfbApprovalService;
import com.yqbsoft.laser.service.ifb.service.IfbRequestFileService;
import com.yqbsoft.laser.service.ifb.service.IfbRequestService;
import com.yqbsoft.laser.service.suppercore.file.FileBean;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.codec.Base64;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class IfbRequestServiceImpl
extends BaseServiceImpl
implements IfbRequestService {
    private static final String SYS_CODE = "ifb.PICK.IfbRequestServiceImpl";
    private IfbRequestMapper ifbRequestMapper;
    private IfbApprovalService ifbApprovalService;
    private IfbRequestFileService ifbRequestFileService;
    private IfbRequestFileMapper ifbRequestFileMapper;
    private static final int FM_NAME_MAX_LENGTH = 40;
    private static Object lock = new Object();
    private static SendService sendService;

    public void setIfbRequestMapper(IfbRequestMapper ifbRequestMapper) {
        this.ifbRequestMapper = ifbRequestMapper;
    }

    public void setIfbRequestFileMapper(IfbRequestFileMapper ifbRequestFileMapper) {
        this.ifbRequestFileMapper = ifbRequestFileMapper;
    }

    public void setIfbRequestFileService(IfbRequestFileService ifbRequestFileService) {
        this.ifbRequestFileService = ifbRequestFileService;
    }

    public void setIfbApprovalService(IfbApprovalService ifbApprovalService) {
        this.ifbApprovalService = ifbApprovalService;
    }

    private Date getSysDate() {
        try {
            return this.ifbRequestMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkbRequest(IfbRequestDomain ifbRequestDomain) {
        if (null == ifbRequestDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ifbRequestDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setbRequestDefault(IfbRequest ifbRequest) {
        if (null == ifbRequest) {
            return;
        }
        if (null == ifbRequest.getDataState()) {
            ifbRequest.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ifbRequest.getGmtCreate()) {
            ifbRequest.setGmtCreate(date);
        }
        ifbRequest.setGmtModified(date);
        if (StringUtils.isBlank((String)ifbRequest.getRequestCode())) {
            ifbRequest.setRequestCode(this.getNo(null, "IfbRequest", "ifbRequest", ifbRequest.getTenantCode()));
        }
    }

    private int getbRequestMaxCode() {
        int code = 0;
        try {
            return this.ifbRequestMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.getbRequestMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setbRequestUpdataDefault(IfbRequest ifbRequest) {
        if (null == ifbRequest) {
            return;
        }
        ifbRequest.setGmtModified(this.getSysDate());
    }

    private void savebRequestModel(IfbRequest ifbRequest) throws ApiException {
        if (null == ifbRequest) {
            return;
        }
        try {
            this.ifbRequestMapper.insertSelective(ifbRequest);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.savebRequestModel.ex", (Throwable)e);
        }
    }

    private void savebRequestBatchModel(List<IfbRequest> ifbRequestList) throws ApiException {
        if (null == ifbRequestList || ifbRequestList.isEmpty()) {
            return;
        }
        try {
            this.ifbRequestMapper.insertBatch(ifbRequestList);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.savebRequestBatchModel.ex", (Throwable)e);
        }
    }

    private IfbRequest getbRequestModelById(Integer bRequestId) {
        if (null == bRequestId) {
            return null;
        }
        try {
            return this.ifbRequestMapper.selectByPrimaryKey(bRequestId);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.getbRequestModelById", (Throwable)e);
            return null;
        }
    }

    private IfbRequest getbRequestModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ifbRequestMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.getbRequestModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delbRequestModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.delbRequestModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.delbRequestModelByCode.num");
        }
    }

    private void deletebRequestModel(Integer bRequestId) throws ApiException {
        if (null == bRequestId) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.deleteByPrimaryKey(bRequestId);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.deletebRequestModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.deletebRequestModel.num");
        }
    }

    private void updatebRequestModel(IfbRequest ifbRequest) throws ApiException {
        if (null == ifbRequest) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.updateRequestById(ifbRequest);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequestModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequestModel.num");
        }
    }

    private void updateStatebRequestModel(Integer bRequestId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == bRequestId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requestId", bRequestId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updateStatebRequestModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updateStatebRequestModel.null");
        }
    }

    private void updateStatebRequestModelByCode(String tenantCode, String bRequestCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)bRequestCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestCode", bRequestCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ifbRequestMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updateStatebRequestModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updateStatebRequestModelByCode.null");
        }
    }

    private IfbRequest makebRequest(IfbRequestDomain ifbRequestDomain, IfbRequest ifbRequest) {
        if (null == ifbRequestDomain) {
            return null;
        }
        if (null == ifbRequest) {
            ifbRequest = new IfbRequest();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ifbRequest, (Object)ifbRequestDomain);
            return ifbRequest;
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.makebRequest", (Throwable)e);
            return null;
        }
    }

    private IfbRequestReDomain makeIfbRequestReDomain(IfbRequest ifbRequest) {
        if (null == ifbRequest) {
            return null;
        }
        IfbRequestReDomain ifbRequestReDomain = new IfbRequestReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ifbRequestReDomain, (Object)ifbRequest);
            return ifbRequestReDomain;
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.makeIfbRequestReDomain", (Throwable)e);
            return null;
        }
    }

    private List<IfbRequest> querybRequestModelPage(Map<String, Object> parammap) {
        try {
            return this.ifbRequestMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.querybRequestModel", (Throwable)e);
            return null;
        }
    }

    private int countbRequest(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ifbRequestMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.countbRequest", (Throwable)e);
        }
        return i;
    }

    private IfbRequest createIfbRequest(IfbRequestDomain ifbRequestDomain) {
        String msg = this.checkbRequest(ifbRequestDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.savebRequest.checkbRequest", msg);
        }
        IfbRequest ifbRequest = this.makebRequest(ifbRequestDomain, null);
        this.setbRequestDefault(ifbRequest);
        return ifbRequest;
    }

    @Override
    public String savebRequest(IfbRequestDomain ifbRequestDomain) throws ApiException {
        IfbRequest ifbRequest = this.createIfbRequest(ifbRequestDomain);
        this.savebRequestModel(ifbRequest);
        if (!EmptyUtil.isEmpty((Object)ifbRequestDomain.getIfbRequestFileDomain())) {
            IfbRequestFileDomain ifbRequestFileDomain = ifbRequestDomain.getIfbRequestFileDomain();
            ifbRequestFileDomain.setRequestCode(ifbRequest.getRequestCode());
            ifbRequestFileDomain.setTenantCode(ifbRequestDomain.getTenantCode());
            this.ifbRequestFileService.savebRequestFile(ifbRequestFileDomain);
        }
        this.ifbApprovalService.savebApproval(this.makeApproval(ifbRequest));
        this.getSendService().putQueue(ifbRequest);
        return ifbRequest.getRequestCode();
    }

    private IfbApprovalDomain makeApproval(IfbRequest ifbRequest) {
        if (null == ifbRequest) {
            return null;
        }
        IfbApprovalDomain ifbApprovalDomain = new IfbApprovalDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ifbApprovalDomain, (Object)ifbRequest);
            ifbApprovalDomain.setBiddingResult("0");
            ifbApprovalDomain.setMemo(ifbRequest.getAreaCode());
            return ifbApprovalDomain;
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.makeApproval", (Throwable)e);
            return null;
        }
    }

    @Override
    public String savebRequestBatch(List<IfbRequestDomain> ifbRequestDomainList) throws ApiException {
        if (null == ifbRequestDomainList || ifbRequestDomainList.isEmpty()) {
            return null;
        }
        ArrayList<IfbRequest> ifbRequestList = new ArrayList<IfbRequest>();
        String code = "";
        for (IfbRequestDomain ifbRequestDomain : ifbRequestDomainList) {
            IfbRequest ifbRequest = this.createIfbRequest(ifbRequestDomain);
            code = ifbRequest.getRequestCode();
            ifbRequestList.add(ifbRequest);
        }
        this.savebRequestBatchModel(ifbRequestList);
        return code;
    }

    @Override
    public void updatebRequestState(Integer bRequestId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == bRequestId) {
            return;
        }
        this.updateStatebRequestModel(bRequestId, dataState, oldDataState, map);
    }

    @Override
    public void updatebRequestStateByCode(String tenantCode, String bRequestCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)bRequestCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatebRequestModelByCode(tenantCode, bRequestCode, dataState, oldDataState, map);
    }

    @Override
    public void updatebRequest(IfbRequestDomain ifbRequestDomain) throws ApiException {
        String msg = this.checkbRequest(ifbRequestDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequest.checkbRequest", msg);
        }
        IfbRequest oldIfbRequest = this.getbRequestModelById(ifbRequestDomain.getRequestId());
        if (null == oldIfbRequest) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequest.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        IfbRequest ifbRequest = this.makebRequest(ifbRequestDomain, oldIfbRequest);
        this.setbRequestUpdataDefault(ifbRequest);
        this.logger.error("ifb.PICK.IfbRequestServiceImpl.updatebRequest", (Object)JsonUtil.buildNormalBinder().toJson((Object)ifbRequest));
        this.updatebRequestModel(ifbRequest);
    }

    @Override
    public IfbRequest getbRequest(Integer bRequestId) {
        if (null == bRequestId) {
            return null;
        }
        return this.getbRequestModelById(bRequestId);
    }

    @Override
    public void deletebRequest(Integer bRequestId) throws ApiException {
        if (null == bRequestId) {
            return;
        }
        this.deletebRequestModel(bRequestId);
    }

    @Override
    public QueryResult<IfbRequest> querybRequestPage(Map<String, Object> map) {
        List<IfbRequest> ifbRequestList = this.querybRequestModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countbRequest(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ifbRequestList);
        return queryResult;
    }

    @Override
    public IfbRequest getbRequestByCode(String tenantCode, String bRequestCode) throws ApiException {
        if (StringUtils.isBlank((String)bRequestCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestCode", bRequestCode);
        return this.getbRequestModelByCode(map);
    }

    @Override
    public void deletebRequestByCode(String tenantCode, String bRequestCode) throws ApiException {
        if (StringUtils.isBlank((String)bRequestCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("requestCode", bRequestCode);
        this.delbRequestModelByCode(map);
    }

    @Override
    public void exportWordByIfbRequest(final IfbRequest ifbRequest) throws ApiException {
        QueryResult<IfbRequestFile> queryResult;
        this.logger.error("ifb.PICK.IfbRequestServiceImpl.exportWordByIfbRequest.info.", (Object)ifbRequest);
        if (null == ifbRequest) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.exportWordByIfbRequest.", (Object)"ifbRequest-null");
            return;
        }
        String companyName = Optional.ofNullable(ifbRequest).map(IfbRequest::getCompanyName).orElse("");
        String brandNames = Optional.ofNullable(ifbRequest).map(IfbRequest::getBrandNames).orElse("");
        String projectName = Optional.ofNullable(ifbRequest).map(IfbRequest::getProjectName).orElse("");
        String projectCode = Optional.ofNullable(ifbRequest).map(IfbRequest::getProjectCode).orElse("");
        Date startTime = Optional.ofNullable(ifbRequest).map(IfbRequest::getAuthStartTime).orElse(null);
        Date endTime = Optional.ofNullable(ifbRequest).map(IfbRequest::getAuthEndTime).orElse(null);
        Date lastTime = Optional.ofNullable(ifbRequest).map(IfbRequest::getLastTime).orElse(new Date());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String authStartTime = startTime == null ? "" : simpleDateFormat.format(startTime.getTime());
        String authEndTime = endTime == null ? "" : simpleDateFormat.format(endTime.getTime());
        String currentTime = simpleDateFormat.format(lastTime);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("companyName", companyName);
        dataMap.put("brandName", brandNames);
        dataMap.put("projectName", projectName);
        dataMap.put("startDate", authStartTime);
        dataMap.put("endDate", authEndTime);
        dataMap.put("projectCode", projectCode);
        dataMap.put("createDate", currentTime);
        Configuration configuration = new Configuration();
        configuration.setDefaultEncoding("utf-8");
        configuration.setClassForTemplateLoading(this.getClass(), "/");
        File outFile = new File("/wordExport3" + UUID.randomUUID().toString() + ".doc");
        String outFileName = "\u6388\u6743\u60c5\u51b5\u8bf4\u660e\u51fd-\u5206\u9500\u5546.ftl";
        if (StringUtils.isNotBlank((String)ifbRequest.getAuthObjectName()) && ifbRequest.getAuthObjectName().equals("\u4e2d\u95f4\u670d\u52a1\u5546")) {
            outFileName = "\u6388\u6743\u60c5\u51b5\u8bf4\u660e\u51fd-\u4e2d\u95f4\u670d\u52a1\u5546.ftl";
        }
        try {
            Template t = configuration.getTemplate(outFileName, "utf-8");
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "utf-8"), 10240);
            t.process(dataMap, (Writer)out);
            ((Writer)out).close();
        }
        catch (Exception e) {
            this.logger.error("ifb.PICK.IfbRequestServiceImpl.exportWordByIfbRequest.", (Throwable)e);
        }
        FileItem fileItem = IfbRequestServiceImpl.createFileItem(outFile);
        CommonsMultipartFile multipartFile = new CommonsMultipartFile(fileItem);
        String fileName = multipartFile.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        FmFileReDomainBean fmFileReDomainBean = new FmFileReDomainBean();
        fmFileReDomainBean.setFileName(name.length() > 40 ? name.substring(0, 40) : name);
        fmFileReDomainBean.setFileSize((int)multipartFile.getSize());
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileCtype(fileType);
        fmFileReDomainBean.setFileRemark(name);
        fmFileReDomainBean.setFileOwner(ifbRequest.getReUserCode());
        FileBean fileBean = this.convertFileBean((MultipartFile)multipartFile);
        fmFileReDomainBean.setFileType("0");
        fmFileReDomainBean.setFileSort("FILE_02");
        fmFileReDomainBean.setTenantCode(ifbRequest.getTenantCode());
        fmFileReDomainBean.setRootPath(ifbRequest.getTenantCode() + "/");
        ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
        fileBeanList.add(fileBean);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("fmFileDomainBean", JsonUtil.buildNormalBinder().toJson((Object)fmFileReDomainBean));
        paramMap.put("fileBeanList", JsonUtil.buildNormalBinder().toJson(fileBeanList));
        this.logger.error("ifb.PICK.IfbRequestServiceImplexportWordByIfbRequest.info", (Object)JsonUtil.buildNormalBinder().toJson(paramMap));
        String fmfilestr = "";
        try {
            fmfilestr = (String)this.getInternalRouter().inInvoke("fm.file.saveFile", paramMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank((String)fmfilestr)) {
            this.logger.error("ifb.PICK.IfbRequestServiceImplexportWordByIfbRequest.error", (Object)fmfilestr);
            return;
        }
        this.logger.error("ifb.PICK.IfbRequestServiceImplexportWordByIfbRequest.error", (Object)fmfilestr);
        FmFileReDomainBean domainBean = (FmFileReDomainBean)JsonUtil.buildNormalBinder().getJsonToObject(fmfilestr, FmFileReDomainBean.class);
        if (null == domainBean) {
            this.logger.error("ifb.PICK.IfbRequestServiceImplexportWordByIfbRequest.domainBean", (Object)domainBean);
            return;
        }
        String httpPath = "/paas/shop";
        String fileUrl = domainBean.getFileUrl();
        this.logger.error("ifb.PICK.IfbRequestServiceImplexportWordByIfbRequest.error", (Object)fileUrl);
        if (StringUtils.isNotBlank((String)fileUrl) && !fileUrl.trim().substring(0, 4).equals("http")) {
            String separator = "/";
            if (fileUrl.startsWith("/") || fileUrl.startsWith("\\")) {
                separator = "";
            }
            fileUrl = httpPath + separator + fileUrl;
        }
        if (!EmptyUtil.isEmpty(queryResult = this.ifbRequestFileService.querybRequestFilePage((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("requestCode", ifbRequest.getRequestCode());
                this.put("tenantCode", ifbRequest.getTenantCode());
            }
        })) && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
            IfbRequestFile ifbRequestFile = (IfbRequestFile)queryResult.getList().get(0);
            ifbRequestFile.setAuthLetterName("\u6388\u6743\u7533\u8bf7\u51fd");
            ifbRequestFile.setAuthLetter(fileUrl);
            this.updatebRequestFileModel(ifbRequestFile);
        } else {
            IfbRequestFileDomain requestFileDomain = new IfbRequestFileDomain();
            requestFileDomain.setAuthLetterName("\u6388\u6743\u7533\u8bf7\u51fd");
            requestFileDomain.setAuthLetter(fileUrl);
            requestFileDomain.setRequestCode(ifbRequest.getRequestCode());
            this.ifbRequestFileService.savebRequestFile(requestFileDomain);
        }
    }

    private void updatebRequestFileModel(IfbRequestFile ifbRequestFile) throws ApiException {
        if (null == ifbRequestFile) {
            return;
        }
        int i = 0;
        try {
            i = this.ifbRequestFileMapper.updateByPrimaryKeySelective(ifbRequestFile);
        }
        catch (Exception e) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequestFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ifb.PICK.IfbRequestServiceImpl.updatebRequestFileModel.num");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((IfbRequestService)SpringApplicationContextUtil.getBean((String)"ifbRequestService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    public static FileItem createFileItem(File file) {
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    private FileBean convertFileBean(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        String fileName = file.getOriginalFilename();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        byte[] fileBytes = new byte[(int)file.getSize()];
        try {
            file.getInputStream().read(fileBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileBean fileBean = new FileBean();
        fileBean.setBytes(Base64.encodeBase64((byte[])fileBytes));
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(name.length() > 40 ? name.substring(0, 40) : name);
        fileBean.setSize(Long.valueOf(file.getSize()));
        return fileBean;
    }
}

