/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.invoice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.invoice.dao.InvInvsetMapper;
import com.yqbsoft.laser.service.invoice.domain.InvInvsetDomain;
import com.yqbsoft.laser.service.invoice.domain.InvInvsetReDomain;
import com.yqbsoft.laser.service.invoice.model.InvInvset;
import com.yqbsoft.laser.service.invoice.service.InvInvsetService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvInvsetServiceImpl
extends BaseServiceImpl
implements InvInvsetService {
    private static final String SYS_CODE = "inv.InvInvsetServiceImpl";
    private InvInvsetMapper invInvsetMapper;

    public void setInvInvsetMapper(InvInvsetMapper invInvsetMapper) {
        this.invInvsetMapper = invInvsetMapper;
    }

    private Date getSysDate() {
        try {
            return this.invInvsetMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvsetServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkInvset(InvInvsetDomain invInvsetDomain) {
        if (null == invInvsetDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)invInvsetDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInvsetDefault(InvInvset invInvset) {
        if (null == invInvset) {
            return;
        }
        if (null == invInvset.getDataState()) {
            invInvset.setDataState(0);
        }
        if (null == invInvset.getGmtCreate()) {
            invInvset.setGmtCreate(this.getSysDate());
        }
        invInvset.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)invInvset.getInvsetCode())) {
            invInvset.setInvsetCode(this.createUUIDString());
        }
    }

    private int getInvsetMaxCode() {
        int code = 0;
        try {
            return this.invInvsetMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvsetServiceImpl.getInvsetMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setInvsetUpdataDefault(InvInvset invInvset) {
        if (null == invInvset) {
            return;
        }
        invInvset.setGmtModified(this.getSysDate());
    }

    private void saveInvsetModel(InvInvset invInvset) throws ApiException {
        if (null == invInvset) {
            return;
        }
        try {
            this.invInvsetMapper.insert(invInvset);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvsetServiceImpl.saveInvsetModel.ex", (Throwable)e);
        }
    }

    private void saveInvsetBatchModel(List<InvInvset> invInvsetList) throws ApiException {
        if (null == invInvsetList || invInvsetList.isEmpty()) {
            return;
        }
        try {
            this.invInvsetMapper.insertBatch(invInvsetList);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvsetServiceImpl.saveInvsetBatchModel.ex", (Throwable)e);
        }
    }

    private InvInvset getInvsetModelById(Integer invsetId) {
        if (null == invsetId) {
            return null;
        }
        try {
            return this.invInvsetMapper.selectByPrimaryKey(invsetId);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvsetServiceImpl.getInvsetModelById", (Throwable)e);
            return null;
        }
    }

    private InvInvset getInvsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.invInvsetMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvsetServiceImpl.getInvsetModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delInvsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvsetMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvsetServiceImpl.delInvsetModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvsetServiceImpl.delInvsetModelByCode.num");
        }
    }

    private void deleteInvsetModel(Integer invsetId) throws ApiException {
        if (null == invsetId) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvsetMapper.deleteByPrimaryKey(invsetId);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvsetServiceImpl.deleteInvsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvsetServiceImpl.deleteInvsetModel.num");
        }
    }

    private void updateInvsetModel(InvInvset invInvset) throws ApiException {
        if (null == invInvset) {
            return;
        }
        int i = 0;
        try {
            i = this.invInvsetMapper.updateByPrimaryKey(invInvset);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvsetServiceImpl.updateInvsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("inv.InvInvsetServiceImpl.updateInvsetModel.num");
        }
    }

    private void updateStateInvsetModel(Integer invsetId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == invsetId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invsetId", invsetId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvsetMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvsetServiceImpl.updateStateInvsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvsetServiceImpl.updateStateInvsetModel.null");
        }
    }

    private void updateStateInvsetModelByCode(String tenantCode, String invsetCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)invsetCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invsetCode", invsetCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.invInvsetMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("inv.InvInvsetServiceImpl.updateStateInvsetModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("inv.InvInvsetServiceImpl.updateStateInvsetModelByCode.null");
        }
    }

    private InvInvset makeInvset(InvInvsetDomain invInvsetDomain, InvInvset invInvset) {
        if (null == invInvsetDomain) {
            return null;
        }
        if (null == invInvset) {
            invInvset = new InvInvset();
        }
        try {
            BeanUtils.copyAllPropertys((Object)invInvset, (Object)invInvsetDomain);
            return invInvset;
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvsetServiceImpl.makeInvset", (Throwable)e);
            return null;
        }
    }

    private InvInvsetReDomain makeInvInvsetReDomain(InvInvset invInvset) {
        if (null == invInvset) {
            return null;
        }
        InvInvsetReDomain invInvsetReDomain = new InvInvsetReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)invInvsetReDomain, (Object)invInvset);
            return invInvsetReDomain;
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvsetServiceImpl.makeInvInvsetReDomain", (Throwable)e);
            return null;
        }
    }

    private List<InvInvset> queryInvsetModelPage(Map<String, Object> parammap) {
        try {
            return this.invInvsetMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvsetServiceImpl.queryInvsetModel", (Throwable)e);
            return null;
        }
    }

    private int countInvset(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.invInvsetMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("inv.InvInvsetServiceImpl.countInvset", (Throwable)e);
        }
        return i;
    }

    private InvInvset createInvInvset(InvInvsetDomain invInvsetDomain) {
        String msg = this.checkInvset(invInvsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvsetServiceImpl.saveInvset.checkInvset", msg);
        }
        InvInvset invInvset = this.makeInvset(invInvsetDomain, null);
        this.setInvsetDefault(invInvset);
        return invInvset;
    }

    @Override
    public String saveInvset(InvInvsetDomain invInvsetDomain) throws ApiException {
        InvInvset invInvset = this.createInvInvset(invInvsetDomain);
        this.saveInvsetModel(invInvset);
        return invInvset.getInvsetCode();
    }

    @Override
    public String saveInvsetBatch(List<InvInvsetDomain> invInvsetDomainList) throws ApiException {
        if (null == invInvsetDomainList || invInvsetDomainList.isEmpty()) {
            return null;
        }
        ArrayList<InvInvset> invInvsetList = new ArrayList<InvInvset>();
        String code = "";
        for (InvInvsetDomain invInvsetDomain : invInvsetDomainList) {
            InvInvset invInvset = this.createInvInvset(invInvsetDomain);
            code = invInvset.getInvsetCode();
            invInvsetList.add(invInvset);
        }
        this.saveInvsetBatchModel(invInvsetList);
        return code;
    }

    @Override
    public void updateInvsetState(Integer invsetId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvsetModel(invsetId, dataState, oldDataState, map);
    }

    @Override
    public void updateInvsetStateByCode(String tenantCode, String invsetCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateInvsetModelByCode(tenantCode, invsetCode, dataState, oldDataState, map);
    }

    @Override
    public void updateInvset(InvInvsetDomain invInvsetDomain) throws ApiException {
        String msg = this.checkInvset(invInvsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("inv.InvInvsetServiceImpl.updateInvset.checkInvset", msg);
        }
        InvInvset oldInvInvset = this.getInvsetModelById(invInvsetDomain.getInvsetId());
        if (null == oldInvInvset) {
            throw new ApiException("inv.InvInvsetServiceImpl.updateInvset.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        InvInvset invInvset = this.makeInvset(invInvsetDomain, oldInvInvset);
        this.setInvsetUpdataDefault(invInvset);
        this.updateInvsetModel(invInvset);
    }

    @Override
    public InvInvset getInvset(Integer invsetId) {
        return this.getInvsetModelById(invsetId);
    }

    @Override
    public void deleteInvset(Integer invsetId) throws ApiException {
        this.deleteInvsetModel(invsetId);
    }

    @Override
    public QueryResult<InvInvset> queryInvsetPage(Map<String, Object> map) {
        List<InvInvset> invInvsetList = this.queryInvsetModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInvset(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(invInvsetList);
        return queryResult;
    }

    @Override
    public InvInvset getInvsetByCode(String tenantCode, String invsetCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invsetCode", invsetCode);
        return this.getInvsetModelByCode(map);
    }

    @Override
    public void deleteInvsetByCode(String tenantCode, String invsetCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("invsetCode", invsetCode);
        this.delInvsetModelByCode(map);
    }
}

