/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.LogisticsConstants;
import com.yqbsoft.laser.service.logistics.dao.WlFreightExpMapper;
import com.yqbsoft.laser.service.logistics.dao.WlFreightExpallMapper;
import com.yqbsoft.laser.service.logistics.dao.WlFreightTemMapper;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpReDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpallDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpdisDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExpgoodsDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightExptagDomain;
import com.yqbsoft.laser.service.logistics.domain.WlFreightTemDomain;
import com.yqbsoft.laser.service.logistics.model.WlFreightExp;
import com.yqbsoft.laser.service.logistics.model.WlFreightExpall;
import com.yqbsoft.laser.service.logistics.model.WlFreightExpdis;
import com.yqbsoft.laser.service.logistics.model.WlFreightExpgoods;
import com.yqbsoft.laser.service.logistics.model.WlFreightExptag;
import com.yqbsoft.laser.service.logistics.model.WlFreightTem;
import com.yqbsoft.laser.service.logistics.service.WlFreightExpdisService;
import com.yqbsoft.laser.service.logistics.service.WlFreightExpgoodsService;
import com.yqbsoft.laser.service.logistics.service.WlFreightExptagService;
import com.yqbsoft.laser.service.logistics.service.WlFreightTemService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.EmptyUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WlFreightTemServiceImpl
extends BaseServiceImpl
implements WlFreightTemService {
    private static final String SYS_CODE = "wl.LOGISTICS.WlFreightTemServiceImpl";
    private WlFreightTemMapper wlFreightTemMapper;
    private WlFreightExpMapper wlFreightExpMapper;
    private WlFreightExpallMapper wlFreightExpallMapper;
    WlFreightExptagService wlFreightExptagService;
    WlFreightExpgoodsService wlFreightExpgoodsService;
    WlFreightExpdisService wlFreightExpdisService;
    private static double EARTH_RADIUS = 6378.137;

    public void setWlFreightExptagService(WlFreightExptagService wlFreightExptagService) {
        this.wlFreightExptagService = wlFreightExptagService;
    }

    public void setWlFreightExpgoodsService(WlFreightExpgoodsService wlFreightExpgoodsService) {
        this.wlFreightExpgoodsService = wlFreightExpgoodsService;
    }

    public void setWlFreightExpdisService(WlFreightExpdisService wlFreightExpdisService) {
        this.wlFreightExpdisService = wlFreightExpdisService;
    }

    public void setWlFreightTemMapper(WlFreightTemMapper wlFreightTemMapper) {
        this.wlFreightTemMapper = wlFreightTemMapper;
    }

    public void setWlFreightExpMapper(WlFreightExpMapper wlFreightExpMapper) {
        this.wlFreightExpMapper = wlFreightExpMapper;
    }

    public void setWlFreightExpallMapper(WlFreightExpallMapper wlFreightExpallMapper) {
        this.wlFreightExpallMapper = wlFreightExpallMapper;
    }

    private Date getSysDate() {
        try {
            return this.wlFreightTemMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFreightTem(WlFreightTemDomain wlFreightTemDomain) {
        if (null == wlFreightTemDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFreightTemDefault(WlFreightTem wlFreightTem) {
        if (null == wlFreightTem) {
            return;
        }
        if (null == wlFreightTem.getDataState()) {
            wlFreightTem.setDataState(0);
        }
        if (null == wlFreightTem.getGmtCreate()) {
            wlFreightTem.setGmtCreate(this.getSysDate());
        }
        wlFreightTem.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlFreightTem.getFreightTemCode())) {
            wlFreightTem.setFreightTemCode(this.createUUIDString());
        }
    }

    private int getFreightTemMaxCode() {
        int code = 0;
        try {
            return this.wlFreightTemMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightTemMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightTemUpdataDefault(WlFreightTem wlFreightTem) {
        if (null == wlFreightTem) {
            return;
        }
        wlFreightTem.setGmtModified(this.getSysDate());
    }

    private void saveFreightTemModel(WlFreightTem wlFreightTem) throws ApiException {
        if (null == wlFreightTem) {
            return;
        }
        try {
            this.wlFreightTemMapper.insert(wlFreightTem);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightTemModel.ex", (Throwable)e);
        }
    }

    private WlFreightTem getFreightTemModelById(Integer freightTemId) {
        if (null == freightTemId) {
            return null;
        }
        try {
            return this.wlFreightTemMapper.selectByPrimaryKey(freightTemId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightTemModelById", (Throwable)e);
            return null;
        }
    }

    public WlFreightTem getFreightTemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightTemMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightTemModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFreightTemModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightTemMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightTemModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightTemModelByCode.num");
        }
    }

    private void deleteFreightTemModel(Integer freightTemId) throws ApiException {
        if (null == freightTemId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightTemMapper.deleteByPrimaryKey(freightTemId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightTemModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightTemModel.num");
        }
    }

    private void updateFreightTemModel(WlFreightTem wlFreightTem) throws ApiException {
        if (null == wlFreightTem) {
            return;
        }
        try {
            this.wlFreightTemMapper.updateByPrimaryKeySelective(wlFreightTem);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightTemModel.ex", (Throwable)e);
        }
    }

    private void updateStateFreightTemModel(Integer freightTemId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == freightTemId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightTemId", freightTemId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlFreightTemMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightTemModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightTemModel.null");
        }
    }

    private WlFreightTem makeFreightTem(WlFreightTemDomain wlFreightTemDomain, WlFreightTem wlFreightTem) {
        if (null == wlFreightTemDomain) {
            return null;
        }
        if (null == wlFreightTem) {
            wlFreightTem = new WlFreightTem();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightTem, (Object)wlFreightTemDomain);
            return wlFreightTem;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.makeFreightTem", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightTem> queryFreightTemModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightTemMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightTemModel", (Throwable)e);
            return null;
        }
    }

    private int countFreightTem(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightTemMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.countFreightTem", (Throwable)e);
        }
        return i;
    }

    private String checkFreightExp(WlFreightExpDomain wlFreightExpDomain) {
        if (null == wlFreightExpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlFreightExpDomain.getMemberCode())) {
            msg = msg + "memberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wlFreightExpDomain.getMemberName())) {
            msg = msg + "memberName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wlFreightExpDomain.getFreightExpPayer())) {
            msg = msg + "freightExpPayer\u4e3a\u7a7a;";
        } else if ("member".equals(wlFreightExpDomain.getFreightExpPayer())) {
            if (StringUtils.isBlank((String)wlFreightExpDomain.getExpressCode())) {
                msg = msg + "expressCode\u4e3a\u7a7a;";
            }
            if (StringUtils.isBlank((String)wlFreightExpDomain.getFreightExpValuation())) {
                msg = msg + "freightExpValuation\u4e3a\u7a7a;";
            }
        }
        if (StringUtils.isBlank((String)wlFreightExpDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFreightExpDefault(WlFreightExp wlFreightExp) {
        if (null == wlFreightExp) {
            return;
        }
        if (null == wlFreightExp.getDataState()) {
            wlFreightExp.setDataState(0);
        }
        if (null == wlFreightExp.getGmtCreate()) {
            wlFreightExp.setGmtCreate(this.getSysDate());
        }
        wlFreightExp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlFreightExp.getFreightExpCode())) {
            wlFreightExp.setFreightExpCode(this.createUUIDString());
        }
    }

    private int getFreightExpMaxCode() {
        int code = 0;
        try {
            return this.wlFreightExpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightExpUpdataDefault(WlFreightExp wlFreightExp) {
        if (null == wlFreightExp) {
            return;
        }
        wlFreightExp.setGmtModified(this.getSysDate());
    }

    private void saveFreightExpModel(WlFreightExp wlFreightExp) throws ApiException {
        if (null == wlFreightExp) {
            return;
        }
        try {
            this.wlFreightExpMapper.insert(wlFreightExp);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightExpModel.ex", (Throwable)e);
        }
    }

    private WlFreightExp getFreightExpModelById(Integer freightExpId) {
        if (null == freightExpId) {
            return null;
        }
        try {
            return this.wlFreightExpMapper.selectByPrimaryKey(freightExpId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpModelById", (Throwable)e);
            return null;
        }
    }

    private WlFreightExp getFreightExpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightExpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFreightExpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightExpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightExpModelByCode.num");
        }
    }

    private void deleteFreightExpModel(Integer freightExpId) throws ApiException {
        if (null == freightExpId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpMapper.deleteByPrimaryKey(freightExpId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightExpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightExpModel.num");
        }
    }

    private void updateFreightExpModel(WlFreightExp wlFreightExp) throws ApiException {
        if (null == wlFreightExp) {
            return;
        }
        try {
            this.wlFreightExpMapper.updateByPrimaryKeySelective(wlFreightExp);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExpModel.ex", (Throwable)e);
        }
    }

    private void updateStateFreightExpModel(Integer freightExpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == freightExpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightExpId", freightExpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlFreightExpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightExpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightExpModel.null");
        }
    }

    private WlFreightExp makeFreightExp(WlFreightExpDomain wlFreightExpDomain, WlFreightExp wlFreightExp) {
        if (null == wlFreightExpDomain) {
            return null;
        }
        if (null == wlFreightExp) {
            wlFreightExp = new WlFreightExp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExp, (Object)wlFreightExpDomain);
            return wlFreightExp;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.makeFreightExp", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExp> queryFreightExpModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightExpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpModel", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExpReDomain> queryFreightExpReDomainList(Map<String, Object> parammap) {
        List<WlFreightExp> freightExpallList = this.queryFreightExpModelPage(parammap);
        ArrayList<WlFreightExpReDomain> freightExpReDomainList = new ArrayList<WlFreightExpReDomain>();
        if (ListUtil.isEmpty(freightExpallList)) {
            return freightExpReDomainList;
        }
        for (WlFreightExp wlFreightExp : freightExpallList) {
            WlFreightExpReDomain freightExpReDomain = new WlFreightExpReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)freightExpReDomain, (Object)wlFreightExp);
                freightExpReDomain.setFreightExpallList(this.queryFreightExpallListByExpCode(wlFreightExp.getFreightExpCode(), wlFreightExp.getTenantCode()));
                freightExpReDomain.setWlFreightExpdisDomainList(this.queryFreightExpdisListByExpCode(wlFreightExp.getFreightExpCode(), wlFreightExp.getTenantCode()));
                freightExpReDomainList.add(freightExpReDomain);
            }
            catch (Exception e) {
                this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpReDomainList.ex", (Throwable)e);
                return null;
            }
        }
        return freightExpReDomainList;
    }

    private int countFreightExp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightExpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.countFreightExp", (Throwable)e);
        }
        return i;
    }

    private String checkFreightExpall(WlFreightExpallDomain wlFreightExpallDomain) {
        if (null == wlFreightExpallDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wlFreightExpallDomain.getFreightExpCode())) {
            msg = msg + "freightExpCode\u4e3a\u7a7a;";
        }
        if (wlFreightExpallDomain.getFreightExpallPostage() == null) {
            msg = msg + "freightExpallPostage\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wlFreightExpallDomain.getFreightExpallPlus())) {
            msg = msg + "freightExpallPlus\u4e3a\u7a7a;";
        }
        if (wlFreightExpallDomain.getFreightExpallPostageplus() == null) {
            msg = msg + "freightExpallPostageplus\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wlFreightExpallDomain.getTenantCode())) {
            msg = msg + "tenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setFreightExpallDefault(WlFreightExpall wlFreightExpall) {
        if (null == wlFreightExpall) {
            return;
        }
        if (null == wlFreightExpall.getDataState()) {
            wlFreightExpall.setDataState(0);
        }
        if (null == wlFreightExpall.getGmtCreate()) {
            wlFreightExpall.setGmtCreate(this.getSysDate());
        }
        wlFreightExpall.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wlFreightExpall.getFreightExpallCode())) {
            wlFreightExpall.setFreightExpallCode(this.createUUIDString());
        }
    }

    private List<WlFreightExpallDomain> queryFreightExpallListByExpCode(String freightExpCode, String tenantCode) {
        if (StringUtils.isBlank((String)freightExpCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("freightExpCode", freightExpCode);
        parammap.put("order", true);
        parammap.put("tenantCode", tenantCode);
        parammap.put("orderStr", "FREIGHT_EXPALL_DEFAULT");
        List<WlFreightExpall> freightExpallList = this.queryFreightExpallModelPage(parammap);
        ArrayList<WlFreightExpallDomain> expallDomainList = new ArrayList<WlFreightExpallDomain>();
        if (ListUtil.isEmpty(freightExpallList)) {
            return expallDomainList;
        }
        try {
            for (WlFreightExpall wlFreightExpall : freightExpallList) {
                WlFreightExpallDomain expallDomain = new WlFreightExpallDomain();
                BeanUtils.copyAllPropertys((Object)expallDomain, (Object)wlFreightExpall);
                expallDomainList.add(expallDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpallListByExpCode.ex", (Throwable)e);
            return null;
        }
        return expallDomainList;
    }

    private List<WlFreightExpgoodsDomain> queryFreightExpgoodsListByExpCode(String freightExpCode, String tenantCode) {
        if (StringUtils.isBlank((String)freightExpCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("freightExpCode", freightExpCode);
        parammap.put("tenantCode", tenantCode);
        QueryResult<WlFreightExpgoods> qlist = this.wlFreightExpgoodsService.queryFreightExpgoodsPage(parammap);
        ArrayList<WlFreightExpgoodsDomain> expallDomainList = new ArrayList<WlFreightExpgoodsDomain>();
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return expallDomainList;
        }
        try {
            for (WlFreightExpgoods wlFreightExpgoods : qlist.getList()) {
                WlFreightExpgoodsDomain expallDomain = new WlFreightExpgoodsDomain();
                BeanUtils.copyAllPropertys((Object)expallDomain, (Object)wlFreightExpgoods);
                expallDomainList.add(expallDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpgoodsListByExpCode.ex", (Throwable)e);
            return null;
        }
        return expallDomainList;
    }

    private List<WlFreightExptagDomain> queryFreightExptagListByExpCode(String freightExpCode, String tenantCode) {
        if (StringUtils.isBlank((String)freightExpCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("freightExpCode", freightExpCode);
        parammap.put("tenantCode", tenantCode);
        QueryResult<WlFreightExptag> qlist = this.wlFreightExptagService.queryFreightExptagPage(parammap);
        ArrayList<WlFreightExptagDomain> expallDomainList = new ArrayList<WlFreightExptagDomain>();
        if (EmptyUtil.isEmpty(qlist) || ListUtil.isEmpty((Collection)qlist.getList())) {
            return expallDomainList;
        }
        try {
            for (WlFreightExptag wlFreightExptag : qlist.getList()) {
                WlFreightExptagDomain expallDomain = new WlFreightExptagDomain();
                BeanUtils.copyAllPropertys((Object)expallDomain, (Object)wlFreightExptag);
                expallDomainList.add(expallDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExptagListByExpCode.ex", (Throwable)e);
            return null;
        }
        return expallDomainList;
    }

    private List<WlFreightExptagDomain> makeTag(WlFreightExpReDomain wlFreightExpReDomain, Map<String, Object> objmap) {
        HashMap<String, Object> tagMap = new HashMap<String, Object>();
        tagMap.put("tenantCode", wlFreightExpReDomain.getTenantCode());
        tagMap.put("appmanageIcode", LogisticsConstants.APPMANAGEICODE);
        tagMap.put("dataState", 0);
        QueryResult<WlFreightExptag> qlist = this.wlFreightExptagService.queryFreightExptagPage(tagMap);
        this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExptagListByExpCode.ex2", (Object)JsonUtil.buildNonDefaultBinder().toJson(qlist));
        ArrayList<WlFreightExptagDomain> expallDomainList = new ArrayList<WlFreightExptagDomain>();
        if (EmptyUtil.isEmpty(qlist) || ListUtil.isEmpty((Collection)qlist.getList())) {
            return expallDomainList;
        }
        try {
            for (WlFreightExptag wlFreightExptag : qlist.getList()) {
                WlFreightExptagDomain expallDomain = new WlFreightExptagDomain();
                BeanUtils.copyAllPropertys((Object)expallDomain, (Object)wlFreightExptag);
                expallDomainList.add(expallDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExptagListByExpCode.ex", (Throwable)e);
            return null;
        }
        return expallDomainList;
    }

    private List<WlFreightExpdisDomain> queryFreightExpdisListByExpCode(String freightExpCode, String tenantCode) {
        if (StringUtils.isBlank((String)freightExpCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("freightExpCode", freightExpCode);
        parammap.put("tenantCode", tenantCode);
        QueryResult<WlFreightExpdis> qlist = this.wlFreightExpdisService.queryFreightExpdisPage(parammap);
        ArrayList<WlFreightExpdisDomain> expallDomainList = new ArrayList<WlFreightExpdisDomain>();
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return expallDomainList;
        }
        try {
            for (WlFreightExpdis wlFreightExpdis : qlist.getList()) {
                WlFreightExpdisDomain expallDomain = new WlFreightExpdisDomain();
                BeanUtils.copyAllPropertys((Object)expallDomain, (Object)wlFreightExpdis);
                expallDomainList.add(expallDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpdisListByExpCode.ex", (Throwable)e);
            return null;
        }
        return expallDomainList;
    }

    private List<WlFreightExpReDomain> getFreightExpModelByMemberCode(String memberCode, String tenantCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memberCode", memberCode);
        params.put("tenantCode", tenantCode);
        ArrayList<WlFreightExpReDomain> freightExpReDomainList = new ArrayList<WlFreightExpReDomain>();
        List<WlFreightExp> freightExpList = this.queryFreightExpModelPage(params);
        if (ListUtil.isEmpty(freightExpList)) {
            return freightExpReDomainList;
        }
        try {
            for (WlFreightExp wlFreightExp : freightExpList) {
                WlFreightExpReDomain freightExpReDomain = new WlFreightExpReDomain();
                BeanUtils.copyAllPropertys((Object)freightExpReDomain, (Object)wlFreightExp);
                freightExpReDomain.setFreightExpallList(this.queryFreightExpallListByExpCode(wlFreightExp.getFreightExpCode(), wlFreightExp.getTenantCode()));
                freightExpReDomainList.add(freightExpReDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightModelByMemberCode.ex", (Throwable)e);
            return null;
        }
        return freightExpReDomainList;
    }

    private int getFreightExpallMaxCode() {
        int code = 0;
        try {
            return this.wlFreightExpallMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpallMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFreightExpallUpdataDefault(WlFreightExpall wlFreightExpall) {
        if (null == wlFreightExpall) {
            return;
        }
        wlFreightExpall.setGmtModified(this.getSysDate());
    }

    private void saveFreightExpallModel(WlFreightExpall wlFreightExpall) throws ApiException {
        if (null == wlFreightExpall) {
            return;
        }
        try {
            this.wlFreightExpallMapper.insert(wlFreightExpall);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightExpallModel.ex", (Throwable)e);
        }
    }

    private WlFreightExpall getFreightExpallModelById(Integer freightExpallId) {
        if (null == freightExpallId) {
            return null;
        }
        try {
            return this.wlFreightExpallMapper.selectByPrimaryKey(freightExpallId);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpallModelById", (Throwable)e);
            return null;
        }
    }

    public WlFreightExpall getFreightExpallModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wlFreightExpallMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightExpallModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFreightExpallModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpallMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightExpallModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.delFreightExpallModelByCode.num");
        }
    }

    private void deleteFreightExpallModel(Integer freightExpallId) throws ApiException {
        if (null == freightExpallId) {
            return;
        }
        int i = 0;
        try {
            i = this.wlFreightExpallMapper.deleteByPrimaryKey(freightExpallId);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightExpallModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.deleteFreightExpallModel.num");
        }
    }

    private void updateFreightExpallModel(WlFreightExpall wlFreightExpall) throws ApiException {
        if (null == wlFreightExpall) {
            return;
        }
        try {
            this.wlFreightExpallMapper.updateByPrimaryKeySelective(wlFreightExpall);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExpallModel.ex", (Throwable)e);
        }
    }

    private void updateStateFreightExpallModel(Integer freightExpallId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == freightExpallId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("freightExpallId", freightExpallId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wlFreightExpallMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightExpallModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateStateFreightExpallModel.null");
        }
    }

    private WlFreightExpall makeFreightExpall(WlFreightExpallDomain wlFreightExpallDomain, WlFreightExpall wlFreightExpall) {
        if (null == wlFreightExpallDomain) {
            return null;
        }
        if (null == wlFreightExpall) {
            wlFreightExpall = new WlFreightExpall();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExpall, (Object)wlFreightExpallDomain);
            return wlFreightExpall;
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.makeFreightExpall", (Throwable)e);
            return null;
        }
    }

    private List<WlFreightExpall> queryFreightExpallModelPage(Map<String, Object> parammap) {
        try {
            return this.wlFreightExpallMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryFreightExpallModel", (Throwable)e);
            return null;
        }
    }

    private int countFreightExpall(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wlFreightExpallMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.countFreightExpall", (Throwable)e);
        }
        return i;
    }

    private void saveFreightExpallBarthModel(List<WlFreightExpallDomain> freightExpallDomainList, WlFreightExp freightExp) {
        if (freightExpallDomainList == null || freightExpallDomainList.isEmpty()) {
            return;
        }
        if (freightExp == null || "shop".equals(freightExp.getFreightExpPayer())) {
            return;
        }
        for (WlFreightExpallDomain wlFreightExpallDomain : freightExpallDomainList) {
            wlFreightExpallDomain.setFreightExpCode(freightExp.getFreightExpCode());
            wlFreightExpallDomain.setAppmanageIcode(freightExp.getAppmanageIcode());
            wlFreightExpallDomain.setTenantCode(freightExp.getTenantCode());
            this.saveFreightExpall(wlFreightExpallDomain);
        }
    }

    @Override
    public String saveFreightTem(WlFreightTemDomain wlFreightTemDomain) throws ApiException {
        String msg = this.checkFreightTem(wlFreightTemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightTem.checkFreightTem", msg);
        }
        WlFreightTem wlFreightTem = this.makeFreightTem(wlFreightTemDomain, null);
        this.setFreightTemDefault(wlFreightTem);
        this.saveFreightTemModel(wlFreightTem);
        return wlFreightTem.getFreightTemCode();
    }

    @Override
    public void updateFreightTemState(Integer freightTemId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFreightTemModel(freightTemId, dataState, oldDataState);
    }

    @Override
    public void updateFreightTem(WlFreightTemDomain wlFreightTemDomain) throws ApiException {
        String msg = this.checkFreightTem(wlFreightTemDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightTem.checkFreightTem", msg);
        }
        WlFreightTem oldWlFreightTem = this.getFreightTemModelById(wlFreightTemDomain.getFreightTemId());
        if (null == oldWlFreightTem) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightTem.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightTem wlFreightTem = this.makeFreightTem(wlFreightTemDomain, oldWlFreightTem);
        this.setFreightTemUpdataDefault(wlFreightTem);
        this.updateFreightTemModel(wlFreightTem);
    }

    @Override
    public WlFreightTem getFreightTem(Integer freightTemId) {
        return this.getFreightTemModelById(freightTemId);
    }

    @Override
    public void deleteFreightTem(Integer freightTemId) throws ApiException {
        this.deleteFreightTemModel(freightTemId);
    }

    @Override
    public QueryResult<WlFreightTem> queryFreightTemPage(Map<String, Object> map) {
        List<WlFreightTem> wlFreightTemList = this.queryFreightTemModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightTem(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightTemList);
        return queryResult;
    }

    @Override
    public WlFreightTem getFreightTemByCode(Map<String, Object> map) {
        return this.getFreightTemModelByCode(map);
    }

    @Override
    public void delFreightTemByCode(Map<String, Object> map) throws ApiException {
        this.delFreightTemModelByCode(map);
    }

    private void saveFreightExpgoodsBarth(List<WlFreightExpgoodsDomain> freightExpgoodsDomainList, WlFreightExp freightExp) {
        if (freightExpgoodsDomainList == null || freightExpgoodsDomainList.isEmpty()) {
            return;
        }
        for (WlFreightExpgoodsDomain wlFreightExpgoodsDomain : freightExpgoodsDomainList) {
            wlFreightExpgoodsDomain.setFreightExpCode(freightExp.getFreightExpCode());
            wlFreightExpgoodsDomain.setAppmanageIcode(freightExp.getAppmanageIcode());
            wlFreightExpgoodsDomain.setTenantCode(freightExp.getTenantCode());
            this.wlFreightExpgoodsService.saveFreightExpgoods(wlFreightExpgoodsDomain);
        }
    }

    private void saveFreightExptagBarth(List<WlFreightExptagDomain> freightExptagDomainList, WlFreightExp freightExp) {
        if (freightExptagDomainList == null || freightExptagDomainList.isEmpty()) {
            return;
        }
        for (WlFreightExptagDomain wlFreightExptagDomain : freightExptagDomainList) {
            wlFreightExptagDomain.setFreightExpCode(freightExp.getFreightExpCode());
            wlFreightExptagDomain.setAppmanageIcode(freightExp.getAppmanageIcode());
            wlFreightExptagDomain.setTenantCode(freightExp.getTenantCode());
            this.wlFreightExptagService.saveFreightExptag(wlFreightExptagDomain);
        }
    }

    private void saveFreightExpdisBarth(List<WlFreightExpdisDomain> freightExpdisDomainList, WlFreightExp freightExp) {
        if (freightExpdisDomainList == null || freightExpdisDomainList.isEmpty()) {
            return;
        }
        for (WlFreightExpdisDomain wlFreightExpdisDomain : freightExpdisDomainList) {
            wlFreightExpdisDomain.setFreightExpCode(freightExp.getFreightExpCode());
            wlFreightExpdisDomain.setAppmanageIcode(freightExp.getAppmanageIcode());
            wlFreightExpdisDomain.setTenantCode(freightExp.getTenantCode());
            this.wlFreightExpdisService.saveFreightExpdis(wlFreightExpdisDomain);
        }
    }

    @Override
    public String saveFreightExp(WlFreightExpDomain wlFreightExpDomain) throws ApiException {
        this.logger.error("wl.LOGISTICS.WlFreightTemServiceImplsaveFreightExp", (Object)JsonUtil.buildNormalBinder().toJson((Object)wlFreightExpDomain));
        String msg = this.checkFreightExp(wlFreightExpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightExp.checkFreightExp", msg);
        }
        WlFreightExp wlFreightExp = this.makeFreightExp(wlFreightExpDomain, null);
        this.setFreightExpDefault(wlFreightExp);
        this.saveFreightExpModel(wlFreightExp);
        this.saveFreightExpallBarthModel(wlFreightExpDomain.getFreightExpallList(), wlFreightExp);
        this.saveFreightExpgoodsBarth(wlFreightExpDomain.getWlFreightExpgoodsDomainList(), wlFreightExp);
        this.saveFreightExptagBarth(wlFreightExpDomain.getWlFreightExptagDomainList(), wlFreightExp);
        this.saveFreightExpdisBarth(wlFreightExpDomain.getWlFreightExpdisDomainList(), wlFreightExp);
        return wlFreightExp.getFreightExpCode();
    }

    @Override
    public void updateFreightExpState(Integer freightExpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFreightExpModel(freightExpId, dataState, oldDataState);
    }

    @Override
    public void updateFreightExp(WlFreightExpDomain wlFreightExpDomain) throws ApiException {
        String msg = this.checkFreightExp(wlFreightExpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExp.checkFreightExp", msg);
        }
        WlFreightExp oldWlFreightExp = this.getFreightExpModelById(wlFreightExpDomain.getFreightExpId());
        if (null == oldWlFreightExp) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightExp wlFreightExp = this.makeFreightExp(wlFreightExpDomain, oldWlFreightExp);
        this.setFreightExpUpdataDefault(wlFreightExp);
        this.updateFreightExpModel(wlFreightExp);
    }

    @Override
    public void updateAllFreightExp(WlFreightExpDomain wlFreightExpDomain) throws ApiException {
        String msg = this.checkFreightExp(wlFreightExpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExp.checkFreightExp", msg);
        }
        WlFreightExp oldWlFreightExp = this.getFreightExpModelById(wlFreightExpDomain.getFreightExpId());
        if (null == oldWlFreightExp) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightExp wlFreightExp = this.makeFreightExp(wlFreightExpDomain, oldWlFreightExp);
        this.setFreightExpUpdataDefault(wlFreightExp);
        this.updateFreightExpModel(wlFreightExp);
        if (ListUtil.isNotEmpty(wlFreightExpDomain.getWlFreightExpgoodsDomainList())) {
            for (WlFreightExpgoodsDomain wlFreightExpgoodsDomain : wlFreightExpDomain.getWlFreightExpgoodsDomainList()) {
                this.wlFreightExpgoodsService.updateFreightExpgoods(wlFreightExpgoodsDomain);
            }
        }
        if (ListUtil.isNotEmpty(wlFreightExpDomain.getWlFreightExptagDomainList())) {
            for (WlFreightExptagDomain wlFreightExptagDomain : wlFreightExpDomain.getWlFreightExptagDomainList()) {
                this.wlFreightExptagService.updateFreightExptag(wlFreightExptagDomain);
            }
        }
        this.wlFreightExpdisService.deleteFreightExpByCode(wlFreightExp.getTenantCode(), wlFreightExpDomain.getFreightExpCode());
        if (ListUtil.isNotEmpty(wlFreightExpDomain.getWlFreightExpdisDomainList())) {
            for (WlFreightExpdisDomain wlFreightExpdisDomain : wlFreightExpDomain.getWlFreightExpdisDomainList()) {
                wlFreightExpdisDomain.setFreightExpCode(wlFreightExpDomain.getFreightExpCode());
                wlFreightExpdisDomain.setTenantCode(wlFreightExpDomain.getTenantCode());
                this.wlFreightExpdisService.saveFreightExpdis(wlFreightExpdisDomain);
            }
        }
    }

    @Override
    public WlFreightExpReDomain getFreightExp(Integer freightExpId) {
        return this.makeFreightExpReDomain(this.getFreightExpModelById(freightExpId));
    }

    @Override
    public void deleteFreightExp(Integer freightExpId) throws ApiException {
        this.deleteFreightExpModel(freightExpId);
    }

    @Override
    public QueryResult<WlFreightExpReDomain> queryFreightExpPage(Map<String, Object> map) {
        int count = this.countFreightExp(map);
        List<WlFreightExpReDomain> wlFreightExpList = count > 0 ? this.queryFreightExpReDomainList(map) : new ArrayList<WlFreightExpReDomain>();
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightExp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightExpList);
        return queryResult;
    }

    private WlFreightExpReDomain makeFreightExpReDomain(WlFreightExp wlFreightExp) {
        if (wlFreightExp == null) {
            return null;
        }
        WlFreightExpReDomain wlFreightExpReDomain = new WlFreightExpReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)wlFreightExpReDomain, (Object)wlFreightExp);
        }
        catch (Exception e) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.makeFreightExpReDomain.ex", (Throwable)e);
            return null;
        }
        wlFreightExpReDomain.setFreightExpallList(this.queryFreightExpallListByExpCode(wlFreightExp.getFreightExpCode(), wlFreightExp.getTenantCode()));
        wlFreightExpReDomain.setWlFreightExptagDomainList(this.queryFreightExptagListByExpCode(wlFreightExp.getFreightExpCode(), wlFreightExp.getTenantCode()));
        wlFreightExpReDomain.setWlFreightExpdisDomainList(this.queryFreightExpdisListByExpCode(wlFreightExp.getFreightExpCode(), wlFreightExp.getTenantCode()));
        wlFreightExpReDomain.setWlFreightExpgoodsDomainList(this.queryFreightExpgoodsListByExpCode(wlFreightExp.getFreightExpCode(), wlFreightExp.getTenantCode()));
        return wlFreightExpReDomain;
    }

    @Override
    public WlFreightExpReDomain getFreightExpByCode(Map<String, Object> map) {
        return this.makeFreightExpReDomain(this.getFreightExpModelByCode(map));
    }

    @Override
    public void delFreightExpByCode(Map<String, Object> map) throws ApiException {
        this.delFreightExpModelByCode(map);
    }

    @Override
    public List<WlFreightExpReDomain> getFreightExpByMemberCode(String memberCode, String tenantCode) {
        return this.getFreightExpModelByMemberCode(memberCode, tenantCode);
    }

    @Override
    public String saveFreightExpall(WlFreightExpallDomain wlFreightExpallDomain) throws ApiException {
        String msg = this.checkFreightExpall(wlFreightExpallDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.saveFreightExpall.checkFreightExpall", msg);
        }
        WlFreightExpall wlFreightExpall = this.makeFreightExpall(wlFreightExpallDomain, null);
        this.setFreightExpallDefault(wlFreightExpall);
        this.saveFreightExpallModel(wlFreightExpall);
        return wlFreightExpall.getFreightExpallCode();
    }

    @Override
    public void updateFreightExpallState(Integer freightExpallId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFreightExpallModel(freightExpallId, dataState, oldDataState);
    }

    @Override
    public void updateFreightExpall(WlFreightExpallDomain wlFreightExpallDomain) throws ApiException {
        String msg = this.checkFreightExpall(wlFreightExpallDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExpall.checkFreightExpall", msg);
        }
        WlFreightExpall oldWlFreightExpall = this.getFreightExpallModelById(wlFreightExpallDomain.getFreightExpallId());
        if (null == oldWlFreightExpall) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.updateFreightExpall.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WlFreightExpall wlFreightExpall = this.makeFreightExpall(wlFreightExpallDomain, oldWlFreightExpall);
        this.setFreightExpallUpdataDefault(wlFreightExpall);
        this.updateFreightExpallModel(wlFreightExpall);
    }

    @Override
    public WlFreightExpall getFreightExpall(Integer freightExpallId) {
        return this.getFreightExpallModelById(freightExpallId);
    }

    @Override
    public void deleteFreightExpall(Integer freightExpallId) throws ApiException {
        this.deleteFreightExpallModel(freightExpallId);
    }

    @Override
    public QueryResult<WlFreightExpall> queryFreightExpallPage(Map<String, Object> map) {
        List<WlFreightExpall> wlFreightExpallList = this.queryFreightExpallModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFreightExpall(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wlFreightExpallList);
        return queryResult;
    }

    @Override
    public WlFreightExpall getFreightExpallByCode(Map<String, Object> map) {
        return this.getFreightExpallModelByCode(map);
    }

    @Override
    public void delFreightExpallByCode(Map<String, Object> map) throws ApiException {
        this.delFreightExpallModelByCode(map);
    }

    private WlFreightExpReDomain checkFreightExp(String freightTemType, String freightExpCode, String tenantCode, List<Map<String, Object>> goodsBeanMap, Map<String, Object> map) {
        List<WlFreightExp> wlFreightExpList;
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.info("wl.LOGISTICS.WlFreightTemServiceImpl.checkFreightExp.tenantCode.null", (Object)"tenantCode is null");
            return null;
        }
        String orderFreight = WlFreightTemServiceImpl.getOrderFreight(tenantCode, "orderFreight", "orderFreight");
        if (StringUtils.isBlank((String)freightTemType)) {
            freightTemType = "0";
        }
        WlFreightExpReDomain wlFreightExpReDomain = null;
        if (StringUtils.isBlank((String)orderFreight)) {
            if (StringUtils.isNotBlank((String)freightExpCode)) {
                wlFreightExpReDomain = this.getFreightExpByCode(this.getQueryMapParam("freightExpCode,tenantCode", new Object[]{freightExpCode, tenantCode}));
            } else {
                wlFreightExpList = this.queryFreightExpModelPage(this.getQueryMapParam("freightTemType,tenantCode,dataState", new Object[]{freightTemType, tenantCode, LogisticsConstants.DATA_STATE}));
                if (ListUtil.isEmpty(wlFreightExpList)) {
                    return null;
                }
                wlFreightExpReDomain = this.checkFreightExp(wlFreightExpList, goodsBeanMap, map);
            }
        }
        if (StringUtils.isNotBlank((String)orderFreight) && orderFreight.equals("orderFreight")) {
            wlFreightExpList = this.queryFreightExpModelPage(this.getQueryMapParam("freightTemType,tenantCode,dataState", new Object[]{freightTemType, tenantCode, LogisticsConstants.DATA_STATE}));
            wlFreightExpReDomain = this.newCheckFreightExp(wlFreightExpList, goodsBeanMap, map);
        }
        return wlFreightExpReDomain;
    }

    private WlFreightExpReDomain checkFreightExpNew(String freightTemType, String freightExpCode, String tenantCode, List<Map<String, Object>> goodsBeanMap, Map<String, Object> map) {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.checkFreightExpNew.tenantCode.null", (Object)"tenantCode is null");
            return null;
        }
        if (StringUtils.isBlank((String)freightTemType)) {
            freightTemType = "0";
        }
        WlFreightExp wlFreightExpReDomain = null;
        List<WlFreightExp> wlFreightExpList = null;
        if (StringUtils.isNotBlank((String)freightExpCode)) {
            wlFreightExpReDomain = this.getFreightExpModelByCode(this.getQueryMapParam("freightExpCode,tenantCode", new Object[]{freightExpCode, tenantCode}));
            if (null == wlFreightExpReDomain) {
                wlFreightExpList = this.queryFreightExpModelPage(this.getQueryMapParam("freightTemType,tenantCode,dataState", new Object[]{freightTemType, tenantCode, LogisticsConstants.DATA_STATE}));
            } else {
                wlFreightExpList = new ArrayList<WlFreightExp>();
                wlFreightExpList.add(wlFreightExpReDomain);
            }
        } else {
            wlFreightExpList = this.queryFreightExpModelPage(this.getQueryMapParam("freightTemType,tenantCode,dataState", new Object[]{freightTemType, tenantCode, LogisticsConstants.DATA_STATE}));
        }
        return this.newCheckFreightExp(wlFreightExpList, goodsBeanMap, map);
    }

    private WlFreightExpReDomain checkFreightExpNew(List<WlFreightExp> wlFreightExpList, List<Map<String, Object>> goodsBeanMap, Map<String, Object> objmap) {
        if (ListUtil.isEmpty(wlFreightExpList)) {
            return null;
        }
        WlFreightExpReDomain wlFreightExpReDomain = null;
        WlFreightExpReDomain reWlFreightExpReDomain = null;
        WlFreightExpallDomain wlFreightExpallDomain = null;
        ArrayList wlFreightExpdisDo = new ArrayList();
        for (WlFreightExp wlFreightExp : wlFreightExpList) {
            wlFreightExpReDomain = this.makeFreightExpReDomain(wlFreightExp);
            if (LogisticsConstants.FREIGHT_TEM_TYPE_2.equals(wlFreightExp.getFreightTemType()) || LogisticsConstants.FREIGHT_TEM_TYPE_3.equals(wlFreightExp.getFreightTemType())) {
                wlFreightExpallDomain = this.checkPall(wlFreightExpReDomain.getFreightExpallList(), objmap);
                if (null == wlFreightExpallDomain) continue;
                wlFreightExpReDomain.setWlFreightExpdisDomainList(null);
                break;
            }
            if (LogisticsConstants.FREIGHT_TEM_TYPE_1.equals(wlFreightExp.getFreightTemType())) {
                List<WlFreightExptagDomain> exptagDomains = this.queryTagTime(wlFreightExpReDomain, objmap);
                wlFreightExpReDomain.setWlFreightExptagDomainList(exptagDomains);
                wlFreightExpReDomain.setWlFreightExpdisDomainList(null);
                wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpReDomain.getFreightExpallList().get(0));
                return wlFreightExpReDomain;
            }
            wlFreightExpallDomain = this.checkAll(wlFreightExpReDomain.getFreightExpallList(), objmap);
            if (null == wlFreightExpallDomain) continue;
            if (null != wlFreightExpallDomain && "100000".equals(wlFreightExpallDomain.getFreightExpallArea())) {
                wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpallDomain);
                wlFreightExpReDomain.setWlFreightExpdisDomainList(null);
                return wlFreightExpReDomain;
            }
            List<Object> wlFreightExptagList = new ArrayList();
            wlFreightExptagList = this.checktagList(wlFreightExpallDomain, wlFreightExpReDomain.getWlFreightExptagDomainList());
            if (ListUtil.isEmpty(wlFreightExptagList)) continue;
            wlFreightExpReDomain.setWlFreightExptagDomainList(wlFreightExptagList);
            if (this.checkTag(wlFreightExpReDomain.getWlFreightExptagDomainList(), objmap)) continue;
            wlFreightExpReDomain.setWlFreightExpdisDomainList(null);
            if (!this.checkGoods(wlFreightExpReDomain.getWlFreightExpgoodsDomainList(), goodsBeanMap)) {
                if (!ListUtil.isEmpty(wlFreightExpReDomain.getWlFreightExpgoodsDomainList())) continue;
                reWlFreightExpReDomain = wlFreightExpReDomain;
                continue;
            }
            wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpallDomain);
            return wlFreightExpReDomain;
        }
        wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpallDomain);
        return wlFreightExpReDomain;
    }

    private WlFreightExpReDomain checkFreightExp(List<WlFreightExp> wlFreightExpList, List<Map<String, Object>> goodsBeanMap, Map<String, Object> objmap) {
        if (ListUtil.isEmpty(wlFreightExpList)) {
            return null;
        }
        WlFreightExpReDomain wlFreightExpReDomain = null;
        WlFreightExpReDomain reWlFreightExpReDomain = null;
        WlFreightExpallDomain wlFreightExpallDomain = null;
        List<Object> wlFreightExpdisDo = new ArrayList();
        for (WlFreightExp wlFreightExp : wlFreightExpList) {
            wlFreightExpReDomain = this.makeFreightExpReDomain(wlFreightExp);
            wlFreightExpdisDo = !LogisticsConstants.FREIGHT_TEM_TYPE_0.equals(wlFreightExp.getFreightTemType()) ? wlFreightExpReDomain.getWlFreightExpdisDomainList() : this.checkExpdis(wlFreightExpReDomain.getWlFreightExpdisDomainList(), objmap);
            if (!this.checkDis(wlFreightExpdisDo, objmap)) {
                reWlFreightExpReDomain = new WlFreightExpReDomain();
                reWlFreightExpReDomain.setWlFreightExpdisDomainList(wlFreightExpdisDo);
                reWlFreightExpReDomain.setFreightExpRemark(wlFreightExp.getFreightExpRemark());
                return reWlFreightExpReDomain;
            }
            if (LogisticsConstants.FREIGHT_TEM_TYPE_2.equals(wlFreightExp.getFreightTemType()) || LogisticsConstants.FREIGHT_TEM_TYPE_3.equals(wlFreightExp.getFreightTemType())) {
                wlFreightExpallDomain = this.checkPall(wlFreightExpReDomain.getFreightExpallList(), objmap);
                if (null == wlFreightExpallDomain) continue;
                wlFreightExpReDomain.setWlFreightExpdisDomainList(null);
                break;
            }
            if (LogisticsConstants.FREIGHT_TEM_TYPE_1.equals(wlFreightExp.getFreightTemType())) {
                List<WlFreightExptagDomain> exptagDomains = this.queryTagTime(wlFreightExpReDomain, objmap);
                wlFreightExpReDomain.setWlFreightExptagDomainList(exptagDomains);
                wlFreightExpReDomain.setWlFreightExpdisDomainList(null);
                wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpReDomain.getFreightExpallList().get(0));
                return wlFreightExpReDomain;
            }
            wlFreightExpallDomain = this.checkAll(wlFreightExpReDomain.getFreightExpallList(), objmap);
            this.logger.error("wlFreightExpallDomain====1" + JsonUtil.buildNonDefaultBinder().toJson((Object)wlFreightExpallDomain));
            if (null == wlFreightExpallDomain) continue;
            if (null != wlFreightExpallDomain && "100000".equals(wlFreightExpallDomain.getFreightExpallArea())) {
                wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpallDomain);
                wlFreightExpReDomain.setWlFreightExpdisDomainList(null);
                return wlFreightExpReDomain;
            }
            List<Object> wlFreightExptagList = new ArrayList();
            wlFreightExptagList = this.checktagList(wlFreightExpallDomain, wlFreightExpReDomain.getWlFreightExptagDomainList());
            if (ListUtil.isEmpty(wlFreightExptagList)) continue;
            wlFreightExpReDomain.setWlFreightExptagDomainList(wlFreightExptagList);
            if (this.checkTag(wlFreightExpReDomain.getWlFreightExptagDomainList(), objmap)) continue;
            wlFreightExpReDomain.setWlFreightExpdisDomainList(null);
            this.logger.error("wlFreightExpReDomain==-" + JsonUtil.buildNonDefaultBinder().toJson((Object)wlFreightExpReDomain));
            if (!this.checkGoods(wlFreightExpReDomain.getWlFreightExpgoodsDomainList(), goodsBeanMap)) {
                if (!ListUtil.isEmpty(wlFreightExpReDomain.getWlFreightExpgoodsDomainList())) continue;
                reWlFreightExpReDomain = wlFreightExpReDomain;
                continue;
            }
            wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpallDomain);
            return wlFreightExpReDomain;
        }
        this.logger.error("wlFreightExpReDomain-===" + JsonUtil.buildNonDefaultBinder().toJson((Object)wlFreightExpReDomain));
        wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpallDomain);
        return wlFreightExpReDomain;
    }

    public static String getOrderFreight(String tenantCode, String flagSettingType, String flagSettingCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)flagSettingType) || StringUtils.isBlank((String)flagSettingCode)) {
            return null;
        }
        String field = tenantCode.concat("-").concat(flagSettingType).concat("-").concat(flagSettingCode);
        return SupDisUtil.getMap((String)"DdFalgSetting-key", (String)field);
    }

    private WlFreightExpReDomain newCheckFreightExp(List<WlFreightExp> wlFreightExpList, List<Map<String, Object>> goodsBeanMap, Map<String, Object> objmap) {
        if (ListUtil.isEmpty(wlFreightExpList)) {
            return null;
        }
        WlFreightExpReDomain wlFreightExpReDomain = null;
        WlFreightExpallDomain wlFreightExpallDomain = null;
        for (WlFreightExp wlFreightExp : wlFreightExpList) {
            wlFreightExpReDomain = this.makeFreightExpReDomain(wlFreightExp);
            if (!this.checkGoods(wlFreightExpReDomain.getWlFreightExpgoodsDomainList(), goodsBeanMap)) continue;
            if (!this.checkTag(wlFreightExpReDomain.getWlFreightExptagDomainList(), objmap)) {
                wlFreightExpReDomain = new WlFreightExpReDomain();
                continue;
            }
            wlFreightExpallDomain = this.checkAll(wlFreightExpReDomain.getFreightExpallList(), objmap);
            if (null == wlFreightExpallDomain) continue;
            wlFreightExpReDomain.setWlFreightExpallDomain(wlFreightExpallDomain);
            return wlFreightExpReDomain;
        }
        return null;
    }

    private List<WlFreightExptagDomain> checktagList(WlFreightExpallDomain wlFreightExpallDomain, List<WlFreightExptagDomain> wlFreightExptagDomains) {
        ArrayList<WlFreightExptagDomain> wlFreightExptagDo = new ArrayList<WlFreightExptagDomain>();
        for (WlFreightExptagDomain wlFreightExptagDomain : wlFreightExptagDomains) {
            if (!wlFreightExpallDomain.getFreightExpallArea().equals(wlFreightExptagDomain.getFreightExptagValue2())) continue;
            wlFreightExptagDo.add(wlFreightExptagDomain);
        }
        return wlFreightExptagDo;
    }

    private List<WlFreightExptagDomain> queryTagTime(WlFreightExpReDomain wlFreightExpReDomain, Map<String, Object> objmap) {
        List<WlFreightExptagDomain> tagList = this.makeTag(wlFreightExpReDomain, objmap);
        if (ListUtil.isEmpty(tagList)) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.queryTagTime.tenantCode.null", (Object)"tagList is null");
            return null;
        }
        ArrayList<WlFreightExptagDomain> freightExptagDomains = null;
        for (WlFreightExptagDomain tag : tagList) {
            freightExptagDomains = new ArrayList<WlFreightExptagDomain>();
            freightExptagDomains.add(tag);
            Map<String, List<String>> listMap = this.makeTaglist(freightExptagDomains);
            this.logger.error("listMap---1" + listMap.toString());
            if (this.checkTagTime(listMap, objmap)) continue;
            return freightExptagDomains;
        }
        return null;
    }

    private boolean checkTagTime(Map<String, List<String>> map, Map<String, Object> objmap) {
        if (null == map || map.isEmpty()) {
            return true;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty(objmap, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs;
                for (String o : otrs = objValue.toString().split("\\,")) {
                    if (WlFreightTemServiceImpl.cond(valueList, term, o)) break;
                }
                continue;
            }
            if ("into".equals(term)) {
                String[] ke;
                StringBuffer buffer = new StringBuffer();
                for (String k : ke = key.split(",")) {
                    buffer.append(objmap.get(k) + ",");
                }
                objValue = buffer.toString();
            }
            this.logger.error("valueList==1" + valueList + "---term:" + term + "---" + objValue);
            if (WlFreightTemServiceImpl.cond(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private WlFreightExpallDomain newCheckPall(List<WlFreightExpallDomain> wlFreightExpallDomainList, Map<String, Object> map, String expressCode) {
        BigDecimal price;
        this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.newCheckPall---" + JsonUtil.buildNonDefaultBinder().toJson(wlFreightExpallDomainList));
        this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.newCheckPall" + JsonUtil.buildNonDefaultBinder().toJson(map));
        BigDecimal bigDecimal = price = map.get("price") == null ? BigDecimal.ZERO : new BigDecimal(map.get("price").toString());
        if (ListUtil.isEmpty(wlFreightExpallDomainList) || StringUtils.isBlank((String)expressCode)) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.newCheckPallStr isnull");
            return null;
        }
        for (WlFreightExpallDomain wlFreightExpallDomain : wlFreightExpallDomainList) {
            if (StringUtils.isBlank((String)wlFreightExpallDomain.getFreightExpRemark()) || StringUtils.isBlank((String)wlFreightExpallDomain.getFreightExpallStart()) || null == wlFreightExpallDomain.getFreightExpallPostage()) {
                this.logger.info("wl.LOGISTICS.WlFreightTemServiceImpl.newCheckPall---" + JsonUtil.buildNormalBinder().toJson((Object)wlFreightExpallDomain));
                continue;
            }
            BigDecimal freightExpallStart = new BigDecimal(wlFreightExpallDomain.getFreightExpallStart());
            if ("0".equals(expressCode) && "<".equals(wlFreightExpallDomain.getFreightExpRemark()) && price.compareTo(freightExpallStart) < 0) {
                return wlFreightExpallDomain;
            }
            if (!"1".equals(expressCode)) continue;
            BigDecimal freightExpallPostageplus = null == wlFreightExpallDomain.getFreightExpallPostageplus() ? BigDecimal.ZERO : wlFreightExpallDomain.getFreightExpallPostageplus();
            boolean flag = false;
            if ("<".equals(wlFreightExpallDomain.getFreightExpRemark()) && price.compareTo(freightExpallStart) <= 0) {
                flag = true;
            }
            boolean flag1 = false;
            if (">=".equals(wlFreightExpallDomain.getFreightExpallPlus()) && price.compareTo(freightExpallPostageplus) >= 0) {
                flag1 = true;
            }
            if (!flag || !flag1) continue;
            return wlFreightExpallDomain;
        }
        this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.newCheckPall isnull");
        return null;
    }

    private WlFreightExpallDomain checkPall(List<WlFreightExpallDomain> wlFreightExpallDomainList, Map<String, Object> map) {
        if (ListUtil.isEmpty(wlFreightExpallDomainList)) {
            return null;
        }
        for (WlFreightExpallDomain wlFreightExpallDomain : wlFreightExpallDomainList) {
            BigDecimal start;
            BigDecimal objs;
            Object obj;
            if (StringUtils.isBlank((String)wlFreightExpallDomain.getFreightExpallStart()) || null == wlFreightExpallDomain.getFreightExpallPostage() || "".equals(wlFreightExpallDomain.getFreightExpallPostage()) || StringUtils.isBlank((String)wlFreightExpallDomain.getAppmanageIcode()) || null == (obj = map.get(wlFreightExpallDomain.getAppmanageIcode())) || (objs = new BigDecimal(obj.toString())).compareTo(start = new BigDecimal(wlFreightExpallDomain.getFreightExpallStart())) != 1 || objs.compareTo(wlFreightExpallDomain.getFreightExpallPostage()) >= 1) continue;
            return wlFreightExpallDomain;
        }
        return null;
    }

    private WlFreightExpallDomain checkAll(List<WlFreightExpallDomain> wlFreightExpallDomainList, Map<String, Object> map) {
        if (ListUtil.isEmpty(wlFreightExpallDomainList) || MapUtil.isEmpty(map)) {
            return null;
        }
        WlFreightExpallDomain deexpall = null;
        String areaCode = (String)map.get("areaCode");
        for (WlFreightExpallDomain wlFreightExpallDomain : wlFreightExpallDomainList) {
            if (wlFreightExpallDomain.getFreightExpallArea().equals("100000")) {
                deexpall = wlFreightExpallDomain;
                continue;
            }
            if (!wlFreightExpallDomain.getFreightExpallArea().contains(areaCode)) continue;
            return wlFreightExpallDomain;
        }
        return deexpall;
    }

    private List<WlFreightExpdisDomain> checkExpdis(List<WlFreightExpdisDomain> wlFreightExpdisDomainList, Map<String, Object> map) {
        if (ListUtil.isEmpty(wlFreightExpdisDomainList) || MapUtil.isEmpty(map)) {
            return null;
        }
        String areaCode = (String)map.get("areaCode");
        ArrayList<WlFreightExpdisDomain> domainList = new ArrayList<WlFreightExpdisDomain>();
        for (WlFreightExpdisDomain wlFreightExpallDomain : wlFreightExpdisDomainList) {
            if (!wlFreightExpallDomain.getFreightExpdisValue4().contains(areaCode)) continue;
            domainList.add(wlFreightExpallDomain);
        }
        return domainList;
    }

    private boolean checkTag(List<WlFreightExptagDomain> wlFreightExptagDomainList, Map<String, Object> objmap) {
        if (ListUtil.isEmpty(wlFreightExptagDomainList)) {
            return true;
        }
        Map<String, List<String>> map = this.makeTaglist(wlFreightExptagDomainList);
        if (null == map || map.isEmpty()) {
            return false;
        }
        boolean flag = true;
        String term = "";
        String key = "";
        for (String keys : map.keySet()) {
            String[] keyStr = keys.split("\\|");
            if (null == keyStr || keyStr.length == 0) continue;
            key = keyStr[0];
            if (keyStr.length > 1) {
                term = keyStr[1];
            }
            Object objValue = BeanUtils.newForceGetProperty(objmap, (String)key);
            List<String> valueList = map.get(keys);
            if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                String[] otrs;
                for (String o : otrs = objValue.toString().split("\\,")) {
                    if (WlFreightTemServiceImpl.condStr(valueList, term, o)) break;
                }
                continue;
            }
            if (WlFreightTemServiceImpl.condStr(valueList, term, objValue)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private Map<String, List<String>> makeTaglist(List<WlFreightExptagDomain> apiconfList) {
        if (ListUtil.isEmpty(apiconfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        boolean flag = false;
        for (WlFreightExptagDomain atChannelsendApiconf : apiconfList) {
            ArrayList<String> list;
            flag = false;
            if (StringUtils.isBlank((String)atChannelsendApiconf.getFreightExptagOp())) {
                atChannelsendApiconf.setFreightExptagOp("=");
            }
            if (null == (list = (ArrayList<String>)map.get(atChannelsendApiconf.getFreightExptagPro() + "|" + atChannelsendApiconf.getFreightExptagOp()))) {
                list = new ArrayList<String>();
                map.put(atChannelsendApiconf.getFreightExptagPro() + "|" + atChannelsendApiconf.getFreightExptagOp(), list);
            }
            if (StringUtils.isBlank((String)atChannelsendApiconf.getFreightExptagValue())) {
                atChannelsendApiconf.setFreightExptagValue("");
            }
            if (StringUtils.isBlank((String)atChannelsendApiconf.getFreightExptagValue1())) {
                atChannelsendApiconf.setFreightExptagValue1("");
            } else {
                flag = true;
            }
            if (flag) {
                list.add(atChannelsendApiconf.getFreightExptagValue() + "=" + atChannelsendApiconf.getFreightExptagValue1());
                continue;
            }
            list.add(atChannelsendApiconf.getFreightExptagValue());
        }
        return map;
    }

    private boolean checkDis(List<WlFreightExpdisDomain> wlFreightExpdisDomainList, Map<String, Object> objmap) {
        if (ListUtil.isEmpty(wlFreightExpdisDomainList)) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.remap.wlFreightExpdisDomainList");
            return false;
        }
        Map<String, Map<String, List<String>>> remap = WlFreightTemServiceImpl.makeDislist(wlFreightExpdisDomainList);
        if (null == remap || remap.isEmpty()) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.remap.map");
            return false;
        }
        for (String groupkey : remap.keySet()) {
            Map<String, List<String>> map = remap.get(groupkey);
            if (null == map || map.isEmpty()) {
                this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.checkDis.map");
                continue;
            }
            boolean flag = true;
            String term = "";
            String key = "";
            block1: for (String keys : map.keySet()) {
                String[] keyStr = keys.split("\\|");
                if (null == keyStr || keyStr.length == 0) continue;
                key = keyStr[0];
                if (keyStr.length > 1) {
                    term = keyStr[1];
                }
                Object objValue = BeanUtils.newForceGetProperty(objmap, (String)key);
                List<String> valueList = map.get(keys);
                if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                    String[] otrs;
                    for (String o : otrs = objValue.toString().split("\\,")) {
                        this.logger.info("======", (Object)(valueList + "==" + term + "==" + o));
                        if (!WlFreightTemServiceImpl.condStr(valueList, term, o)) continue;
                        this.logger.info("====1==", (Object)(valueList + "==" + term + "==" + o));
                        continue block1;
                    }
                    continue;
                }
                if ("into".equals(term)) {
                    String[] ke;
                    StringBuffer buffer = new StringBuffer();
                    for (String k : ke = key.split(",")) {
                        buffer.append(objmap.get(k) + ",");
                    }
                    objValue = buffer.toString();
                }
                this.logger.info("====2==", (Object)(valueList + "==" + term + "==" + objValue));
                if (WlFreightTemServiceImpl.condStr(valueList, term, objValue)) continue;
                this.logger.info("====3==", (Object)(valueList + "==" + term + "==" + objValue));
                flag = false;
                break;
            }
            if (!flag) continue;
            return flag;
        }
        return false;
    }

    public static void main(String[] args) {
        String[] s = "group1.price".split("\\.");
        System.out.println(s[0]);
        System.out.println(s[1]);
    }

    private static Map<String, Map<String, List<String>>> makeDislist(List<WlFreightExpdisDomain> apiconfList) {
        if (ListUtil.isEmpty(apiconfList)) {
            return null;
        }
        Map map = new HashMap();
        HashMap<String, Map<String, List<String>>> remap = new HashMap<String, Map<String, List<String>>>();
        String group = "";
        for (WlFreightExpdisDomain atChannelsendApiconf : apiconfList) {
            ArrayList<String> list;
            String pro;
            String[] s;
            if (StringUtils.isBlank((String)atChannelsendApiconf.getFreightExpdisPro())) {
                atChannelsendApiconf.setFreightExpdisPro("");
            }
            if (null != (s = atChannelsendApiconf.getFreightExpdisPro().split("\\.")) && s.length > 1) {
                group = s[0];
                pro = s[1];
            } else {
                group = "";
                pro = atChannelsendApiconf.getFreightExpdisPro();
            }
            map = (Map)remap.get(group);
            if (null == map) {
                map = new HashMap();
                remap.put(group, map);
            }
            if (StringUtils.isBlank((String)atChannelsendApiconf.getFreightExpdisOp())) {
                atChannelsendApiconf.setFreightExpdisOp("=");
            }
            if (null == (list = (ArrayList<String>)map.get(pro + "|" + atChannelsendApiconf.getFreightExpdisOp()))) {
                list = new ArrayList<String>();
                map.put(pro + "|" + atChannelsendApiconf.getFreightExpdisOp(), list);
            }
            if (StringUtils.isBlank((String)atChannelsendApiconf.getFreightExpdisValue())) {
                atChannelsendApiconf.setFreightExpdisValue("");
            }
            list.add(atChannelsendApiconf.getFreightExpdisValue());
        }
        return remap;
    }

    private boolean checkGoods(List<WlFreightExpgoodsDomain> wlFreightExpgoodsDomainList, List<Map<String, Object>> goodsBeanMap) {
        if (ListUtil.isEmpty(wlFreightExpgoodsDomainList) && ListUtil.isEmpty(goodsBeanMap)) {
            return true;
        }
        if (ListUtil.isEmpty(wlFreightExpgoodsDomainList) && ListUtil.isNotEmpty(goodsBeanMap)) {
            return true;
        }
        if (ListUtil.isNotEmpty(wlFreightExpgoodsDomainList) && ListUtil.isEmpty(goodsBeanMap)) {
            return false;
        }
        for (Map<String, Object> objmap : goodsBeanMap) {
            Map<String, List<String>> map = this.makeScopeApiconflist(wlFreightExpgoodsDomainList);
            if (null == map || map.isEmpty()) continue;
            boolean flag = true;
            String term = "";
            String key = "";
            for (String keys : map.keySet()) {
                String[] keyStr = keys.split("\\|");
                if (null == keyStr || keyStr.length == 0) continue;
                key = keyStr[0];
                if (keyStr.length > 1) {
                    term = keyStr[1];
                }
                Object objValue = BeanUtils.newForceGetProperty(objmap, (String)key);
                List<String> valueList = map.get(keys);
                if (objValue instanceof String && null != objValue && objValue.toString().indexOf(",") > 0) {
                    String[] otrs;
                    for (String o : otrs = objValue.toString().split("\\,")) {
                        if (WlFreightTemServiceImpl.condStr(valueList, term, o)) break;
                    }
                    continue;
                }
                if (WlFreightTemServiceImpl.condStr(valueList, term, objValue)) continue;
                flag = false;
                break;
            }
            if (flag) continue;
            return false;
        }
        return true;
    }

    private static boolean condStr(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = false;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (new BigDecimal(objValue.toString()).compareTo(new BigDecimal(value)) == -1) {
                flag = true;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (new BigDecimal(objValue.toString()).compareTo(new BigDecimal(value)) == 1) {
                flag = true;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (new BigDecimal(objValue.toString()).compareTo(new BigDecimal(value)) >= 0) {
                flag = true;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (new BigDecimal(objValue.toString()).compareTo(new BigDecimal(value)) <= 0) {
                flag = true;
            }
        } else if ("=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "";
            }
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue)) {
                flag = true;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = true;
            }
        } else if ("datein".equals(term)) {
            if (null == objValue) {
                objValue = null;
            }
            String d1 = "";
            String d2 = "";
            for (String string : valueList) {
                d1 = string.split("=")[0];
                d2 = string.split("=")[1];
                Date d = (Date)objValue;
                Date d11 = DateUtil.getDateToString((String)d1, (String)"yyyy-MM-dd HH:mm:ss");
                Date d21 = DateUtil.getDateToString((String)d2, (String)"yyyy-MM-dd HH:mm:ss");
                if (d.getTime() < d11.getTime() || d.getTime() > d21.getTime()) continue;
                return true;
            }
        } else if ("in".equals(term)) {
            if (null == objValue) {
                objValue = "0";
            }
            String d1 = "";
            String d2 = "";
            for (String string : valueList) {
                d1 = string.split("=")[0];
                d2 = string.split("=")[1];
                BigDecimal d = new BigDecimal(objValue.toString());
                BigDecimal d11 = new BigDecimal(d1);
                BigDecimal d12 = new BigDecimal(d2);
                if (d.compareTo(d11) < 0 || d.compareTo(d12) > 0) continue;
                return true;
            }
        } else if ("into".equals(term)) {
            String[] values;
            if (ListUtil.isEmpty(valueList) || null == objValue) {
                return flag;
            }
            String value0 = "0";
            String value1 = "0";
            String value2 = "0";
            String[] objVa = objValue.toString().split(",");
            String objVa0 = "0";
            String objVa1 = "0";
            if (objVa.length > 0) {
                objVa0 = objVa[0];
            }
            if (objVa.length > 1) {
                objVa1 = objVa[1];
            }
            if ((values = value.split(",")).length > 0) {
                value0 = values[0];
            }
            if (values.length > 1) {
                value1 = values[1];
            }
            if (values.length > 2) {
                value2 = values[2];
            }
            BigDecimal bigDecObjVa0 = new BigDecimal(objVa0);
            BigDecimal bigDecObjVa1 = new BigDecimal(objVa1);
            BigDecimal bigDecValue0 = new BigDecimal(value0);
            BigDecimal bigDecValue1 = new BigDecimal(value1);
            BigDecimal bigDecValue2 = new BigDecimal(value2);
            if (bigDecObjVa0.compareTo(bigDecValue2) == -1 && bigDecObjVa1.compareTo(bigDecValue0) > -1 && bigDecObjVa1.compareTo(bigDecValue1) == -1) {
                flag = true;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = true;
            }
        }
        return flag;
    }

    private static boolean cond(List<String> valueList, String term, Object objValue) {
        if (ListUtil.isEmpty(valueList)) {
            return false;
        }
        if (StringUtils.isBlank((String)term)) {
            term = "=";
        }
        boolean flag = false;
        String value = valueList.get(0);
        if ("<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (new BigDecimal(objValue.toString()).compareTo(new BigDecimal(value)) == -1) {
                flag = true;
            }
        } else if (">".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (new BigDecimal(objValue.toString()).compareTo(new BigDecimal(value)) == 1) {
                flag = true;
            }
        } else if (">=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (new BigDecimal(objValue.toString()).compareTo(new BigDecimal(value)) >= 0) {
                flag = true;
            }
        } else if ("=<".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "0";
            }
            if (new BigDecimal(objValue.toString()).compareTo(new BigDecimal(value)) <= 0) {
                flag = true;
            }
        } else if ("=".equals(term)) {
            if (StringUtils.isBlank((String)value)) {
                value = "0";
            }
            if (null == objValue) {
                objValue = "1";
            }
            if (new BigDecimal(value).compareTo(new BigDecimal(objValue.toString())) == 0) {
                flag = true;
            }
        } else if ("!=".equals(term)) {
            if (null == objValue) {
                objValue = "";
            }
            if (!valueList.contains(objValue.toString())) {
                flag = true;
            }
        } else if ("datein".equals(term)) {
            if (null == objValue) {
                objValue = null;
            }
            String d1 = "";
            String d2 = "";
            for (String string : valueList) {
                d1 = string.split("=")[0];
                d2 = string.split("=")[1];
                Date d = (Date)objValue;
                Date d11 = DateUtil.getDateToString((String)d1, (String)"yyyy-MM-dd HH:mm:ss");
                Date d21 = DateUtil.getDateToString((String)d2, (String)"yyyy-MM-dd HH:mm:ss");
                if (d.getTime() < d11.getTime() || d.getTime() > d21.getTime()) continue;
                return true;
            }
        } else if ("in".equals(term)) {
            if (null == objValue) {
                objValue = "0";
            }
            String d1 = "";
            String d2 = "";
            for (String string : valueList) {
                d1 = string.split("=")[0];
                d2 = string.split("=")[1];
                BigDecimal d = new BigDecimal(objValue.toString());
                BigDecimal d11 = new BigDecimal(d1);
                BigDecimal d12 = new BigDecimal(d2);
                if (d.compareTo(d11) < 0 || d.compareTo(d12) > 0) continue;
                return true;
            }
        } else if ("into".equals(term)) {
            String[] values;
            if (ListUtil.isEmpty(valueList) || null == objValue) {
                return flag;
            }
            String value0 = "0";
            String value1 = "0";
            String value2 = "0";
            String[] objVa = objValue.toString().split(",");
            String objVa0 = "0";
            String objVa1 = "0";
            if (objVa.length > 0) {
                objVa0 = objVa[0];
            }
            if (objVa.length > 1) {
                objVa1 = objVa[1];
            }
            if ((values = value.split(",")).length > 0) {
                value0 = values[0];
            }
            if (values.length > 1) {
                value1 = values[1];
            }
            if (values.length > 2) {
                value2 = values[2];
            }
            BigDecimal bigDecObjVa0 = new BigDecimal(objVa0);
            BigDecimal bigDecObjVa1 = new BigDecimal(objVa1);
            BigDecimal bigDecValue0 = new BigDecimal(value0);
            BigDecimal bigDecValue1 = new BigDecimal(value1);
            BigDecimal bigDecValue2 = new BigDecimal(value2);
            if (bigDecObjVa0.compareTo(bigDecValue2) == -1 && bigDecObjVa1.compareTo(bigDecValue0) > -1 && bigDecObjVa1.compareTo(bigDecValue1) == -1) {
                flag = true;
            }
        } else {
            if (null == objValue) {
                objValue = "";
            }
            if (valueList.contains(objValue.toString())) {
                flag = true;
            }
        }
        return flag;
    }

    private Map<String, List<String>> makeScopeApiconflist(List<WlFreightExpgoodsDomain> apiconfList) {
        if (ListUtil.isEmpty(apiconfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (WlFreightExpgoodsDomain atChannelsendApiconf : apiconfList) {
            ArrayList<String> list;
            if (StringUtils.isBlank((String)atChannelsendApiconf.getFreightExpgoodsOp())) {
                atChannelsendApiconf.setFreightExpgoodsOp("=");
            }
            if (null == (list = (ArrayList<String>)map.get(atChannelsendApiconf.getFreightExpgoodsPro() + "|" + atChannelsendApiconf.getFreightExpgoodsOp()))) {
                list = new ArrayList<String>();
                map.put(atChannelsendApiconf.getFreightExpgoodsPro() + "|" + atChannelsendApiconf.getFreightExpgoodsOp(), list);
            }
            if (StringUtils.isBlank((String)atChannelsendApiconf.getFreightExpgoodsValue())) {
                atChannelsendApiconf.setFreightExpgoodsValue("");
            }
            list.add(atChannelsendApiconf.getFreightExpgoodsValue());
        }
        return map;
    }

    @Override
    public BigDecimal getFreightFare(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.map.null", "map is null");
        }
        String tenantCode = (String)map.get("tenantCode");
        String orderFreight = WlFreightTemServiceImpl.getOrderFreight(tenantCode, "orderFreight", "orderFreight");
        this.logger.error(SYS_CODE, (Object)("orderFreight+++tenantCode===========" + orderFreight + "+++" + tenantCode));
        if (StringUtils.isNotBlank((String)orderFreight) && orderFreight.equals("orderFreight")) {
            HashMap<String, Object> remap = new HashMap<String, Object>();
            return this.getNewFreightFareByType("0", map, remap);
        }
        return this.getFreightFareByType("0", map);
    }

    @Override
    public Map<String, Object> getFreightFareReMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFareReMap.map", "map is null");
        }
        String tenantCode = (String)map.get("tenantCode");
        if (StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFareReMap.map.tenantCode", "tenantCode is null");
        }
        String areaCode = (String)map.get("areaCode");
        if (StringUtils.isBlank((String)areaCode)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFareReMap.map.areaCode", "areaCode is null");
        }
        return this.getNewFreightFareByType("0", map);
    }

    public BigDecimal getFreightFareByType(String freightTemType, Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.map.null", "map is null");
        }
        map.put("nowDate", this.getSysDate());
        String freightExpCode = (String)map.get("freightExpCode");
        String areaCode = (String)map.get("areaCode");
        Object quantityMap = map.get("quantity");
        Object weightMap = map.get("weight");
        String tenantCode = (String)map.get("tenantCode");
        BigDecimal price = map.get("price") == null ? BigDecimal.ZERO : new BigDecimal(map.get("price").toString());
        BigDecimal DEFAULT_FARE = BigDecimal.ZERO;
        List goodsBeanMap = (List)map.get("goods");
        if (StringUtils.isBlank((String)areaCode)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.areaCode.null", "\u6536\u8d27\u5730\u5740\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        WlFreightExpReDomain wlFreightExp = this.checkFreightExp(freightTemType, freightExpCode, tenantCode, goodsBeanMap, map);
        this.logger.error("wlFreightExp.result", (Object)JsonUtil.buildNormalBinder().toJson((Object)wlFreightExp));
        if (wlFreightExp == null) {
            this.logger.info(SYS_CODE, (Object)("\u672a\u5339\u914d\u5230\u7269\u6d41\u6a21\u677f   code=" + freightExpCode));
            return DEFAULT_FARE;
        }
        if ("shop".equals(wlFreightExp.getFreightExpPayer())) {
            return BigDecimal.ZERO;
        }
        WlFreightExpallDomain expall = wlFreightExp.getWlFreightExpallDomain();
        if (Objects.isNull(expall) && StringUtils.isNotBlank((String)areaCode) && ListUtil.isNotEmpty(wlFreightExp.getFreightExpallList())) {
            for (WlFreightExpallDomain wlFreightExpallDomain : wlFreightExp.getFreightExpallList()) {
                String[] arealist;
                for (String wlArea : arealist = wlFreightExpallDomain.getFreightExpallArea().split(",")) {
                    if (!areaCode.equals(wlArea)) continue;
                    expall = wlFreightExpallDomain;
                }
            }
            if (Objects.isNull(expall) && Objects.isNull(expall = (WlFreightExpallDomain)wlFreightExp.getFreightExpallList().stream().filter(x -> x.getFreightExpallArea().equals("100000")).findFirst().orElse(null))) {
                return DEFAULT_FARE;
            }
        }
        BigDecimal buynums = BigDecimal.ZERO;
        if ("quantity".equals(wlFreightExp.getFreightExpValuation())) {
            if (quantityMap == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.quantity.null", "\u672a\u83b7\u53d6\u5230\u6570\u91cf\u4fe1\u606f");
            }
            buynums = new BigDecimal(quantityMap.toString());
        } else if ("g".equals(wlFreightExp.getFreightExpValuation())) {
            if (weightMap == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.weight.null", "\u672a\u83b7\u53d6\u5230\u91cd\u91cf\u4fe1\u606f");
            }
            buynums = new BigDecimal(weightMap.toString());
        } else if (!"price".equals(wlFreightExp.getFreightExpValuation())) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.null", (Object)("\u8fd0\u8d39\u6a21\u677f\u8ba1\u91cf\u672a\u5339\u914d\u6210\u529f" + wlFreightExp.getFreightExpValuation()));
            return DEFAULT_FARE;
        }
        BigDecimal fare = BigDecimal.ZERO;
        BigDecimal vstart = new BigDecimal(expall.getFreightExpallStart());
        if (buynums.compareTo(BigDecimal.ZERO) < 1 && price.compareTo(BigDecimal.ZERO) < 1) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.no", "\u6570\u91cf/\u91cd\u91cf/\u91d1\u989d\u6709\u8bef" + buynums + price);
        }
        if (buynums.compareTo(BigDecimal.ZERO) == 1) {
            fare = expall.getFreightExpallPostage();
            if (vstart.compareTo(buynums) < 0) {
                BigDecimal numu = buynums.subtract(vstart).divide(new BigDecimal(expall.getFreightExpallPlus()), 0, RoundingMode.CEILING);
                fare = fare.add(numu.multiply(expall.getFreightExpallPostageplus()));
            }
        } else if (price.compareTo(BigDecimal.ZERO) == 1 && vstart.compareTo(price) < 1 && expall.getFreightExpallPostage().compareTo(price) == 1) {
            fare = new BigDecimal(expall.getFreightExpallPlus());
        }
        return fare;
    }

    public Map<String, Object> getNewFreightFareByType(String freightTemType, Map<String, Object> map) {
        List goodsBeanMap;
        String tenantCode;
        if (map == null || map.isEmpty()) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getNewFreightFareByType.map.null", "map is null");
        }
        HashMap hashMap = new HashMap();
        HashMap<String, Object> remap = new HashMap<String, Object>();
        String freightExpCode = (String)map.get("freightExpCode");
        WlFreightExpReDomain wlFreightExp = this.checkFreightExpNew(freightTemType, freightExpCode, tenantCode = (String)map.get("tenantCode"), goodsBeanMap = (List)map.get("goods"), map);
        if (wlFreightExp == null) {
            remap.put("success", true);
            remap.put("msg", "\u6ca1\u6709\u914d\u7f6e\u6a21\u677f");
            remap.put("wlfree", BigDecimal.ZERO);
            remap.put("oldWlfree", BigDecimal.ZERO);
            remap.put("disfree", BigDecimal.ZERO);
            return remap;
        }
        if (wlFreightExp != null && StringUtils.isBlank((String)wlFreightExp.getFreightExpCode())) {
            remap.put("success", false);
            remap.put("msg", "\u4e0d\u5728\u914d\u9001\u8303\u56f4\u5185");
            return remap;
        }
        if ("shop".equals(wlFreightExp.getFreightExpPayer())) {
            remap.put("success", true);
            remap.put("msg", "\u5356\u5bb6\u627f\u62c5\u8d39\u7528");
            remap.put("wlfree", BigDecimal.ZERO);
            remap.put("oldWlfree", BigDecimal.ZERO);
            remap.put("disfree", BigDecimal.ZERO);
            return remap;
        }
        WlFreightExpallDomain expall = wlFreightExp.getWlFreightExpallDomain();
        if (null == expall) {
            remap.put("success", false);
            remap.put("msg", "\u7269\u6d41\u6a21\u677f\u6ca1\u6709\u8bbe\u7f6e\u8d39\u7528\u89c4\u5219");
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFareByType.expall", (Object)"expall is null");
            return remap;
        }
        BigDecimal quantityMap = map.get("quantity") == null ? BigDecimal.ZERO : new BigDecimal(map.get("quantity").toString());
        BigDecimal weightMap = map.get("weight") == null ? BigDecimal.ZERO : new BigDecimal(map.get("weight").toString());
        BigDecimal price = map.get("price") == null ? BigDecimal.ZERO : new BigDecimal(map.get("price").toString());
        BigDecimal buynums = BigDecimal.ZERO;
        if ("quantity".equals(wlFreightExp.getFreightExpValuation())) {
            if (quantityMap == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.quantity.null", "\u672a\u83b7\u53d6\u5230\u6570\u91cf\u4fe1\u606f");
            }
            buynums = quantityMap;
        } else if ("g".equals(wlFreightExp.getFreightExpValuation())) {
            if (weightMap == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.weight.null", "\u672a\u83b7\u53d6\u5230\u91cd\u91cf\u4fe1\u606f");
            }
            buynums = weightMap;
        } else if ("price".equals(wlFreightExp.getFreightExpValuation()) && price == null) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.price.null", "\u672a\u83b7\u53d6\u5230\u91d1\u989d\u4fe1\u606f");
        }
        BigDecimal fare = BigDecimal.ZERO;
        BigDecimal vstart = new BigDecimal(expall.getFreightExpallStart());
        if (buynums.compareTo(BigDecimal.ZERO) < 1 && price.compareTo(BigDecimal.ZERO) < 1) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.no", "\u6570\u91cf/\u91cd\u91cf/\u91d1\u989d\u6709\u8bef" + buynums + price);
        }
        if (buynums.compareTo(BigDecimal.ZERO) == 1) {
            fare = expall.getFreightExpallPostage();
            if (vstart.compareTo(buynums) < 0) {
                BigDecimal numu = buynums.subtract(vstart).divide(new BigDecimal(expall.getFreightExpallPlus()), 0, RoundingMode.CEILING);
                fare = fare.add(numu.multiply(expall.getFreightExpallPostageplus()));
            }
        } else if (price.compareTo(BigDecimal.ZERO) == 1 && vstart.compareTo(price) < 1 && expall.getFreightExpallPostage().compareTo(price) == 1) {
            fare = new BigDecimal(expall.getFreightExpallPlus());
        }
        remap.put("success", true);
        remap.put("msg", "");
        remap.put("wlfree", fare);
        remap.put("oldWlfree", fare);
        remap.put("disfree", BigDecimal.ZERO);
        if (this.checkDis(wlFreightExp.getWlFreightExpdisDomainList(), map)) {
            remap.put("wlfree", BigDecimal.ZERO);
            remap.put("disfree", fare);
        }
        return remap;
    }

    public BigDecimal getNewFreightFareByType(String freightTemType, Map<String, Object> map, Map<String, Object> remap) {
        if (map == null || map.isEmpty() || null == remap) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getNewFreightFareByType.map.null", "map is null");
        }
        HashMap hashMap = new HashMap();
        String freightExpCode = (String)map.get("freightExpCode");
        String tenantCode = (String)map.get("tenantCode");
        BigDecimal price = map.get("price") == null ? BigDecimal.ZERO : new BigDecimal(map.get("price").toString());
        BigDecimal DEFAULT_FARE = BigDecimal.ZERO;
        List goodsBeanMap = (List)map.get("goods");
        WlFreightExpReDomain wlFreightExp = this.checkFreightExp(freightTemType, freightExpCode, tenantCode, goodsBeanMap, map);
        if (wlFreightExp == null) {
            remap.put("success", false);
            remap.put("msg", freightExpCode + "\u7269\u6d41\u6a21\u677f\u4ee3\u7801\u4e0d\u5b58\u5728");
            return DEFAULT_FARE;
        }
        if ("shop".equals(wlFreightExp.getFreightExpPayer())) {
            remap.put("success", true);
            remap.put("msg", "\u5356\u5bb6\u627f\u62c5\u8d39\u7528");
            remap.put("wlfree", BigDecimal.ZERO);
            remap.put("disfree", BigDecimal.ZERO);
            return DEFAULT_FARE;
        }
        WlFreightExpallDomain expall = wlFreightExp.getWlFreightExpallDomain();
        if (null == expall) {
            remap.put("success", false);
            remap.put("msg", "\u7269\u6d41\u6a21\u677f\u6ca1\u6709\u8bbe\u7f6e\u8d39\u7528\u89c4\u5219");
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFareByType.expall.null", (Object)"expall is null");
            return DEFAULT_FARE;
        }
        BigDecimal buynums = BigDecimal.ZERO;
        if (!"price".equals(wlFreightExp.getFreightExpValuation())) {
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.null", (Object)("\u8fd0\u8d39\u6a21\u677f\u8ba1\u91cf\u672a\u5339\u914d\u6210\u529f" + wlFreightExp.getFreightExpValuation()));
            return DEFAULT_FARE;
        }
        buynums = price;
        BigDecimal fare = BigDecimal.ZERO;
        if (buynums.compareTo(BigDecimal.ZERO) < 1 && price.compareTo(BigDecimal.ZERO) < 1) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.no", "\u6570\u91cf/\u91cd\u91cf/\u91d1\u989d\u6709\u8bef" + buynums + price);
        }
        if (buynums.compareTo(BigDecimal.ZERO) == 1) {
            if ("0".equals(wlFreightExp.getExpressCode())) {
                fare = expall.getFreightExpallPostage();
            }
            if ("1".equals(wlFreightExp.getExpressCode())) {
                fare = buynums.multiply(expall.getFreightExpallPostage().divide(BigDecimal.valueOf(100L)));
            }
        }
        return fare;
    }

    @Override
    public BigDecimal getPackingFee(Map<String, Object> map) {
        return this.getFreightFareByType("2", map);
    }

    @Override
    public Map<String, Object> getPackingFeeMark(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getPackingFeeMark.map.null", "map is null");
        }
        String freightTemType = LogisticsConstants.FREIGHT_TEM_TYPE_3;
        Object goodsClass = map.get("goodsClass");
        if (null != goodsClass && "mini".equals(goodsClass.toString())) {
            freightTemType = LogisticsConstants.FREIGHT_TEM_TYPE_2;
        }
        return this.getFreightFareMarkByType(freightTemType, map);
    }

    @Override
    public Map<String, Object> getFreightFareMark(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFareMark.map.null", "map is null");
        }
        String freightTemType = LogisticsConstants.FREIGHT_TEM_TYPE_0;
        Object goodsClass = map.get("goodsClass");
        if (null != goodsClass && "o2o".equals(goodsClass.toString())) {
            double stance = this.makeDistance(map);
            map.put(LogisticsConstants.DISTANCE, stance);
            freightTemType = LogisticsConstants.FREIGHT_TEM_TYPE_1;
        }
        return this.getFreightFareMarkByType(freightTemType, map);
    }

    public double makeDistance(Map<String, Object> map) {
        Object lat1 = map.get(LogisticsConstants.LAT1);
        Object lng1 = map.get(LogisticsConstants.LNG1);
        Object lat2 = map.get(LogisticsConstants.LAT2);
        Object lng2 = map.get(LogisticsConstants.LNG2);
        if (null == lat1 || null == lng1 || null == lat2 || null == lng2 || "".equals(lat1) || "".equals(lng1) || "".equals(lat2) || "".equals(lng2)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFareMark.map.null", "\u7528\u6237\u6216\u95e8\u5e97\u7ecf\u7eac\u5ea6\u4e3a\u7a7a");
        }
        return WlFreightTemServiceImpl.getDistance(Double.valueOf(lat1.toString()), Double.valueOf(lng1.toString()), Double.valueOf(lat2.toString()), Double.valueOf(lng2.toString()));
    }

    public Map<String, Object> getFreightFareMarkByType(String freightTemType, Map<String, Object> map) {
        Object weightKg;
        if (map == null || map.isEmpty()) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.map.null", "map is null");
        }
        this.logger.info("map----" + map.toString() + "freightTemType:" + freightTemType);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        map.put("nowDate", this.getSysDate());
        String freightExpCode = (String)map.get("freightExpCode");
        String areaCode = (String)map.get("areaCode");
        Object quantityMap = map.get("quantity");
        String unit = (String)map.get("unit");
        if (StringUtils.isNotBlank((String)unit) && "kg".equals(unit) && !"".equals(weightKg = map.get("weight")) && null != weightKg) {
            BigDecimal bigDecWeight = new BigDecimal(weightKg.toString());
            BigDecimal newWeight = bigDecWeight.multiply(new BigDecimal(LogisticsConstants.KG));
            map.put("weight", newWeight);
        }
        Object weightMap = map.get("weight");
        this.logger.info("weightMap=====" + weightMap);
        String tenantCode = (String)map.get("tenantCode");
        BigDecimal price = map.get("price") == null ? BigDecimal.ZERO : new BigDecimal(map.get("price").toString());
        BigDecimal DEFAULT_FARE = BigDecimal.ZERO;
        List goodsBeanMap = (List)map.get("goods");
        if (StringUtils.isBlank((String)areaCode) && LogisticsConstants.FREIGHT_TEM_TYPE_0.equals(freightTemType)) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.areaCode.null", "\u6536\u8d27\u5730\u5740\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        WlFreightExpReDomain wlFreightExp = this.checkFreightExp(freightTemType, freightExpCode, tenantCode, goodsBeanMap, map);
        if (wlFreightExp == null) {
            hashMap.put("fare", DEFAULT_FARE);
            hashMap.put("reMark", "");
            this.logger.info(SYS_CODE, (Object)("\u672a\u5339\u914d\u5230\u7269\u6d41\u6a21\u677f   code=" + freightExpCode));
            return hashMap;
        }
        if ("shop".equals(wlFreightExp.getFreightExpPayer())) {
            hashMap.put("fare", BigDecimal.ZERO);
            hashMap.put("reMark", "\u5356\u5bb6\u627f\u62c5");
            return hashMap;
        }
        if (ListUtil.isNotEmpty(wlFreightExp.getWlFreightExpdisDomainList())) {
            hashMap.put("fare", BigDecimal.ZERO);
            hashMap.put("reMark", wlFreightExp.getFreightExpRemark());
            return hashMap;
        }
        WlFreightExpallDomain expall = wlFreightExp.getWlFreightExpallDomain();
        if (null == expall) {
            hashMap.put("fare", DEFAULT_FARE);
            hashMap.put("reMark", "");
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFareByType.expall.null", (Object)"expall is null");
            return hashMap;
        }
        BigDecimal buynums = BigDecimal.ZERO;
        if ("quantity".equals(wlFreightExp.getFreightExpValuation())) {
            if (quantityMap == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.quantity.null", "\u672a\u83b7\u53d6\u5230\u6570\u91cf\u4fe1\u606f");
            }
            buynums = new BigDecimal(quantityMap.toString());
        } else if ("g".equals(wlFreightExp.getFreightExpValuation())) {
            if (weightMap == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.weight.null", "\u672a\u83b7\u53d6\u5230\u91cd\u91cf\u4fe1\u606f");
            }
            buynums = new BigDecimal(weightMap.toString());
        } else if ("price".equals(wlFreightExp.getFreightExpValuation())) {
            buynums = price;
        } else if (LogisticsConstants.DISTANCE.equals(wlFreightExp.getFreightExpValuation())) {
            Object obj = map.get(LogisticsConstants.DISTANCE);
            if (obj == null) {
                throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.weight.null", "\u672a\u83b7\u53d6\u5230\u5b9e\u9645\u8ddd\u79bb");
            }
            buynums = new BigDecimal(obj.toString());
        } else {
            hashMap.put("fare", DEFAULT_FARE);
            hashMap.put("reMark", "");
            this.logger.error("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.null", (Object)("\u8fd0\u8d39\u6a21\u677f\u8ba1\u91cf\u672a\u5339\u914d\u6210\u529f" + wlFreightExp.getFreightExpValuation()));
            return hashMap;
        }
        if (LogisticsConstants.FREIGHT_TEM_TYPE_2.equals(wlFreightExp.getFreightTemType()) || LogisticsConstants.FREIGHT_TEM_TYPE_3.equals(wlFreightExp.getFreightTemType())) {
            hashMap.put("fare", expall.getFreightExpallPlus());
            hashMap.put("reMark", wlFreightExp.getFreightExpRemark());
            return hashMap;
        }
        BigDecimal fare = BigDecimal.ZERO;
        BigDecimal vstart = new BigDecimal(expall.getFreightExpallStart());
        if (buynums.compareTo(BigDecimal.ZERO) < 1 && price.compareTo(BigDecimal.ZERO) < 1) {
            throw new ApiException("wl.LOGISTICS.WlFreightTemServiceImpl.getFreightFare.buynums.no", "\u6570\u91cf/\u91cd\u91cf/\u91d1\u989d\u6709\u8bef" + buynums + price);
        }
        if (buynums.compareTo(BigDecimal.ZERO) == 1) {
            fare = expall.getFreightExpallPostage();
            if (vstart.compareTo(buynums) < 0) {
                BigDecimal numu = buynums.subtract(vstart).divide(new BigDecimal(expall.getFreightExpallPlus()), 0, RoundingMode.CEILING);
                fare = fare.add(numu.multiply(expall.getFreightExpallPostageplus()));
            }
        } else if (price.compareTo(BigDecimal.ZERO) == 1 && vstart.compareTo(price) < 1 && expall.getFreightExpallPostage().compareTo(price) == 1) {
            fare = new BigDecimal(expall.getFreightExpallPlus());
        }
        hashMap.put("fare", fare);
        hashMap.put("reMark", wlFreightExp.getFreightExpRemark());
        if (LogisticsConstants.FREIGHT_TEM_TYPE_1.equals(wlFreightExp.getFreightTemType()) && ListUtil.isNotEmpty(wlFreightExp.getWlFreightExptagDomainList())) {
            WlFreightExptagDomain wlFreightExptagDomain = wlFreightExp.getWlFreightExptagDomainList().get(0);
            String moneyValue = wlFreightExptagDomain.getFreightExptagValue2();
            if (StringUtils.isNotBlank((String)moneyValue)) {
                fare = fare.add(new BigDecimal(moneyValue));
            }
            hashMap.put("fare", fare);
        }
        return hashMap;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getDistance(double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = WlFreightTemServiceImpl.rad(lat1);
        double radLat2 = WlFreightTemServiceImpl.rad(lat2);
        double a = radLat1 - radLat2;
        double b = WlFreightTemServiceImpl.rad(lng1) - WlFreightTemServiceImpl.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s *= 1000.0;
    }

    public static void main1(String[] args) {
        double distance = WlFreightTemServiceImpl.getDistance(29.490295, 106.486654, 29.615467, 106.581515);
        System.out.println(distance);
    }
}

