/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.lt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DrawLotteryUtil {
    public static int drawGift(List<Gift> giftList) {
        if (null != giftList && giftList.size() > 0) {
            ArrayList<Double> orgProbList = new ArrayList<Double>(giftList.size());
            for (Gift gift : giftList) {
                orgProbList.add(gift.getProb());
            }
            return DrawLotteryUtil.draw(orgProbList);
        }
        return -1;
    }

    public static int draw(List<Double> giftProbList) {
        ArrayList<Double> sortRateList = new ArrayList<Double>();
        Double sumRate = 0.0;
        for (Double prob : giftProbList) {
            sumRate = sumRate + prob;
        }
        if (sumRate != 0.0) {
            double rate = 0.0;
            for (Double prob : giftProbList) {
                sortRateList.add((rate += prob.doubleValue()) / sumRate);
            }
            double random = Math.random();
            sortRateList.add(random);
            Collections.sort(sortRateList);
            return sortRateList.indexOf(random);
        }
        return -1;
    }

    public static String TotalAwardRate(Double probability) {
        Gift thanks = new Gift("2", 1.0 - probability);
        Gift iphone = new Gift("1", probability);
        ArrayList<Gift> list = new ArrayList<Gift>();
        list.add(thanks);
        list.add(iphone);
        return ((Gift)list.get(DrawLotteryUtil.drawGift(list))).getName();
    }

    public static class Gift {
        private String name;
        private double prob;

        public Gift(String name, double prob) {
            this.name = name;
            this.prob = prob;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getProb() {
            return this.prob;
        }

        public void setProb(double prob) {
            this.prob = prob;
        }
    }
}

