/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.dao.MnsBatchmnsMapper;
import com.yqbsoft.laser.service.mns.domain.MnsBatchmnsDomain;
import com.yqbsoft.laser.service.mns.domain.MnsBatchmnsReDomain;
import com.yqbsoft.laser.service.mns.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.mns.model.MnsBatchmns;
import com.yqbsoft.laser.service.mns.model.RdRandomConfig;
import com.yqbsoft.laser.service.mns.service.MnsBatchmnsService;
import com.yqbsoft.laser.service.mns.service.MnsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MnsBatchmnsServiceImpl
extends BaseServiceImpl
implements MnsBatchmnsService {
    private static final String SYS_CODE = "mns.MNS.MnsBatchmnsServiceImpl";
    private MnsBatchmnsMapper mnsBatchmnsMapper;
    private MnsService mnsService;
    private String cacheKey = "RdRandomConfig_randomconfigBustype";

    public void setMnsService(MnsService mnsService) {
        this.mnsService = mnsService;
    }

    public void setMnsBatchmnsMapper(MnsBatchmnsMapper mnsBatchmnsMapper) {
        this.mnsBatchmnsMapper = mnsBatchmnsMapper;
    }

    private Date getSysDate() {
        try {
            return this.mnsBatchmnsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsBatchmnsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkBatchmns(MnsBatchmnsDomain mnsBatchmnsDomain) {
        if (null == mnsBatchmnsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)mnsBatchmnsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setBatchmnsDefault(MnsBatchmns mnsBatchmns) {
        if (null == mnsBatchmns) {
            return;
        }
        if (null == mnsBatchmns.getDataState()) {
            mnsBatchmns.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == mnsBatchmns.getGmtCreate()) {
            mnsBatchmns.setGmtCreate(date);
        }
        mnsBatchmns.setGmtModified(date);
        if (null == mnsBatchmns.getMnslistSenddate()) {
            mnsBatchmns.setMnslistSenddate(date);
        }
        if (StringUtils.isBlank((String)mnsBatchmns.getBatchmnsCode())) {
            mnsBatchmns.setBatchmnsCode(this.getNo(null, "MnsBatchmns", "mnsBatchmns", mnsBatchmns.getTenantCode()));
        }
    }

    private int getBatchmnsMaxCode() {
        int code = 0;
        try {
            return this.mnsBatchmnsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsBatchmnsServiceImpl.getBatchmnsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setBatchmnsUpdataDefault(MnsBatchmns mnsBatchmns) {
        if (null == mnsBatchmns) {
            return;
        }
        mnsBatchmns.setGmtModified(this.getSysDate());
    }

    private void saveBatchmnsModel(MnsBatchmns mnsBatchmns) throws ApiException {
        if (null == mnsBatchmns) {
            return;
        }
        try {
            this.mnsBatchmnsMapper.insert(mnsBatchmns);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.saveBatchmnsModel.ex", (Throwable)e);
        }
    }

    private void saveBatchmnsBatchModel(List<MnsBatchmns> mnsBatchmnsList) throws ApiException {
        if (null == mnsBatchmnsList || mnsBatchmnsList.isEmpty()) {
            return;
        }
        try {
            this.mnsBatchmnsMapper.insertBatch(mnsBatchmnsList);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.saveBatchmnsBatchModel.ex", (Throwable)e);
        }
    }

    private MnsBatchmns getBatchmnsModelById(Integer batchmnsId) {
        if (null == batchmnsId) {
            return null;
        }
        try {
            return this.mnsBatchmnsMapper.selectByPrimaryKey(batchmnsId);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsBatchmnsServiceImpl.getBatchmnsModelById", (Throwable)e);
            return null;
        }
    }

    private MnsBatchmns getBatchmnsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.mnsBatchmnsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsBatchmnsServiceImpl.getBatchmnsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delBatchmnsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsBatchmnsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.delBatchmnsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.delBatchmnsModelByCode.num");
        }
    }

    private void deleteBatchmnsModel(Integer batchmnsId) throws ApiException {
        if (null == batchmnsId) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsBatchmnsMapper.deleteByPrimaryKey(batchmnsId);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.deleteBatchmnsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.deleteBatchmnsModel.num");
        }
    }

    private void updateBatchmnsModel(MnsBatchmns mnsBatchmns) throws ApiException {
        if (null == mnsBatchmns) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsBatchmnsMapper.updateByPrimaryKey(mnsBatchmns);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.updateBatchmnsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.updateBatchmnsModel.num");
        }
    }

    private void updateStateBatchmnsModel(Integer batchmnsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == batchmnsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("batchmnsId", batchmnsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mnsBatchmnsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.updateStateBatchmnsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.updateStateBatchmnsModel.null");
        }
    }

    private void updateStateBatchmnsModelByCode(String tenantCode, String batchmnsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)batchmnsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("batchmnsCode", batchmnsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.mnsBatchmnsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.updateStateBatchmnsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.updateStateBatchmnsModelByCode.null");
        }
    }

    private MnsBatchmns makeBatchmns(MnsBatchmnsDomain mnsBatchmnsDomain, MnsBatchmns mnsBatchmns) {
        if (null == mnsBatchmnsDomain) {
            return null;
        }
        if (null == mnsBatchmns) {
            mnsBatchmns = new MnsBatchmns();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnsBatchmns, (Object)mnsBatchmnsDomain);
            return mnsBatchmns;
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsBatchmnsServiceImpl.makeBatchmns", (Throwable)e);
            return null;
        }
    }

    private MnsBatchmnsReDomain makeMnsBatchmnsReDomain(MnsBatchmns mnsBatchmns) {
        if (null == mnsBatchmns) {
            return null;
        }
        MnsBatchmnsReDomain mnsBatchmnsReDomain = new MnsBatchmnsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)mnsBatchmnsReDomain, (Object)mnsBatchmns);
            return mnsBatchmnsReDomain;
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsBatchmnsServiceImpl.makeMnsBatchmnsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<MnsBatchmns> queryBatchmnsModelPage(Map<String, Object> parammap) {
        try {
            return this.mnsBatchmnsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsBatchmnsServiceImpl.queryBatchmnsModel", (Throwable)e);
            return null;
        }
    }

    private int countBatchmns(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mnsBatchmnsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnsBatchmnsServiceImpl.countBatchmns", (Throwable)e);
        }
        return i;
    }

    private MnsBatchmns createMnsBatchmns(MnsBatchmnsDomain mnsBatchmnsDomain) {
        String msg = this.checkBatchmns(mnsBatchmnsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.saveBatchmns.checkBatchmns", msg);
        }
        MnsBatchmns mnsBatchmns = this.makeBatchmns(mnsBatchmnsDomain, null);
        this.setBatchmnsDefault(mnsBatchmns);
        return mnsBatchmns;
    }

    @Override
    public String saveBatchmns(MnsBatchmnsDomain mnsBatchmnsDomain) throws ApiException {
        MnsBatchmns mnsBatchmns = this.createMnsBatchmns(mnsBatchmnsDomain);
        this.saveBatchmnsModel(mnsBatchmns);
        return mnsBatchmns.getBatchmnsCode();
    }

    @Override
    public String saveBatchmnsBatch(List<MnsBatchmnsDomain> mnsBatchmnsDomainList) throws ApiException {
        if (null == mnsBatchmnsDomainList || mnsBatchmnsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<MnsBatchmns> mnsBatchmnsList = new ArrayList<MnsBatchmns>();
        String code = "";
        for (MnsBatchmnsDomain mnsBatchmnsDomain : mnsBatchmnsDomainList) {
            MnsBatchmns mnsBatchmns = this.createMnsBatchmns(mnsBatchmnsDomain);
            code = mnsBatchmns.getBatchmnsCode();
            mnsBatchmnsList.add(mnsBatchmns);
        }
        this.saveBatchmnsBatchModel(mnsBatchmnsList);
        return code;
    }

    @Override
    public void updateBatchmnsState(Integer batchmnsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateBatchmnsModel(batchmnsId, dataState, oldDataState, map);
    }

    @Override
    public void updateBatchmnsStateByCode(String tenantCode, String batchmnsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateBatchmnsModelByCode(tenantCode, batchmnsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateBatchmns(MnsBatchmnsDomain mnsBatchmnsDomain) throws ApiException {
        String msg = this.checkBatchmns(mnsBatchmnsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.updateBatchmns.checkBatchmns", msg);
        }
        MnsBatchmns oldMnsBatchmns = this.getBatchmnsModelById(mnsBatchmnsDomain.getBatchmnsId());
        if (null == oldMnsBatchmns) {
            throw new ApiException("mns.MNS.MnsBatchmnsServiceImpl.updateBatchmns.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsBatchmns mnsBatchmns = this.makeBatchmns(mnsBatchmnsDomain, oldMnsBatchmns);
        this.setBatchmnsUpdataDefault(mnsBatchmns);
        this.updateBatchmnsModel(mnsBatchmns);
    }

    @Override
    public MnsBatchmns getBatchmns(Integer batchmnsId) {
        return this.getBatchmnsModelById(batchmnsId);
    }

    @Override
    public void deleteBatchmns(Integer batchmnsId) throws ApiException {
        this.deleteBatchmnsModel(batchmnsId);
    }

    @Override
    public QueryResult<MnsBatchmns> queryBatchmnsPage(Map<String, Object> map) {
        List<MnsBatchmns> mnsBatchmnsList = this.queryBatchmnsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBatchmns(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mnsBatchmnsList);
        return queryResult;
    }

    @Override
    public MnsBatchmns getBatchmnsByCode(String tenantCode, String batchmnsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("batchmnsCode", batchmnsCode);
        return this.getBatchmnsModelByCode(map);
    }

    @Override
    public void deleteBatchmnsByCode(String tenantCode, String batchmnsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("batchmnsCode", batchmnsCode);
        this.delBatchmnsModelByCode(map);
    }

    @Override
    public void releaseBatchmns(Integer batchmnsId) throws ApiException {
        MnsBatchmns mnsBatchmns = this.getBatchmnsModelById(batchmnsId);
        String phoneListResult = mnsBatchmns.getMnslistPhone();
        String[] phoneList = phoneListResult.split(",");
        String param = null;
        for (String mnsPhone : phoneList) {
            MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
            ArrayList receiverList = new ArrayList();
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, String> contentMap = new HashMap<String, String>();
            HashMap<String, String> expMap = new HashMap<String, String>();
            map.put("telphone", mnsPhone);
            receiverList.add(map);
            contentMap.put("phone", mnsPhone);
            contentMap.put("param", mnsBatchmns.getMnslistContent());
            expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(contentMap));
            expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
            param = JsonUtil.buildNonDefaultBinder().toJson(expMap);
            mnsMnslistDomainBean.setMnslistExp(param);
            mnsMnslistDomainBean.setMnslistSource(0);
            mnsMnslistDomainBean.setMnslistSubject(mnsBatchmns.getMnslistSubject());
            mnsMnslistDomainBean.setMnslistBusname(mnsBatchmns.getMnslistBusname());
            mnsMnslistDomainBean.setMnslistBustype(mnsBatchmns.getMnslistBustype());
            mnsMnslistDomainBean.setMemberCode(mnsBatchmns.getMemberCode());
            mnsMnslistDomainBean.setTenantCode(mnsBatchmns.getTenantCode());
            mnsMnslistDomainBean.setDataTenant(mnsBatchmns.getDataTenant());
            mnsMnslistDomainBean.setMnschannelType(0);
            this.mnsService.sendMnslist(mnsMnslistDomainBean);
        }
    }

    @Override
    public void releasephones(String phones, String randomconfigBustype, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)phones) || StringUtils.isBlank((String)randomconfigBustype) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        RdRandomConfig randomConfig = (RdRandomConfig)DisUtil.getMapJson((String)this.cacheKey, (String)(randomconfigBustype + "-" + tenantCode), RdRandomConfig.class);
        this.logger.error("releasephones--------1", (Object)JsonUtil.buildNormalBinder().toJson((Object)randomConfig));
        if (null == randomConfig) {
            randomConfig = (RdRandomConfig)DisUtil.getMapJson((String)this.cacheKey, (String)(randomconfigBustype + "-" + "00000000"), RdRandomConfig.class);
        }
        if (null == randomConfig) {
            return;
        }
        this.logger.error("releasephones--------2", (Object)JsonUtil.buildNormalBinder().toJson((Object)randomConfig));
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        mnsMap.put("mnslistSubject", "\u6d3b\u52a8\u62a5\u540d\u901a\u77e5");
        mnsMap.put("mnslistSource", "0");
        mnsMap.put("mnslistBustype", randomConfig.getMnsconfigBustype());
        mnsMap.put("mnslistBusname", randomConfig.getMnsconfigBusname());
        mnsMap.put("mnslistExp", this.getMnslistExp(phones, randomConfig.getMnsconfigBustype(), String.valueOf(randomConfig.getRandomconfigTime())));
        mnsMap.put("tenantCode", tenantCode);
        ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
        sendMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(mnsMap));
        Object res = this.getInternalRouter().inInvoke("mns.ser.sendMnslist", "1.0", "0", sendMap);
        if (null == res) {
            res = "";
        }
        this.logger.error("releasephones--------3", (Object)JsonUtil.buildNormalBinder().toJson(res));
    }

    private String getMnslistExp(String host, String businessType, String time) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        HashMap<String, String> mapReceiver = new HashMap<String, String>();
        mapReceiver.put("code", "");
        mapReceiver.put("name", "");
        mapReceiver.put("telphone", host);
        mapReceiver.put("email", host);
        listReceiver.add(mapReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
        map.put("theme", "");
        map.put("businessType", businessType);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("random", "133322");
        paramMap.put("time", "");
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }
}

