/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.deamon;

import com.yqbsoft.laser.service.monitor.deamon.DeamonThread;
import com.yqbsoft.laser.service.monitor.domain.AmmMEvtInfoDomain;
import com.yqbsoft.laser.service.monitor.repository.EventRepository;
import com.yqbsoft.laser.service.monitor.support.MsgStore;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStoreThread
implements DeamonThread {
    private static final Logger logger = LoggerFactory.getLogger(EventStoreThread.class);
    private static final int THREAD_SIZE = 50;
    private EventRepository eventRepository;
    private ExecutorService executor = Executors.newFixedThreadPool(50);

    @Override
    @PostConstruct
    public void start() {
        for (int i = 0; i < 50; ++i) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    Map<String, AmmMEvtInfoDomain> map = null;
                    try {
                        while ((map = MsgStore.evtStoreQueue.take()) != null) {
                            EventStoreThread.this.eventRepository.store(map);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                }
            });
        }
        logger.info("[EvtStoreThread]process thread start!");
    }

    public EventRepository getEventRepository() {
        return this.eventRepository;
    }

    public void setEventRepository(EventRepository eventRepository) {
        this.eventRepository = eventRepository;
    }
}

