/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.engine;

import com.yqbsoft.laser.service.monitor.engine.RuleContext;
import com.yqbsoft.laser.service.monitor.engine.RuleEngine;
import com.yqbsoft.laser.service.monitor.enums.PeriodType;
import com.yqbsoft.laser.service.monitor.rules.StatisticRule;
import com.yqbsoft.laser.service.monitor.support.ApiTree;
import com.yqbsoft.laser.service.monitor.support.PeriodUtil;
import com.yqbsoft.laser.service.monitor.support.Point;
import com.yqbsoft.laser.service.monitor.support.RuleFactory;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class JavaRuleEngineImpl
implements RuleEngine {
    private static final int MAX_RETRY_COUNT = 10;
    private static final long MIN_MILLISECOND = 60000L;
    private static final long HOUR_MILLISECOND = 3600000L;
    private static final long DAY_MILLISECOND = 86400000L;
    private RuleFactory ruleFactory;
    private final ScheduledExecutorService schedule = Executors.newScheduledThreadPool(10);
    private final Map<Integer, ScheduledFuture<?>> scheduleMap = new ConcurrentHashMap();

    @Override
    public void execute(RuleContext ctx, ApiTree tree) {
        for (String ruleId : ctx.getRuleIds().keySet()) {
            StatisticRule rule = this.ruleFactory.getRule(ruleId);
            if (rule == null) {
                return;
            }
            this.register(rule, ctx.getRuleIds().get(ruleId));
            rule.prepare(ctx);
            rule.submit(tree, ctx.getRuleIds().get(ruleId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(StatisticRule rule, Point point) {
        if (this.scheduleMap.containsKey(point.getPointId())) {
            return;
        }
        Map<Integer, ScheduledFuture<?>> map = this.scheduleMap;
        synchronized (map) {
            if (this.scheduleMap.containsKey(point.getPointId())) {
                return;
            }
            long delay = PeriodUtil.getNow2NextPeriodDelay(PeriodType.getEnum(point.getPeriodType()));
            ScheduledFuture<?> future = null;
            ScheduleThread thread = new ScheduleThread(rule, point.getPointId());
            System.out.println("------delay:" + delay);
            if (PeriodType.MIN.getValue().equals(point.getPeriodType())) {
                future = this.schedule.scheduleAtFixedRate(thread, delay, 60000L, TimeUnit.MILLISECONDS);
            } else if (PeriodType.HOUR.getValue().equals(point.getPeriodType())) {
                future = this.schedule.scheduleAtFixedRate(thread, delay, 3600000L, TimeUnit.MILLISECONDS);
            } else if (PeriodType.DAY.getValue().equals(point.getPeriodType())) {
                future = this.schedule.scheduleAtFixedRate(thread, delay, 86400000L, TimeUnit.MILLISECONDS);
            }
            this.scheduleMap.put(point.getPointId(), future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregister(Integer pointId) {
        ScheduledFuture<?> future = null;
        Map<Integer, ScheduledFuture<?>> map = this.scheduleMap;
        synchronized (map) {
            future = this.scheduleMap.remove(pointId);
        }
        if (future == null) {
            return true;
        }
        return future.cancel(true);
    }

    public RuleFactory getRuleFactory() {
        return this.ruleFactory;
    }

    public void setRuleFactory(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    class ScheduleThread
    implements Runnable {
        private StatisticRule rule;
        private Integer pointId;
        private AtomicInteger errNum = new AtomicInteger();

        ScheduleThread(StatisticRule rule, Integer pointId) {
            this.rule = rule;
            this.pointId = pointId;
        }

        @Override
        public void run() {
            block4: {
                System.out.println("---------------ScheduleThread run------------------------------");
                try {
                    if (!this.rule.doSchedule(new Date(), this.pointId)) {
                        JavaRuleEngineImpl.this.unregister(this.pointId);
                    } else {
                        this.errNum.set(0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errNum.incrementAndGet();
                    if (this.errNum.intValue() <= 10) break block4;
                    JavaRuleEngineImpl.this.unregister(this.pointId);
                }
            }
        }
    }
}

