/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.rules.support;

import com.yqbsoft.laser.service.monitor.rules.result.StatResult;
import com.yqbsoft.laser.service.monitor.rules.support.SlotBasedCounter;
import com.yqbsoft.laser.service.monitor.support.Entry;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;

public final class SlidingWindowCounter<T, K extends StatResult<J>, J>
implements Serializable {
    private static final long serialVersionUID = 6912766295554991816L;
    private int slotNum;
    private Class<K> kclazz;
    private SlotBasedCounter<T, K, J> objCounter;
    private ConcurrentHashMap<T, Entry<Integer, Integer>> headTailSlotMap = new ConcurrentHashMap();

    public SlidingWindowCounter(Class<K> kclazz, int slotNum) {
        if (slotNum < 3) {
            throw new IllegalArgumentException("slot size in Window must be at least three (you requested " + slotNum + ")");
        }
        this.kclazz = kclazz;
        this.slotNum = slotNum;
        this.objCounter = new SlotBasedCounter(this.kclazz, slotNum);
    }

    public void incrementCount(T pointId, J node) {
        Entry<Integer, Integer> entry = this.getHeadTail(pointId);
        this.objCounter.incrementCount(pointId, node, entry.getK());
    }

    public K advanceWindowThenGetPeriodCount(T pointId) {
        Entry<Integer, Integer> entry = this.getHeadTail(pointId);
        StatResult k = null;
        K j = null;
        int head = entry.getK();
        int tail = entry.getV();
        this.objCounter.wipeSlot(tail);
        this.objCounter.wipeZeros();
        this.advanceHead(pointId);
        try {
            j = this.objCounter.getCount(pointId, head);
            if (j == null) {
                return null;
            }
            k = (StatResult)this.kclazz.newInstance();
            BeanUtils.copyProperties(j, (Object)k);
        }
        catch (Exception e) {
            return j;
        }
        return (K)k;
    }

    public Map<T, Long> getCounts() {
        return this.objCounter.getCounts();
    }

    public K getCurrentCount(T pointId) {
        Entry<Integer, Integer> entry = this.getHeadTail(pointId);
        return this.objCounter.getCount(pointId, entry.getK());
    }

    private void advanceHead(T pointId) {
        Entry<Integer, Integer> entry = this.getHeadTail(pointId);
        entry.setK(entry.getV());
        entry.setV(this.slotAfter(entry.getV()));
    }

    private int slotAfter(int slot) {
        return (slot + 1) % this.slotNum;
    }

    private Entry<Integer, Integer> getHeadTail(T pointId) {
        Entry<Integer, Integer> entry = this.headTailSlotMap.get(pointId);
        if (entry == null) {
            this.headTailSlotMap.putIfAbsent(pointId, new Entry<Integer, Integer>(0, 1));
            entry = this.headTailSlotMap.get(pointId);
        }
        return entry;
    }
}

