/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.rules.support;

import com.yqbsoft.laser.service.monitor.rules.result.StatResult;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SlotBasedCounter<T, K extends StatResult<J>, J>
implements Serializable {
    private static final long serialVersionUID = 4858185737378394432L;
    private final ConcurrentHashMap<T, K[]> objToCounts = new ConcurrentHashMap();
    private final int slotSize;
    private Class<K> resultClz;

    public SlotBasedCounter(Class<K> kclz, int slotSize) {
        if (slotSize <= 0) {
            throw new IllegalArgumentException("Number of slots must be greater than zero (you requested " + slotSize + ")");
        }
        this.slotSize = slotSize;
        this.resultClz = kclz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void incrementCount(T pointId, J node, int slot) {
        StatResult[] counts = (StatResult[])this.objToCounts.get(pointId);
        if (counts == null) {
            this.objToCounts.putIfAbsent(pointId, (StatResult[])Array.newInstance(this.resultClz, this.slotSize));
            counts = (StatResult[])this.objToCounts.get(pointId);
        }
        if (counts[slot] == null) {
            StatResult[] statResultArray = counts;
            // MONITORENTER : counts
            if (counts[slot] == null) {
                try {
                    counts[slot] = (StatResult)this.resultClz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // MONITOREXIT : statResultArray
        }
        counts[slot].incrementCount(node);
    }

    public K getCount(T obj, int slot) {
        StatResult[] counts = (StatResult[])this.objToCounts.get(obj);
        if (counts == null) {
            return null;
        }
        counts[slot].calcInferCount();
        return (K)counts[slot];
    }

    public Map<T, Long> getCounts() {
        HashMap result = new HashMap();
        for (Object obj : this.objToCounts.keySet()) {
            result.put(obj, this.computeTotalCount(obj));
        }
        return result;
    }

    private long computeTotalCount(T obj) {
        StatResult[] curr = (StatResult[])this.objToCounts.get(obj);
        long total = 0L;
        for (StatResult l : curr) {
            if (l == null) continue;
            total += l.getStatCount();
        }
        return total;
    }

    public void wipeSlot(int slot) {
        for (Object obj : this.objToCounts.keySet()) {
            this.resetSlotCountToZero(obj, slot);
        }
    }

    private void resetSlotCountToZero(T obj, int slot) {
        StatResult[] counts = (StatResult[])this.objToCounts.get(obj);
        if (counts[slot] == null) {
            return;
        }
        counts[slot].reset();
    }

    private boolean shouldBeRemovedFromCounter(T obj) {
        return this.computeTotalCount(obj) == 0L;
    }

    public void wipeZeros() {
        HashSet objToBeRemoved = new HashSet();
        for (Object obj : this.objToCounts.keySet()) {
            if (!this.shouldBeRemovedFromCounter(obj)) continue;
            objToBeRemoved.add(obj);
        }
        for (Object obj : objToBeRemoved) {
            this.objToCounts.remove(obj);
        }
    }
}

