/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.monitor.dao.AmmMFieldMapper;
import com.yqbsoft.laser.service.monitor.domain.AmmMFieldDomain;
import com.yqbsoft.laser.service.monitor.model.AmmMField;
import com.yqbsoft.laser.service.monitor.service.AmmMFieldService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmmMFieldServiceImpl
extends BaseServiceImpl
implements AmmMFieldService {
    public static final String SYS_CODE = "amm.MConstants.AmmMFieldServiceImpl";
    private AmmMFieldMapper ammMFieldMapper;

    public void setAmmMFieldMapper(AmmMFieldMapper ammMFieldMapper) {
        this.ammMFieldMapper = ammMFieldMapper;
    }

    private Date getSysDate() {
        try {
            return this.ammMFieldMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMFieldServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMField(AmmMFieldDomain ammMFieldDomain) {
        if (null == ammMFieldDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMFieldDefault(AmmMField ammMField) {
        if (null == ammMField) {
            return;
        }
        if (null == ammMField.getDataState()) {
            ammMField.setDataState(0);
        }
        if (null == ammMField.getGmtCreate()) {
            ammMField.setGmtCreate(this.getSysDate());
        }
        ammMField.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ammMFieldMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMFieldServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMFieldUpdataDefault(AmmMField ammMField) {
        if (null == ammMField) {
            return;
        }
        ammMField.setGmtModified(this.getSysDate());
    }

    private void saveMFieldModel(AmmMField ammMField) throws ApiException {
        if (null == ammMField) {
            return;
        }
        try {
            this.ammMFieldMapper.insert(ammMField);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.saveMFieldModel.ex", (Throwable)e);
        }
    }

    private AmmMField getMFieldModelById(Integer fieldId) {
        if (null == fieldId) {
            return null;
        }
        try {
            return this.ammMFieldMapper.selectByPrimaryKey(fieldId);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMFieldServiceImpl.getMFieldModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMFieldModel(Integer fieldId) throws ApiException {
        if (null == fieldId) {
            return;
        }
        int i = 0;
        try {
            i = this.ammMFieldMapper.deleteByPrimaryKey(fieldId);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.deleteMFieldModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.deleteMFieldModel.num");
        }
    }

    private void updateMFieldModel(AmmMField ammMField) throws ApiException {
        if (null == ammMField) {
            return;
        }
        try {
            this.ammMFieldMapper.updateByPrimaryKeySelective(ammMField);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.updateMFieldModel.ex", (Throwable)e);
        }
    }

    private void updateStateMFieldModel(Integer fieldId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == fieldId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldId", fieldId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ammMFieldMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.updateStateMFieldModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.updateStateMFieldModel.null");
        }
    }

    private AmmMField makeMField(AmmMFieldDomain ammMFieldDomain, AmmMField ammMField) {
        if (null == ammMFieldDomain) {
            return null;
        }
        if (null == ammMField) {
            ammMField = new AmmMField();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ammMField, (Object)ammMFieldDomain);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMFieldServiceImpl.makeMField", (Throwable)e);
        }
        return ammMField;
    }

    private List<AmmMField> queryMFieldModelPage(Map<String, Object> parammap) {
        try {
            return this.ammMFieldMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMFieldServiceImpl.queryMFieldModel", (Throwable)e);
            return null;
        }
    }

    private int countMField(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ammMFieldMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMFieldServiceImpl.countMField", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMField(AmmMFieldDomain ammMFieldDomain) throws ApiException {
        String msg = this.checkMField(ammMFieldDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.saveMField.checkMField", msg);
        }
        AmmMField ammMField = this.makeMField(ammMFieldDomain, null);
        this.setMFieldDefault(ammMField);
        this.saveMFieldModel(ammMField);
    }

    @Override
    public void updateMFieldState(Integer fieldId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMFieldModel(fieldId, dataState, oldDataState);
    }

    @Override
    public void updateMField(AmmMFieldDomain ammMFieldDomain) throws ApiException {
        String msg = this.checkMField(ammMFieldDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.updateMField.checkMField", msg);
        }
        AmmMField oldAmmMField = this.getMFieldModelById(ammMFieldDomain.getFieldId());
        if (null == oldAmmMField) {
            throw new ApiException("amm.MConstants.AmmMFieldServiceImpl.updateMField.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmmMField ammMField = this.makeMField(ammMFieldDomain, oldAmmMField);
        this.setMFieldUpdataDefault(ammMField);
        this.updateMFieldModel(ammMField);
    }

    @Override
    public AmmMField getMField(Integer fieldId) {
        return this.getMFieldModelById(fieldId);
    }

    @Override
    public void deleteMField(Integer fieldId) throws ApiException {
        this.deleteMFieldModel(fieldId);
    }

    @Override
    public QueryResult<AmmMField> queryMFieldPage(Map<String, Object> map) {
        List<AmmMField> ammMFieldList = this.queryMFieldModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMField(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ammMFieldList);
        return queryResult;
    }
}

