/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.monitor.MEvent;
import com.yqbsoft.laser.service.monitor.domain.AmmMEvtInfoDomain;
import com.yqbsoft.laser.service.monitor.service.EventReceiver;
import com.yqbsoft.laser.service.monitor.support.ApiNode;
import com.yqbsoft.laser.service.monitor.support.ApiTree;
import com.yqbsoft.laser.service.monitor.support.MsgStore;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class EventReceiverImpl
implements EventReceiver {
    private static final Logger logger = LoggerFactory.getLogger(EventReceiver.class);
    public static final String ROOT_ID = "ROOTID";
    public static final String REQ_MSG = "REQ";
    public static final String RES_MSG = "RES";

    @Override
    public void onReceive(Map<String, String> paramMap) {
        String rootId = paramMap.get(ROOT_ID);
        if (StringUtils.isBlank((CharSequence)rootId)) {
            logger.warn("[RECEIVER]rootId:{} is null,discard msg!", (Object)rootId);
            return;
        }
        Map map = DisUtil.getDisCache().getMapAll(rootId);
        DisUtil.getDisCache().del(rootId);
        if (map.size() == 0) {
            logger.warn("[RECEIVER]rootId:{} cache not exist,discard msg!", (Object)rootId);
            return;
        }
        MEvent root = (MEvent)JsonUtil.buildNonNullBinder().getJsonToObject((String)map.remove(TokenUtil.genToken((Object[])new Object[]{rootId, RES_MSG})), MEvent.class);
        if (map.size() + 1 != root.getLevel() * 2) {
            logger.warn("[RECEIVER]rootId:{} some event missing,real:{},expect:{}*2 ,discard msg!", new Object[]{rootId, map.size(), root.getLevel()});
            return;
        }
        HashMap<String, AmmMEvtInfoDomain> mergeMap = new HashMap<String, AmmMEvtInfoDomain>();
        HashMap<String, MEvent> reqMap = new HashMap<String, MEvent>();
        HashMap<String, MEvent> resMap = new HashMap<String, MEvent>();
        resMap.put(rootId, root);
        for (Map.Entry entry : map.entrySet()) {
            MEvent me = (MEvent)JsonUtil.buildNonNullBinder().getJsonToObject((String)entry.getValue(), MEvent.class);
            if (((String)entry.getKey()).indexOf(REQ_MSG) > -1) {
                reqMap.put(me.getSelfId(), me);
                continue;
            }
            resMap.put(me.getSelfId(), me);
        }
        for (Map.Entry entry : reqMap.entrySet()) {
            MEvent res = null;
            res = (MEvent)resMap.remove(entry.getKey());
            if (res == null) {
                logger.warn("[RECEIVER]rootId:{}, res event:{} missing,discard msg!", (Object)rootId, entry.getKey());
                return;
            }
            mergeMap.put((String)entry.getKey(), EventReceiverImpl.merge((MEvent)entry.getValue(), res));
        }
        if (resMap.size() > 0) {
            logger.warn("[RECEIVER]rootId:{}, exist res event unmatch,left size:{},discard msg!", (Object)rootId, (Object)resMap.size());
            return;
        }
        try {
            MsgStore.evtStoreQueue.put(mergeMap);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        try {
            MsgStore.analyseQueue.put(this.buildTree(rootId, mergeMap));
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public ApiTree buildTree(String rootId, Map<String, AmmMEvtInfoDomain> map) {
        HashMap api2Info = new HashMap();
        for (Map.Entry<String, AmmMEvtInfoDomain> entry : map.entrySet()) {
            Iterator info = entry.getValue();
            List list = MapUtil.getList(api2Info, (Object)((AmmMEvtInfoDomain)((Object)info)).getApiKey());
            if (((AmmMEvtInfoDomain)((Object)info)).isOuter()) {
                list.add(0, info);
                continue;
            }
            list.add(info);
        }
        LinkedList<AmmMEvtInfoDomain> outerInfos = new LinkedList<AmmMEvtInfoDomain>();
        HashMap<String, ApiNode> uid2node = new HashMap<String, ApiNode>();
        for (Map.Entry entry : api2Info.entrySet()) {
            List list = (List)entry.getValue();
            AmmMEvtInfoDomain outer = (AmmMEvtInfoDomain)list.remove(0);
            ApiNode node = new ApiNode(outer);
            for (AmmMEvtInfoDomain evt : list) {
                node.getInners().add(evt);
                uid2node.put(evt.getSelfId(), node);
            }
            uid2node.put(outer.getSelfId(), node);
            outerInfos.add(outer);
        }
        for (AmmMEvtInfoDomain ammMEvtInfoDomain : outerInfos) {
            ApiNode self = (ApiNode)uid2node.get(ammMEvtInfoDomain.getSelfId());
            ApiNode parent = (ApiNode)uid2node.get(ammMEvtInfoDomain.getParentId());
            if (parent == null) continue;
            parent.addChild(self);
            self.setParent(parent);
        }
        ApiTree tree = new ApiTree();
        tree.setRoot((ApiNode)uid2node.get(rootId));
        return tree;
    }

    public static AmmMEvtInfoDomain merge(MEvent req, MEvent res) {
        AmmMEvtInfoDomain info = new AmmMEvtInfoDomain();
        BeanUtils.copyProperties((Object)req, (Object)info);
        info.setStartTime(req.getInvokeTime());
        info.setReqMsgClass(req.getMsgClass());
        info.setReqExtJson(req.getExtJson());
        info.setEndTime(res.getInvokeTime());
        info.setResMsgClass(res.getMsgClass());
        info.setResExtJson(res.getExtJson());
        info.setResultCode(res.getResultCode());
        info.setResultType(res.getResultType());
        if (info.isVisualApi() && !res.isVisualApi()) {
            info.setApiCode(res.getApiCode());
            info.setVisualApi(false);
        }
        return info;
    }
}

