/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service.impl;

import com.yqbsoft.laser.service.monitor.enums.PeriodType;
import com.yqbsoft.laser.service.monitor.repository.WarnRepository;
import com.yqbsoft.laser.service.monitor.service.WarnProcessor;
import com.yqbsoft.laser.service.monitor.support.ActionFactory;
import com.yqbsoft.laser.service.monitor.support.PeriodUtil;
import com.yqbsoft.laser.service.monitor.support.Point;
import com.yqbsoft.laser.service.monitor.support.ProcessorContext;
import com.yqbsoft.laser.service.monitor.support.ValidateResult;
import com.yqbsoft.laser.service.monitor.warn.Action;
import com.yqbsoft.laser.service.suppercore.cache.repository.BeanRepository;
import com.yqbsoft.laser.service.suppercore.cache.repository.CacheBean;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class WarnProcessorImpl
implements WarnProcessor {
    private static final String WARN = "WARN";
    private static final String sep = ",";
    private ActionFactory actionFactory;
    private WarnRepository warnRepository;
    private ExecutorService executor = new ThreadPoolExecutor(10, 100, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public void process(Point point, ProcessorContext context) {
        if (WarnProcessorImpl.isCurrentPeriodWarned(point)) {
            return;
        }
        this.executor.submit(new WarnRanner(point, context));
    }

    public WarnRepository getWarnRepository() {
        return this.warnRepository;
    }

    public void setWarnRepository(WarnRepository warnRepository) {
        this.warnRepository = warnRepository;
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    private static boolean isCurrentPeriodWarned(Point point) {
        PeriodType type = PeriodType.getEnum(point.getPeriodType());
        String key = PeriodUtil.getCurrentPeriod(type);
        if (BeanRepository.newInstance((String)WARN).get(key) != null) {
            return true;
        }
        CacheBean bean = new CacheBean();
        bean.setExpire(PeriodUtil.getNow2NextPeriodDelay(type));
        BeanRepository.newInstance((String)WARN).put(key, (Object)bean);
        return false;
    }

    public static void main(String[] args) {
        Point point = new Point();
        point.setPeriodType("2");
        System.out.println(WarnProcessorImpl.isCurrentPeriodWarned(point));
        System.out.println(WarnProcessorImpl.isCurrentPeriodWarned(point));
    }

    class WarnRanner
    implements Runnable {
        private Point point;
        private ProcessorContext context;

        WarnRanner(Point point, ProcessorContext context) {
            this.point = point;
            this.context = context;
        }

        @Override
        public void run() {
            List<Action> actions;
            String actionName;
            WarnProcessorImpl.this.warnRepository.store(this.point, this.context);
            ValidateResult result = this.context.getResult();
            String string = actionName = result.isFailOnMaxValve() ? this.point.getMaxValveActions() : this.point.getMinValveActions();
            if (StringUtils.isNotBlank((CharSequence)actionName) && CollectionUtils.isNotEmpty(actions = WarnProcessorImpl.this.actionFactory.getActions(Arrays.asList(actionName.split(WarnProcessorImpl.sep))))) {
                for (Action act : actions) {
                    act.doAction(this.point, this.context);
                }
            }
        }
    }
}

